/*
 *  Copyright (C) 2007 The MITRE Corporation.  All rights reserved.
 *
 *  MRALD is released under the license specified in the file
 *  mrald_license.txt supplied with this file.  If you cannot find this
 *  file, contact The MITRE Technology Transfer Office at techtransfer@mitre.org
 *  or at http://www.mitre.org/work/tech_transfer/
 */

package org.mitre.mrald.chart;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.output.OutputManagerException;
import org.mitre.mrald.util.Config;
/**
 *  This HTMLOutput Class specializes the OutputManager class. It specifically
 *  gathers information pertaining to the output columns desired by the user. As
 *  the query is constructed, this class adds output information and updates the
 *  columns and joins necessary to obtain this output information
 *
 *@author    Gail Hamilton
 *@created    February 2, 2005
 *@version    1.0
 */

public class ChartOutput extends OutputManager
{
    /**
     *  Constructor for the HTMLOutput object
     *
     *@since
     */
    public ChartOutput()
    {
        super();
    }


    /**
     *  method to Format the output
     *
     *@param  msg                         Description of the Parameter
     *@exception  ServletException        Description of the Exception
     *@exception  IOException             Description of the Exception
     *@exception  SQLException            Description of the Exception
     *@exception  OutputManagerException  Description of the Exception
     *@exception  MsgObjectException      Description of the Exception
     *@since                              1.2
     */
    public void formatOutput( MsgObject msg )
        throws ServletException, IOException, SQLException, OutputManagerException, MsgObjectException
    {
	    //Set up session variables, taken from msgObject
	HttpSession sess = msg.getReq().getSession();
	sess.setAttribute("labelLimit", msg.getValue("labelLimit")[0]);
        sess.setAttribute("query", msg.getQuery()[0]);
	sess.setAttribute("chartType", msg.getValue("chartType")[0]);
	sess.setAttribute("graphTitle", msg.getValue("graphTitle")[0]);
	sess.setAttribute("xaxislabel", msg.getValue("xaxislabel")[0]);
	sess.setAttribute("yaxislabel", msg.getValue("yaxislabel")[0]);
	sess.setAttribute("startCount", msg.getValue("startCount")[0]);
	sess.setAttribute("rowCount", msg.getValue("rowCount")[0]);

        msg.getRes().sendRedirect( Config.getProperty( "BaseUrl" ) + "/chart.jsp" );

    }

    /**
     *  This method outputs the header so that the file is recognized as an HTML
     *  file
     *
     *@param  msg                         Description of the Parameter
     *@exception  OutputManagerException  Description of the Exception
     *@since
     */
    protected void prepareHeaders( MsgObject msg )
        throws OutputManagerException
    {
        try
        {

        }
        catch ( Exception mge )
        {
            OutputManagerException ome = new OutputManagerException( mge.getMessage() );
            throw ome;
        }
    }

    /**
     *  Description of the Method
     *
     *@param  out  Description of the Parameter
     */
    public void printNavigation( PrintWriter out )
    {
        out.println( "<center><table cellpadding='0' cellspacing='0' border='0' width='600'>\n" );
        out.println( "<tr><td>\n" );
        out.print( "<script language='JavaScript1.2' type='text/javascript' src='" );
        out.print( Config.getProperty( "BaseUrl" ) );
        out.println( "/navi.js'></script>\n" );
        out.println( "</td></tr>\n" );
        out.println( "</table></center>\n" );
    }
}

