#!/usr/bin/python
"""Runs the pipelines defined in the YAML script.
"""

import os
import yaml
import re
import copy
import numpy as np
import matplotlib as mpl
import networkx as nx

def executive(inputfile):
    """Main routine that executes pipelines
    """
    # read yaml config
    fh = open(inputfile,'r')
    yaml_in = yaml.load(fh)
    fh.close()
    #print yaml.dump(yaml_in,default_flow_style=False)

    outputlocation = yaml_in['study']['output_dir']
    if not os.path.exists(outputlocation):
        os.mkdir(outputlocation)
    
    # execute each pipeline
    for pipeline in yaml_in['execute']:
        # create execution order

        # Create a graph of dependencies
        G = nx.DiGraph()
        G.add_nodes_from(yaml_in[pipeline])
        #print G.nodes()
        
        dep = {} # change to list of dicts
        for mod in G.nodes():
            #print "Tracking: " + mod + yaml.dump(yaml_in[mod])
            dep[mod] = find_dep(yaml_in[mod],mod)
            if dep[mod]:
                for p in dep[mod]:
                    foo =  re.split(":",p)
                    # add edge from source output to input param
                    G.add_edge(re.findall("\[.*?\]",foo[1])[0][1:-1],re.findall("\[.*?\]",foo[0])[0][1:-1])
        #print G.edges()

        # Generate graph order
        order = determine_order(G)
        #print order
        
        #print yaml.dump(dep,default_flow_style=False)
        execute(G,order,yaml_in,dep)
        
    return (G,order,yaml_in)
    
    
def find_dep(mod,modname):
    """Recursive module returns dependency relations
    """
    dep = []

    if type(mod) == type(''):
        # print '-->'+mod[:2]+'<--'
        if mod[:2] == '<[':
            dep.append(''.join(('[',modname,']',':',mod[1:-1])))

    if type(mod) == type({}):
        for rd in mod.keys():
            foo = find_dep(mod[rd],rd)
            if foo:
                dep.append(''.join(('[',modname,']',foo[0])))

    return dep
    
def determine_order(G):
    """Returns execution order given a connectivity matrix
    """
    order = []
    Nproc = G.number_of_nodes() 

    a = np.zeros((Nproc,3),dtype=int)
    a[:,0] = G.in_degree()
    a[:,1] = G.out_degree()
    a[:,2] = range(Nproc)

    #print a
    # sort ascending by in_degree
    order = a[a[:,0].argsort(),]
    #print order

    # sub-sort descending by out_degree
    for i0 in np.unique(order[:,0]):
        idx = mpl.mlab.find(order[:,0]==i0)
        a = order[idx,1:]
        #print a[a[:,0].argsort(),]
        order[idx,1:] = a[a[:,0].argsort(),][::-1,:]

    ### above doesn't work, need to implement sub-sort
    
    #order = np.sort(a.view([('',a.dtype)]*a.shape[1]),0).view(a.dtype)
    #print a.view([('',a.dtype)]*a.shape[1])

    #print order
    
    nx.draw_graphviz(G,'dot')
    mpl.pyplot.show()
    mpl.pyplot.ylim(0,300)
    mpl.pyplot.xlim(0,300)
    
    return order[:,-1]

def execute(G,order,yaml_in,dep):
    """Executes the processes in the appropriate order
    """
    listofprocesses = G.nodes()
    print listofprocesses
    print order
    # just execute serially currently
    for i0 in order:
        job = listofprocesses[i0]
        print "executing: " + job
        run_job(job,yaml_in,dep)
        print "finished: " + job

    #print yaml.dump(yaml_in,default_flow_style=False)

    #implement process submission algorithm (ala Kim Lumbard)
    """
    The basic algorithm is:
    While (Pending Jobs and Active Jobs) {
        Check Active Jobs.  If any finished, move to Finished Jobs.
        Check Resources.  If available, then Schedule Job {
        Compare Pending Queue to Active Queue
        Move first non-conflicting Pending Job to Active Job
        }
        sleep(sliding timer)
    }
    """

def run_job(job,yaml_in,dep):
    if dep[job]:
        for p in dep[job]:
            foo =  re.split(":",p)
            # update dependencies
            source  = re.findall("\[.*?\]",foo[1])
            param   = re.findall("\[.*?\]",foo[0])
            str1 = ''
            for f in param[1:]:
                str1 = ''.join((str1,"['",f[1:-1],"']"))
            str2 = ''
            for f in source:
                str2 = ''.join((str2,"['",f[1:-1],"']"))
            #print yaml_proc
            #print yaml_in
            cmd =  "yaml_in['"+job+"']"+str1+"= yaml_in"+str2
            #print cmd
            exec(cmd)

    foo =  re.split("\.",job)
    modstr = os.path.join('neuropypes.modules',foo[0],foo[1])
    cmd = eval("__import__(modstr)."+foo[1])
    yaml_proc = {}
    yaml_proc[job] = copy.deepcopy(yaml_in[job])
    yaml_proc = cmd(yaml_proc)
    yaml_in[job] = copy.deepcopy(yaml_proc[job])
    
    #print yaml.dump(yaml_proc,default_flow_style=False)

