#!/usr/bin/python
"""Generate data structure from fips source tree

"""

import os
import glob
import sys
import yaml
import copy
import shutil
import traceback

def fipssink(inputfile,outputfile=''):
    """Generate fips data structure

    Input/Output
    -----
    YAML formatted specification

    Input Requirements
    ------------------
    fipstemplate  : template name structure of runs

    in addition to the mandatory fields (source, name, location)
    
    Output
    ------
    in addition to the mandatory fields (source, name, location)

    
    """
    source = 'mgh'
    modulename = 'fipssink'
    modulename = ''.join((source,'.',modulename))

    # read YAML input
    try:
        if type(inputfile) == type(str()):
            fh = open(inputfile,'r')
            yaml_in = yaml.load(fh)
            fh.close()
        else:
            yaml_in = inputfile
        yaml_in = yaml_in[modulename]
    except:
        print("Cannot find or load input file")
        traceback.print_exc()

    # Create directory for module output
    outputlocation = os.path.join(yaml_in['location'],modulename)
    if not os.path.exists(outputlocation):
        os.mkdir(outputlocation)

    # initialize YAML output
    output             = copy.deepcopy(yaml_in)
    output['outliers']   = []
    
    # get list of directories
    listofdirs = yaml_in['mocopar']

    for fileno in range(len(yaml_in['mocopar'])):
        # get location of outlier directory
        (filepath,filename) = os.path.split(yaml_in['mocopar'][fileno])
        outlierdir = os.path.join(filepath,''.join(('',yaml_in['outlierdir'])))

        # mk outlier directory if it doesn't exist
        if not os.path.exists(outlierdir):
            #print "creating directory:", outlierdir
            if yaml_in['copy'] == 1:
                os.mkdir(outlierdir)

        outlierext = '.txt'
        
        # copy outlier file and rename it
        outlierfilename = os.path.join(outlierdir,''.join((yaml_in['outliername'],outlierext)))
        if yaml_in['copy'] == 1:
            shutil.copyfile(yaml_in['outliers'][fileno],outlierfilename)
        #print "copying: ", yaml_in['outliers'][fileno], " to ", outlierfilename
        output['outliers'].insert(fileno,outlierfilename)
    
    yaml_out = {}
    yaml_out[modulename] = output

    # Generate filename and write yaml output
    if outputfile == '':
        outputfile = os.path.join(outputlocation,''.join((modulename,'.yaml')))

    # print("writing output to: %s"%outputfile)
    fh = open(outputfile,'wt')
    yaml.dump(yaml_out,fh,default_flow_style=False)
    fh.close()

    return yaml_out

if __name__=="__main__":
    try:
        fipssource(sys.argv[1],sys.argv[2])
    except:
        print "An unhandled exception occured, here's the traceback!"
        traceback.print_exc()

