#!/usr/bin/python
"""Generate data structure from fips source tree

"""

import os
import glob
import sys
import yaml
import numpy as np
import traceback

def fipssource(inputfile,outputfile=''):
    """Generate fips data structure

    Input/Output
    -----
    YAML formatted specification

    Input Requirements
    ------------------
    fipstemplate  : template name structure of runs

    in addition to the mandatory fields (source, name, location)
    
    Output
    ------
    in addition to the mandatory fields (source, name, location)

    
    """
    source = 'mgh'
    modulename = 'fipssource'
    modulename = ''.join((source,'.',modulename))

    # read YAML input
    try:
        if type(inputfile) == type(str()):
            fh = open(inputfile,'r')
            yaml_in = yaml.load(fh)
            fh.close()
        else:
            yaml_in = inputfile
        yaml_in = yaml_in[modulename]
    except:
        print("Cannot find or load input file")
        traceback.print_exc()

    # Create directory for module output
    outputlocation = os.path.join(yaml_in['location'],modulename)
    if not os.path.exists(outputlocation):
        os.mkdir(outputlocation)

    # initialize YAML output
    output             = yaml_in
    output['series']   = []
    output['mocopar']  = []
    
    # get list of directories
    listofdirs = glob.glob(yaml_in['fipstemplate'])

    for dirname in listofdirs:
        # get raw functional image
        output['series'].append(os.path.join(glob.glob(
            os.path.join(dirname,yaml_in['seriesdir'])).pop(),yaml_in['seriesname']))
        output['mocopar'].append(os.path.join(glob.glob(
            os.path.join(dirname,yaml_in['analysisdir'])).pop(),yaml_in['moconame']))
        
    yaml_out = {}
    yaml_out[modulename] = output

    # Generate filename and write yaml output
    if outputfile == '':
        outputfile = os.path.join(outputlocation,''.join((modulename,'.yaml')))

    # print("writing output to: %s"%outputfile)
    fh = open(outputfile,'wt')
    yaml.dump(yaml_out,fh,default_flow_style=False)
    fh.close()

    return yaml_out

if __name__=="__main__":
    try:
        fipssource(sys.argv[1],sys.argv[2])
    except:
        print "An unhandled exception occured, here's the traceback!"
        traceback.print_exc()

