#!/usr/bin/python
"""dummy mod

"""

import os
import yaml
import copy
import traceback

def mod2(inputfile,outputfile=''):
    """dummy mod

    Input/Output
    -----
    YAML formatted specification

    Input Requirements
    ------------------
    
    Output
    ------
    
    """
    source = 'test'
    modulename = 'mod2'
    modulename = ''.join((source,'.',modulename))

    # read YAML input
    try:
        if type(inputfile) == type(str()):
            fh = open(inputfile,'r')
            yaml_in = yaml.load(fh)
            fh.close()
        else:
            yaml_in = inputfile
        yaml_in = yaml_in[modulename]
    except:
        print("Cannot find or load input file")
        traceback.print_exc()

    # Create directory for module output
    outputlocation = os.path.join(yaml_in['location'],modulename)
    if not os.path.exists(outputlocation):
        os.mkdir(outputlocation)

    # initialize YAML output
    output          = copy.deepcopy(yaml_in)
    output['out1']  = []
    output['out2']  = []
    output['out3']  = []
    output['out4']  = []
    
    yaml_out = {}
    yaml_out[modulename] = output

    # Generate filename and write yaml output
    if outputfile == '':
        outputfile = os.path.join(outputlocation,''.join((modulename,'.yaml')))

    # print("writing output to: %s"%outputfile)
    fh = open(outputfile,'wt')
    yaml.dump(yaml_out,fh,default_flow_style=False)
    fh.close()

    return yaml_out

if __name__=="__main__":
    try:
        mod2(sys.argv[1],sys.argv[2])
    except:
        print "An unhandled exception occured, here's the traceback!"
        traceback.print_exc()

