#!/usr/bin/python

import yaml
import os
from neuropypes.modules.mgh import fipssource, fipssink
from neuropypes.modules.mit import mocoreformat, artifactdetect

# read in config
fh = open('testing/mghpipe.yaml','r')
npcfg = yaml.load(fh)
fh.close()

# execute pipeline
outputlocation = npcfg['study']['output_dir']
if not os.path.exists(outputlocation):
    os.mkdir(outputlocation)

# get data source information
a = {}
modulename1 = 'mgh.fipssource'
a[modulename1] = npcfg[modulename1]
out1 = fipssource.fipssource(a)

# convert fsl parameters to artifactdetect format
b = {}
modulename2 = 'mit.mocoreformat'
b[modulename2] = npcfg[modulename2]
b[modulename2]['mocopar'] = out1[modulename1]['mocopar']
out2 = mocoreformat.mocoreformat(b)

# run art detect
c = {}
modulename3 = 'mit.artifactdetect'
c[modulename3] = npcfg[modulename3]
c[modulename3]['series'] = out1[modulename1]['series']
c[modulename3]['mocopar'] = out2[modulename2]['mocopar']
out3 = artifactdetect.artifactdetect(c)

# copy results into fips structure
d = {}
modulename4 = 'mgh.fipssink'
d[modulename4] = npcfg[modulename4]
d[modulename4]['outliers'] = out3[modulename3]['outliers']
d[modulename4]['mocopar'] = out1[modulename1]['mocopar']
d[modulename4]['param'] = out3[modulename3]['param']['thresholds']
out4 = fipssink.fipssink(d)
