#!/bin/bash

basedir=$1
mkdir -p $basedir

mkdir -p installdir
cd installdir

# install python if it doesn't exist
if [ ! -e $basedir/bin/python ]; then
    wget http://python.org/ftp/python/2.5.4/Python-2.5.4.tgz

    mkdir -p temp
    cd temp
    tar zxf ../Python-2.5.4.tgz
    mkdir -p build
    cd build
    ../Python-2.5.4/configure --prefix=$basedir
    make
    make install
    cd ..
    cd ..
fi

export PATH=$basedir/bin/:$PATH

# install setuptools
if [ ! -e $basedir/bin/easy_install ]; then
    mkdir -p temp
    cd temp
    wget http://pypi.python.org/packages/2.5/s/setuptools/setuptools-0.6c9-py2.5.egg
    sh setuptools-0.6c9-py2.5.egg
    cd ..
fi

# install blas and lapack before install numpy
if [ ! -e $basedir/lib/libblas.a ]; then
    mkdir -p temp
    cd temp
    wget http://www.netlib.org/blas/blas.tgz
    tar xzf blas.tgz
    cd BLAS
    g77 -O3 -m64 -fno-second-underscore -fPIC -c *.f
    ar r libfblas.a *.o
    ranlib libfblas.a
    cp libfblas.a $basedir/lib/libblas.a
    rm -rf *.o
    cd ..
    cd ..
    rm -rf temp
fi
export BLAS=$basedir/lib/libblas.a

if [ ! -e $basedir/lib/liblapack.a ]; then
    mkdir -p temp
    cd temp
    wget http://www.netlib.org/lapack/lapack-3.1.1.tgz
    tar xzf lapack-3.1.1.tgz
    cd lapack-3.1.1
    patch -p0 < ../../../make.diff
    mv make.inc.example make.inc
    make lapacklib
    make clean
    cp lapack_LINUX.a $basedir/lib/liblapack.a
    cd ..
    cd ..
    rm -rf temp
fi
export LAPACK=$basedir/lib/liblapack.a

exit

if [ -e $basedir/bin/easy_install ]; then
     # install the rest using easy_install
    svn co http://svn.scipy.org/svn/numpy/trunk numpy
    easy_install numpy
    svn co http://svn.scipy.org/svn/scipy/trunk scipy
    easy_install scipy
    svn co https://matplotlib.svn.sourceforge.net/svnroot/matplotlib/trunk/matplotlib matplotlib
    easy_install matplotlib
    easy_install ipython
    svn co https://networkx.lanl.gov/svn/networkx/trunk/ networkx
    easy_install networkx
fi

cd ..
