#!/usr/bin/python

# satra@mit.edu 
# import sys, os, string

#### functions ####
# from optparse import OptionParser

class realign:
    """Class wrapper for calling the SPM realign function.
    """
    #    data = {'options' : {}}
    
    def __init__(self):
        """Perform any class initialization
        """
        self.data = {'options' : {}}

    def clear(self): 
    	self.data.clear()
    
    def copy(self):                             
        import copy
        return copy.copy(self)                 
    
    def deepcopy(self):                             
        import copy
        return copy.deepcopy(self)                 

    def keys(self): 
    	return self.data.keys()
    
    def items(self): 
    	return self.data.items()  
    	
    def values(self): 
    	return self.data.values()

    def __getitem__(self, key): 
       	return self.data[key]

    def __setitem__(self, key, item):
        self.data[key] = item

    def getoutput(self):
    	return run_spm_realign()

    def run_spm_realign(self):
        """
        Generates an m-file that can be executed in matlab to realign
        a set of functional runs for a given subject
        """
        import os
        
        if mcfiles==[]:
            print("No files to motion correct!")
            sys.exit(1)
            
        script_dir = os.path.join(sdir,"scripts")
        if not(os.path.exists(script_dir)):
            os.mkdir(script_dir)
                
        # create a matlab script to do motion correction using spm
        motion_script=os.path.join(script_dir,"motion_correct.m")
        if options.verbose:
            print(motion_script)
                    
        fh = open(motion_script,"w")
        fh.write("% auto-generated by:"+realign.__name__+"\n")
        
        if options.reslice:
            fh.write("load "+os.path.join(options.matlab_dir,"realign_and_reslice_job.mat")+";\n")
        else:
            fh.write("load "+os.path.join(options.matlab_dir,"realign_job.mat")+";\n")
            
        fh.write("addpath('scripts');\n")
        fh.write("sr=which('spm_realign');\n")
        fh.write("fprintf('motion correcting with %s\\n',sr);\n")
            
        # build file list
        fh.write("jobs{1}.spatial{1}.realign{1}.estwrite.data = {")
            
        for f0 in mcfiles:
            fh.write(f0+",")
                
        fh.write("};\n")
        fh.write("spm_jobman('run',jobs);\n")
        fh.close()
        #"$exec_dir"/run_matlab_script.sh "$motion_script"
