package edu.jhu.pami.spring2009;

import java.util.ArrayList;

import edu.jhu.ece.iacl.io.ArrayDoubleListTxtReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;

public class CreateCrossingFiber extends ProcessingAlgorithm{ 

	private ParamVolumeCollection DWdata4D; 			// Imaging Data
	private ParamObject<ArrayList<double[][]>> smR;		// Weighting of each tensor
	private ParamVolume outVol;							// Output image after weighting

	private static final String rcsid =
		"$Id: CreateCrossingFiber.java,v 1.1 2009/06/30 18:55:10 jhuuser Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setName("Create a Crossing Fiber Pattern");
		inputParams.setLabel("Crossing Fiber");	
		inputParams.setCategory("PAMI");
		inputParams.setPackage("Spring2009");	
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Hanlin Wan","han@jhu.edu",""));
		info.setDescription("Creates a crossing fiber pattern by weighting each tensor. Note: Does not do error checking for size mismatch. Please make sure weighting arrays are the same size as the images.");
		info.setAffiliation("Johns Hopkins University, Department of Biomedical Engineering");
		info.setVersion(revnum);	

		inputParams.add(DWdata4D=new ParamVolumeCollection("DWI and Reference Image(s) Data (4D)"));
		inputParams.add(smR=new ParamObject<ArrayList<double[][]>>("Weighting Arrays",new ArrayDoubleListTxtReaderWriter()));
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outVol=new ParamVolume("Result Volume",null,-1,-1,-1,-1));
	}
	
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {	
		ArrayList<double[][]> weight = smR.getObject();
		ImageData img = DWdata4D.getImageDataList().get(0);
		int rows = img.getRows();
		int cols = img.getCols();
		int slices = img.getSlices();
		int comps = img.getComponents();
		int n = DWdata4D.getImageDataList().size();
		
		ImageData resultVol = new ImageDataFloat(DWdata4D.getImageDataList().get(0));
		for (int i=0; i<rows; i++) {
			for (int j=0; j<cols; j++) {
				for (int k=0; k<slices; k++) {
					for (int l=0; l<comps; l++) {
						double val = 0;
						for (int m=0; m<n; m++) {
							val += DWdata4D.getImageDataList().get(m).get(i,j,k,l).doubleValue() * weight.get(m)[j][i];
						}
						resultVol.set(i, j, k, l, val);
					}
				}
			}
		}
		resultVol.setName(resultVol.getName()+"_calc");
		outVol.setValue(resultVol);
	}
}
