package edu.jhu.pami.spring2009;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import Jama.Matrix;
import edu.jhmi.rad.medic.utilities.MedicUtil;
import edu.jhu.bme.smile.commons.textfiles.TextFileReader;
import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.*;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamMatrix;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class OptimizeTensorVolume extends ProcessingAlgorithm {

	/****************************************************
	 * Input Parameters
	 ****************************************************/
	private ParamMatrix param_imgMatrix;
	private ParamFloat param_b0, param_sigma;
	private ParamVolume param_obsB0Vol, param_obsDW;
	private ParamFileCollection param_tensorEstVol;

	/****************************************************
	 * Output Parameters
	 ****************************************************/
	private ParamFileCollection tensorVolume;


	/****************************************************
	 * Other Parameters
	 ****************************************************/
	private static final String rcsid = "";
	private static final String cvsversion = "";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {

	//Set Plugin Info
	inputParams.setName("OptimizeTensorVolume");
	inputParams.setLabel("OptimizeTensorVolume");
	inputParams.setCategory("PAMI");
	inputParams.setPackage("Spring2009");
	AlgorithmInformation info=getAlgorithmInformation();
	info.setWebsite("http://sites.google.com/site/jhupami/");
	info.add(new AlgorithmAuthor("Name","Email","URL"));
	info.setDescription("Optimize a tensor volume with an 8D, Downhill Simplex Method.");
	info.setAffiliation("Johns Hopkins University, Department of Biomedical Engineering");
	info.setVersion(revnum);

	//Set Input Parameters
	inputParams.add(param_tensorEstVol = new ParamFileCollection("Tensor Estimation Volume",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
	inputParams.add(param_imgMatrix=new ParamMatrix("imgMatrix",8,6));
	inputParams.add(param_b0 = new ParamFloat("b0"));
	inputParams.add(param_sigma = new ParamFloat("sigma"));
	inputParams.add(param_obsB0Vol = new ParamVolume("Observed b0 Volume"));
	inputParams.add(param_obsDW = new ParamVolume("Observed DW Volume"));
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		tensorVolume = new ParamFileCollection("Tensor Estimate",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions));
		tensorVolume.setName("Tensor (xx,xy,xz,yy,yz,zz)");
		outputParams.add(tensorVolume);
	}

	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		//get input parameters
		Matrix imgMatrix = param_imgMatrix.getValue();
		float b0 = param_b0.getFloat();
		float sigma = param_sigma.getFloat();
		ImageData obsB0Vol = param_obsB0Vol.getImageData(); //read observed b0 volume
		ImageData obsDW = param_obsDW.getImageData(); //read observed DW data
		CubicVolumeReaderWriter rw  = CubicVolumeReaderWriter.getInstance(); //read tensor volume
		ImageData tensorEstVol = rw.read(param_tensorEstVol.getValue(0));
		ArrayList<File> outVols = new ArrayList<File>();

		//initialize output (last dimension should be 6)
		float[][][][] tensors = new float[tensorEstVol.getRows()][tensorEstVol.getCols()][tensorEstVol.getSlices()][tensorEstVol.getComponents()];

		//Loop over volume
		for (int x = 0; x < tensorEstVol.getRows(); x++) {
			for (int y = 0; y < tensorEstVol.getCols(); y++) {
				for (int z = 0; z <  tensorEstVol.getSlices(); z++) {
						//get per-voxel obsB0 value
						double voxel_obsB0 = obsB0Vol.getDouble(x, y, z);
						//get per-voxel obsDW array
						double[] voxel_obsDW = new double[obsDW.getComponents()];
						for (int a = 0; a < voxel_obsDW.length; a++) {
							voxel_obsDW[a] = obsDW.getDouble(x, y, z, a);
						}
						//get tensor estimate
						double[] voxel_dInit = new double[6];
						for (int b = 0; b < voxel_dInit.length; b++) {
							voxel_dInit[b] = tensorEstVol.getDouble(x, y, z, b);
						}

						//Optimize this tensor!
						float []tensor = Opt8DSimplex.estimate(imgMatrix, b0, sigma, voxel_obsB0, voxel_obsDW, voxel_dInit);

						//store result in output volume!
						for (int c = 0; c < tensor.length; c++) {
							tensors[x][y][z][c] = tensor[c];
						}

				} //end loop over z
			} //end loop over y
		} //end loop over x

		ImageData  out= (new ImageDataFloat(tensors));
		tensors = null;
		out.setName(param_tensorEstVol.getName()+"_TensorOpt");
		File outputSlab = rw.write(out, getOutputDirectory());
		outVols.add(outputSlab);
		out.dispose();
		out=null;
		tensorVolume.setName(param_tensorEstVol.getName()+"_TensorOpt"+".xml");
		tensorVolume.setValue(outVols);
	}
}
