/*=========================================================================

  Program:         Level-Set Segmentation for Slicer3
  Module:          LevelSetPreprocessing.cxx
  Language:        C++
  Date:            2008-07-31 15:06:54
  Version:         1.00
  Author:	       Carlos S. Mendoza - Universidad de Sevilla, Spain
  E-mail:          carlos.sanchez.mendoza@gmail.com
  Acknowledgments: This work is funded by a scholarship for research 
                   personnel instruction from the University of 
				   Sevilla, Spain.
				   
				   This work has been developed under the supervision of
				   Mr. Steve Pieper Ph.D. and Ron Kikinis M.D.,  during 
				   an internship in the Surgical Planning Laboratory in 
				   Harvard Medical School and Brigham and Women's Hospital.

=========================================================================*/

/*-------------------------------------------------------------------------

The purpose of this filter is to create a feature image that is suitable 
for a level-set algorithm from an intensity image.

It takes the original image and performs anisotropic gaussian diffusion 
on it, reducing the noise while preserving the edges.

Then the magnitude of the gradient is computed. This magnitude is then 
non-linearly remapped so as to get really small values 
in the image edges and really big values in homogeneous areas.

-------------------------------------------------------------------------*/

#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#ifdef __BORLANDC__
#define ITK_LEAN_AND_MEAN
#endif

#include "LevelSetPreprocessingCLP.h"
#include "itkOrientedImage.h"
#include "itkScalarImageToListAdaptor.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkGradientAnisotropicDiffusionImageFilter.h" 
#include "itkGradientMagnitudeImageFilter.h" 
#include "itkSigmoidImageFilter.h"
#include "itkMeanCalculator.h"
#include <iostream>

int main( int argc, char *argv[] )
{	
	PARSE_ARGS;
	const unsigned int Dimension = 3;
	typedef float InputPixelType;
	typedef float OutputPixelType;
	typedef itk::OrientedImage<OutputPixelType,Dimension> OutputImageType;
	typedef itk::OrientedImage<InputPixelType,Dimension> InputImageType;
	typedef itk::ImageFileReader<InputImageType> InputReaderType;
	typedef itk::ImageFileWriter<OutputImageType> OutputWriterType;
	typedef itk::GradientAnisotropicDiffusionImageFilter<InputImageType,OutputImageType> GADFilter;
	typedef itk::GradientMagnitudeImageFilter<InputImageType,OutputImageType> GradientFilter;
	typedef itk::SigmoidImageFilter<InputImageType,OutputImageType> SigmoidFilterType;
	typedef itk::Statistics::ScalarImageToListAdaptor<OutputImageType> SampleType;
	typedef itk::Statistics::MeanCalculator<SampleType> MeanCalculatorType;

	InputReaderType::Pointer reader = InputReaderType::New();
	OutputWriterType::Pointer writer = OutputWriterType::New();
	GADFilter::Pointer gad = GADFilter::New();
	GradientFilter::Pointer gradient = GradientFilter::New();
	SigmoidFilterType::Pointer sigmoid = SigmoidFilterType::New();
	SampleType::Pointer sample = SampleType::New();
	MeanCalculatorType::Pointer calculator = MeanCalculatorType::New();

	// We read the imege to be preprocessed and connect the pipeline
	
	reader->SetFileName(inputVolume.c_str());
	gad->SetInput(reader->GetOutput());
	gradient->SetInput(gad->GetOutput());
	
	// The first filter is the GAD filter. The blurring iterations are provided from Slicer's GUI
	// as it is the conductance parameter.
	
	gad->SetNumberOfIterations(blurringIterations);
	gad->SetTimeStep(0.125f);
	gad->SetConductanceParameter(conductance);
	
	// Now both the GAD and the gradient can be computed

	gradient->Update();
	
	// We want to compute the mean in the resulting image
	// for centering the mapping of the following sigmoid remapping

	sample->SetImage(gradient->GetOutput());
	calculator->SetInputSample(sample);
	calculator->Update();
	float mean = calculator->GetOutput()->GetElement(0);
	std::cout << mean << "\n";

	// We remap through a sigmoid that is centered in the mean value
	// of the gradient, with a slope that is controlled by a parameter

	sigmoid->SetAlpha(-contrast);
	sigmoid->SetBeta(betta*mean);
	sigmoid->SetInput(gradient->GetOutput());
	sigmoid->SetOutputMinimum(0);
	sigmoid->SetOutputMaximum(1);
	sigmoid->Print(std::cout,0);

	// The image is ready and can be written

	writer->SetFileName(outputVolume.c_str());
	writer->SetInput(sigmoid->GetOutput());

	writer->Update();
	
	std::cout << "Success"; 
	return EXIT_SUCCESS;
}
















