#include <iostream>
#include <vector>
#include <utility>
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkVector.h"
#include "itkPluginFilterWatcher.h"
#include "itkImageToVectorImageFilter.h"
#include "itkMaskImageFilter.h"
#include "itkGradientAnisotropicDiffusionImageFilter.h"
#include "itkMultiplyByConstantImageFilter.h"
#include "itkWeightedAddImageFilter.h"
#include "itkConstrainedValueDifferenceImageFilter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkImageDuplicator.h"
#include "LongitudinalDifferenceCLP.h"

int main(int argc, char * argv [])
{
  PARSE_ARGS;

  bool violated=false;
  if (inputLesionTime1.size() == 0) { violated = true; std::cout << "  --inputLesionTime1 Required! " << std::endl; }
  if (inputLesionTime2.size() == 0) { violated = true; std::cout << "  --inputLesionTime2 Required! " << std::endl; }
  if (outputImage.size() == 0) { violated = true; std::cout << "  --outputImage Required! "  << std::endl; }
  if (violated) exit(1);

  typedef unsigned short       PixelType;
  const unsigned int          Dimension = 3;

  typedef itk::Image< PixelType,  Dimension >   InputImageType;
  typedef itk::Image< float,  Dimension >   FloatImageType;
  typedef itk::ImageFileReader< InputImageType  >  ReaderType;

  ReaderType::Pointer inputLesionTime1Reader = ReaderType::New();
  ReaderType::Pointer inputLesionTime2Reader = ReaderType::New();

  inputLesionTime1Reader->SetFileName(inputLesionTime1.c_str());
  inputLesionTime2Reader->SetFileName(inputLesionTime2.c_str());

  typedef itk::ImageFileWriter< InputImageType > WriterType;
  WriterType::Pointer outputWriter = WriterType::New();

  typedef itk::ImageRegionIteratorWithIndex< InputImageType > ImageRegionIteratorType;

  typedef itk::ImageDuplicator<InputImageType> ImageDuplicatorType;
  ImageDuplicatorType::Pointer imageDuplicator = ImageDuplicatorType::New();

  /*
  typedef itk::WeightedAddImageFilter< InputImageType,InputImageType, FloatImageType> AddImageFilterType;
  AddImageFilterType::Pointer addImageFilter = AddImageFilterType::New();
  addImageFilter->SetAlpha(.25);

  typedef itk::MultiplyByConstantImageFilter<FloatImageType,int,InputImageType> MultiplyFilterType;
  MultiplyFilterType::Pointer multiplyFilter = MultiplyFilterType::New();
  multiplyFilter->SetConstant(100);
  */
  InputImageType::Pointer lesion1 = NULL;
  InputImageType::Pointer lesion2 = NULL;
  InputImageType::Pointer outputMaskImage = NULL;

  try
    {
    /*
    addImageFilter->SetInput1(inputLesionTime1Reader->GetOutput());    
    addImageFilter->SetInput2(inputLesionTime2Reader->GetOutput());    
    multiplyFilter->SetInput(addImageFilter->GetOutput());
    outputWriter->SetInput(multiplyFilter->GetOutput());
    outputWriter->SetFileName(outputImage);
    outputWriter->Update();
    */
    lesion1 = inputLesionTime1Reader->GetOutput();
    inputLesionTime1Reader->Update();
    lesion2 = inputLesionTime2Reader->GetOutput();
    inputLesionTime2Reader->Update();
    imageDuplicator->SetInputImage(inputLesionTime1Reader->GetOutput());
    imageDuplicator->Update();
    outputMaskImage = imageDuplicator->GetOutput();    

    }
  catch (itk::ExceptionObject &excep)
    {
    std::cerr << argv[0] << ": exception caught !" << std::endl;
    std::cerr << excep << std::endl;
    return EXIT_FAILURE;
    }

  /* Iterator over the lesion mask */
  ImageRegionIteratorType imgItr( lesion1,lesion1->GetRequestedRegion() );
  
  try
    {
    for ( imgItr.GoToBegin(); !imgItr.IsAtEnd(); ++imgItr)
      {
      InputImageType::IndexType idx = imgItr.GetIndex();
      if(lesion1->GetPixel(idx) == lesion2->GetPixel(idx) && lesion1->GetPixel(idx) == 0)
        {
        //outputMaskImage->SetPixel(idx,64);
        outputMaskImage->SetPixel(idx,0);
        }
      if(lesion1->GetPixel(idx) == lesion2->GetPixel(idx) && lesion1->GetPixel(idx) > 0)
        {
        outputMaskImage->SetPixel(idx,248);
        }
      else if (lesion1->GetPixel(idx) < lesion2->GetPixel(idx))
        {
        outputMaskImage->SetPixel(idx,254);
        }
      else if (lesion1->GetPixel(idx) > lesion2->GetPixel(idx))
        {
        outputMaskImage->SetPixel(idx,247);
        }
      else
        {
        // All possibilities already covered.
        }
      }

    outputWriter->SetInput(outputMaskImage);
    outputWriter->SetFileName(outputImage);
    outputWriter->Update();
    }
  catch (itk::ExceptionObject &excep)
    {
    std::cerr << argv[0] << ": exception caught !" << std::endl;
    std::cerr << excep << std::endl;
    return EXIT_FAILURE;
    }

  return EXIT_SUCCESS;
}
