#include <iostream>
//#include <vector>
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkListSample.h"
#include "itkVector.h"
#include "itkMaskImageFilter.h"
#include "itkMeanImageFilter.h"
#include "itkMedianImageFilter.h"
#include "itkGrayscaleDilateImageFilter.h"
#include "itkGrayscaleErodeImageFilter.h"
#include "itkLabelStatisticsImageFilter.h"
#include "itkScalarImageKmeansImageFilter.h"
#include "itkDanielssonDistanceMapImageFilter.h"
#include "itkBinaryThresholdImageFilter.h"
#include "itkCastImageFilter.h"
#include "itkBinaryBallStructuringElement.h"
#if !defined(ITK_USE_REVIEW_STATISTICS)
 #include "itkGaussianDensityFunction.h"
 #include "itkEuclideanDistance.h"
 #include "itkSampleClassifier.h"
#include "itkMembershipSample.h"
#else
 #include "mySampleClassifier.h"
 #include "myMembershipSample.h"
 #include "itkEuclideanDistanceMetric.h"
 #include "itkGaussianMembershipFunction.h"
#endif
#include "itkFixedArray.h"
#include "itkAddImageAdaptor.h"
#include "itkThresholdImageFilter.h"
#include "itkImageDuplicator.h"
#include "itkMaximumRatioDecisionRule.h"
#include "itkVariableSizeMatrix.h"
#include "itkConstrainedValueDifferenceImageFilter.h"
#include "itkBinaryThresholdImageFilter.h"
#include "itkPluginFilterWatcher.h"
#include "svm.h"
#include "lesionSegmentationModel.h"
#include "PredictLesionsCLP.h"

#define FEATURE_LENGTH 49
#define BAYES_LENGTH 34
//#define EUCLID_LENGTH 5
#define EUCLID_LENGTH 39

int main(int argc, char * argv [])
{
  PARSE_ARGS;

  bool violated=false;
  if (inputT1Volume.size() == 0) { violated = true; std::cout << "  --inputT1Volume Required! "  << std::endl; }
  if (inputT2Volume.size() == 0) { violated = true; std::cout << "  --inputT2Volume Required! "  << std::endl; }
  if (inputFLAIRVolume.size() == 0) { violated = true; std::cout << "  --inputFLAIRVolume Required! "  << std::endl; }
  if (inputMaskVolume.size() == 0) { violated = true; std::cout << "  --inputMaskVolume Required! "  << std::endl; }
  if (outputLesionMask.size() == 0) { violated = true; std::cout << "  --outputLesionMask Required! "  << std::endl; }
  if (outputLesionProb.size() == 0) { violated = true; std::cout << "  --outputLesionProb Required! "  << std::endl; }
  if (inputModelFile.size() == 0) { violated = true; std::cout << "  --inputModelFile Required! "  << std::endl; }
  if (inputSVMModelFile.size() == 0) { violated = true; std::cout << "  --inputSVMModelFile Required! "  << std::endl; }
  if (violated) exit(1);

  typedef itk::Vector< double, FEATURE_LENGTH > MeasurementVectorType;
  typedef itk::Vector<unsigned int, FEATURE_LENGTH> IndexVectorType;
  typedef itk::Vector<double, EUCLID_LENGTH> EuclidVectorType;
  typedef itk::Vector<double, BAYES_LENGTH> BayesVectorType;

  IndexVectorType featureIndexes; featureIndexes.Fill(0);
  featureIndexes[0]=36;featureIndexes[1]=46;featureIndexes[2]=42;featureIndexes[3]=40; 
  featureIndexes[4]=1;featureIndexes[5]=41;featureIndexes[6]=2;featureIndexes[7]=30; 
  featureIndexes[8]=44;featureIndexes[9]=21;featureIndexes[10]=48;featureIndexes[11]=37;
  featureIndexes[12]=39;featureIndexes[13]=11;featureIndexes[14]=47;featureIndexes[15]=31;
  featureIndexes[16]=33;featureIndexes[17]=27;featureIndexes[18]=38;featureIndexes[19]=45;
  featureIndexes[20]=29;featureIndexes[21]=34;featureIndexes[22]=20;featureIndexes[23]=23;
  featureIndexes[24]=3;featureIndexes[25]=18;featureIndexes[26]=5;featureIndexes[27]=12;
  featureIndexes[28]=35;featureIndexes[29]=26;featureIndexes[30]=15;featureIndexes[31]=28;
  featureIndexes[32]=8;featureIndexes[33]=43;featureIndexes[34]=9;featureIndexes[35]=17;
  featureIndexes[36]=24;featureIndexes[37]=0;featureIndexes[38]=14;featureIndexes[39]=6;
  featureIndexes[40]=32;featureIndexes[41]=19;featureIndexes[42]=25;featureIndexes[43]=13;
  featureIndexes[44]=16;featureIndexes[45]=10;featureIndexes[46]=22;featureIndexes[47]=4;
  featureIndexes[48]=7;


  typedef float                 PixelType;
  //typedef unsigned long       PixelType;
  const unsigned int          Dimension = 3;

  typedef itk::Image< PixelType,  Dimension >   ImageType;
  typedef itk::Image< unsigned short, Dimension > ShortImageType;
  typedef itk::Image< char,  Dimension >   MaskImageType;
  typedef itk::ImageFileReader< ImageType  >  ReaderType;
  typedef itk::ImageFileWriter< ImageType  >  WriterType;
  typedef itk::ImageFileReader< MaskImageType  >  MaskReaderType;

  ReaderType::Pointer t1Reader = ReaderType::New();
  ReaderType::Pointer t2Reader = ReaderType::New();
  ReaderType::Pointer flairReader = ReaderType::New();
  MaskReaderType::Pointer maskReader = MaskReaderType::New();

  WriterType::Pointer lesionWriter = WriterType::New();

  t1Reader->SetFileName( inputT1Volume.c_str() );
  double start = 0;
  double fraction = .0025;
  itk::PluginFilterWatcher watcht1Reader(t1Reader,"t1Reader",CLPProcessInformation,fraction,start);
  start+=fraction;
      
  t2Reader->SetFileName( inputT2Volume.c_str() );
  
  itk::PluginFilterWatcher watcht2Reader(t2Reader,"t2Reader",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  flairReader->SetFileName( inputFLAIRVolume.c_str() );
  
  itk::PluginFilterWatcher watchflairReader(flairReader,"flairReader",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  maskReader->SetFileName( inputMaskVolume.c_str() );

  itk::PluginFilterWatcher watchamaskReader(maskReader,"maskReader",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  typedef itk::MaskImageFilter< ImageType, MaskImageType, ImageType > MaskFilterType;
  MaskFilterType::Pointer t1MaskFilter = MaskFilterType::New();
  MaskFilterType::Pointer t2MaskFilter = MaskFilterType::New();
  MaskFilterType::Pointer flairMaskFilter = MaskFilterType::New();
  MaskFilterType::Pointer clippedT1Filter = MaskFilterType::New();

  itk::PluginFilterWatcher watchat1maskFilter(maskReader,"T1 Mask Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
  itk::PluginFilterWatcher watchat2maskFilter(maskReader,"T2 Mask Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
  itk::PluginFilterWatcher watchaflairmaskFilter(maskReader,"Flair Mask Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
  itk::PluginFilterWatcher watchaclippedmaskFilter(maskReader,"Clipped Mask Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  typedef itk::LabelStatisticsImageFilter< ImageType, MaskImageType > LabelStatisticsFilterType;
  typedef LabelStatisticsFilterType::RealType StatisticRealType;
  LabelStatisticsFilterType::Pointer statisticsFilter = LabelStatisticsFilterType::New();
 
  itk::PluginFilterWatcher watchlabelStats(statisticsFilter,"Statistics Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  int brainLabel = 255;

  /* The Scalar Image Kmeans Image Filter will find a code image in 3 classes
     for the interior of the mask, plus a code for the exterior of the mask. */
  typedef itk::ScalarImageKmeansImageFilter< ImageType > KMeansFilterType;
  typedef KMeansFilterType::RealPixelType RealPixelType;
  KMeansFilterType::Pointer kmeansFilter = KMeansFilterType::New();

  fraction = 0.05;
  itk::PluginFilterWatcher watchkmeansfilter(kmeansFilter,"kMeans Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  unsigned int numberOfInitialClasses = 4;
  const PixelType imageExclusion = -32000;

  clippedT1Filter->SetInput1( t1Reader->GetOutput() );
  clippedT1Filter->SetInput2( maskReader->GetOutput() );
  clippedT1Filter->SetOutsideValue( imageExclusion );
  clippedT1Filter->Update();

  typedef KMeansFilterType::OutputImageType LabelImageType;

  typedef itk::CastImageFilter<LabelImageType,ShortImageType> CastFilterType;
  CastFilterType::Pointer castFilter = CastFilterType::New();

  fraction = 0.0033;
  itk::PluginFilterWatcher watchcastFilter(castFilter,"Cast Filter",CLPProcessInformation,fraction,start);
  start+=fraction;

  typedef itk::CastImageFilter<MaskImageType,ImageType> MaskCastFilterType;
  MaskCastFilterType::Pointer lesionCastFilter = MaskCastFilterType::New();

  itk::PluginFilterWatcher watchlesioncastFilter(lesionCastFilter,"Lesion Cast Filter",CLPProcessInformation,fraction,start);
  start+=fraction;

  typedef itk::BinaryThresholdImageFilter<LabelImageType,LabelImageType> BinaryThresholdFilterType;
  BinaryThresholdFilterType::Pointer grayBinaryFilter = BinaryThresholdFilterType::New();
  BinaryThresholdFilterType::Pointer whiteBinaryFilter = BinaryThresholdFilterType::New();
  BinaryThresholdFilterType::Pointer csfBinaryFilter = BinaryThresholdFilterType::New();

  itk::PluginFilterWatcher watchgrayBinaryFilter(grayBinaryFilter,"Gray Binary Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  itk::PluginFilterWatcher watchwhiteBinaryFilter(whiteBinaryFilter,"White Binary Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  itk::PluginFilterWatcher watchcsfBinaryFilter(csfBinaryFilter,"CSF Binary Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  typedef itk::DanielssonDistanceMapImageFilter< LabelImageType, LabelImageType> DistanceMapFilterType;
  DistanceMapFilterType::Pointer grayDistanceMapFilter = DistanceMapFilterType::New();
  DistanceMapFilterType::Pointer whiteDistanceMapFilter = DistanceMapFilterType::New();
  DistanceMapFilterType::Pointer csfDistanceMapFilter = DistanceMapFilterType::New();
  typedef DistanceMapFilterType::OutputImageType DistanceMapImageType;
  
  fraction = 0.025;
  itk::PluginFilterWatcher watchgrayDistanceFilter(grayDistanceMapFilter,"Gray Distance Map",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  itk::PluginFilterWatcher watchwhiteDistanceFilter(whiteDistanceMapFilter,"White Distance Map",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  itk::PluginFilterWatcher watchcsfDistanceFilter(csfDistanceMapFilter,"CSF Distance Map",CLPProcessInformation,fraction,start);
  start+=fraction;
  
  typedef itk::MeanImageFilter< ImageType, ImageType > MeanFilterType;
  MeanFilterType::Pointer t1Mean1Filter = MeanFilterType::New();
  MeanFilterType::Pointer t1Mean2Filter = MeanFilterType::New();
  MeanFilterType::Pointer t1Mean3Filter = MeanFilterType::New();
  MeanFilterType::Pointer t2Mean1Filter = MeanFilterType::New();
  MeanFilterType::Pointer t2Mean2Filter = MeanFilterType::New();
  MeanFilterType::Pointer t2Mean3Filter = MeanFilterType::New();
  MeanFilterType::Pointer flairMean1Filter = MeanFilterType::New();
  MeanFilterType::Pointer flairMean2Filter = MeanFilterType::New();
  MeanFilterType::Pointer flairMean3Filter = MeanFilterType::New();

  fraction = 0.0033;
  itk::PluginFilterWatcher watcht1mean1Filter(t1Mean1Filter,"T1 Mean Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht1mean2Filter(t1Mean2Filter,"T1 Mean Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht1mean3Filter(t1Mean3Filter,"T1 Mean Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht2mean1Filter(t2Mean1Filter,"T2 Mean Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht2mean2Filter(t2Mean2Filter,"T2 Mean Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht2mean3Filter(t2Mean3Filter,"T2 Mean Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watchflairmean1Filter(flairMean1Filter,"FLAIR Mean Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watchflairmean2Filter(flairMean2Filter,"FLAIR Mean Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watchflairmean3Filter(flairMean3Filter,"FLAIR Mean Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;

  typedef itk::MedianImageFilter< ImageType, ImageType > MedianFilterType;
  MedianFilterType::Pointer t1Median1Filter = MedianFilterType::New();
  MedianFilterType::Pointer t1Median2Filter = MedianFilterType::New();
  MedianFilterType::Pointer t1Median3Filter = MedianFilterType::New();
  MedianFilterType::Pointer t2Median1Filter = MedianFilterType::New();
  MedianFilterType::Pointer t2Median2Filter = MedianFilterType::New();
  MedianFilterType::Pointer t2Median3Filter = MedianFilterType::New();
  MedianFilterType::Pointer flairMedian1Filter = MedianFilterType::New();
  MedianFilterType::Pointer flairMedian2Filter = MedianFilterType::New();
  MedianFilterType::Pointer flairMedian3Filter = MedianFilterType::New();

  itk::PluginFilterWatcher watcht1median1Filter(t1Median1Filter,"T1 Median Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht1median2Filter(t1Median2Filter,"T1 Median Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht1median3Filter(t1Median3Filter,"T1 Median Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht2median1Filter(t2Median1Filter,"T2 Median Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht2median2Filter(t2Median2Filter,"T2 Median Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watcht2median3Filter(t2Median3Filter,"T2 Median Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watchflairmedian1Filter(flairMedian1Filter,"FLAIR Median Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watchflairmedian2Filter(flairMedian2Filter,"FLAIR Median Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;

  itk::PluginFilterWatcher watchflairmedian3Filter(flairMedian3Filter,"FLAIR Median Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;

  MeanFilterType::InputSizeType radius1;
  radius1[0] = 1;
  radius1[1] = 1;
  radius1[2] = 1;

  MeanFilterType::InputSizeType radius2;
  radius2[0] = 2;
  radius2[1] = 2;
  radius2[2] = 2;

  MeanFilterType::InputSizeType radius3;
  radius3[0] = 3;
  radius3[1] = 3;
  radius3[2] = 3;

  try {
    t1MaskFilter->SetInput1( t1Reader->GetOutput() );
    t1MaskFilter->SetInput2( maskReader->GetOutput() );
    //t1MaskFilter->SetOutsideValue(imageExclusion);
    t1MaskFilter->SetOutsideValue(0);
    t1MaskFilter->Update();
    
    t2MaskFilter->SetInput1( t2Reader->GetOutput() );
    t2MaskFilter->SetInput2( maskReader->GetOutput() );
    t2MaskFilter->SetOutsideValue(0);
    t2MaskFilter->Update();
  
    flairMaskFilter->SetInput1( flairReader->GetOutput() );
    flairMaskFilter->SetInput2( maskReader->GetOutput() );
    flairMaskFilter->SetOutsideValue(0);
    flairMaskFilter->Update();

    statisticsFilter->SetInput( t1MaskFilter->GetOutput() );
    statisticsFilter->SetLabelInput( maskReader->GetOutput() );
    statisticsFilter->Update();
    
    //const PixelType imageMin = static_cast<PixelType> ( statisticsFilter->GetMinimum(brainLabel) );
    //const PixelType imageMax = static_cast<PixelType> ( statisticsFilter->GetMaximum(brainLabel) );
    const StatisticRealType imageMean = statisticsFilter->GetMean(brainLabel);
    const StatisticRealType imageSigma = statisticsFilter->GetSigma(brainLabel);
  
    const RealPixelType csfInitialMean = imageMean - 2*imageSigma;
    const RealPixelType whiteInitialMean = imageMean + imageSigma;
    const RealPixelType grayInitialMean = imageMean - imageSigma/5;

    RealPixelType backgroundInitialMean = imageExclusion;
    kmeansFilter->AddClassWithInitialMean( backgroundInitialMean );
    kmeansFilter->AddClassWithInitialMean( csfInitialMean );
    kmeansFilter->AddClassWithInitialMean( grayInitialMean );
    kmeansFilter->AddClassWithInitialMean( whiteInitialMean );

    //kmeansFilter->SetInput( t1MaskFilter->GetOutput() );
    kmeansFilter->SetInput( clippedT1Filter->GetOutput() );
    castFilter->SetInput(kmeansFilter->GetOutput());
    castFilter->Update();

    grayBinaryFilter->SetInput(kmeansFilter->GetOutput());
    grayBinaryFilter->SetLowerThreshold(2);
    grayBinaryFilter->SetUpperThreshold(2);
    grayDistanceMapFilter->SetInput( grayBinaryFilter->GetOutput() );
    grayDistanceMapFilter->UseImageSpacingOff();
    grayDistanceMapFilter->SquaredDistanceOff();
    grayDistanceMapFilter->Update();

    whiteBinaryFilter->SetInput(kmeansFilter->GetOutput());
    whiteBinaryFilter->SetLowerThreshold(1);
    whiteBinaryFilter->SetUpperThreshold(1);
    whiteDistanceMapFilter->SetInput( whiteBinaryFilter->GetOutput() );
    whiteDistanceMapFilter->UseImageSpacingOff();
    whiteDistanceMapFilter->SquaredDistanceOff();
    whiteDistanceMapFilter->Update();
    
    csfBinaryFilter->SetInput(kmeansFilter->GetOutput());
    csfBinaryFilter->SetLowerThreshold(3);
    csfBinaryFilter->SetUpperThreshold(3);
    csfDistanceMapFilter->SetInput( csfBinaryFilter->GetOutput() );
    csfDistanceMapFilter->UseImageSpacingOff();
    csfDistanceMapFilter->SquaredDistanceOff();
    csfDistanceMapFilter->Update();

    t1Mean1Filter->SetInput( t1MaskFilter->GetOutput() );
    t1Mean1Filter->SetRadius( radius1 );
    t1Mean1Filter->Update();

    t1Mean2Filter->SetInput( t1MaskFilter->GetOutput() );
    t1Mean2Filter->SetRadius( radius2 );
    t1Mean2Filter->Update();

    t1Mean3Filter->SetInput( t1MaskFilter->GetOutput() );
    t1Mean3Filter->SetRadius( radius3 );
    t1Mean3Filter->Update();

    t2Mean1Filter->SetInput( t2MaskFilter->GetOutput() );
    t2Mean1Filter->SetRadius( radius1 );
    t2Mean1Filter->Update();

    t2Mean2Filter->SetInput( t2MaskFilter->GetOutput() );
    t2Mean2Filter->SetRadius( radius2 );
    t2Mean2Filter->Update();

    t2Mean3Filter->SetInput( t2MaskFilter->GetOutput() );
    t2Mean3Filter->SetRadius( radius3 );
    t2Mean3Filter->Update();

    flairMean1Filter->SetInput( flairMaskFilter->GetOutput() );
    flairMean1Filter->SetRadius( radius1 );
    flairMean1Filter->Update();

    flairMean2Filter->SetInput( flairMaskFilter->GetOutput() );
    flairMean2Filter->SetRadius( radius2 );
    flairMean2Filter->Update();

    flairMean3Filter->SetInput( flairMaskFilter->GetOutput() );
    flairMean3Filter->SetRadius( radius3 );
    flairMean3Filter->Update();

    t1Median1Filter->SetInput( t1MaskFilter->GetOutput() );
    t1Median1Filter->SetRadius( radius1 );
    t1Median1Filter->Update();

    t1Median2Filter->SetInput( t1MaskFilter->GetOutput() );
    t1Median2Filter->SetRadius( radius2 );
    t1Median2Filter->Update();

    t1Median3Filter->SetInput( t1MaskFilter->GetOutput() );
    t1Median3Filter->SetRadius( radius3 );
    t1Median3Filter->Update();

    t2Median1Filter->SetInput( t2MaskFilter->GetOutput() );
    t2Median1Filter->SetRadius( radius1 );
    t2Median1Filter->Update();

    t2Median2Filter->SetInput( t2MaskFilter->GetOutput() );
    t2Median2Filter->SetRadius( radius2 );
    t2Median2Filter->Update();

    t2Median3Filter->SetInput( t2MaskFilter->GetOutput() );
    t2Median3Filter->SetRadius( radius3 );
    t2Median3Filter->Update();

    flairMedian1Filter->SetInput( flairMaskFilter->GetOutput() );
    flairMedian1Filter->SetRadius( radius1 );
    flairMedian1Filter->Update();

    flairMedian2Filter->SetInput( flairMaskFilter->GetOutput() );
    flairMedian2Filter->SetRadius( radius2 );
    flairMedian2Filter->Update();

    flairMedian3Filter->SetInput( flairMaskFilter->GetOutput() );
    flairMedian3Filter->SetRadius( radius3 );
    flairMedian3Filter->Update();
  }
  catch (itk::ExceptionObject &excep)
  {
    std::cerr << argv[0] << ": exception caught !" << std::endl;
    std::cerr << excep << std::endl;
    return EXIT_FAILURE;
  }

  /* Perform the mathematical morphometry dilate operation for 
  ** the flair and T1 with radius 1, 2, and 3.
  */
  typedef itk::BinaryBallStructuringElement<PixelType,Dimension > StructuringElementType;
  typedef itk::GrayscaleDilateImageFilter< ImageType, ImageType, StructuringElementType > DilateFilterType; 
  DilateFilterType::Pointer t1GrayscaleDilate1 = DilateFilterType::New();
  DilateFilterType::Pointer t1GrayscaleDilate2 = DilateFilterType::New();
  DilateFilterType::Pointer t1GrayscaleDilate3 = DilateFilterType::New();
  DilateFilterType::Pointer t2GrayscaleDilate1 = DilateFilterType::New();
  DilateFilterType::Pointer t2GrayscaleDilate2 = DilateFilterType::New();
  DilateFilterType::Pointer t2GrayscaleDilate3 = DilateFilterType::New();
  DilateFilterType::Pointer flairGrayscaleDilate1 = DilateFilterType::New();
  DilateFilterType::Pointer flairGrayscaleDilate2 = DilateFilterType::New();
  DilateFilterType::Pointer flairGrayscaleDilate3 = DilateFilterType::New();
 
  itk::PluginFilterWatcher watcht1GrayscaleDilate1(t1GrayscaleDilate1,"T1 Grayscale Dilate Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht1GrayscaleDilate2(t1GrayscaleDilate2,"T1 Grayscale Dilate Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht1GrayscaleDilate3(t1GrayscaleDilate3,"T1 Grayscale Dilate Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht2GrayscaleDilate1(t2GrayscaleDilate1,"T2 Grayscale Dilate Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht2GrayscaleDilate2(t2GrayscaleDilate2,"T2 Grayscale Dilate Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht2GrayscaleDilate3(t2GrayscaleDilate3,"T2 Grayscale Dilate Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watchflairGrayscaleDilate1(flairGrayscaleDilate1,"FLAIR Grayscale Dilate Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watchflairGrayscaleDilate2(flairGrayscaleDilate2,"FLAIR Grayscale Dilate Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watchflairGrayscaleDilate3(flairGrayscaleDilate3,"FLAIR Grayscale Dilate Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  typedef itk::GrayscaleErodeImageFilter< ImageType, ImageType, StructuringElementType > ErodeFilterType; 
  ErodeFilterType::Pointer t1GrayscaleErode1 = ErodeFilterType::New();
  ErodeFilterType::Pointer t2GrayscaleErode1 = ErodeFilterType::New();
  ErodeFilterType::Pointer flairGrayscaleErode1 = ErodeFilterType::New();
  ErodeFilterType::Pointer t1GrayscaleErode2 = ErodeFilterType::New();
  ErodeFilterType::Pointer t2GrayscaleErode2 = ErodeFilterType::New();
  ErodeFilterType::Pointer flairGrayscaleErode2 = ErodeFilterType::New();
  ErodeFilterType::Pointer t1GrayscaleErode3 = ErodeFilterType::New();
  ErodeFilterType::Pointer t2GrayscaleErode3 = ErodeFilterType::New();
  ErodeFilterType::Pointer flairGrayscaleErode3 = ErodeFilterType::New();
          
  itk::PluginFilterWatcher watcht1GrayscaleErode1(t1GrayscaleErode1,"T1 Grayscale Erode Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht1GrayscaleErode2(t1GrayscaleErode2,"T1 Grayscale Erode Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht1GrayscaleErode3(t1GrayscaleErode3,"T1 Grayscale Erode Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht2GrayscaleErode1(t2GrayscaleErode1,"T2 Grayscale Erode Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht2GrayscaleErode2(t2GrayscaleErode2,"T2 Grayscale Erode Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht2GrayscaleErode3(t2GrayscaleErode3,"T2 Grayscale Erode Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watchflairGrayscaleErode1(flairGrayscaleErode1,"FLAIR Grayscale Erode Radius 1",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watchflairGrayscaleErode2(flairGrayscaleErode2,"FLAIR Grayscale Erode Radius 2",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watchflairGrayscaleErode3(flairGrayscaleErode3,"FLAIR Grayscale Erode Radius 3",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  StructuringElementType structuringElement1;  
  structuringElement1.SetRadius( 1 ); 
  structuringElement1.CreateStructuringElement();  
  t1GrayscaleDilate1->SetKernel( structuringElement1 );
  t2GrayscaleDilate1->SetKernel( structuringElement1 );
  flairGrayscaleDilate1->SetKernel( structuringElement1 );
  t1GrayscaleErode1->SetKernel( structuringElement1 );
  t2GrayscaleErode1->SetKernel( structuringElement1 );
  flairGrayscaleErode1->SetKernel( structuringElement1 );

  StructuringElementType structuringElement2;  
  structuringElement2.SetRadius( 2 ); 
  structuringElement2.CreateStructuringElement();  
  t1GrayscaleDilate2->SetKernel( structuringElement2 );
  t2GrayscaleDilate2->SetKernel( structuringElement2 );
  flairGrayscaleDilate2->SetKernel( structuringElement2 );
  t1GrayscaleErode2->SetKernel( structuringElement2 );
  t2GrayscaleErode2->SetKernel( structuringElement2 );
  flairGrayscaleErode2->SetKernel( structuringElement2 );

  StructuringElementType structuringElement3;  
  structuringElement3.SetRadius( 3 ); 
  structuringElement3.CreateStructuringElement();  
  t1GrayscaleDilate3->SetKernel( structuringElement3 );
  t2GrayscaleDilate3->SetKernel( structuringElement3 );
  flairGrayscaleDilate3->SetKernel( structuringElement3 );
  t1GrayscaleErode3->SetKernel( structuringElement3 );
  t2GrayscaleErode3->SetKernel( structuringElement3 );
  flairGrayscaleErode3->SetKernel( structuringElement3 );

  try
  {
    t1GrayscaleDilate1->SetInput( t1MaskFilter->GetOutput() );
    t1GrayscaleDilate1->Update();
    t1GrayscaleDilate2->SetInput( t1MaskFilter->GetOutput() );
    t1GrayscaleDilate2->Update();
    t1GrayscaleDilate3->SetInput( t1MaskFilter->GetOutput() );
    t1GrayscaleDilate3->Update();

    t1GrayscaleErode1->SetInput( t1MaskFilter->GetOutput() );
    t1GrayscaleErode1->Update();
    t1GrayscaleErode2->SetInput( t1MaskFilter->GetOutput() );
    t1GrayscaleErode2->Update();
    t1GrayscaleErode3->SetInput( t1MaskFilter->GetOutput() );
    t1GrayscaleErode3->Update();

    t2GrayscaleDilate1->SetInput( t2MaskFilter->GetOutput() );
    t2GrayscaleDilate1->Update();
    t2GrayscaleDilate2->SetInput( t2MaskFilter->GetOutput() );
    t2GrayscaleDilate2->Update();
    t2GrayscaleDilate3->SetInput( t2MaskFilter->GetOutput() );
    t2GrayscaleDilate3->Update();

    t2GrayscaleErode1->SetInput( t2MaskFilter->GetOutput() );
    t2GrayscaleErode1->Update();
    t2GrayscaleErode2->SetInput( t2MaskFilter->GetOutput() );
    t2GrayscaleErode2->Update();
    t2GrayscaleErode3->SetInput( t2MaskFilter->GetOutput() );
    t2GrayscaleErode3->Update();

    flairGrayscaleDilate1->SetInput( flairMaskFilter->GetOutput() );
    flairGrayscaleDilate1->Update();
    flairGrayscaleDilate2->SetInput( flairMaskFilter->GetOutput() );
    flairGrayscaleDilate2->Update();
    flairGrayscaleDilate3->SetInput( flairMaskFilter->GetOutput() );
    flairGrayscaleDilate3->Update();
    
    flairGrayscaleErode1->SetInput( flairMaskFilter->GetOutput() );
    flairGrayscaleErode1->Update();
    flairGrayscaleErode2->SetInput( flairMaskFilter->GetOutput() );
    flairGrayscaleErode2->Update();
    flairGrayscaleErode3->SetInput( flairMaskFilter->GetOutput() );
    flairGrayscaleErode3->Update();
  }
  catch (itk::ExceptionObject &excep)
  {
    std::cerr << argv[0] << ": exception caught !" << std::endl;
    return EXIT_FAILURE;
  }          

  typedef itk::ConstrainedValueDifferenceImageFilter< ImageType, ImageType, ImageType > DifferenceFilterType;
  DifferenceFilterType::Pointer t1DifferenceFilter = DifferenceFilterType::New(); 
  DifferenceFilterType::Pointer t2DifferenceFilter = DifferenceFilterType::New(); 
  DifferenceFilterType::Pointer flairDifferenceFilter = DifferenceFilterType::New(); 

  itk::PluginFilterWatcher watcht1DifferenceFilter(t1DifferenceFilter,"T1 Difference Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watcht2DifferenceFilter(t2DifferenceFilter,"T2 Difference Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  itk::PluginFilterWatcher watchflairDifferenceFilter(flairDifferenceFilter,"FLAIR Difference Filter",CLPProcessInformation,fraction,start);
  start+=fraction;
    
  typedef itk::ImageDuplicator<ImageType> ImageDuplicatorType;
  ImageDuplicatorType::Pointer t1DuplicateImageFilter = ImageDuplicatorType::New();
  ImageDuplicatorType::Pointer t2DuplicateImageFilter = ImageDuplicatorType::New();
  ImageDuplicatorType::Pointer flairDuplicateImageFilter = ImageDuplicatorType::New();

  //itk::PluginFilterWatcher watcht1duplicatorFilter(t1DuplicateImageFilter,"Duplicating T1",CLPProcessInformation,fraction,start);
  //start+=fraction;
    
  //itk::PluginFilterWatcher watcht2duplicatorFilter(t2DuplicateImageFilter,"Duplicating T2",CLPProcessInformation,fraction,start);
  //start+=fraction;
    
  //itk::PluginFilterWatcher watchflairduplicatorFilter(flairDuplicateImageFilter,"Duplicating T2",CLPProcessInformation,fraction,start);
  //start+=fraction;
    
  try
  {
    t1DuplicateImageFilter->SetInputImage(t1MaskFilter->GetOutput());
    t1DuplicateImageFilter->Update();

    t2DuplicateImageFilter->SetInputImage(t2MaskFilter->GetOutput());
    t2DuplicateImageFilter->Update();
    
    flairDuplicateImageFilter->SetInputImage(flairMaskFilter->GetOutput());
    flairDuplicateImageFilter->Update();
  }
  catch (itk::ExceptionObject &excep)
  {
    std::cerr << argv[0] << ": exception caught !" << std::endl;
    return EXIT_FAILURE;
  }          

  typedef itk::ImageRegionIterator< ImageType > ImageRegionIteratorType;
  ImageRegionIteratorType imgItr( t1MaskFilter->GetOutput(),t1MaskFilter->GetOutput()->GetRequestedRegion() );
  unsigned long xMax = t1MaskFilter->GetOutput()->GetLargestPossibleRegion().GetSize()[0];
  unsigned long yMax = t1MaskFilter->GetOutput()->GetLargestPossibleRegion().GetSize()[1];
  unsigned long zMax = t1MaskFilter->GetOutput()->GetLargestPossibleRegion().GetSize()[2];

  std::cout << "<filter-start>" << std::endl;
  std::cout << "<filter-name>FlippedDifferenceImageFilter</filter-name>" << std::endl;
  std::cout << "<filter-comment>Calculating Flipped Difference</filter-comment>" << std::endl;
  std::cout << "</filter-start>" << std::endl;
  std::cout << "<filter-progress>" << start << "</filter-start>" << std::endl;
  std::cout << "<filter-stage-progress>0</filter-stage-progress>" << std::endl;

  unsigned int tempCount = 0;
  unsigned long totalSize = xMax*yMax*zMax;
  float tempProgress = 0;
  fraction = .1;

  for ( imgItr.GoToBegin(); !imgItr.IsAtEnd(); ++imgItr)
  { 
    ImageType::IndexType idx = imgItr.GetIndex();
    ImageType::IndexType idxOpposite = imgItr.GetIndex();
    idxOpposite[0] = xMax - idx[0];
    if(maskReader->GetOutput()->GetPixel(idx) != 0)
    { 
      t1DuplicateImageFilter->GetOutput()->SetPixel(idx,t1MaskFilter->GetOutput()->GetPixel(idxOpposite));
      t2DuplicateImageFilter->GetOutput()->SetPixel(idx,t2MaskFilter->GetOutput()->GetPixel(idxOpposite));
      flairDuplicateImageFilter->GetOutput()->SetPixel(idx,flairMaskFilter->GetOutput()->GetPixel(idxOpposite));
      if(tempCount%10000 == 0)
      { 
        tempProgress += 0.01;
        start+= fraction/100;
        std::cout << "<filter-progress>" << start << "</filter-start>" << std::endl;
        std::cout << "<filter-stage-progress>" << tempProgress << "</filter-stage-progress>" << std::endl;
      }
      tempCount++;
    }
  }
  
  std::cout << "<filter-end>" << std::endl;
  std::cout << "<filter-name>FlippedDifferenceImageFilter</filter-name>" << std::endl;
  std::cout << "<filter-time>1</filter-time>" << std::endl;

  try
  {
    t1DifferenceFilter->SetInput1( t1DuplicateImageFilter->GetOutput() );
    t1DifferenceFilter->SetInput2( t1MaskFilter->GetOutput() );
    t1DifferenceFilter->Update();

    t2DifferenceFilter->SetInput1( t2DuplicateImageFilter->GetOutput() );
    t2DifferenceFilter->SetInput2( t2MaskFilter->GetOutput() );
    t2DifferenceFilter->Update();

    flairDifferenceFilter->SetInput1( flairDuplicateImageFilter->GetOutput() );
    flairDifferenceFilter->SetInput2( flairMaskFilter->GetOutput() );
    flairDifferenceFilter->Update();
  }
  catch (itk::ExceptionObject &excep)
  {
    std::cerr << argv[0] << ": exception caught !" << excep << std::endl;
    return EXIT_FAILURE;
  }

 
  /* Need the means and standard deviations of all the features for 
  ** this individual.  These values are used later to zero mean each
  ** feature and set the standard deviation to one.  There doesn't 
  ** appear to be an ITK filter for doing this automatically.  This 
  ** is single threaded, and likely could be made MUCH more efficient.
  */
  ImageRegionIteratorType t1Itr( t1MaskFilter->GetOutput(), t1MaskFilter->GetOutput()->GetRequestedRegion() );

  MeasurementVectorType trainMeans(FEATURE_LENGTH); trainMeans.Fill(0);
  MeasurementVectorType trainSigmas(FEATURE_LENGTH); trainSigmas.Fill(0);

  unsigned int count = 0;
  
  std::cout << "<filter-start>" << std::endl;
  std::cout << "<filter-name>FeatureStatistics</filter-name>" << std::endl;
  std::cout << "<filter-comment>Calculating Feature Statistics</filter-comment>" << std::endl;
  std::cout << "</filter-start>" << std::endl;
  std::cout << "<filter-progress>" << start << "</filter-start>" << std::endl;
  std::cout << "<filter-stage-progress>0</filter-stage-progress>" << std::endl;

  tempProgress = 0;
  tempCount = 0; 
  for ( t1Itr.GoToBegin(); !t1Itr.IsAtEnd(); ++t1Itr)
  {
    ImageType::IndexType idx = t1Itr.GetIndex();
    if( maskReader->GetOutput()->GetPixel(idx) !=0 )
    {
      trainMeans[0] += castFilter->GetOutput()->GetPixel(idx);
      trainMeans[1] += whiteDistanceMapFilter->GetOutput()->GetPixel(idx);
      trainMeans[2] += grayDistanceMapFilter->GetOutput()->GetPixel(idx);
      trainMeans[3] += csfDistanceMapFilter->GetOutput()->GetPixel(idx);
      trainMeans[4] += t1Mean1Filter->GetOutput()->GetPixel(idx);
      trainMeans[5] += t2Mean1Filter->GetOutput()->GetPixel(idx);
      trainMeans[6] += flairMean1Filter->GetOutput()->GetPixel(idx);
      trainMeans[7] += t1Mean2Filter->GetOutput()->GetPixel(idx);
      trainMeans[8] += t2Mean2Filter->GetOutput()->GetPixel(idx);
      trainMeans[9] += flairMean2Filter->GetOutput()->GetPixel(idx);
      trainMeans[10] += t1Mean3Filter->GetOutput()->GetPixel(idx);
      trainMeans[11] += t2Mean3Filter->GetOutput()->GetPixel(idx);
      trainMeans[12] += flairMean3Filter->GetOutput()->GetPixel(idx);
      trainMeans[13] += t1Median1Filter->GetOutput()->GetPixel(idx);
      trainMeans[14] += t2Median1Filter->GetOutput()->GetPixel(idx);
      trainMeans[15] += flairMedian1Filter->GetOutput()->GetPixel(idx);
      trainMeans[16] += t1Median2Filter->GetOutput()->GetPixel(idx);
      trainMeans[17] += t2Median2Filter->GetOutput()->GetPixel(idx);
      trainMeans[18] += flairMedian2Filter->GetOutput()->GetPixel(idx);
      trainMeans[19] += t1Median3Filter->GetOutput()->GetPixel(idx);
      trainMeans[20] += t2Median3Filter->GetOutput()->GetPixel(idx);
      trainMeans[21] += flairMedian3Filter->GetOutput()->GetPixel(idx);
      trainMeans[22] += t1GrayscaleErode1->GetOutput()->GetPixel(idx);
      trainMeans[23] += t2GrayscaleErode1->GetOutput()->GetPixel(idx);
      trainMeans[24] += flairGrayscaleErode1->GetOutput()->GetPixel(idx);
      trainMeans[25] += t1GrayscaleErode2->GetOutput()->GetPixel(idx);
      trainMeans[26] += t2GrayscaleErode2->GetOutput()->GetPixel(idx);
      trainMeans[27] += flairGrayscaleErode2->GetOutput()->GetPixel(idx);
      trainMeans[28] += t1GrayscaleErode3->GetOutput()->GetPixel(idx);
      trainMeans[29] += t2GrayscaleErode3->GetOutput()->GetPixel(idx);
      trainMeans[30] += flairGrayscaleErode3->GetOutput()->GetPixel(idx);
      trainMeans[31] += t1GrayscaleDilate1->GetOutput()->GetPixel(idx);
      trainMeans[32] += t2GrayscaleDilate1->GetOutput()->GetPixel(idx);
      trainMeans[33] += flairGrayscaleDilate1->GetOutput()->GetPixel(idx);
      trainMeans[34] += t1GrayscaleDilate2->GetOutput()->GetPixel(idx);
      trainMeans[35] += t2GrayscaleDilate2->GetOutput()->GetPixel(idx);
      trainMeans[36] += flairGrayscaleDilate2->GetOutput()->GetPixel(idx);
      trainMeans[37] += t1GrayscaleDilate3->GetOutput()->GetPixel(idx);
      trainMeans[38] += t2GrayscaleDilate3->GetOutput()->GetPixel(idx);
      trainMeans[39] += flairGrayscaleDilate3->GetOutput()->GetPixel(idx);
      trainMeans[40] += idx[0]; 
      trainMeans[41] += idx[1]; 
      trainMeans[42] += idx[2];
      trainMeans[43] += t1MaskFilter->GetOutput()->GetPixel(idx);
      trainMeans[44] += t2MaskFilter->GetOutput()->GetPixel(idx);
      trainMeans[45] += flairMaskFilter->GetOutput()->GetPixel(idx);
      trainMeans[46] += t1DifferenceFilter->GetOutput()->GetPixel(idx);
      trainMeans[47] += t2DifferenceFilter->GetOutput()->GetPixel(idx);
      trainMeans[48] += flairDifferenceFilter->GetOutput()->GetPixel(idx);

      double tempSigma = 0;
      tempSigma = castFilter->GetOutput()->GetPixel(idx);
      trainSigmas[0] += tempSigma * tempSigma;
      tempSigma = whiteDistanceMapFilter->GetOutput()->GetPixel(idx);
      trainSigmas[1] += tempSigma * tempSigma;
      tempSigma = grayDistanceMapFilter->GetOutput()->GetPixel(idx);
      trainSigmas[2] += tempSigma * tempSigma;
      tempSigma = csfDistanceMapFilter->GetOutput()->GetPixel(idx);
      trainSigmas[3] += tempSigma * tempSigma;
      tempSigma = t1Mean1Filter->GetOutput()->GetPixel(idx);
      trainSigmas[4] += tempSigma * tempSigma;
      tempSigma = t2Mean1Filter->GetOutput()->GetPixel(idx);
      trainSigmas[5] += tempSigma * tempSigma;
      tempSigma = flairMean1Filter->GetOutput()->GetPixel(idx);
      trainSigmas[6] += tempSigma * tempSigma;
      tempSigma = t1Mean2Filter->GetOutput()->GetPixel(idx);
      trainSigmas[7] += tempSigma * tempSigma;
      tempSigma = t2Mean2Filter->GetOutput()->GetPixel(idx);
      trainSigmas[8] += tempSigma * tempSigma;
      tempSigma = flairMean2Filter->GetOutput()->GetPixel(idx);
      trainSigmas[9] += tempSigma * tempSigma;
      tempSigma = t1Mean3Filter->GetOutput()->GetPixel(idx);
      trainSigmas[10] += tempSigma * tempSigma;
      tempSigma = t2Mean3Filter->GetOutput()->GetPixel(idx);
      trainSigmas[11] += tempSigma * tempSigma;
      tempSigma = flairMean3Filter->GetOutput()->GetPixel(idx);
      trainSigmas[12] += tempSigma * tempSigma;
      tempSigma = t1Median1Filter->GetOutput()->GetPixel(idx);
      trainSigmas[13] += tempSigma * tempSigma;
      tempSigma = t2Median1Filter->GetOutput()->GetPixel(idx);
      trainSigmas[14] += tempSigma * tempSigma;
      tempSigma = flairMedian1Filter->GetOutput()->GetPixel(idx);
      trainSigmas[15] += tempSigma * tempSigma;
      tempSigma = t1Median2Filter->GetOutput()->GetPixel(idx);
      trainSigmas[16] += tempSigma * tempSigma;
      tempSigma = t2Median2Filter->GetOutput()->GetPixel(idx);
      trainSigmas[17] += tempSigma * tempSigma;
      tempSigma = flairMedian2Filter->GetOutput()->GetPixel(idx);
      trainSigmas[18] += tempSigma * tempSigma;
      tempSigma = t1Median3Filter->GetOutput()->GetPixel(idx);
      trainSigmas[19] += tempSigma * tempSigma;
      tempSigma = t2Median3Filter->GetOutput()->GetPixel(idx);
      trainSigmas[20] += tempSigma * tempSigma;
      tempSigma = flairMedian3Filter->GetOutput()->GetPixel(idx);
      trainSigmas[21] += tempSigma * tempSigma;
      tempSigma = t1GrayscaleErode1->GetOutput()->GetPixel(idx);
      trainSigmas[22] += tempSigma * tempSigma;
      tempSigma = t2GrayscaleErode1->GetOutput()->GetPixel(idx);
      trainSigmas[23] += tempSigma * tempSigma;
      tempSigma = flairGrayscaleErode1->GetOutput()->GetPixel(idx);
      trainSigmas[24] += tempSigma * tempSigma;
      tempSigma = t1GrayscaleErode2->GetOutput()->GetPixel(idx);
      trainSigmas[25] += tempSigma * tempSigma;
      tempSigma = t2GrayscaleErode2->GetOutput()->GetPixel(idx);
      trainSigmas[26] += tempSigma * tempSigma;
      tempSigma = flairGrayscaleErode2->GetOutput()->GetPixel(idx);
      trainSigmas[27] += tempSigma * tempSigma;
      tempSigma = t1GrayscaleErode3->GetOutput()->GetPixel(idx);
      trainSigmas[28] += tempSigma * tempSigma;
      tempSigma = t2GrayscaleErode3->GetOutput()->GetPixel(idx);
      trainSigmas[29] += tempSigma * tempSigma;
      tempSigma = flairGrayscaleErode3->GetOutput()->GetPixel(idx);
      trainSigmas[30] += tempSigma * tempSigma;
      tempSigma = t1GrayscaleDilate1->GetOutput()->GetPixel(idx);
      trainSigmas[31] += tempSigma * tempSigma;
      tempSigma = t2GrayscaleDilate1->GetOutput()->GetPixel(idx);
      trainSigmas[32] += tempSigma * tempSigma;
      tempSigma = flairGrayscaleDilate1->GetOutput()->GetPixel(idx);
      trainSigmas[33] += tempSigma * tempSigma;
      tempSigma = t1GrayscaleDilate2->GetOutput()->GetPixel(idx);
      trainSigmas[34] += tempSigma * tempSigma;
      tempSigma = t2GrayscaleDilate2->GetOutput()->GetPixel(idx);
      trainSigmas[35] += tempSigma * tempSigma;
      tempSigma = flairGrayscaleDilate2->GetOutput()->GetPixel(idx);
      trainSigmas[36] += tempSigma * tempSigma;
      tempSigma = t1GrayscaleDilate3->GetOutput()->GetPixel(idx);
      trainSigmas[37] += tempSigma * tempSigma;
      tempSigma = t2GrayscaleDilate3->GetOutput()->GetPixel(idx);
      trainSigmas[38] += tempSigma * tempSigma;
      tempSigma = flairGrayscaleDilate3->GetOutput()->GetPixel(idx);
      trainSigmas[39] += tempSigma * tempSigma;
      tempSigma = idx[0]; 
      trainSigmas[40] += tempSigma * tempSigma;
      tempSigma = idx[1]; 
      trainSigmas[41] += tempSigma * tempSigma;
      tempSigma = idx[2];
      trainSigmas[42] += tempSigma * tempSigma;
      tempSigma = t1MaskFilter->GetOutput()->GetPixel(idx);
      trainSigmas[43] += tempSigma * tempSigma;
      tempSigma = t2MaskFilter->GetOutput()->GetPixel(idx);
      trainSigmas[44] += tempSigma * tempSigma;
      tempSigma = flairMaskFilter->GetOutput()->GetPixel(idx);
      trainSigmas[45] += tempSigma * tempSigma;
      tempSigma = t1DifferenceFilter->GetOutput()->GetPixel(idx);
      trainSigmas[46] += tempSigma * tempSigma;
      tempSigma = t2DifferenceFilter->GetOutput()->GetPixel(idx);
      trainSigmas[47] += tempSigma * tempSigma;
      tempSigma = flairDifferenceFilter->GetOutput()->GetPixel(idx);
      trainSigmas[48] += tempSigma * tempSigma;

      count++;
      if(tempCount%12000 == 0)
      { 
        tempProgress += 0.01;
        start+= fraction/100;
        std::cout << "<filter-progress>" << start << "</filter-start>" << std::endl;
        std::cout << "<filter-stage-progress>" << tempProgress << "</filter-stage-progress>" << std::endl;
      }
      tempCount++;
    }
  }

  std::cout << "<filter-end>" << std::endl;
  std::cout << "<filter-name>FeatureStatistics</filter-name>" << std::endl;
  std::cout << "<filter-time>1</filter-time>" << std::endl;

  for(int w=0;w<FEATURE_LENGTH;w++)
  {
    trainMeans[w] = trainMeans[w] / count;
    trainSigmas[w] = trainSigmas[w] / count;
    trainSigmas[w] = sqrt(trainSigmas[w] - (trainMeans[w]*trainMeans[w]));
  }

  typedef itk::Vector<double,FEATURE_LENGTH> FeatureVectorType;
  FeatureVectorType voxelSample; voxelSample.Fill(0);
 
  /* Need the euclidean distance from the lesion centroid.
  ** The centroid is loaded from a file. Distance is calculated 
  ** on zero-meaned, sigma corrected, but unscaled data.
  */
  #if !defined(ITK_USE_REVIEW_STATISTICS)
  typedef itk::Statistics::EuclideanDistance< EuclidVectorType > DistanceMetricType; 
  #else
  typedef itk::Statistics::EuclideanDistanceMetric< EuclidVectorType > DistanceMetricType; 

  #endif
  DistanceMetricType::Pointer distanceMetric = DistanceMetricType::New();
  distanceMetric->SetMeasurementVectorSize(EUCLID_LENGTH);
  /* ************************************ */ 
  lesionSegmentationModel lesionModel(EUCLID_LENGTH,BAYES_LENGTH,FEATURE_LENGTH);
  lesionModel.ReadmodelFilename(inputModelFile);
  /* ************************************ */ 
  DistanceMetricType::OriginType lesionCentroid = lesionModel.getLesionCentroid();
  distanceMetric->SetOrigin(lesionCentroid);
  /*std::cerr << "lesion centroid: ";
  for(unsigned int y=0;y<EUCLID_LENGTH;y++)
  {
    std::cerr << lesionCentroid[y] << ",";
  }
  std::cerr << std::endl;
  */

  /* ************************************ */ 
  double lesionDistanceThreshold = lesionModel.getDistanceThreshold();
  //std::cerr << "Distance Thresh: " << lesionDistanceThreshold << std::endl;
  /* ************************************ */ 

  // Duplicate the T1 image to create an output lesion image
  //typedef itk::ImageDuplicator<ImageType> ImageDuplicatorType;
  ImageDuplicatorType::Pointer imageDuplicator = ImageDuplicatorType::New();
  imageDuplicator->SetInputImage(t2MaskFilter->GetOutput());
  imageDuplicator->Update();
  ImageType::Pointer predictedLesionImage = imageDuplicator->GetOutput();

  // Other prob image
  /*ImageDuplicatorType::Pointer imageDuplicator2 = ImageDuplicatorType::New();
  imageDuplicator2->SetInputImage(t2MaskFilter->GetOutput());
  imageDuplicator2->Update();
  ImageType::Pointer predictedLesionImage2 = imageDuplicator2->GetOutput();
  */

  // Duplicate the brain mask image to create an output lesion mask
  typedef itk::ImageDuplicator<MaskImageType> MaskImageDuplicatorType;
  MaskImageDuplicatorType::Pointer maskImageDuplicator = MaskImageDuplicatorType::New();
  maskImageDuplicator->SetInputImage(maskReader->GetOutput());
  maskImageDuplicator->Update();
  //MaskImageType::Pointer predictedLesionMask = maskImageDuplicator->GetOutput();

  /* Train the Bayesian Classifier 
  ** The Bayesian Classifier uses scaled data.
  */
  typedef itk::Statistics::ListSample< BayesVectorType > ListSampleType;
  typedef ListSampleType ClassSampleType;

#if !defined(ITK_USE_REVIEW_STATISTICS)
  typedef itk::Statistics::GaussianDensityFunction< BayesVectorType > MembershipFunctionType;
#else
  typedef itk::Statistics::GaussianMembershipFunction< BayesVectorType > MembershipFunctionType;
#endif

  typedef itk::MaximumRatioDecisionRule DecisionRuleType;
  DecisionRuleType::Pointer decisionRule = DecisionRuleType::New();

  DecisionRuleType::APrioriVectorType aPrioris;

  /* Priors for nonlesion and lesion classes */
  aPrioris.push_back(1); // Nonlesion
  //aPrioris.push_back(inputLesionApriori); // Lesion
  aPrioris.push_back(1); // Lesion
  decisionRule->SetAPriori( aPrioris );

#if !defined(ITK_USE_REVIEW_STATISTICS)
  typedef itk::Statistics::SampleClassifier< ClassSampleType > ClassifierType;
  ClassifierType::Pointer classifier = ClassifierType::New();
  classifier->SetDecisionRule( (itk::DecisionRuleBase::Pointer) decisionRule);
#else
  typedef itk::Statistics::my::SampleClassifier< ClassSampleType > ClassifierType;
  ClassifierType::Pointer classifier = ClassifierType::New();
  classifier->SetDecisionRule(  (itk::DecisionRuleBase::Pointer) decisionRule );
#endif

  //classifier->SetDecisionRule( decisionRule );
  classifier->SetNumberOfClasses( 2 );

  /* Two labels, 0 for nonlesion and 1 for lesion */
  std::vector< unsigned int > classLabels;
  classLabels.resize( 2 );
  classLabels[0] = 0;
  classLabels[1] = 1;

#if !defined(ITK_USE_REVIEW_STATISTICS)
  classifier->SetMembershipFunctionClassLabels(classLabels);
#else
  classifier->SetMembershipFunctionClassLabels(classLabels);
  //classifier->SetClassLabels(classLabels);
#endif

  /* Create and add the membership functions for lesions and nonlesions
  ** to the classifier.
  */
  std::vector< MembershipFunctionType::Pointer > membershipFunctions;
  
  membershipFunctions.push_back(MembershipFunctionType::New());
#if !defined(ITK_USE_REVIEW_STATISTICS)
  membershipFunctions[0]->SetMean( &lesionModel.getNonLesionDataMean() );
  membershipFunctions[0]->SetCovariance( &lesionModel.getNonLesionDataCovariance() );
#else
  membershipFunctions[0]->SetMean( lesionModel.getNonLesionDataMean() );
  membershipFunctions[0]->SetCovariance( lesionModel.getNonLesionDataCovariance() );
#endif

  membershipFunctions.push_back(MembershipFunctionType::New());
#if !defined(ITK_USE_REVIEW_STATISTICS)
  membershipFunctions[1]->SetMean( &lesionModel.getLesionDataMean() );
  membershipFunctions[1]->SetCovariance( &lesionModel.getLesionDataCovariance() );
#else
  membershipFunctions[1]->SetMean( lesionModel.getLesionDataMean() );
  membershipFunctions[1]->SetCovariance( lesionModel.getLesionDataCovariance() );
#endif

#if !defined(ITK_USE_REVIEW_STATISTICS)
  classifier->AddMembershipFunction(membershipFunctions[0].GetPointer());
  classifier->AddMembershipFunction(membershipFunctions[1].GetPointer());
#else
  classifier->AddMembershipFunction(membershipFunctions[0].GetPointer());
  classifier->AddMembershipFunction(membershipFunctions[1].GetPointer());
#endif
 
// Training mins and maxes for scaling each feature
  /* ************************************ */ 
  //itk::VariableLengthVector<double> trainingMinTemp;
  //itk::VariableLengthVector<double> trainingMaxTemp;
  //trainingMinTemp.SetSize(21);
  //trainingMaxTemp.SetSize(21);
  //MeasurementVectorType trainingMin = lesionModel.getTrainingMins();
  MeasurementVectorType trainingMin; trainingMin.Fill(0);
  //MeasurementVectorType trainingMax = lesionModel.getTrainingMaxs();
  MeasurementVectorType trainingMax; trainingMax.Fill(0);
  //std::cerr << "Training Mins: "; 
  for(int w=0;w<FEATURE_LENGTH;w++)
  {
    //trainingMinTemp[w] = trainingMin[w];
    //trainingMaxTemp[w] = trainingMax[w];
    trainingMin[w] = lesionModel.getTrainingMins()[w];
    trainingMax[w] = lesionModel.getTrainingMaxs()[w];
    //std::cerr << trainingMin[w] << ",";
  }
  /*
  lesionModel.setTrainingMins(trainingMinTemp); 
  lesionModel.setTrainingMaxs(trainingMaxTemp); 
  lesionModel.WritemodelFilename("testOut.model");
  */
  /* ************************************ */ 

  unsigned int bayesCount = 0;
  unsigned int svmPosCount = 0;
  
  //struct svm_node *x = (struct svm_node *) malloc(FEATURE_LENGTH*sizeof(struct svm_node));
  struct svm_node *x = (struct svm_node *) malloc(sizeof(struct svm_node));
  x->values = (double *) malloc((1+FEATURE_LENGTH)*sizeof(double));
  x->values[0] = 0.0;
  struct svm_model* model;
  model=svm_load_model(inputSVMModelFile.c_str());
  double *prob_estimates = (double *) malloc(2*sizeof(double));

  /*
  ** Construct the feature set in this order:
  ** kMeansTissueType, DistanceToGray, DistanceToWhite, DistanceToCSF, 
  ** normedX, normedY, normedZ, normedT1, normedFLAIR, 
  ** MeanT1_1, MeanT1_2, MeanT1_3, MedianT1_1, MedianT1_2, MedianT1_3, 
  ** DilateT1_1, DilateT1_2, DilateT1_3, 
  ** DilateFLAIR_1, DilateFLAIR_2, DilateFLAIR_3, T1Vox, FLAIRVox
  */
  std::cout << "<filter-start>" << std::endl;
  std::cout << "<filter-name>VoxelClassification</filter-name>" << std::endl;
  std::cout << "<filter-comment>Segmenting Voxels</filter-comment>" << std::endl;
  std::cout << "</filter-start>" << std::endl;
  std::cout << "<filter-progress>" << start << "</filter-start>" << std::endl;
  std::cout << "<filter-stage-progress>0</filter-stage-progress>" << std::endl;

  fraction = .5;
  tempCount = 0;
  tempProgress = 0;
  for ( t1Itr.GoToBegin(); !t1Itr.IsAtEnd(); ++t1Itr)
  {
    ImageType::IndexType idx = t1Itr.GetIndex();
    //if(maskReader->GetOutput()->GetPixel(idx) != 0 && lesionReader->GetOutput()->GetPixel(idx) != 0)
    if(maskReader->GetOutput()->GetPixel(idx) !=0)
    {
      /* Need to create a measurement vector (itk::Vector) for each voxel, then check
      ** if it is close enough to the lesion cluster centroid for us to
      ** pass it on to the support vector machines.
      */
      //voxelSample[0] = (castFilter->GetOutput()->GetPixel(idx) - trainMeans[0])/trainSigmas[0];
      voxelSample[0] = castFilter->GetOutput()->GetPixel(idx);
      voxelSample[1] = (whiteDistanceMapFilter->GetOutput()->GetPixel(idx) - trainMeans[1])/trainSigmas[1];
      voxelSample[2] = (grayDistanceMapFilter->GetOutput()->GetPixel(idx) - trainMeans[2])/trainSigmas[2];
      voxelSample[3] = (csfDistanceMapFilter->GetOutput()->GetPixel(idx) - trainMeans[3])/trainSigmas[3];
      voxelSample[4] = (t1Mean1Filter->GetOutput()->GetPixel(idx) - trainMeans[4])/trainSigmas[4];
      voxelSample[5] = (t2Mean1Filter->GetOutput()->GetPixel(idx) - trainMeans[5])/trainSigmas[5];
      voxelSample[6] = (flairMean1Filter->GetOutput()->GetPixel(idx) - trainMeans[6])/trainSigmas[6];
      voxelSample[7] = (t1Mean2Filter->GetOutput()->GetPixel(idx) - trainMeans[7])/trainSigmas[7];
      voxelSample[8] = (t2Mean2Filter->GetOutput()->GetPixel(idx) - trainMeans[8])/trainSigmas[8];
      voxelSample[9] = (flairMean2Filter->GetOutput()->GetPixel(idx) - trainMeans[9])/trainSigmas[9];
      voxelSample[10] = (t1Mean3Filter->GetOutput()->GetPixel(idx) - trainMeans[10])/trainSigmas[10];
      voxelSample[11] = (t2Mean3Filter->GetOutput()->GetPixel(idx) - trainMeans[11])/trainSigmas[11];
      voxelSample[12] = (flairMean3Filter->GetOutput()->GetPixel(idx) - trainMeans[12])/trainSigmas[12];
      voxelSample[13] = (t1Median1Filter->GetOutput()->GetPixel(idx) - trainMeans[13])/trainSigmas[13];
      voxelSample[14] = (t2Median1Filter->GetOutput()->GetPixel(idx) - trainMeans[14])/trainSigmas[14];
      voxelSample[15] = (flairMedian1Filter->GetOutput()->GetPixel(idx) - trainMeans[15])/trainSigmas[15];
      voxelSample[16] = (t1Median2Filter->GetOutput()->GetPixel(idx) - trainMeans[16])/trainSigmas[16];
      voxelSample[17] = (t2Median2Filter->GetOutput()->GetPixel(idx) - trainMeans[17])/trainSigmas[17];
      voxelSample[18] = (flairMedian2Filter->GetOutput()->GetPixel(idx) - trainMeans[18])/trainSigmas[18];
      voxelSample[19] = (t1Median3Filter->GetOutput()->GetPixel(idx) - trainMeans[19])/trainSigmas[19];
      voxelSample[20] = (t2Median3Filter->GetOutput()->GetPixel(idx) - trainMeans[20])/trainSigmas[20];
      voxelSample[21] = (flairMedian3Filter->GetOutput()->GetPixel(idx) - trainMeans[21])/trainSigmas[21];
      voxelSample[22] = (t1GrayscaleErode1->GetOutput()->GetPixel(idx) - trainMeans[22])/trainSigmas[22];
      voxelSample[23] = (t2GrayscaleErode1->GetOutput()->GetPixel(idx) - trainMeans[23])/trainSigmas[23];
      voxelSample[24] = (flairGrayscaleErode1->GetOutput()->GetPixel(idx) - trainMeans[24])/trainSigmas[24];
      voxelSample[25] = (t1GrayscaleErode2->GetOutput()->GetPixel(idx) - trainMeans[25])/trainSigmas[25];
      voxelSample[26] = (t2GrayscaleErode2->GetOutput()->GetPixel(idx) - trainMeans[26])/trainSigmas[26];
      voxelSample[27] = (flairGrayscaleErode2->GetOutput()->GetPixel(idx) - trainMeans[27])/trainSigmas[27];
      voxelSample[28] = (t1GrayscaleErode3->GetOutput()->GetPixel(idx) - trainMeans[28])/trainSigmas[28];
      voxelSample[29] = (t2GrayscaleErode3->GetOutput()->GetPixel(idx) - trainMeans[29])/trainSigmas[29];
      voxelSample[30] = (flairGrayscaleErode3->GetOutput()->GetPixel(idx) - trainMeans[30])/trainSigmas[30];
      voxelSample[31] = (t1GrayscaleDilate1->GetOutput()->GetPixel(idx) - trainMeans[31])/trainSigmas[31];
      voxelSample[32] = (t2GrayscaleDilate1->GetOutput()->GetPixel(idx) - trainMeans[32])/trainSigmas[32];
      voxelSample[33] = (flairGrayscaleDilate1->GetOutput()->GetPixel(idx) - trainMeans[33])/trainSigmas[33];
      voxelSample[34] = (t1GrayscaleDilate2->GetOutput()->GetPixel(idx) - trainMeans[34])/trainSigmas[34];
      voxelSample[35] = (t2GrayscaleDilate2->GetOutput()->GetPixel(idx) - trainMeans[35])/trainSigmas[35];
      voxelSample[36] = (flairGrayscaleDilate2->GetOutput()->GetPixel(idx) - trainMeans[36])/trainSigmas[36];
      voxelSample[37] = (t1GrayscaleDilate3->GetOutput()->GetPixel(idx) - trainMeans[37])/trainSigmas[37];
      voxelSample[38] = (t2GrayscaleDilate3->GetOutput()->GetPixel(idx) - trainMeans[38])/trainSigmas[38];
      voxelSample[39] = (flairGrayscaleDilate3->GetOutput()->GetPixel(idx) - trainMeans[39])/trainSigmas[39];
      voxelSample[40] = (idx[0] - trainMeans[40])/trainSigmas[40]; 
      voxelSample[41] = (idx[1] - trainMeans[41])/trainSigmas[41]; 
      voxelSample[42] = (idx[2] - trainMeans[42])/trainSigmas[42];
      voxelSample[43] = (t1MaskFilter->GetOutput()->GetPixel(idx) - trainMeans[43])/trainSigmas[43];
      voxelSample[44] = (t2MaskFilter->GetOutput()->GetPixel(idx) - trainMeans[44])/trainSigmas[44];
      voxelSample[45] = (flairMaskFilter->GetOutput()->GetPixel(idx) - trainMeans[45])/trainSigmas[45];
      voxelSample[46] = (t1DifferenceFilter->GetOutput()->GetPixel(idx) - trainMeans[46])/trainSigmas[46];
      voxelSample[47] = (t2DifferenceFilter->GetOutput()->GetPixel(idx) - trainMeans[47])/trainSigmas[47];
      voxelSample[48] = (flairDifferenceFilter->GetOutput()->GetPixel(idx) - trainMeans[48])/trainSigmas[48];

      EuclidVectorType tempEuclid;

      //std::cerr << "Euclid vector: ";
      for(unsigned int a=0;a<EUCLID_LENGTH;++a)
      {
        tempEuclid[a] = voxelSample[featureIndexes[a]];
        //std::cerr << tempEuclid[a] << ",";
      }
      //std::cerr << std::endl;

      double metricResult = 0;
      //metricResult = distanceMetric->Evaluate(tempEuclid);
      
      if(metricResult <= lesionDistanceThreshold)
      {
        //std::cerr << "Passes Distance thresh" << std::endl;
        
        /* Scale each feature to the range -1<=x<=+1 */
        for(int r=0;r<FEATURE_LENGTH;r++)
        {
          if(voxelSample[r] == trainingMin[r])
          {
            voxelSample[r] = -1;
          }
          else if (voxelSample[r] == trainingMax[r])
          {
            voxelSample[r] = 1;
          }
          else
          {
            voxelSample[r] = -1+2*(voxelSample[r]-trainingMin[r])/(trainingMax[r]-trainingMin[r]);
          }
          x->values[r+1] = voxelSample[r];
        }
        x->dim = FEATURE_LENGTH;
 
        /* Use the previously initialized bayesian classifier to classify this 
        ** voxel.  The bayesian classifier works on scaled data.
        */
        BayesVectorType tempBayes; tempBayes.Fill(0);
        for(unsigned int a=0;a<BAYES_LENGTH;++a)
        {
          tempBayes[a] = voxelSample[featureIndexes[a]];
        }
       
        /* Not doing bayes classification  
        ClassSampleType::Pointer querySample = ClassSampleType::New();
        querySample->PushBack(tempBayes);

        classifier->SetSample(querySample);
        classifier->Modified();
        classifier->Update();

        ClassifierType::OutputType* membershipSample = classifier->GetOutput();
        ClassifierType::OutputType::ConstIterator iter = membershipSample->Begin();
        */
                                                        
        //while ( iter != membershipSample->End() )
        //{
          //if(iter.GetClassLabel()!=0)
          //{
            /*for(unsigned int h=0;h<FEATURE_LENGTH;h++)
            {
              std::cout << voxelSample[h];
              if(h<FEATURE_LENGTH-1)
              {
                std::cout << " ";
              }
              else
              {
                std::cout << std::endl;
              }
            }*/
   
            //bayesCount++;
            double voxelPrediction = svm_predict_probability(model,x,prob_estimates);
            predictedLesionImage->SetPixel(idx, prob_estimates[1]);
            //voxelPrediction = svm_predict(model,x);
            /*if(voxelPrediction > 0)
            {
              predictedLesionMask->SetPixel(idx,voxelPrediction);
              svmPosCount++;
            }
            else
            {
              predictedLesionMask->SetPixel(idx,0);
            }*/
          /*}
          else
          {
            predictedLesionImage->SetPixel(idx,0);
            predictedLesionMask->SetPixel(idx,0);
          }*/
          //++iter;
        //}
      }
      else
      {
        predictedLesionImage->SetPixel(idx,0);
        //predictedLesionMask->SetPixel(idx,0);
      }
      if(tempCount%12000 == 0)
      { 
        tempProgress += 0.01;
        start+= fraction/100;
        std::cout << "<filter-progress>" << start << "</filter-start>" << std::endl;
        std::cout << "<filter-stage-progress>" << tempProgress << "</filter-stage-progress>" << std::endl;
      }
      tempCount++;
    }
    else
    {
      predictedLesionImage->SetPixel(idx,0);
      //predictedLesionMask->SetPixel(idx,0);
    }
  }
  svm_destroy_model(model);
  free(x->values);
  free(x);

  std::cout << "<filter-end>" << std::endl;
  std::cout << "<filter-name>VoxelClassification</filter-name>" << std::endl;
  std::cout << "<filter-time>1</filter-time>" << std::endl;

  //std::cerr << "Positive Naive Bayes count: " << bayesCount << std::endl;
  //std::cerr << "Positive SVM count: " << svmPosCount << std::endl;

  // Threshold heat map using inputPercentThreshold.
  typedef itk::BinaryThresholdImageFilter< ImageType, MaskImageType > BinaryThreshType;
  BinaryThreshType::Pointer binaryThresh = BinaryThreshType::New();
  binaryThresh->SetOutsideValue(0);
  binaryThresh->SetInsideValue(1);
  float floatThreshold = (float)inputPercentThreshold / 100.0;
  binaryThresh->SetLowerThreshold(floatThreshold);
  binaryThresh->SetUpperThreshold(1);
  binaryThresh->SetInput(predictedLesionImage);
  binaryThresh->Update();
  
  typedef itk::ImageFileWriter<MaskImageType> MaskWriterType;
  MaskWriterType::Pointer lesionMaskWriter = MaskWriterType::New();
  //lesionMaskWriter->SetInput(predictedLesionMask);
  lesionMaskWriter->SetInput(binaryThresh->GetOutput());
  lesionMaskWriter->SetFileName(outputLesionMask.c_str());
  lesionMaskWriter->Update();

  /* Write out the predicted lesion image */
  lesionWriter->SetInput(predictedLesionImage);
  lesionWriter->SetFileName(outputLesionProb.c_str());
  lesionWriter->Update();
  
  /*lesionWriter->SetInput(predictedLesionImage2);
  lesionWriter->SetFileName("predictedLesion2.nii.gz");
  lesionWriter->Modified();
  lesionWriter->Update();
  */

  return EXIT_SUCCESS;
}
