
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string>
#include <vector>

#include "itkFixedArray.h"
#include "itkMatrix.h"
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkShrinkImageFilter.h"
#include "itkWarpImageFilter.h"
#include "itkVectorLinearInterpolateImageFunction.h" 
#include "itkNearestNeighborInterpolateImageFunction.h" 

#include "itkVector.h"

#include "itkHammerTissueAttributeVectorImageFilter.h"
#include "itkHammerDeformableRegistrationImageFilter.h"
#include "time.h"

#include "itkPluginUtilities.h"

#include "HammerRegistrationCLP.h"

using namespace std;
using namespace TCLAP;

typedef itk::HammerTissueAttributeVector ImgAttribute;

typedef float FloatType;
typedef itk::Vector<FloatType, 3>       ITKFvector3d;
typedef itk::Vector<int, 3>             Ivector3d;
typedef itk::Matrix<FloatType, 4, 4>    Matrix;
typedef itk::Image<unsigned char, 3>    ImageType;
typedef itk::ImageFileReader<ImageType> ReaderType;
typedef itk::ImageFileWriter<ImageType> WriterType;

typedef itk::Image<unsigned short, 3>    UShortImageType;
typedef itk::ImageFileReader<UShortImageType> USReaderType;
typedef itk::ImageFileWriter<UShortImageType> USWriterType;

typedef itk::Image<ITKFvector3d, 3>     DeformationFieldType;
typedef itk::Image<ImgAttribute, 3>     AttributeImageType;
typedef itk::HammerTissueAttributeVectorImageFilter<ImageType, AttributeImageType> AttributeFilterType;

unsigned char Geom_UP = static_cast<unsigned char>(0.9*255) ;
unsigned char Geom_DN = static_cast<unsigned char>(0.4*255) ;
unsigned char VNvlm_UP = static_cast<unsigned char>(255/12) ;
unsigned char VNvlm_DN = 170 ; /* ~65% added on Dec 2006 */
unsigned char CSFBG_UP = static_cast<unsigned char>(255/4) ;

unsigned char Geom_DownsUp = static_cast<unsigned char>(Geom_DN/1.1) ; /*1.5*/

int main(int argc,char *argv[])  
{
	
  PARSE_ARGS;

  float XYZres = 1. ;

  double scale = 7*(1./XYZres) ; if(scale<3) scale=3; 
  
  /***** Model image, segmented *****/
  /*Img_XY = 256 ;*/   
  
  /*** Load in fixed image and compute the attribute vectors ***/
  ReaderType::Pointer ImgReader = ReaderType::New();
  ImgReader->SetFileName( FixedImageFileName.c_str() );
  try
    {
    ImgReader->Update();
    }
  catch( itk::ExceptionObject *ex )
    {
    std::cerr << ex << std::endl;
    }
  ImageType::Pointer fImg0 = ImgReader->GetOutput();
  fImg0->DisconnectPipeline();
  std::cout << "Fixed image file read in\n";

  /*** Load in moving image and compute the attribute vectors ***/
  ImgReader->SetFileName( MovingImageFileName.c_str() );
  try
    {
    ImgReader->Update();
    }
  catch( itk::ExceptionObject *ex )
    {
    std::cerr << ex << std::endl;
    }
  ImageType::Pointer mImg0 = ImgReader->GetOutput();
  mImg0->DisconnectPipeline();
  std::cout << "Moving image file read in\n";

  
  // convert to 10.150,250 label 
  int csfLabel = tissueLabel[0];
  int gmLabel = tissueLabel[1];
  int wmLabel = tissueLabel[2];

  itk::ImageRegionIterator<ImageType> itFixed( fImg0, fImg0->GetLargestPossibleRegion() );
  for (itFixed.GoToBegin(); !itFixed.IsAtEnd(); ++itFixed)
    {
    ImageType::PixelType p = itFixed.Get();
    if (p == csfLabel)
      {
      itFixed.Set( 10 );
      }
    if (p == gmLabel)
      {
      itFixed.Set( 150 );
      }
    if (p == wmLabel)
      {
      itFixed.Set( 250 );
      }
    }

  itk::ImageRegionIterator<ImageType> itMoving( mImg0, mImg0->GetLargestPossibleRegion() );
  for (itMoving.GoToBegin(); !itMoving.IsAtEnd(); ++itMoving)
    {
    ImageType::PixelType p = itMoving.Get();
    if (p == csfLabel)
      {
      itMoving.Set( 10 );
      }
    if (p == gmLabel)
      {
      itMoving.Set( 150 );
      }
    if (p == wmLabel)
      {
      itMoving.Set( 250 );
      }
    }

  typedef itk::HammerDeformableRegistrationImageFilter<
    ImageType,
    DeformationFieldType> RegistrationFilterType;
  RegistrationFilterType::Pointer hammer = RegistrationFilterType::New();

  // hammer only need to know the fixed image, moving image, and 
  // how attribute vectors are computed (also similarity computation)
  // to perform registration

  hammer->SetFixedImage( fImg0 );
  hammer->SetMovingImage( mImg0 );

  // ----------------------------------------------------------
  // define an attribute vector filter object and set it to the 
  // hammer registration filter so the registration know   
  // 1. How to compute attribute vectors
  // 2. How to compute similarity between attribute vectors
  AttributeFilterType::Pointer avFilter = AttributeFilterType::New();
  // hammer->SetAttributeVectorFilter( avFilter );
  // ----------------------------------------------------------


  // ----------------------------------------------------------
  // the following lines set parameters for HAMMER registration
  // all these parameters should have default values
  hammer->SetIterations( iterations[0], iterations[1], iterations[2] );
  hammer->SetDeformRate(0.05);
  hammer->SetPointMatchingThreshold(0.8);
  hammer->SetSubvolumnSimilarityThreshold(0.6);
  hammer->SetSearchRadius(12);
  // hammer->SetNumberOfMaximumDrivingVoxels( 5000 );
  // hammer->SetSigma ( 2 ); 
  // ----------------------------------------------------------

  itk::PluginFilterWatcher watchHammer( hammer, "Hammer Registration Filter" );
  clock_t Start = clock();
  hammer->Update();
  clock_t End = clock();

  std::cout<<"Execution time = "<<(End-Start)/CLOCKS_PER_SEC<<"s"<<std::endl;

  typedef itk::WarpImageFilter<
    ImageType, 
    ImageType,
    DeformationFieldType  >     WarperType;

  typedef itk::NearestNeighborInterpolateImageFunction<
    ImageType,
    double >  InterpolatorType;

  WarperType::Pointer warper = WarperType::New();
  InterpolatorType::Pointer interpolator = InterpolatorType::New();

  warper->SetInput( mImg0 );
  warper->SetInterpolator( interpolator );
  warper->SetOutputDirection( fImg0->GetDirection() );
  warper->SetOutputSpacing( fImg0->GetSpacing() );
  warper->SetOutputOrigin( fImg0->GetOrigin() );
  warper->SetDeformationField(hammer->GetOutput());

  WriterType::Pointer      writer =  WriterType::New();
  writer->SetFileName( ResampledImageFileName.c_str() );
  writer->SetInput( warper->GetOutput() );
  writer->Update();

  if (IntensityMovingImageFileName != "" && ResampledIntensityImageFileName != "")
    {
    USReaderType::Pointer usReader = USReaderType::New();
    usReader->SetFileName( IntensityMovingImageFileName.c_str() );

    typedef itk::WarpImageFilter<
      UShortImageType, 
      UShortImageType,
      DeformationFieldType  >     UShortWarperType;

    UShortWarperType::Pointer warper2 = UShortWarperType::New();
    warper2->SetInput( usReader->GetOutput() );
    warper2->SetOutputDirection( fImg0->GetDirection() );
    warper2->SetOutputSpacing( fImg0->GetSpacing() );
    warper2->SetOutputOrigin( fImg0->GetOrigin() );
    warper2->SetDeformationField(hammer->GetOutput());

    typedef itk::LinearInterpolateImageFunction< UShortImageType, double >  LinearInterpolatorType;
    LinearInterpolatorType::Pointer lInterpolator = LinearInterpolatorType::New();
    
    warper2->SetInterpolator( lInterpolator );
   
    USWriterType::Pointer writer2 = USWriterType::New();
    writer2->SetFileName( ResampledIntensityImageFileName.c_str() );
    writer2->SetInput( warper2->GetOutput() );

    try
      {
      writer2->Update();
      }
    catch( itk::ExceptionObject *ex )
      {
      std::cerr << ex << std::endl;
      }
    }

  itk::ImageFileWriter<DeformationFieldType>::Pointer fieldWriter = itk::ImageFileWriter<DeformationFieldType>::New();
  fieldWriter->SetFileName( "DeformationField.mha" );
  fieldWriter->SetInput( hammer->GetOutput() );
  try
  {
    fieldWriter->Update();
  }
  catch( itk::ExceptionObject *ex )
  {
    std::cerr << ex << std::endl;
  }


  return 0;
}



