/*=========================================================================

Program:   Insight Segmentation & Registration Toolkit
Module:    $RCSfile: itkHammerRegistrationFilter.txx,v $
Language:  C++
Date:      $Date: 2009/01/15 15:06:35 $
Version:   $Revision: 1.1 $

Copyright (c) Insight Software Consortium. All rights reserved.
See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for
details.

This program is developed under NIH NCBC collaboration grant
R01 EB006733, "Development and Dissemination of Robust Brain MRI
Measurement Tools". 

This software is distributed WITHOUT ANY WARRANTY; without even 
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef __itkHammerRegistrationFilter_txx
#define __itkHammerRegistrationFilter_txx
#include "itkHammerRegistrationFilter.h"

namespace itk
{

/**
 * Default constructor
 */
template <class TFixedImage, class TMovingImage, class TDeformationField, class TAVFilterType>
HammerRegistrationFilter<TFixedImage,TMovingImage,TDeformationField, TAVFilterType>
::HammerRegistrationFilter()
{
 
  typename HammerRegistrationFunctionType::Pointer drfp;
  drfp = HammerRegistrationFunctionType::New();

  this->SetDifferenceFunction( static_cast<FiniteDifferenceFunctionType *>(
                                 drfp.GetPointer() ) );

  // Here, we need to set default values for registration
  //

}


template <class TFixedImage, class TMovingImage, class TDeformationField, class TAVFilterType>
void
HammerRegistrationFilter<TFixedImage,TMovingImage,TDeformationField, TAVFilterType>
::PrintSelf(std::ostream& os, Indent indent) const
{ 
  Superclass::PrintSelf( os, indent );
  // Print out hammer parameters.

}


/*
 * Set the function state values before each iteration
 */
template <class TFixedImage, class TMovingImage, class TDeformationField, class TAVFilterType>
void
HammerRegistrationFilter<TFixedImage,TMovingImage,TDeformationField, TAVFilterType>
::InitializeIteration()
{
 
  // call the superclass  implementation
  Superclass::InitializeIteration();

  // do initialization for hammer registration
  // 1. compute attribute vectors for fixed and moving image
  // 2. possibly, we need to initialize deformation field to zeros
  // 3. tell HammerRegistrationFunction all that it needs to know
   
}


/**
 * Get the metric value from the difference function
 */
template <class TFixedImage, class TMovingImage, class TDeformationField, class TAVFilterType>
double
HammerRegistrationFilter<TFixedImage,TMovingImage,TDeformationField, TAVFilterType>
::GetMetric() const
{
  // compute and return image metric (integral of AV similarity over image)
  return 0;
}


/**
 * Get the metric value from the difference function
 */
template <class TFixedImage, class TMovingImage, class TDeformationField, class TAVFilterType>
void
HammerRegistrationFilter<TFixedImage,TMovingImage,TDeformationField, TAVFilterType>
::ApplyUpdate(TimeStepType dt)
{

  // need to have Hammer implementation here.
}

} // end namespace itk

#endif
