// HE_ALG_Registration.cpp: implementation of the HE_ALG_Registration class.
//
//////////////////////////////////////////////////////////////////////
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "common.h"
#include "HE_ALG_Registration.h"


#define BSIC_RAD 1 /* 1 */
#define BASIC_R 0
#define INTERPOLATE YYES
#define INTERP_SEG NNO
#define BUBBNUM   10    /* 8 10*/
#define STEPPNT   3     /* 3 (May2001), 20 */
#define ITER_THRD 0.85   /* iteration threshold for switching focus */
//#define HAMMER_SHEN
#define DUMP_DATA

#ifndef HAMMER_WIN32
#define SQR(a) ((a)*(a))
#define max(a,b) ((a)>(b)?(a):(b))
#define min(a,b) ((a)<(b)?(a):(b))
#define _FMAX 9999999999999999999999999999999999999999999999999999999999999999.99
#define _FMIN -9999999999999999999999999999999999999999999999999999999999999999.9
#endif
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

HE_ALG_Registration::HE_ALG_Registration()
{
  int s,l;

  Start_Search_Point = 0;
  regist_CompGuassianOnce = FFAIL ;
  for(l=0; l<MAX_LEVEL; l++)
	  GuassianAtLevelSigma[0][l] = 0 ;
  for(s=1; s<MAX_SIGMA; s++)
	  for(l=0; l<MAX_LEVEL; l++)
		  GuassianAtLevelSigma[s][l] = exp(-l*l/(2.0*s*s)) ;
  p_Running_Parameter = new Definition_of_HAMMER(); 
}


HE_ALG_Registration::~HE_ALG_Registration()
{

}

bool HE_ALG_Registration::ParseCommand(int argc, char *argv[], int MinParms)
{
	p_Running_Parameter->ObtainParm(argc, argv, MinParms);
	PrintParms(p_Running_Parameter);
	return true;
}


void HE_ALG_Registration::PrintParms(HAMMER_Param *ptParm)
{
	printf("##################################################################\n");
	printf("#############Print Parameters ####################################\n");
	printf(" search_resolution = (%d %d %d)\n", ptParm->search_resolution[LOW_LEVEL], ptParm->search_resolution[MID_LEVEL], ptParm->search_resolution[HIGH_LEVEL]);
	printf("iter = %d\n Deform_RATE=%f\n Affine_Degree=%f\n MatchingDegreeOfMdlOnImgEdge=%f\n", ptParm->iter, ptParm->Deform_RATE,\
		ptParm->Affine_Degree,ptParm->MatchingDegreeOfMdlOnImgEdge) ;
	printf(" Pont similarity = %f\n", ptParm->PointSimilarity);
	printf(" smoothFactor=%f\n", ptParm->smoothFactor) ;

	if(ptParm->InputOriginalObjImg == true)
	{
		printf(" Warping result on orignal image will be saved!\n") ;
		printf(" The Original File is %s\n", ptParm->ObjOriginalImgFile);
	}
	else
	{
		printf(" No Original Image Inputed.\n");
	}

	if(ptParm->BigVN==YYES)
	{
		printf("\n\n *************\n"); 
		printf("  big ventricle");
		printf("\n *************\n");
	}
	if(ptParm->InitialUpdate == true)
		printf(" InitialUpdate=%d\n", ptParm->InitialUpdate) ;
	printf(" Img_XY=%d\n", ptParm->Img_XY) ;
	if( ptParm-> YoungBrain==YYES )  
		printf("\n\n ... YoungBrain!\n\n") ; /*March 31 2003*/
	if(ptParm->OutputTemporayResults == false ) 
		printf(" Will not output temporary warping results.\n") ;
	else
		printf(" The temperal dump directory is %s\n", ptParm->OutputDir);

	printf(" DfmSmthCoeff=%f, DfmSmthTimes=%d\n\n", ptParm->DfmSmthCoeff, ptParm->DfmSmthTimes) ;
	printf(" ConfidenceOnLastDeformation=%f\n", ptParm->ConfidenceOnLastDeformation) ;
	if(ptParm->Soft_Correspondence == true)
	{
		printf("Soft correspondence detection will be used.\n");
		printf("AdditionSmth = %d\n", ptParm->AdditionalSmth);
	}
	if(ptParm->UsingTPSRegularization == true)
	{
		printf("TPS parameters: \n");	
		printf("The max control point in block is %d\n", ptParm->MaxTPSPoint);
		printf("Block_size = %d  Overlap_Step = %d   Lemda = %f\n", ptParm->BlockSize, ptParm->OverStep, ptParm->TPS_Lemda);
		printf("TPS_Decomposition Level is %d  TPS_Tolorence is %f\n", ptParm->TPS_Decomposition_Level, ptParm->Residual_Tolerance);
	}
	else
		printf("Using the gaussian smoothing procedure.\n");
}

void HE_ALG_Registration::WriteImg(char filename[], unsigned char ***data, int image_size, int z_size)
{
  FILE  *fp;
  int   i, k;
	
  /* write the smoothed image */
#ifdef HAMMER_WIN32
  fp=myopen(filename, "wb");
#else
  fp = myopen(filename, "w");
#endif
  for(k=0;k<z_size;k++)
    for(i=0;i<image_size;i++)
      fwrite(data[k][i],1,image_size,fp);
  fclose(fp);
}

void HE_ALG_Registration::WriteImgAttribute(char filename[], ImgAttribute ***Img, int image_size, int z_size)
{
	int   i, j, k ;
	unsigned char ***TempImg;
	char fn[180] ;
	
	TempImg = UCalloc3d(image_size,image_size,z_size);
	
	/* Tissue */
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				TempImg[k][i][j] = Img[k][i][j].Tiss ;
	sprintf(fn, "%s_Tissue", filename);
	WriteImg(fn,   TempImg,   image_size, z_size) ;  
			
	/* Edge */		
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				TempImg[k][i][j] = Img[k][i][j].Edge ;
	sprintf(fn, "%s_Edge", filename);
	WriteImg(fn,   TempImg,   image_size, z_size) ; 
	
	/* Geometric */
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				TempImg[k][i][j] = Img[k][i][j].Geom ;
	sprintf(fn, "%s_Geometric", filename);
	WriteImg(fn,   TempImg,   image_size, z_size) ; 
	
	/* VN volume */
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				TempImg[k][i][j] = Img[k][i][j].VNvlm ;
	sprintf(fn, "%s_VNvolume", filename);
	WriteImg(fn,   TempImg,   image_size, z_size) ; 
	
	/* CSF/BG volume */
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				TempImg[k][i][j] = Img[k][i][j].CSFBG ;
	sprintf(fn, "%s_CSFBG", filename);
	WriteImg(fn,   TempImg,   image_size, z_size) ; 
	
	UCfree3d(TempImg, z_size, image_size) ;
}

void HE_ALG_Registration::WriteDeformationField(char filename[], Fvector3d ***DeformFld, int image_size, int z_size)
{
	FILE  *fp;
	int   i, k ;
	
	/* write the smoothed image */
#ifdef HAMMER_WIN32
	fp=myopen(filename, "wb");
#else
	fp = myopen(filename, "w");
#endif
	fwrite(&image_size,sizeof(int),1,fp);
	fwrite(&z_size,sizeof(int),1,fp);
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			fwrite(DeformFld[k][i],sizeof(Fvector3d),image_size,fp);
	fclose(fp);
}

void HE_ALG_Registration::OpenDeformationField(char filename[], Fvector3d ***DeformFld, int image_size, int z_size, HAMMER_Param *ptParm)
{
  FILE  *fp;
  Fvector3d ***Last_DeformFld ;
  int Last_image_size, Last_z_size ;
  float XYZ_ratio, deform_ratio, dx, dy, dz ;
  /* for linear interpolation */
  float ii,jj,kk, b,c,d, b1,c1,d1;
  int   i,j,k,ni,nj,nk, niP1,njP1,nkP1;
  float alpha ;
  
  /* open deformation field in the last resolution */
#ifdef HAMMER_WIN32
  fp=myopen(filename, "rb");
#else
  fp = myopen(filename, "r");
#endif
  fread(&Last_image_size,sizeof(int),1,fp); 
  printf("Last_image_size=%d ", Last_image_size) ;
  fread(&Last_z_size,sizeof(int),1,fp); 
  printf("Last_z_size=%d\n", Last_z_size) ;
  
  Last_DeformFld = Fvector3dalloc3d(Last_image_size,Last_image_size,Last_z_size);
  
  for(k=0;k<Last_z_size;k++)
    for(i=0;i<Last_image_size;i++)
      fread(Last_DeformFld[k][i],sizeof(Fvector3d),Last_image_size,fp);
  fclose(fp);
  
	
  /* interpolation */
  XYZ_ratio = (float)Last_z_size/(float)z_size ;
  deform_ratio = 1.0/XYZ_ratio ;
  alpha        = 1.0-ptParm->ConfidenceOnLastDeformation ; /* it was directly 1.0 at June 18 2001 ~ Oct 23 2002; theoretically it should be 0. */
  if(ptParm->SmoothingTimes>OverSmoothTimes )
    alpha = 0.5 ; /* June 22, 2004 */
  deform_ratio = ( 1.0*alpha + deform_ratio*(1.0-alpha) ) ;  /* changed back June 18, 2001 */
  for(k=0; k<z_size; k++)
    for(i=0; i<image_size; i++)
      for(j=0; j<image_size; j++)
      {
        ii = i*XYZ_ratio ;
        jj = j*XYZ_ratio ;
        kk = k*XYZ_ratio ;
		
        ni = (int)ii ;
        nj = (int)jj ;
        nk = (int)kk ;
		
        niP1 = ni+1 ;
        njP1 = nj+1 ;
        nkP1 = nk+1 ;
		
        if(ni>=0 && ni<Last_image_size-1  &&  nj>=0 && nj<Last_image_size-1  &&  nk>=0 && nk<Last_z_size-1 )
        {
          b = ii-ni ;        b1 = 1.-b ;
          c = jj-nj ;        c1 = 1.-c ;
          d = kk-nk ;        d1 = 1.-d ;
          
          dx = ( d1*(Last_DeformFld[nk][ni][nj].x*(b1*c1) + Last_DeformFld[nk][niP1][nj].x*(b*c1) + Last_DeformFld[nk][ni][njP1].x*(b1*c) + Last_DeformFld[nk][niP1][njP1].x*(b*c)) + d*(Last_DeformFld[nkP1][ni][nj].x*(b1*c1) + Last_DeformFld[nkP1][niP1][nj].x*(b*c1) + Last_DeformFld[nkP1][ni][njP1].x*(b1*c) + Last_DeformFld[nkP1][niP1][njP1].x*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 
          dy = ( d1*(Last_DeformFld[nk][ni][nj].y*(b1*c1) + Last_DeformFld[nk][niP1][nj].y*(b*c1) + Last_DeformFld[nk][ni][njP1].y*(b1*c) + Last_DeformFld[nk][niP1][njP1].y*(b*c)) + d*(Last_DeformFld[nkP1][ni][nj].y*(b1*c1) + Last_DeformFld[nkP1][niP1][nj].y*(b*c1) + Last_DeformFld[nkP1][ni][njP1].y*(b1*c) + Last_DeformFld[nkP1][niP1][njP1].y*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 
          dz = ( d1*(Last_DeformFld[nk][ni][nj].z*(b1*c1) + Last_DeformFld[nk][niP1][nj].z*(b*c1) + Last_DeformFld[nk][ni][njP1].z*(b1*c) + Last_DeformFld[nk][niP1][njP1].z*(b*c)) + d*(Last_DeformFld[nkP1][ni][nj].z*(b1*c1) + Last_DeformFld[nkP1][niP1][nj].z*(b*c1) + Last_DeformFld[nkP1][ni][njP1].z*(b1*c) + Last_DeformFld[nkP1][niP1][njP1].z*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 
          
          DeformFld[k][i][j].x = dx*deform_ratio ; /* *deform_ratio, June 14, 2001*/
          DeformFld[k][i][j].y = dy*deform_ratio ;
          DeformFld[k][i][j].z = dz*deform_ratio ;
        }
		
        if(ni==Last_image_size-1 && nj>=0 && nj<Last_image_size-1 && nk>=0 && nk<Last_z_size-1 || ni>=0 && ni<Last_image_size-1 && nj==Last_image_size-1 && nk>=0 && nk<Last_z_size-1  || ni>=0 && ni<Last_image_size-1 && nj>=0 && nj<Last_image_size-1 && nk==Last_z_size-1)
        {
          DeformFld[k][i][j].x = Last_DeformFld[nk][ni][nj].x*deform_ratio ; /* *deform_ratio, June 14, 2001*/
          DeformFld[k][i][j].y = Last_DeformFld[nk][ni][nj].y*deform_ratio ;
          DeformFld[k][i][j].z = Last_DeformFld[nk][ni][nj].z*deform_ratio ;
        }
		
        /* boundary constraints */
        if(DeformFld[k][i][j].x+i<0) DeformFld[k][i][j].x=-i ;
        if(DeformFld[k][i][j].y+j<0) DeformFld[k][i][j].y=-j ;
        if(DeformFld[k][i][j].z+k<0) DeformFld[k][i][j].z=-k ;
		
        if(DeformFld[k][i][j].x+i>=(image_size-1)) DeformFld[k][i][j].x=(image_size-1)-i ;
        if(DeformFld[k][i][j].y+j>=(image_size-1)) DeformFld[k][i][j].y=(image_size-1)-j ;
        if(DeformFld[k][i][j].z+k>=(z_size-1))     DeformFld[k][i][j].z=(z_size-1)-k ;
      }
  
  /* free */
  Fvector3dfree3d(Last_DeformFld, Last_z_size, Last_image_size) ;
}

void HE_ALG_Registration::calculate_hood(Fvector3d **hood, int *nbr_size, float xres, float yres, float zres)
{
	int i,j,k,s,t,rad_sqrd,radius;
	
	/*  printf("xres=%f yres=%f zres=%f\n",xres,yres,zres); */
	for(s=0;s<10;s++)
    {
		t=0;
		radius=s+BSIC_RAD;
		rad_sqrd=radius*radius;
		for (i=-radius;i<=radius;i++)
			for(j=-radius;j<=radius;j++)
				for(k=-radius;k<=radius;k++)
				{
					if((i*i+j*j+k*k)<=rad_sqrd)
					{
						hood[s][t].x=((float) i)/xres;
						hood[s][t].y=((float) j)/yres;
						hood[s][t].z=((float) k)/zres;
						t++;
					}
				}
		nbr_size[s]=t;
    }
}

void HE_ALG_Registration::calculate_hood_special(Fvector3d *bubble, int bubble_size, int *pixelNumInBubble, float xres, float yres, float zres)
{
	int i,j,k,t,rad_sqrd,radius;
	
	t=0;
	radius=bubble_size+BASIC_R;
	rad_sqrd=radius*radius;
	for(i=-radius;i<=radius;i++)
		for(j=-radius;j<=radius;j++)
			for(k=-radius;k<=radius;k++)
				if((i*i+j*j+k*k)<=rad_sqrd)
				{
					bubble[t].x=((float) i)/xres;
					bubble[t].y=((float) j)/yres;
					bubble[t].z=((float) k)/zres;
					t++;
				}
	(*pixelNumInBubble) = t;
}

void HE_ALG_Registration::calculate_hood_byIncreasingRadius(Ivector3d *Hood, int HoodSize, int *pixelNumInHood, float xres, float yres, float zres)
{
	int        i, j, k, l ;
	int        x, y, z, t, r  ;
	int        half ; 
	
	
	t = 0 ;  Hood[0].x = 0 ;  Hood[0].y = 0 ;  Hood[0].z = 0 ;
	t++ ;
	half = HoodSize/2;
	for(r=1; r<=half; r++)
    {
		for(z=-r; z<=r; z+=2*r)
			for(x=-r; x<=r; x++)
				for(y=-r; y<=r; y++)
				{
					Hood[t].x = x/xres ;
					Hood[t].y = y/yres ;
					Hood[t].z = z/zres ;
					
					t++ ;
					/*printf("t=%d: (%d,%d,%d)\n", t,x,y,z) ;*/
				}
		for(x=-r; x<=r; x+=2*r)
			for(z=-r+1; z<=r-1; z++) 
				for(y=-r; y<=r; y++)
				{
					Hood[t].x = x/xres ;
					Hood[t].y = y/yres ;
					Hood[t].z = z/zres ;
					
					t++ ;
					/*printf("t=%d: (%d,%d,%d)\n", t,x,y,z) ;*/
				}
		for(y=-r; y<=r; y+=2*r)
			for(z=-r+1; z<=r-1; z++) 
				for(x=-r+1; x<=r-1; x++) 
				{
					Hood[t].x = x/xres ;
					Hood[t].y = y/yres ;
					Hood[t].z = z/zres ;
					
					t++ ;
					/*printf("t=%d: (%d,%d,%d)\n", t,x,y,z) ;*/
				}
    }
	(*pixelNumInHood) = t ;
	printf("total %d in the search area!\n", t) ;
}

void HE_ALG_Registration::Get_WMedge_GmVnEdge_FromSegmentedImg(ImgAttribute ***Img)
{
	int i,j,k ;
	int x,y,z ;
	int flag, strength ;
	int flag_VN, flag_GM ;
	
	printf("\nfinding WM edges and GM+VN edges ...\n") ;
	
	
	strength = 1 ;
	
	/* reset edge map */
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				Img[k][i][j].Edge=0 ;
			
	/* WM edge map */
	for(k=1;k<z_size-1;k++)
		for(i=1;i<image_size-1;i++)
			for(j=1;j<image_size-1;j++)
				if(Img[k][i][j].Tiss==WM)
				{
					flag_GM = 0 ;
					if(Img[k+1][i][j].Tiss==GM) flag_GM++;
					if(Img[k-1][i][j].Tiss==GM) flag_GM++;
					if(Img[k][i+1][j].Tiss==GM) flag_GM++;
					if(Img[k][i-1][j].Tiss==GM) flag_GM++;
					if(Img[k][i][j+1].Tiss==GM) flag_GM++;
					if(Img[k][i][j-1].Tiss==GM) flag_GM++;
					
					flag_VN = 0 ;
					if(Img[k+1][i][j].Tiss==VN) flag_VN++;
					if(Img[k-1][i][j].Tiss==VN) flag_VN++;
					if(Img[k][i+1][j].Tiss==VN) flag_VN++;
					if(Img[k][i-1][j].Tiss==VN) flag_VN++;
					if(Img[k][i][j+1].Tiss==VN) flag_VN++;
					if(Img[k][i][j-1].Tiss==VN) flag_VN++;
					
					/* determine, whether edge? If edge, which type */
					if( flag_GM>flag_VN )
						Img[k][i][j].Edge = WMGM_EDGE ;
					if( flag_GM<=flag_VN && flag_VN!=0 )
						Img[k][i][j].Edge = WMVN_EDGE ;
				}
				
	/* June 4 2001: edge between GM and CSF/BG */
	for(k=1;k<z_size-1;k++)		
		for(i=1;i<image_size-1;i++)
			for(j=1;j<image_size-1;j++)
				if(Img[k][i][j].Tiss==GM)
				{
					flag = 0 ;
					if(Img[k+1][i][j].Tiss<=CSF) flag++;
					if(Img[k-1][i][j].Tiss<=CSF) flag++;
					if(Img[k][i+1][j].Tiss<=CSF) flag++;
					if(Img[k][i-1][j].Tiss<=CSF) flag++;
					if(Img[k][i][j+1].Tiss<=CSF) flag++;
					if(Img[k][i][j-1].Tiss<=CSF) flag++;
					if( flag>=strength )
						Img[k][i][j].Edge = GMCSFBG_EDGE ;
				}
							
	/* edge between GM and VN */
	for(k=1; k<z_size-1;k++)
		for(i=1;i<image_size-1;i++)
			for(j=1;j<image_size-1;j++)
				if(Img[k][i][j].Tiss==GM)
				{
					flag = 0 ;
					if(Img[k+1][i][j].Tiss==VN) flag++;
					if(Img[k-1][i][j].Tiss==VN) flag++;
					if(Img[k][i+1][j].Tiss==VN) flag++;
					if(Img[k][i-1][j].Tiss==VN) flag++;
					if(Img[k][i][j+1].Tiss==VN) flag++;
					if(Img[k][i][j-1].Tiss==VN) flag++;
					if( flag>=strength )
						Img[k][i][j].Edge = GMVN_EDGE ;
				}
}


void HE_ALG_Registration::Compute_GeometricFeatures(ImgAttribute ***Img, int scale, float Xres, float Yres, float Zres)
{
	int i,j,k, t, l,m,n ;
	float degree ;
	int   NumDown, value, VN_value, CSFBG_value, XYscale, Zscale ;
	
	int       bubble_size, pixelNumInBubble;
	Fvector3d *bubble ;
	
	printf("Compute geometric features for each edge voxel.\n") ;
	
	bubble = Fvector3dalloc1d(10000);
	bubble_size = scale ;
	calculate_hood_special(bubble, bubble_size, &pixelNumInBubble, Xres, Yres, Zres);
	printf("bubble_size=%d, pixelNumInBubble=%d\n", bubble_size, pixelNumInBubble) ;
	
	Zscale  = scale/Zres ;
	XYscale = scale/Xres ;
	
	/* action */
	
	for(k=Zscale;k<z_size-Zscale;k++)
		for(i=XYscale;i<image_size-XYscale;i++)
			for(j=XYscale;j<image_size-XYscale;j++)
			{
				if(Img[k][i][j].Edge==0)
				{
					Img[k][i][j].Geom  = 0 ; 
					Img[k][i][j].VNvlm = 0 ; 
					Img[k][i][j].CSFBG = 0 ; 
				}
				/* limit computation candidates */
				if(Img[k][i][j].Edge!=0 )
				{
					NumDown = 0 ;
					VN_value = 0 ;
					CSFBG_value = 0 ;
					for(t=0; t<pixelNumInBubble; t++)
					{
						l = (int)bubble[t].x ;
						m = (int)bubble[t].y ;
						n = (int)bubble[t].z ;
						
						if( Img[k+n][i+l][j+m].Tiss!=WM )  NumDown++ ;
						if( Img[k+n][i+l][j+m].Tiss==VN )  VN_value++ ;
						if( Img[k+n][i+l][j+m].Tiss<=CSF)  CSFBG_value++ ;
					}
					degree = ((float)NumDown/(float)pixelNumInBubble) ;
					value = degree*255*1.2 ; /*degree*degree*255*/
					if( value>255 ) value = 255 ;
					Img[k][i][j].Geom = (unsigned char)value ;
					/*printf("(%d,%d,%d)=%d\n", k, i, j, NumDown) ;*/
					
					/* VN volume */
					VN_value = VN_value*255*1.2/pixelNumInBubble ;
					if( VN_value>255 ) VN_value=255 ;
					Img[k][i][j].VNvlm = (unsigned char)VN_value ;
					
					/* CSF/BG volume */
					CSFBG_value = CSFBG_value*255*1.2/pixelNumInBubble ;
					if( CSFBG_value>255 ) CSFBG_value=255 ;
					Img[k][i][j].CSFBG = (unsigned char)CSFBG_value ;
				}
			}
	/* free */
	free(bubble);
}

int HE_ALG_Registration::EvaluationOfRegistration(ImgAttribute ***MdlImg, ImgAttribute ***ObjImg, Fvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder)
{
	int s, i, j, k, x, y, z ;
	FILE  *fp;
	char  filename[180] ;
	unsigned char resImg ;
	int total ;
	
	total = 0 ;
	for(k=0; k<z_size; k++)
		for(i=0; i<image_size; i++)
			for(j=0; j<image_size; j++)
			{
				x = i + DeformFld[k][i][j].x ;
				y = j + DeformFld[k][i][j].y ;
				z = k + DeformFld[k][i][j].z ;
				
				if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 )
					resImg = ObjImg[z][x][y].Tiss ;
				else
					resImg = 0 ;
				
				if(resImg!=MdlImg[k][i][j].Tiss)
					total ++ ;
			}
			
			/* save */
	sprintf(filename, "Diff.sample%d.%d", XYZres, fileOrder);    
	/* write the smoothed image */
	fp=myopen(filename,"w");
	fprintf(fp, "Diff.sample%d.%d:  %d\n", XYZres, fileOrder, total);    
	fclose(fp);
	return 0;
}

unsigned char HE_ALG_Registration::InterpolatedIntensity(float ii, float jj, float kk, unsigned char ***Img, int image_size, int z_size)
{
	float CurrentV ;
	float b,c,d, b1,c1,d1;
	int   ni,nj,nk, niP1,njP1,nkP1, GreyValue ;
	
	GreyValue = 0;
	ni = (int)floor(ii) ;
	nj = (int)floor(jj) ;
	nk = (int)floor(kk) ;
	
	niP1 = ni+1 ;
	njP1 = nj+1 ;
	nkP1 = nk+1 ;
	
	if(ni>=0 && ni<image_size-1  &&  nj>=0 && nj<image_size-1  &&  nk>=0 && nk<z_size-1 )
    {
		b = ii-ni ;        b1 = 1.-b ;
		c = jj-nj ;        c1 = 1.-c ;
		d = kk-nk ;        d1 = 1.-d ;
		
		CurrentV = ( d1*(Img[nk][ni][nj]*(b1*c1) + Img[nk][niP1][nj]*(b*c1) + Img[nk][ni][njP1]*(b1*c) + Img[nk][niP1][njP1]*(b*c)) + d*(Img[nkP1][ni][nj]*(b1*c1) + Img[nkP1][niP1][nj]*(b*c1) + Img[nkP1][ni][njP1]*(b1*c) + Img[nkP1][niP1][njP1]*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 
		
		if( CurrentV>255 )
			GreyValue = 255 ;
		else
			GreyValue = CurrentV ;
    }
	
	if(ni==image_size-1 && nj>=0 && nj<image_size-1 && nk>=0 && nk<z_size-1 || ni>=0 && ni<image_size-1 && nj==image_size-1 && nk>=0 && nk<z_size-1  || ni>=0 && ni<image_size-1 && nj>=0 && nj<image_size-1 && nk==z_size-1)
		GreyValue = Img[nk][ni][nj] ;
	
	return GreyValue ;
}


void HE_ALG_Registration::SaveCurrentWarpingResultOnSegmentedObj(ImgAttribute ***ObjImg, Fvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder, HAMMER_Param *ptParm)
{
  int s, i, j, k, x, y, z ;
  FILE  *fp;
  char  filename[180] ;
  unsigned char ***resImg, ***Img ;
  float  ii, jj, kk ;
  unsigned char GreyValue, MappedV ;
	
	
  Img    = UCalloc3d(image_size,image_size,z_size); 
  resImg = UCalloc3d(image_size,image_size,z_size); 
  
  /* get intensity image in ObjImg */
  for(k=0; k<z_size; k++)
    for(i=0; i<image_size; i++)
      for(j=0; j<image_size; j++)
        Img[k][i][j] = ObjImg[k][i][j].Tiss ;
  
  for(k=0; k<z_size; k++)
    for(i=0; i<image_size; i++)
      for(j=0; j<image_size; j++)
      {
        if(INTERP_SEG==YYES)
        {
          ii = i + DeformFld[k][i][j].x ;
          jj = j + DeformFld[k][i][j].y ;
          kk = k + DeformFld[k][i][j].z ;
          
          GreyValue = InterpolatedIntensity(ii, jj, kk, Img, image_size, z_size) ;
          
          if( GreyValue>=BG&& GreyValue<=(BG+CSF)/2 )
            MappedV = BG ;	      
          if( GreyValue>=(BG+CSF)/2  && GreyValue<=(CSF+VN)/2 )
            MappedV = CSF ;	      
          if( GreyValue>=(CSF+VN)/2  && GreyValue<=(VN+GM)/2 )
            MappedV = VN ;
          if( GreyValue>(VN+GM)/2    && GreyValue<=(GM+WM)/2 )
            MappedV = GM ; ;
          if( GreyValue>(GM+WM)/2)
            MappedV = WM ;
          
          resImg[k][i][j] = MappedV ;
        }
        else
        {
          x = i + DeformFld[k][i][j].x + 0.5 ;
          y = j + DeformFld[k][i][j].y + 0.5 ;
          z = k + DeformFld[k][i][j].z + 0.5 ;
          
          if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 )
            resImg[k][i][j] = Img[z][x][y] ; 
          else 
            resImg[k][i][j] = 0 ;
        }
      }
  
	/* save */
  sprintf(filename, "%sRes.img.sample%d.%d", ptParm->OutputDir, XYZres, fileOrder);
  WriteImg(filename, resImg, image_size, z_size) ;
  
  /* free */
  UCfree3d(resImg, z_size, image_size) ;
  UCfree3d(Img,    z_size, image_size) ;
}

void HE_ALG_Registration::SaveCurrentWarpingResultOnOriginalObjImg(unsigned char ***ObjOriginalImg, Fvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder, HAMMER_Param *ptParm)
{
  int s, i, j, k, x, y, z ;
  FILE  *fp;
  char  filename[180] ;
  unsigned char ***resImg ;
  float  ii, jj, kk ;
  
  resImg = UCalloc3d(image_size,image_size,z_size); 
  
  for(k=0; k<z_size; k++)
    for(i=0; i<image_size; i++)
      for(j=0; j<image_size; j++)
      {
        if(INTERPOLATE==YYES)
        {
          ii = i + DeformFld[k][i][j].x ;
          jj = j + DeformFld[k][i][j].y ;
          kk = k + DeformFld[k][i][j].z ;
          
          resImg[k][i][j] = InterpolatedIntensity(ii, jj, kk, ObjOriginalImg, image_size, z_size) ;
        }
        else
        {
          x = i + DeformFld[k][i][j].x + 0.5 ;
          y = j + DeformFld[k][i][j].y + 0.5 ;
          z = k + DeformFld[k][i][j].z + 0.5 ;
          
          if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 )
            resImg[k][i][j] = ObjOriginalImg[z][x][y] ;
          else
            resImg[k][i][j] = 0 ;
        }
      }
			
  /* save */
  sprintf(filename, "%sWarped.OriginalImg.sample%d.%d", ptParm->OutputDir, XYZres, fileOrder);    
  WriteImg(filename, resImg, image_size, z_size) ;
  
  /* free */
  UCfree3d(resImg, z_size, image_size) ;
}

float HE_ALG_Registration::SimilarityBetweenFocusedPointsInMdlObjImgs(ImgAttribute *ObjVer_Fea, int l, ImgAttribute *MdlVer_Fea, int s)
{
	float Degree ;
	
	Degree = 0 ;
	if( ObjVer_Fea[l].Edge==MdlVer_Fea[s].Edge )
	{
		Degree  =  1.0-abs(MdlVer_Fea[s].Geom -ObjVer_Fea[l].Geom)/255.0 ;
		Degree *= (1.0-abs(MdlVer_Fea[s].VNvlm-ObjVer_Fea[l].VNvlm)/255.0) ;
		Degree *= (1.0-abs(MdlVer_Fea[s].CSFBG-ObjVer_Fea[l].CSFBG)/255.0) ;
		Degree *= (1.0-abs(MdlVer_Fea[s].Tiss -ObjVer_Fea[l].Tiss)/255.0) ;
	}
	
	return Degree ;
}


float HE_ALG_Registration::SimilarityBetweenFeaturesInImgAndFeaturesInMdl(ImgAttribute ***ObjImg, int x, int y, int z, ImgAttribute *MdlVer_Fea, int s)
{
	float Degree ;
	
	Degree = 0 ;
	if( ObjImg[z][x][y].Edge==MdlVer_Fea[s].Edge )
	{
        Degree  =  1.0-abs(MdlVer_Fea[s].Geom -ObjImg[z][x][y].Geom)/255.0 ;
		Degree *= (1.0-abs(MdlVer_Fea[s].VNvlm-ObjImg[z][x][y].VNvlm)/255.0) ;
		Degree *= (1.0-abs(MdlVer_Fea[s].CSFBG-ObjImg[z][x][y].CSFBG)/255.0) ;
		Degree *= (1.0-abs(MdlVer_Fea[s].Tiss -ObjImg[z][x][y].Tiss)/255.0) ;
	}
	
	return Degree ;
}

float HE_ALG_Registration::SimilarityBetweenFeaturesInMdlAndObjImgs(ImgAttribute ***ObjImg, int x, int y, int z, ImgAttribute ***MdlImg, int i, int j, int k)
{
	float Degree ;
	
	Degree = 0 ;
	if( ObjImg[z][x][y].Edge==MdlImg[k][i][j].Edge )
	{
        Degree  =  1.0-abs(MdlImg[k][i][j].Geom -ObjImg[z][x][y].Geom)/255.0 ;
		Degree *= (1.0-abs(MdlImg[k][i][j].VNvlm-ObjImg[z][x][y].VNvlm)/255.0) ;
		Degree *= (1.0-abs(MdlImg[k][i][j].CSFBG-ObjImg[z][x][y].CSFBG)/255.0) ;
		Degree *= (1.0-abs(MdlImg[k][i][j].Tiss -ObjImg[z][x][y].Tiss)/255.0) ;
	}
	
	return Degree ;
}

void HE_ALG_Registration::SmoothDeformationField_FastImplementation(Fvector3d ***DeformFld, int image_size, int z_size)
{
	int i,j,k,n ;
	int x,y,z ;
	int        smth_size, temp_num ;
	Fvector3d  nbr_tot, nbr_average ;
	float      LocalRatio ;
	
	
	printf("smoothing ...\n") ;
	smth_size = 3 ; /* 3 */
	
	
	LocalRatio = 0.5 ;
	/* 1-D smoothing on y dimension */
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
		{
			for(j=0;j<image_size;j++)
			{
				if( j==0 )
				{
					/* need to calcaulate total values around the first point */
					nbr_tot.x=0; nbr_tot.y=0; nbr_tot.z=0; temp_num=0;
					for(n=-smth_size;n<=smth_size;n++)
					{
						y = j + n ;
						if( y<image_size && y>=0 )
						{
							nbr_tot.x += DeformFld[k][i][y].x;
							nbr_tot.y += DeformFld[k][i][y].y;
							nbr_tot.z += DeformFld[k][i][y].z;
							
							temp_num++ ;
						}
					}
					if(temp_num>0)
					{
						nbr_average.x = nbr_tot.x/temp_num ;
						nbr_average.y = nbr_tot.y/temp_num ;
						nbr_average.x = nbr_tot.z/temp_num ;
					}
				}
				else
				{
					/* total values around the current point is obtained ...  */
					y = j-1 - smth_size ;
					if( y<image_size && y>=0 )
					{
						nbr_tot.x -= DeformFld[k][i][y].x;
						nbr_tot.y -= DeformFld[k][i][y].y;
						nbr_tot.z -= DeformFld[k][i][y].z;
						
						temp_num-- ;
					}
					
					y = j + smth_size ;
					if( y<image_size && y>=0 )
					{
						nbr_tot.x += DeformFld[k][i][y].x;
						nbr_tot.y += DeformFld[k][i][y].y;
						nbr_tot.z += DeformFld[k][i][y].z;
						
						temp_num++ ;
					}
					
					if(temp_num>0)
					{
						nbr_average.x = nbr_tot.x/temp_num ;
						nbr_average.y = nbr_tot.y/temp_num ;
						nbr_average.x = nbr_tot.z/temp_num ;
					}
				}  
				
				DeformFld[k][i][j].x += (nbr_average.x - DeformFld[k][i][j].x)*LocalRatio ;
				DeformFld[k][i][j].y += (nbr_average.y - DeformFld[k][i][j].y)*LocalRatio ; 
				DeformFld[k][i][j].z += (nbr_average.z - DeformFld[k][i][j].z)*LocalRatio ; 
			}
		}
		
		
		/* 1-D smoothing on x dimension */
		for(k=0;k<z_size;k++)
			for(j=0;j<image_size;j++)
			{
				for(i=0;i<image_size;i++)
				{
					if( i==0 )
					{
						/* need to calcaulate total values around the first point */
						nbr_tot.x=0; nbr_tot.y=0; nbr_tot.z=0; temp_num=0;
						for(n=-smth_size;n<=smth_size;n++)
						{
							x = i + n ;
							if( x<image_size && x>=0 )
							{
								nbr_tot.x += DeformFld[k][x][j].x;
								nbr_tot.y += DeformFld[k][x][j].y;
								nbr_tot.z += DeformFld[k][x][j].z;
								
								temp_num++ ;
							}
						}
						if(temp_num>0)
						{
							nbr_average.x = nbr_tot.x/temp_num ;
							nbr_average.y = nbr_tot.y/temp_num ;
							nbr_average.x = nbr_tot.z/temp_num ;
						}
					}
					else
					{
						/* total values around the current point is obtained ...  */
						x = i-1 - smth_size ;
						if( x<image_size && x>=0 )
						{
							nbr_tot.x -= DeformFld[k][x][j].x;
							nbr_tot.y -= DeformFld[k][x][j].y;
							nbr_tot.z -= DeformFld[k][x][j].z;
							
							temp_num-- ;
						}
						
						x = i + smth_size ;
						if( x<image_size && x>=0 )
						{
							nbr_tot.x += DeformFld[k][x][j].x;
							nbr_tot.y += DeformFld[k][x][j].y;
							nbr_tot.z += DeformFld[k][x][j].z;
							
							temp_num++ ;
						}
						
						if(temp_num>0)
						{
							nbr_average.x = nbr_tot.x/temp_num ;
							nbr_average.y = nbr_tot.y/temp_num ;
							nbr_average.x = nbr_tot.z/temp_num ;
						}
					}
					
					DeformFld[k][i][j].x += (nbr_average.x - DeformFld[k][i][j].x)*LocalRatio ;
					DeformFld[k][i][j].y += (nbr_average.y - DeformFld[k][i][j].y)*LocalRatio ; 
					DeformFld[k][i][j].z += (nbr_average.z - DeformFld[k][i][j].z)*LocalRatio ; 
				}
			}
			
			
			/* 1-D smoothing on z dimension */
			for(i=0;i<image_size;i++)
				for(j=0;j<image_size;j++)
				{
					for(k=0;k<z_size;k++)
					{
						if( k==0 )
						{
							/* need to calcaulate total values around the first point */
							nbr_tot.x=0; nbr_tot.y=0; nbr_tot.z=0; temp_num=0;
							for(n=-smth_size;n<=smth_size;n++)
							{
								z = k + n ;
								if( z<z_size && z>=0 )
								{
									nbr_tot.x += DeformFld[z][i][j].x;
									nbr_tot.y += DeformFld[z][i][j].y;
									nbr_tot.z += DeformFld[z][i][j].z;
									
									temp_num++ ;
								}
							}
							if(temp_num>0)
							{
								nbr_average.x = nbr_tot.x/temp_num ;
								nbr_average.y = nbr_tot.y/temp_num ;
								nbr_average.x = nbr_tot.z/temp_num ;
							}
						}
						else
						{
							/* total values around the current point is obtained ...  */
							z = k-1 - smth_size ;
							if( z<z_size && z>=0 )
							{
								nbr_tot.x -= DeformFld[z][i][j].x;
								nbr_tot.y -= DeformFld[z][i][j].y;
								nbr_tot.z -= DeformFld[z][i][j].z;
								
								temp_num-- ;
							}
							
							z = k + smth_size ;
							if( z<z_size && z>=0 )
							{
								nbr_tot.x += DeformFld[z][i][j].x;
								nbr_tot.y += DeformFld[z][i][j].y;
								nbr_tot.z += DeformFld[z][i][j].z;
								
								temp_num++ ;
							}
							
							if(temp_num>0)
							{
								nbr_average.x = nbr_tot.x/temp_num ;
								nbr_average.y = nbr_tot.y/temp_num ;
								nbr_average.x = nbr_tot.z/temp_num ;
							}
						}
						
						DeformFld[k][i][j].x += (nbr_average.x - DeformFld[k][i][j].x)*LocalRatio ;
						DeformFld[k][i][j].y += (nbr_average.y - DeformFld[k][i][j].y)*LocalRatio ; 
						DeformFld[k][i][j].z += (nbr_average.z - DeformFld[k][i][j].z)*LocalRatio ; 
					}
				}
				
	/* assign ... */  
	for(k=0;k<z_size;k++)	
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
			{
				/* boundary constraints */
				if(DeformFld[k][i][j].x+i<0) DeformFld[k][i][j].x=-i ;
				if(DeformFld[k][i][j].y+j<0) DeformFld[k][i][j].y=-j ;
				if(DeformFld[k][i][j].z+k<0) DeformFld[k][i][j].z=-k ;
				
				if(DeformFld[k][i][j].x+i>=(image_size-1)) DeformFld[k][i][j].x=(image_size-1)-i ;
				if(DeformFld[k][i][j].y+j>=(image_size-1)) DeformFld[k][i][j].y=(image_size-1)-j ;
				if(DeformFld[k][i][j].z+k>=(z_size-1))     DeformFld[k][i][j].z=(z_size-1)-k ;
			}
	printf("End\n") ;
}



void HE_ALG_Registration::SmoothDeformationField(Fvector3d ***DeformFld, int image_size, int z_size, ImgAttribute ***MdlImg, HAMMER_Param *ptParm)
{
	int i,j,k,n,t ;
	int x,y,z ;
	Ivector3d  *nb_pnt ;
	int        nb_size, count, half, temp_num ;
	Fvector3d  nbr_tot, direct ;
	float      LocalRatio, mag ;

	printf("\n\nsmoothing ...\n") ;
	nb_size = 3 ;
	nb_pnt= Ivector3dalloc1d(nb_size*nb_size*nb_size) ;
	calculate_hood_byIncreasingRadius(nb_pnt, nb_size, &count, 1., 1., 1.) ; /* 0.5, 0.5, 0.5, Feb 28, 2002 */

	half=nb_size/2;  
	LocalRatio = ptParm->DfmSmthCoeff ; /* LocalRatio = 0.5 ; before Dec 19, 2003 */
	printf("smoothing factor = %f\n", LocalRatio) ;
	for(t=0; t<ptParm->DfmSmthTimes; t++ ) /* DfmSmthTimes=1; before Dec 19, 2003*/
	{
		printf("The %d-th time of smoothing deformation field, without edge-preserving!\n", t) ;

		for(k=0;k<z_size;k++)
			for(i=0;i<image_size;i++)
				for(j=0;j<image_size;j++)
				{
					nbr_tot.x=0; nbr_tot.y=0; nbr_tot.z=0; temp_num=0;
					for(n=1;n<27;n++) /* 26 neighbor */
					{
						x = i + nb_pnt[n].x ;
						y = j + nb_pnt[n].y ;
						z = k + nb_pnt[n].z ;

						if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 )
						{
							nbr_tot.x += DeformFld[z][x][y].x;
							nbr_tot.y += DeformFld[z][x][y].y;
							nbr_tot.z += DeformFld[z][x][y].z;

							temp_num++ ;
						}
					}
					if(temp_num>0)
					{
						nbr_tot.x /= temp_num ;
						nbr_tot.y /= temp_num ;
						nbr_tot.z /= temp_num ;
					}

					/* Jun 21, 2004 */
					if( ptParm->SmoothingTimes<=1 || MdlImg[k][i][j].Edge!=GMVN_EDGE && MdlImg[k][i][j].Edge!=WMVN_EDGE  ) 
					{
						DeformFld[k][i][j].x += (nbr_tot.x - DeformFld[k][i][j].x)*LocalRatio ;
						DeformFld[k][i][j].y += (nbr_tot.y - DeformFld[k][i][j].y)*LocalRatio ; 
						DeformFld[k][i][j].z += (nbr_tot.z - DeformFld[k][i][j].z)*LocalRatio ; 	  
					}
					else
					{
						direct.x = (nbr_tot.x - DeformFld[k][i][j].x)*LocalRatio ;
						direct.y = (nbr_tot.y - DeformFld[k][i][j].y)*LocalRatio ;
						direct.z = (nbr_tot.z - DeformFld[k][i][j].z)*LocalRatio ;
						mag = Fvector3dmag(direct) ;
						if( mag>3.0 ) /* 2.0 before June 22 2004 */
						{
							direct.x /= mag/3.0 ; 
							direct.y /= mag/3.0 ;
							direct.z /= mag/3.0 ;
						}

						DeformFld[k][i][j].x += direct.x ;
						DeformFld[k][i][j].y += direct.y ;
						DeformFld[k][i][j].z += direct.z ;
					}

					/* boundary constraints */
					if(DeformFld[k][i][j].x+i<0) DeformFld[k][i][j].x=-i ;
					if(DeformFld[k][i][j].y+j<0) DeformFld[k][i][j].y=-j ;
					if(DeformFld[k][i][j].z+k<0) DeformFld[k][i][j].z=-k ;

					if(DeformFld[k][i][j].x+i>=(image_size-1)) DeformFld[k][i][j].x=(image_size-1)-i ;
					if(DeformFld[k][i][j].y+j>=(image_size-1)) DeformFld[k][i][j].y=(image_size-1)-j ;
					if(DeformFld[k][i][j].z+k>=(z_size-1))     DeformFld[k][i][j].z=(z_size-1)-k ;
				}
	}

	printf("End\n") ;
}

void HE_ALG_Registration::SmoothDeformationFieldWithEdgePreserving(Ivector3d *FixedMdlVer, int MdlVer_Num, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, int image_size, int z_size, float ratio_iteration, HAMMER_Param *ptParm)
{
	int i,j,k,n, t,s ;
	int x,y,z, sx,sy,sz ;
	Ivector3d  *nb_pnt ;
	int        nb_size, count, half, temp_num ;
	Fvector3d  nbr_tot ;
	float      LocalRatio ;
	unsigned char ***FixedImg;
	
	
	printf("\nEdge preserving smoothing ...\n") ;
	nb_size = 3 ;
	nb_pnt= Ivector3dalloc1d(nb_size*nb_size*nb_size) ;
	calculate_hood_byIncreasingRadius(nb_pnt, nb_size, &count, 1., 1., 1.) ; /* 0.5, 0.5, 0.5, Feb 28, 2002 */
	
	
	/* insert the MdelVer poistions into an image, for the computation convenience. */
	FixedImg = UCalloc3d(image_size,image_size,z_size);
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				FixedImg[k][i][j]=0 ;
	for(s=0; s<MdlVer_Num; s++)
	{
		sx = FixedMdlVer[s].x ;
		sy = FixedMdlVer[s].y ;
		sz = FixedMdlVer[s].z ;

		FixedImg[sz][sx][sy]=255 ;
	}
			
	/* smoothing */
	LocalRatio = 0.75-0.25*ratio_iteration*ratio_iteration ;   /* 0.75, 0.25 */
	printf("Hierarchical ratio in edge-preserving smoothing : %f\n", LocalRatio) ;
	for( t=0; t<ptParm->SmoothingTimes; t++)
	{
		printf("The %dth time ...\n", t) ;
		for(k=0;k<z_size;k++)
			for(i=0;i<image_size;i++)
				for(j=0;j<image_size;j++)
					if( /*FixedImg[k][i][j]<255 &&*/ MdlImg[k][i][j].Tiss>0 ) /* for saving time, smooth on brain region only, no background. Feb 26, 2002 */ 
					{
						nbr_tot.x=0; nbr_tot.y=0; nbr_tot.z=0; temp_num=0;
						for(n=1;n<27;n++) /* 26 neighbor */
						{
							x = i + nb_pnt[n].x ;
							y = j + nb_pnt[n].y ;
							z = k + nb_pnt[n].z ;
							
							if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 )
							{
								nbr_tot.x += DeformFld[z][x][y].x;
								nbr_tot.y += DeformFld[z][x][y].y;
								nbr_tot.z += DeformFld[z][x][y].z;
								
								temp_num++ ;
								
								/*Jun 17 2004*/ /* to increase the weights of VN boundary points */
								if( ptParm->SmoothingTimes>1 && (MdlImg[z][x][y].Edge==GMVN_EDGE || MdlImg[z][x][y].Edge==WMVN_EDGE) ) 
								{
									nbr_tot.x += DeformFld[z][x][y].x ; /*+ DeformFld[z][x][y].x ; */
									nbr_tot.y += DeformFld[z][x][y].y ; /*+ DeformFld[z][x][y].y ; */
									nbr_tot.z += DeformFld[z][x][y].z ; /*+ DeformFld[z][x][y].z ; */
									
									temp_num++ ; /*temp_num++ ;  */
								} 
								
							}
						}
						if(temp_num>0)
						{
							nbr_tot.x /= temp_num ;
							nbr_tot.y /= temp_num ;
							nbr_tot.z /= temp_num ;
						}
						
						if( /*FixedImg[k][i][j]<255  -Jun 17 2004*/ ptParm-> SmoothingTimes<=1 || MdlImg[k][i][j].Edge!=GMVN_EDGE && MdlImg[k][i][j].Edge!=WMVN_EDGE  ) 
						{		
							DeformFld[k][i][j].x += (nbr_tot.x - DeformFld[k][i][j].x)*LocalRatio ;
							DeformFld[k][i][j].y += (nbr_tot.y - DeformFld[k][i][j].y)*LocalRatio ; 
							DeformFld[k][i][j].z += (nbr_tot.z - DeformFld[k][i][j].z)*LocalRatio ; 
						}
						else
						{
							DeformFld[k][i][j].x += (nbr_tot.x - DeformFld[k][i][j].x)*LocalRatio/100 ; /*1000*/ /*/2.0 ; */ 
							DeformFld[k][i][j].y += (nbr_tot.y - DeformFld[k][i][j].y)*LocalRatio/100 ;          /*/2.0 ; */ 
							DeformFld[k][i][j].z += (nbr_tot.z - DeformFld[k][i][j].z)*LocalRatio/100 ;          /*/2.0 ; */  
						}
						
						/* boundary constraints */
						if(DeformFld[k][i][j].x+i<0) DeformFld[k][i][j].x=-i ;
						if(DeformFld[k][i][j].y+j<0) DeformFld[k][i][j].y=-j ;
						if(DeformFld[k][i][j].z+k<0) DeformFld[k][i][j].z=-k ;
						
						if(DeformFld[k][i][j].x+i>=(image_size-1)) DeformFld[k][i][j].x=(image_size-1)-i ;
						if(DeformFld[k][i][j].y+j>=(image_size-1)) DeformFld[k][i][j].y=(image_size-1)-j ;
						if(DeformFld[k][i][j].z+k>=(z_size-1))     DeformFld[k][i][j].z=(z_size-1)-k ;
					}
	}
	printf("End\n") ;
	/* free */
	UCfree3d(FixedImg, z_size, image_size) ;
}

void HE_ALG_Registration::AffineDeform3D(Fvector3d *MdlVer, Ivector3d *FixedMdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, int image_size, int z_size, int resolution, HAMMER_Param *ptParm)
{
  int   i,j,s,k,g,l,m,n,old_count,count,num,how_many,max,size,t, SHIFT, incre, LocalM, scale, beforeN, SelectVerNum, vv, RealVV ;
  float weight, CurrentDegree, OverlapDegree, MaxDegree, AdaptiveFactor, DistSeg, MinDist ;
  Fvector3d Search, Crnt, Tmp, dfm, parallel, globl;
  float mag, factor, Delta, level, magDfm ;
  int   x,y,z, sx,sy,sz ;
  
  /* Bubble for checking similarity */
  Ivector3d  *nb_pnt, Grid, StudiedPoint;
  int      nb_size ;
  /* Bubble for transforming subvolume */
  Ivector3d  *SubV_pnt;
  int        SubVNum, SubVsize, UsedVNum ;
  float      UsedGuassianSigma ;
  
  /* for estimating the overlapping degree */
  int bubble_size[BUBBNUM], real_size ;
  
  /* for local geometric features of 3D shape */
  float     CenterRate, LocalRatio ;
  Fvector3d *verModelLast, nbr_tot ;
  int       numTEMP, Last_searched_point, temp_num ;
  
  
  /* to speed up, the neighboring driving voxels are not necessary to deform for multiple times. */
  unsigned char ***SearchingStatus ;
  int           FilterSize ;
  
  
  /* June 5, 2001 */
  Fvector3d  ***DeformFld_Last ;
  DeformFld_Last=Fvector3dalloc3d(image_size,image_size,z_size);
  
	
  /* global constraints  */
  verModelLast      = Fvector3dalloc1d(MdlVer_Num); /* used as model */
  /* remember */
  for(numTEMP=0; numTEMP<MdlVer_Num; numTEMP++)
  {
    verModelLast[numTEMP].x=MdlVer[numTEMP].x; 
    verModelLast[numTEMP].y=MdlVer[numTEMP].y; 
    verModelLast[numTEMP].z=MdlVer[numTEMP].z;
  }
  for(k=0;k<z_size;k++)
    for(i=0;i<image_size;i++)
      for(j=0;j<image_size;j++)
      {
        DeformFld_Last[k][i][j].x=DeformFld[k][i][j].x ;
        DeformFld_Last[k][i][j].y=DeformFld[k][i][j].y ;
        DeformFld_Last[k][i][j].z=DeformFld[k][i][j].z ;
      }
  
  
  /* shift assigned */
  SHIFT = resolution/2 ; 
  if(SHIFT<1)
    SHIFT=1; 
  printf("Shift=%d\n", SHIFT) ;
  
  /* get the forces from the landmarks */
  
  printf("before ObjVer_Num=%d\n", ObjVer_Num) ;
  if(ratio_iteration<=ITER_THRD && ptParm->UsingForcesFromObject==true) 
    SearchTheNearestVertexForEachLandmark_March2003(ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg,    MdlVer, MdlVer_Num, MdlVer_Fea, FixedMdlVer, MdlImg, DeformFld,  image_size, z_size,  SHIFT+1, ptParm) ;
  /*SearchTheNearestVertexForEachLandmark_NewFeb2002(ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg,   MdlVer, MdlVer_Num, MdlVer_Fea, MdlImg, DeformFld, image_size, z_size) ; used before March 2003*/
  /*SearchTheNearestVertexForEachLandmark( ObjVer, ObjVer_Num, ObjVer_Fea, MdlVer, MdlVer_Num, MdlVer_Fea, image_size, z_size ) ;*/
  
  
  incre = 2*SHIFT/6 /*8, 20, May 2001*/ ; if(incre<1) incre=1 ;
  max = SHIFT+1 ;
  nb_size = max*2+1; /*nb_size should be odd number */ 
  nb_pnt= Ivector3dalloc1d(nb_size*nb_size*nb_size) ;
  calculate_hood_byIncreasingRadius(nb_pnt, nb_size, &count, 1., 1., 1.) ; 
  printf("nbr num:%d with rad %d\n", nb_size, count) ;
  /* for transformation in Subvolume */
  SubVsize = 41 ; /* nb_size+2*0 */
  SubV_pnt = Ivector3dalloc1d(SubVsize*SubVsize*SubVsize) ;
  calculate_hood_byIncreasingRadius(SubV_pnt, SubVsize, &SubVNum, 1., 1., 1.) ; 
  printf("Subvolume num:%d with rad %d\n", SubVsize, SubVNum) ;
  t = 0;   /* 3 8 */ /* 0 ~ 9*/
  t = resolution/10 ;if(t>2) t=2 ;
  SelectVerNum = MdlVer_Num ;
  printf("incre=%d  max=%d   searched Num=%d    t=%d\n", incre, max, SelectVerNum, t ) ;
  
	
	
  /* Feb 27, 2002: To speed up, the neighboring driving voxels are not necessary to deform for multiple times. */
  SearchingStatus = UCalloc3d(image_size,image_size,z_size);
  for(k=0;k<z_size;k++)
    for(i=0;i<image_size;i++)
      for(j=0;j<image_size;j++)
        SearchingStatus[k][i][j]=OOK ;
  RealVV = 0 ;
  for(vv=0; vv<MdlVer_Num; vv+=STEPPNT)  /*for(s=0; s<MdlVer_Num; s+=STEPPNT)*/
  {
    s = (vv+Start_Search_Point)%MdlVer_Num ; 
	
    if( (RealVV<SelectVerNum || Fvector3dmag(forceByFocusedPntInObj[s])!=0) && SearchingStatus[FixedMdlVer[s].z][FixedMdlVer[s].x][FixedMdlVer[s].y]==OOK )
    {
      RealVV ++ ;
      Last_searched_point = s ;
      if( s%100==0 )
      { 
        printf("\ns=%d  Last_searched_point= %d   ", s, Last_searched_point) ;
        printf("percent finished = %f\n", (float)RealVV/SelectVerNum) ; 
      }
      
      /* May 24, 2001 */
      m_STEPNBR = count/20 ;  
      if(m_STEPNBR<1) 
        m_STEPNBR=1 ;
      
      if( Fvector3dmag(forceByFocusedPntInObj[s])==0 || ratio_iteration>ITER_THRD)
      {
        /* begin to search by greedy algorithm: external part */
        dfm.x = 0 ; dfm.y = 0 ; dfm.z = 0 ;
        MaxDegree = 0 ;
        MinDist = 100000.0 ;
        /*printf("VerNumInTheSameRegionOfCurrentVer[%d]=%d\n", s,VerNumInTheSameRegionOfCurrentVer[s]) ;*/
        sx = FixedMdlVer[s].x ;
        sy = FixedMdlVer[s].y ;
        sz = FixedMdlVer[s].z ;
        if( sx>=image_size || sy>=image_size || sz>=z_size || sx<0 || sy<0 || sz<0 ) 
        {
          printf("out\n"); 
          exit(0);
        }
        for(Search.x=-SHIFT; Search.x<=SHIFT; Search.x+=incre)
          for(Search.y=-SHIFT; Search.y<=SHIFT; Search.y+=incre)
            for(Search.z=-SHIFT; Search.z<=SHIFT; Search.z+=incre)
            {
              /*		  x = (int)(MdlVer[s].x+Search.x) ;
                y = (int)(MdlVer[s].y+Search.y) ;
                z = (int)(MdlVer[s].z+Search.z) ;
              */
              /* MdlVer[s]'s current position */
              x = (int)(DeformFld[sz][sx][sy].x + sx + Search.x + 0.5) ;
              y = (int)(DeformFld[sz][sx][sy].y + sy + Search.y + 0.5) ;
              z = (int)(DeformFld[sz][sx][sy].z + sz + Search.z + 0.5) ;
              
              /*printf("1:(%d) xyz=%d,%d,%d   %f,%f,%f\n", SHIFT, x,y,z, Search.x, Search.y, Search.z) ;*/
              
              if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 && \
                  (SimilarityBetweenFeaturesInImgAndFeaturesInMdl(ObjImg,x,y,z,MdlVer_Fea,s)>SMR_THR|| \
                   (ptParm->BigVN==YYES && MdlVer_Fea[s].VNvlm>0 && ObjImg[z][x][y].VNvlm>0)) ) 
              {
                /*printf("2: xyz=%d,%d,%d\n", x,y,z) ;*/
				
                OverlapDegree = 0 ;
                DistSeg = 0 ;
                real_size = 0 ;
                for(n=0; n<count; n+=m_STEPNBR)
                {
                  /* Coordinate In Template */
                  Grid.x = sx+nb_pnt[n].x ;
                  Grid.y = sy+nb_pnt[n].y ;
                  Grid.z = sz+nb_pnt[n].z ;
                  
                  /*printf("3: Gxyz=%d,%d,%d\n", Grid.x,Grid.y,Grid.z) ;*/
                  
                  if( Grid.x<image_size && Grid.y<image_size && Grid.z<z_size && Grid.x>=0 && Grid.y>=0 && Grid.z>=0 ) /* true */
                  {
                    /*printf("4: Gxyz=%d,%d,%d\n", Grid.x,Grid.y,Grid.z) ;*/
					
                    /*real_size ++ ;	Nov 15, 2001 */
                    Crnt.x = DeformFld[Grid.z][Grid.x][Grid.y].x + Grid.x ;
                    Crnt.y = DeformFld[Grid.z][Grid.x][Grid.y].y + Grid.y ;
                    Crnt.z = DeformFld[Grid.z][Grid.x][Grid.y].z + Grid.z ;
					
                    /* shift for every vertex in this set of neighborhood */
                    level = (abs(nb_pnt[n].x)+abs(nb_pnt[n].y)+abs(nb_pnt[n].z))/3.0 ; 
                    /*level = sqrt( nb_pnt[n].x*nb_pnt[n].x + nb_pnt[n].y*nb_pnt[n].y + nb_pnt[n].z*nb_pnt[n].z ) ; /* tried before June 18, 2001 */
                    ShiftByGuassianWeight(Crnt, &Tmp, Search, level, nb_size) ;
					
                    x = (int)(Tmp.x + 0.5) ;
                    y = (int)(Tmp.y + 0.5) ;
                    z = (int)(Tmp.z + 0.5) ;
					
                    /*printf("5: xyz=%d,%d,%d\n", x,y,z) ;*/
					
                    if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 )
                    {
                      CurrentDegree = SimilarityBetweenFeaturesInMdlAndObjImgs( ObjImg, x, y, z, MdlImg, Grid.x, Grid.y, Grid.z ) ;
                      
                      /* March 27, 2003: This is added for considering   */
                      /* (1) binary tissue matching, (2) BG effect.      */    /*good for yng brain*/
                      if(ptParm->YoungBrain==YYES  && MdlImg[Grid.z][Grid.x][Grid.y].Edge==0 && CurrentDegree<0.6 ) 
                        CurrentDegree=0;
                      /*if( MdlImg[Grid.z][Grid.x][Grid.y].Tiss==BG && CurrentDegree>0.6 )
                        {
                        CurrentDegree=0; 
                        real_size -- ; 
                        }*/
                      /* will not count current one. Notable size will be increased one nest*/
                      
                      
                      real_size ++ ;
                      if( MdlImg[Grid.z][Grid.x][Grid.y].Edge>0 ) /* June 6, 2001*/
                      {
                        CurrentDegree *= 1.2 ;
                        real_size += (1.2-1.0) ;
                      }
                    }
                    else
                      CurrentDegree = 0 ;
                    
                    /*if( MdlImg[Grid.z][Grid.x][Grid.y].Edge>0 ) 
                      {
                      CurrentDegree *= 1.2 ;
                      real_size += (1.2-1.0) ;
                      } Nov 15, 2001 */
                    
                    DistSeg += (1-CurrentDegree)/(count/m_STEPNBR);
                    if( DistSeg>MinDist ) break ; /* no need to continue on this selected deformation */
                    OverlapDegree += CurrentDegree ; 
                  }//end of Grid search
                }//end of for(n=0; n<count; n+=STEPNBR)
                if(real_size>0) 
                  OverlapDegree = OverlapDegree/real_size ; 
                
                if( OverlapDegree>MaxDegree )
                {
                  MinDist = DistSeg ;
                  MaxDegree = OverlapDegree ;
                  dfm.x = Search.x ;
                  dfm.y = Search.y ;	    
                  dfm.z = Search.z ;
                }
              }//end of if
            }//end of triple for search
      }//end of if ( Fvector3dmag(forceByFocusedPntInObj[s])==0 || ratio_iteration>ITER_THRD)
      else
      {
        MaxDegree = 10000.0 ;
		
        x = FixedMdlVer[s].x ;
        y = FixedMdlVer[s].y ;
        z = FixedMdlVer[s].z ;
		
        dfm.x = (DeformFld_Last[z][x][y].x-DeformFld[z][x][y].x+forceByFocusedPntInObj[s].x)*(1.0+(1+ratio_iteration))/2. ;  /*5.*/
        dfm.y = (DeformFld_Last[z][x][y].y-DeformFld[z][x][y].y+forceByFocusedPntInObj[s].y)*(1.0+(1+ratio_iteration))/2. ;	    
        dfm.z = (DeformFld_Last[z][x][y].z-DeformFld[z][x][y].z+forceByFocusedPntInObj[s].z)*(1.0+(1+ratio_iteration))/2. ; /* May 2001 */
        /*printf("dfm=(%f,%f,%f)\n", dfm.x, dfm.y, dfm.z) ;*/
		
        /* scale it */
        magDfm = Fvector3dmag(dfm) ;
        if( magDfm>nb_size/2 ) 
        {
          dfm.x = dfm.x/magDfm*(nb_size/2) ;
          dfm.y = dfm.y/magDfm*(nb_size/2) ;
          dfm.z = dfm.z/magDfm*(nb_size/2) ;
        }
      }
      /*printf("\ns=%d  MaxDegree=%f  (%f,%f,%f)\n", s, MaxDegree, dfm.x, dfm.y, dfm.z) ;*/
      
      
      
      if( MaxDegree>ptParm->MatchingDegreeOfMdlOnImgEdge ) /*&& (dfm.x!=0 || dfm.y!=0 || dfm.z!=0) )*/   /* deform it*/
        /* MatchingDegreeOfMdlOnImgEdge=0.1 */
      {
        if(s%100==0)
          printf("%d->   OL(%d)=%f: (%f,%f,%f)\n", SelectVerNum, s, MaxDegree, dfm.x, dfm.y, dfm.z) ;
        /* get the sizes of real subvolume and Gaussian Sigma */
        /*UsedGuassianSigma = sqrt(dfm.x*dfm.x + dfm.y*dfm.y + dfm.z*dfm.z)*0.8 ;
          if( UsedGuassianSigma<1.0 ) UsedGuassianSigma=1.0 ;  
          UsedVNum = pow( 2*((int)(UsedGuassianSigma*1.0))+1, 3.0) ; 
          if( UsedVNum>SubVNum )  UsedVNum = SubVNum ; */
        UsedVNum=count ;
        UsedGuassianSigma = nb_size ;
        if( s%100==0 )
          printf("MaxDegree=%f   Current Sigma =%f  volNum=%d\n", MaxDegree, UsedGuassianSigma, UsedVNum) ;
        
        /* change the status around this model driving voxel */	
        /*FilterSize = UsedGuassianSigma/2/3*2+1 ;  if( FilterSize>3 ) FilterSize=3 ;
          FilterSize = FilterSize*FilterSize*FilterSize ; 
          for(n=0; n<FilterSize; n++) 
          {  
          x = FixedMdlVer[s].x+nb_pnt[n].x ;  
          y = FixedMdlVer[s].y+nb_pnt[n].y ;  
          z = FixedMdlVer[s].z+nb_pnt[n].z ; 
          if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 ) 
          SearchingStatus[z][x][y]=FFAIL ; 
          }*/ 
        
        /* Begin to deform the subvolume at Gaussian way */
        for(n=0; n<UsedVNum; n++)
        {
          StudiedPoint.x = FixedMdlVer[s].x+SubV_pnt[n].x ;
          StudiedPoint.y = FixedMdlVer[s].y+SubV_pnt[n].y ;
          StudiedPoint.z = FixedMdlVer[s].z+SubV_pnt[n].z ;
          
          if( StudiedPoint.x<image_size && StudiedPoint.y<image_size && \
              StudiedPoint.z<z_size && StudiedPoint.x>=0 && StudiedPoint.y>=0 && StudiedPoint.z>=0 )
          {
			
            /* shift for every vertex in this set of neighborhood */
            level = (abs(SubV_pnt[n].x)+abs(SubV_pnt[n].y)+abs(SubV_pnt[n].z))/3.0 ;
            /*level = sqrt( SubV_pnt[n].x*SubV_pnt[n].x + SubV_pnt[n].y*SubV_pnt[n].y + SubV_pnt[n].z*SubV_pnt[n].z ) ; */ /* tried before June 18, 2001 */
            weight = GuassianWeight( level, UsedGuassianSigma /*nb_size*/ ) ;
            /*weight = exp(-level*level/(2.*nb_size*nb_size)) ;*/
			
			
            /* converge to its center */
            nbr_tot.x = 0 ;  nbr_tot.y = 0 ;  nbr_tot.z = 0 ;
            temp_num = 0 ;
            for(i=1;i<27;i++) /* 26 neighbor */
            {
              Grid.x = StudiedPoint.x+nb_pnt[i].x ;
              Grid.y = StudiedPoint.y+nb_pnt[i].y ;
              Grid.z = StudiedPoint.z+nb_pnt[i].z ;
              
              if( Grid.x<image_size && Grid.y<image_size && Grid.z<z_size && Grid.x>=0 && Grid.y>=0 && Grid.z>=0 )
              {
                nbr_tot.x += DeformFld[Grid.z][Grid.x][Grid.y].x;
                nbr_tot.y += DeformFld[Grid.z][Grid.x][Grid.y].y;
                nbr_tot.z += DeformFld[Grid.z][Grid.x][Grid.y].z;
				
                temp_num++ ;
              }
            }
            if(temp_num>0)
            {
              nbr_tot.x /= temp_num ;
              nbr_tot.y /= temp_num ;
              nbr_tot.z /= temp_num ;
            }
            else
              printf("(%d,%d,%d) temp_num=%d (total 8)\n", StudiedPoint.x, StudiedPoint.y, StudiedPoint.z, temp_num) ;
            
            CenterRate = ptParm->smoothFactor ; /*0.05 */
            nbr_tot.x =  (nbr_tot.x - DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].x)*CenterRate ; 
            nbr_tot.y =  (nbr_tot.y - DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].y)*CenterRate ;
            nbr_tot.z =  (nbr_tot.z - DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].z)*CenterRate ;
			
            Delta=0.005*ratio_iteration ; /* June 6, 2001*/
            /*printf("weight=%f (%d)", weight, level[n]) ; getchar() ;*/
            DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].x += (dfm.x*weight + nbr_tot.x)*(ptParm->Deform_RATE+Delta) ;
            DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].y += (dfm.y*weight + nbr_tot.y)*(ptParm->Deform_RATE+Delta) ;  
            DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].z += (dfm.z*weight + nbr_tot.z)*(ptParm->Deform_RATE+Delta) ;  
          }
        }
      }//end of else
    }//end of if( (RealVV<SelectVerNum || Fvector3dmag(forceByFocusedPntInObj[s])!=0) && SearchingStatus[FixedMdlVer[s].z][FixedMdlVer[s].x][FixedMdlVer[s].y]==OOK ) 
  }//end of vv loop
  
  
  Start_Search_Point = Last_searched_point ;
  
  /* get update MdlVer's position from the DeformFld, for estimating global transformation*/
  for(s=0; s<MdlVer_Num; s++)
  {  
    x = FixedMdlVer[s].x ;
    y = FixedMdlVer[s].y ;
    z = FixedMdlVer[s].z ;
	
    MdlVer[s].x = DeformFld[z][x][y].x + x ;
    MdlVer[s].y = DeformFld[z][x][y].y + y ;
    MdlVer[s].z = DeformFld[z][x][y].z + z ;
  }
  
  /*0.3*//*0.3*/
  /*0.4*//*0.4*/
  /*0.6*//*0.4*/
  /*0.5*//*0.5*/   /* probably for EN** et al */
  LocalRatio = 0.25 + 0.65*exp(-(ratio_iteration-1.)*(ratio_iteration-1.)/2./.25/.25) ; /* (0.3,0.3),  directly 0.88 */
  /* deformation modified by global affine-transformation plus local deformation */
  GlobalAffineUpdatePlusLocalDeformation( MdlVer, verModelLast, MdlVer_Num ) ;
  Mat_Print(Transform) ;
  /* update deformation matrix */
  for(k=0;k<z_size;k++)
    for(i=0;i<image_size;i++)
      for(j=0;j<image_size;j++)
      {
        Crnt.x = DeformFld_Last[k][i][j].x + i ;
        Crnt.y = DeformFld_Last[k][i][j].y + j ;
        Crnt.z = DeformFld_Last[k][i][j].z + k ;
		
        globl.x = Transform->data[0][0]*Crnt.x + Transform->data[0][1]*Crnt.y + Transform->data[0][2]*Crnt.z + Transform->data[0][3] -i ;
        globl.y = Transform->data[1][0]*Crnt.x + Transform->data[1][1]*Crnt.y + Transform->data[1][2]*Crnt.z + Transform->data[1][3] -j ;
        globl.z = Transform->data[2][0]*Crnt.x + Transform->data[2][1]*Crnt.y + Transform->data[2][2]*Crnt.z + Transform->data[2][3] -k ;
		
        DeformFld[k][i][j].x = globl.x + (DeformFld[k][i][j].x-globl.x)*LocalRatio/1.2;
        DeformFld[k][i][j].y = globl.y + (DeformFld[k][i][j].y-globl.y)*LocalRatio/1.2;
        DeformFld[k][i][j].z = globl.z + (DeformFld[k][i][j].z-globl.z)*LocalRatio/1.2;
		
        /* boundary constraints */
        if(DeformFld[k][i][j].x+i<0) DeformFld[k][i][j].x=-i ;
        if(DeformFld[k][i][j].y+j<0) DeformFld[k][i][j].y=-j ;
        if(DeformFld[k][i][j].z+k<0) DeformFld[k][i][j].z=-k ;
		
        if(DeformFld[k][i][j].x+i>=(image_size-1)) DeformFld[k][i][j].x=(image_size-1)-i ;
        if(DeformFld[k][i][j].y+j>=(image_size-1)) DeformFld[k][i][j].y=(image_size-1)-j ;
        if(DeformFld[k][i][j].z+k>=(z_size-1))     DeformFld[k][i][j].z=(z_size-1)-k ;
      }
  SmoothDeformationField(DeformFld, image_size, z_size,  MdlImg, ptParm) ;
  if(ptParm->SmoothingTimes>0) 
    SmoothDeformationFieldWithEdgePreserving( FixedMdlVer, MdlVer_Num, DeformFld, MdlImg, image_size, z_size, ratio_iteration, ptParm) ;
  /* focused edge points in the model */
  for(s=0; s<MdlVer_Num; s++)
  {  
    x = FixedMdlVer[s].x ;
    y = FixedMdlVer[s].y ;
    z = FixedMdlVer[s].z ;
	
    MdlVer[s].x = DeformFld[z][x][y].x + x ;
    MdlVer[s].y = DeformFld[z][x][y].y + y ;
    MdlVer[s].z = DeformFld[z][x][y].z + z ;
  }
  
  /* free */
  free(nb_pnt) ;
  free(SubV_pnt) ;	
  UCfree3d(SearchingStatus, z_size, image_size) ;
  
  /* geometric */
  free(verModelLast) ;		
  Fvector3dfree3d(DeformFld_Last, z_size, image_size) ;
}


void HE_ALG_Registration::Select3DEdgePointsInModelTO1D(int *MdlVer_Num, ImgAttribute ***MdlImg, Fvector3d ***DeformFld, int image_size, int z_size)
{
	int   i, j, k, c ;
	int   Geom_DownsUp ;
	unsigned char ***FeaPoints ;
	FILE  *fp;
	
	
	/* To view which points are selected as landmarks. */
	FeaPoints = UCalloc3d(image_size,image_size,z_size);
    
	Geom_DownsUp = MdlThreshold.Geom_DN/1.1 ; /*1.5*/
	
	(*MdlVer_Num) = 0 ;
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				if( MdlImg[k][i][j].Edge!=0 && (MdlImg[k][i][j].Geom>MdlThreshold.Geom_UP || \
					(MdlImg[k][i][j].Geom<MdlThreshold.Geom_DN && MdlImg[k][i][j].Geom>Geom_DownsUp) || \
					MdlImg[k][i][j].VNvlm>MdlThreshold.VNvlm_UP ||\
					MdlImg[k][i][j].CSFBG>MdlThreshold.CSFBG_UP) ) 
					(*MdlVer_Num)+=1 ;
				
	printf("There are %d focused edge points in model image!\n", (*MdlVer_Num));
	
	MdlVer     = Fvector3dalloc1d(*MdlVer_Num);
	FixedMdlVer= Ivector3dalloc1d(*MdlVer_Num);  /* for connection */
	MdlVer_Fea = ImgAttributealloc1d(*MdlVer_Num) ; /* attributes for each selected point */
				
	c = 0 ;
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				if( MdlImg[k][i][j].Edge!=0 && (MdlImg[k][i][j].Geom>MdlThreshold.Geom_UP ||\
					(MdlImg[k][i][j].Geom<MdlThreshold.Geom_DN && MdlImg[k][i][j].Geom>Geom_DownsUp) || \
					MdlImg[k][i][j].VNvlm>MdlThreshold.VNvlm_UP || MdlImg[k][i][j].CSFBG>MdlThreshold.CSFBG_UP) ) 
				{
					/* position */
					MdlVer[c].x = i + DeformFld[k][i][j].x ;
					MdlVer[c].y = j + DeformFld[k][i][j].y ;
					MdlVer[c].z = k + DeformFld[k][i][j].z ;
					
					FixedMdlVer[c].x = i ;
					FixedMdlVer[c].y = j ;
					FixedMdlVer[c].z = k ;
					
					/* attributes  */
					MdlVer_Fea[c].Edge  = MdlImg[k][i][j].Edge;   /* edge */
					MdlVer_Fea[c].Tiss  = MdlImg[k][i][j].Tiss;   /* intensity */
					MdlVer_Fea[c].Geom  = MdlImg[k][i][j].Geom;   /* geometric */
					MdlVer_Fea[c].VNvlm = MdlImg[k][i][j].VNvlm;  /* VN volume */
					MdlVer_Fea[c].CSFBG = MdlImg[k][i][j].CSFBG;  /* CSF/BG volume */
					
					c ++ ;
					
					FeaPoints[k][i][j] = 255 ;
				}
				else
					FeaPoints[k][i][j] = 0 ;
				
	/* saving ... */
	/*
	fp=myopen("MdlImg_FocuedEdges","w"); 
	for(k=0;k<z_size;k++)  
		for(i=0;i<image_size;i++)  
			fwrite(FeaPoints[k][i],1,image_size,fp);  
	fclose(fp);
	*/
	/* free */
	UCfree3d(FeaPoints, z_size, image_size) ;
}


void HE_ALG_Registration::Select3DEdgePointsInObjectTO1D(int *ObjVer_Num, ImgAttribute ***ObjImg, int image_size, int z_size)
{
	int   i, j, k, c ;
	float alpha, beta;
	int   Geom_DownsUp  ;
	unsigned char ***FeaPoints ;
	FILE  *fp;
	
	/* To view which points are selected as landmarks. */
	FeaPoints = UCalloc3d(image_size,image_size,z_size);
	
	alpha = 0.9 ; /* */
	beta  = 0.4;
	
	ObjThreshold.Geom_UP = alpha*255 ;
	ObjThreshold.Geom_DN = beta*255 ;
	Geom_DownsUp = ObjThreshold.Geom_DN/1.1 ; /*1.5*/
	ObjThreshold.VNvlm_UP = 255/4 ;  
	ObjThreshold.CSFBG_UP = 255/4 ;
	
	
	(*ObjVer_Num) = 0 ;
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				if( ObjImg[k][i][j].Edge!=0 &&\
					(ObjImg[k][i][j].Geom>ObjThreshold.Geom_UP ||\
					(ObjImg[k][i][j].Geom<ObjThreshold.Geom_DN && ObjImg[k][i][j].Geom>Geom_DownsUp) ||\
					ObjImg[k][i][j].VNvlm>ObjThreshold.VNvlm_UP || ObjImg[k][i][j].CSFBG>ObjThreshold.CSFBG_UP) ) 
					(*ObjVer_Num)+=1 ;
	printf("There are %d focued edge points in the object image!\n", *ObjVer_Num);
				
	ObjVer     = Ivector3dalloc1d(*ObjVer_Num);
	ObjVer_Fea = ImgAttributealloc1d(*ObjVer_Num) ; /* attributes for each selected point */
				
	c = 0 ;
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				if( ObjImg[k][i][j].Edge!=0 && (ObjImg[k][i][j].Geom>ObjThreshold.Geom_UP || (ObjImg[k][i][j].Geom<ObjThreshold.Geom_DN && ObjImg[k][i][j].Geom>Geom_DownsUp) || ObjImg[k][i][j].VNvlm>ObjThreshold.VNvlm_UP || ObjImg[k][i][j].CSFBG>ObjThreshold.CSFBG_UP) ) 
				{
					/* position */
					ObjVer[c].x = i ;
					ObjVer[c].y = j ;
					ObjVer[c].z = k ;
					
					/* attributes  */
					ObjVer_Fea[c].Edge  = ObjImg[k][i][j].Edge;   /* edge */
					ObjVer_Fea[c].Tiss  = ObjImg[k][i][j].Tiss;   /* intensity */
					ObjVer_Fea[c].Geom  = ObjImg[k][i][j].Geom;   /* geometric */
					ObjVer_Fea[c].VNvlm = ObjImg[k][i][j].VNvlm;  /* VN volume */
					ObjVer_Fea[c].CSFBG = ObjImg[k][i][j].CSFBG;  /* CSF/BG volume */
					
					c ++ ;
					FeaPoints[k][i][j] = 255 ;
				}
				else
					FeaPoints[k][i][j] = 0 ;
	/* saving ... */
	/*
	fp=myopen("ObjImg_FocuedEdges","w"); 
	for(k=0;k<z_size;k++)  
		for(i=0;i<image_size;i++)  
			fwrite(FeaPoints[k][i],1,image_size,fp);  
	fclose(fp);
	*/
	/* free */
	UCfree3d(FeaPoints, z_size, image_size) ;
}

void HE_ALG_Registration::SearchTheNearestVertexForEachLandmark_March2003(Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, Fvector3d *MdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Ivector3d *FixedMdlVer, ImgAttribute ***MdlImg, Fvector3d ***DeformFld, int image_size, int z_size, int max, HAMMER_Param *ptParm)
{
	int        i, j, k, l ;
	int        ***VerticesImg, x, y, z, r, t, px, py, pz, vx, vy, vz, s ;
	int        TotalMatchingPoints, TotalMdlPntMatched, TotalSamples ;
	float      degree, StepDesign, Pointer ;
	
	/* for subvolume matching*/
	float level, CurrentDegree, OverlapDegree, MaxDegree ;
	Fvector3d Crnt, Tmp, Search, SubjNb, dfm;
	int   sx,sy,sz, real_size, SmplStep, incre, dfm_s ;
	
	/* subvolume */
	Ivector3d  *nb_pnt, Grid;
	int        nb_size, n,count ;
	
	nb_size = max*2+1; /*nb_size should be odd number */ 
	nb_pnt= Ivector3dalloc1d(nb_size*nb_size*nb_size) ;
	calculate_hood_byIncreasingRadius(nb_pnt, nb_size, &count, 1., 1., 1.) ; 
	SmplStep = count/20 ;  if(SmplStep<1) SmplStep=1 ;
	printf("   nbr num:%d with rad %d <- sampling step=%d\n", count,nb_size, SmplStep) ;
	
	
	/* For saving searching time */
	VerticesImg = Ialloc3d(image_size,image_size,z_size);
	if (!VerticesImg) printf("   memeoy application in VerticesImg\n") ;
	/* transfering surface's vertices */
	for(k=0; k<z_size; k++)
		for(i=0; i<image_size; i++)
			for(j=0; j<image_size; j++)
				VerticesImg[k][i][j] = -1 ;
	for( i=0; i<MdlVer_Num; i++)
	{
		x = (int)(MdlVer[i].x) ;
		y = (int)(MdlVer[i].y) ;
		z = (int)(MdlVer[i].z) ;
		
		if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 )
			VerticesImg[z][x][y] = i ;
	}
	printf("   image setting\n") ;
	
	/* reset */
	for( i=0; i<MdlVer_Num; i++)
	{
		forceByFocusedPntInObj[i].x = 0 ;
		forceByFocusedPntInObj[i].y = 0 ;
		forceByFocusedPntInObj[i].z = 0 ;
		multiple[i] = 0 ;
	}
	
	
	TotalSamples = MdlVer_Num/2;
	if(TotalSamples>ObjVer_Num) TotalSamples = ObjVer_Num ;
	if(TotalSamples>20000)      TotalSamples = 20000 ;
	StepDesign = (float)ObjVer_Num/(float)TotalSamples ; printf("   StepDesign=%f\n", StepDesign) ;
	incre = 2*max/6 ; if(incre<1) incre=1 ;              printf("   incre=%d\n", incre);
	TotalMatchingPoints = 0;
	for(Pointer=0, l=0; l<ObjVer_Num; Pointer += StepDesign, l=(int)Pointer)
	{
		px = ObjVer[l].x ;
		py = ObjVer[l].y ;
		pz = ObjVer[l].z ;	  
		
		dfm.x = 0 ; dfm.y = 0 ; dfm.z = 0 ;
		MaxDegree = 0 ;
		for(SubjNb.x=-max; SubjNb.x<=max; SubjNb.x+=incre)
			for(SubjNb.y=-max; SubjNb.y<=max; SubjNb.y+=incre)
				for(SubjNb.z=-max; SubjNb.z<=max; SubjNb.z+=incre)
					/*for(t=0; t<pixelNumIn_MyHood && Status==FFAIL; t++)*/
				{
					vx = px + SubjNb.x ; /*+ MyHood[t].x ;*/
					vy = py + SubjNb.y ; /*+ MyHood[t].y ;*/
					vz = pz + SubjNb.z ; /*+ MyHood[t].z ;*/
					
					if( vx<image_size && vy<image_size && vz<z_size && vx>=0 && vy>=0 && vz>=0)
					{
						s = VerticesImg[vz][vx][vy] ;
						
						if( s>=0 && px<image_size && py<image_size && pz<z_size && px>=0 && py>=0 && pz>=0)
						{
							degree = SimilarityBetweenFocusedPointsInMdlObjImgs(ObjVer_Fea,l, MdlVer_Fea,s) ;
							if( degree>SMR_THR)
							{
								/* get subvolume similarity */
								/*****************************************/
								sx = FixedMdlVer[s].x ;
								sy = FixedMdlVer[s].y ;
								sz = FixedMdlVer[s].z ;
								
								Search.x = -SubjNb.x ;  /*+ MyHood[t].x ;*/
								Search.y = -SubjNb.y ;  /*+ MyHood[t].y ;*/
								Search.z = -SubjNb.z ;  /*+ MyHood[t].z ;*/			
								
								OverlapDegree = 0 ;
								real_size = 0 ;
								for(n=0; n<count; n+=SmplStep)
								{
									/* Coordinate In Template */
									Grid.x = sx+nb_pnt[n].x ;
									Grid.y = sy+nb_pnt[n].y ;
									Grid.z = sz+nb_pnt[n].z ;
									
									if( Grid.x<image_size &&\
										Grid.y<image_size && Grid.z<z_size && Grid.x>=0 && Grid.y>=0 && Grid.z>=0 ) /* true */
									{
										Crnt.x = DeformFld[Grid.z][Grid.x][Grid.y].x + Grid.x ;
										Crnt.y = DeformFld[Grid.z][Grid.x][Grid.y].y + Grid.y ;
										Crnt.z = DeformFld[Grid.z][Grid.x][Grid.y].z + Grid.z ;
										
										
										/* shift for every vertex in this set of neighborhood */
										level = (abs(nb_pnt[n].x)+abs(nb_pnt[n].y)+abs(nb_pnt[n].z))/3.0 ; 
										ShiftByGuassianWeight(Crnt, &Tmp, Search, level, nb_size) ;
										
										x = (int)(Tmp.x + 0.5) ;
										y = (int)(Tmp.y + 0.5) ;
										z = (int)(Tmp.z + 0.5) ;
										
										if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 )
										{
											CurrentDegree = SimilarityBetweenFeaturesInMdlAndObjImgs( ObjImg, x, y, z, MdlImg, Grid.x, Grid.y, Grid.z ) ;
											
											/* March 27, 2003: This is added for considering   */
											/* (1) binary tissue matching, (2) BG effect.      */  /*good for yng brain*/
											if(ptParm->YoungBrain==YYES &&  MdlImg[Grid.z][Grid.x][Grid.y].Edge==0 && CurrentDegree<0.6 ) 
												CurrentDegree=0;
												/*if(  MdlImg[Grid.z][Grid.x][Grid.y].Tiss==BG && CurrentDegree>0.6 )
												{
												CurrentDegree=0; 
												real_size -- ; 
										}*/
											/* will not count current one. Notable size will be increased one nest*/
											
											real_size ++ ;
											if( MdlImg[Grid.z][Grid.x][Grid.y].Edge>0 )
											{
												CurrentDegree *= 1.2 ;
												real_size += (1.2-1.0) ;
											}
										}
										else
											CurrentDegree = 0 ;
										
										OverlapDegree += CurrentDegree ; 
									}
								}
								if(real_size>0) 
									OverlapDegree = OverlapDegree/real_size ;
								/*****************************************/
                                printf("s=%d (%fx%fx%f)-> OverlapDegree = %f\n", s,Search.x, Search.y, Search.z, OverlapDegree);
								if( OverlapDegree>MaxDegree )
								{
									MaxDegree = OverlapDegree ;
									dfm.x = Search.x ;
									dfm.y = Search.y ;	    
									dfm.z = Search.z ;
									dfm_s = s ;
								}
							}
						}
					}
				}
				
				/* get a maximal one */
        if( MaxDegree>ptParm->MatchingDegreeOfMdlOnImgEdge )
				{
					TotalMatchingPoints ++;
					forceByFocusedPntInObj[dfm_s].x += dfm.x ;
					forceByFocusedPntInObj[dfm_s].y += dfm.y ;
					forceByFocusedPntInObj[dfm_s].z += dfm.z ;
					multiple[dfm_s] += 1 ;
				}
    }
	printf("   TotalMatchingPoints=%d (%f)\n", TotalMatchingPoints, (float)TotalMatchingPoints/(float)ObjVer_Num*100.0) ;
	
	
	TotalMdlPntMatched = 0 ;
	for( i=0; i<MdlVer_Num; i++)
		if( multiple[i]>0 )
		{
			/*printf("i=%d num=%d\n", i,multiple[i]) ;*/
			forceByFocusedPntInObj[i].x /= multiple[i] ;
			forceByFocusedPntInObj[i].y /= multiple[i] ;
			forceByFocusedPntInObj[i].z /= multiple[i] ;
			TotalMdlPntMatched ++ ;
		}
		printf("   TotalMdlPntMatched=%d (%f)\n", TotalMdlPntMatched, (float)TotalMdlPntMatched/(float)MdlVer_Num*100.0) ;
		
		/* free */
		Ifree3d(VerticesImg, z_size, image_size) ;
}

void HE_ALG_Registration::GlobalAffineUpdatePlusLocalDeformation(Fvector3d *verObject, Fvector3d *verModel, int MdlVer_Num)
{
	int i, j, k ;
	Matrix *ModelMatrix, *ObjectMatrix, *FittingMatrix, *TmpM1, *TmpM2, *InversedMtrx/*, *Transform*/ ;	
	
	/* create  metrices*/
	CreateMatrix(&ModelMatrix,  4, MdlVer_Num);
	CreateMatrix(&ObjectMatrix, 4, MdlVer_Num);
	CreateMatrix(&FittingMatrix,4, MdlVer_Num);
	CreateMatrix(&TmpM1,        4, 4);
	CreateMatrix(&TmpM2,        4, 4);
	CreateMatrix(&InversedMtrx, 4, 4);
	/*   CreateMatrix(&Transform,    4, 4);*/
	
	
	/* get ModelMatrix->data[4][MdlVer_Num] */
	for(j=0; j<MdlVer_Num; j++)
	{
		ModelMatrix->data[0][j] = verModel[j].x ;
		ModelMatrix->data[1][j] = verModel[j].y ;
		ModelMatrix->data[2][j] = verModel[j].z ;
		ModelMatrix->data[3][j] = 1 ;
	}
	
	/* get ObjectMatrix->data[4][MdlVer_Num] */
	for(j=0; j<MdlVer_Num; j++)
	{
		ObjectMatrix->data[0][j] = verObject[j].x ;
		ObjectMatrix->data[1][j] = verObject[j].y ;
		ObjectMatrix->data[2][j] = verObject[j].z ;
		ObjectMatrix->data[3][j] = 1 ;
	}
	
	
	/*get matrix 4X4 TmpM1*/
	for(i=0; i<4; i++)
		for(j=0; j<4; j++)
		{
			TmpM1->data[i][j] = 0 ;
			
			for(k=0; k<MdlVer_Num; k++)
				TmpM1->data[i][j] += (ModelMatrix->data[i][k]*ModelMatrix->data[j][k]) ;
		}
		
		
	/*get matrix 4X4 TmpM2 */
	for(i=0; i<4; i++)
		for(j=0; j<4; j++)
		{
			TmpM2->data[i][j] = 0 ;
			
			for(k=0; k<MdlVer_Num; k++)
				TmpM2->data[i][j] += (ObjectMatrix->data[i][k]*ModelMatrix->data[j][k]) ;
		}
		
		
		Mat_Inverse( TmpM1, InversedMtrx ) ;
		
		/* get affine transformation */
		Mat_A_equal_BxC(Transform, TmpM2, InversedMtrx) ;             /*A=BxC*/
		
		
		/* use model to best fit the object */
		Mat_A_equal_BxC(FittingMatrix, Transform, ModelMatrix) ;    
		
		
		/* back to model variables */
		for(j=0; j<MdlVer_Num; j++)
		{
			verModel[j].x = FittingMatrix->data[0][j] ;
			verModel[j].y = FittingMatrix->data[1][j] ;
			verModel[j].z = FittingMatrix->data[2][j] ;
		}
		
		
		/* free */ 
		FreeMatrix(ModelMatrix) ;
		FreeMatrix(ObjectMatrix) ;
		FreeMatrix(FittingMatrix) ;
		FreeMatrix(TmpM1) ;
		FreeMatrix(TmpM2) ;
		FreeMatrix(InversedMtrx) ;
		/*   FreeMatrix(Transform) ;*/
}

void HE_ALG_Registration::ShiftByGuassianWeight(Fvector3d In, Fvector3d *Tmp, Fvector3d Search, float level, float sigma)
{
	float weight ;
	int   s, l ;
	
	/* calculate for one time */
	if(regist_CompGuassianOnce == OOK )
    {
		regist_CompGuassianOnce = FFAIL ;
		
		for(l=0; l<MAX_LEVEL; l++)
			GuassianAtLevelSigma[0][l] = 0 ;
		
		for(s=1; s<MAX_SIGMA; s++)
			for(l=0; l<MAX_LEVEL; l++)
				GuassianAtLevelSigma[s][l] = exp(-l*l/(2.0*s*s)) ;
    }
	
	if( sigma<MAX_SIGMA && level<MAX_LEVEL )
		weight = GuassianAtLevelSigma[(int)sigma][(int)level] ;
	else 
    {
		weight = exp(-level*level/(2.0*sigma*sigma)) ;
		printf("\n\n\n\nWatch here!!!\n\n\n") ;
    }
	(*Tmp).x = In.x + Search.x*weight ;
	(*Tmp).y = In.y + Search.y*weight ;
	(*Tmp).z = In.z + Search.z*weight ;
}	


float HE_ALG_Registration::GuassianWeight(float level, float sigma)
{
	float weight ;
	
	if( sigma<MAX_SIGMA && level<MAX_LEVEL )
		weight = GuassianAtLevelSigma[(int)sigma][(int)level] ;
	else 
    {
		weight = exp(-level*level/(2.0*sigma*sigma)) ;
		printf("\n\n\n\nWatch here!!!\n\n\n") ;
    }
	
	return(weight) ;
}


void HE_ALG_Registration::DoMethod()
{
  int l;
  float Resolution;
  bool CoarsestLevel; 
  
  for(l=0;l<PYRAMID_LEVEL;l++)
  {
    printf("\n#####################################################################\n");
    printf("##################Processing %d Level #############################\n", l+1);
    printf("\n#####################################################################\n");
    
    p_Running_Parameter->XYZres = (float)(1<<(PYRAMID_LEVEL-l-1));
    p_Running_Parameter->Current_Level = l;
    if(l==0)
      p_Running_Parameter->OpenDeformationFieldFromLastScale = false;
    else
      p_Running_Parameter->OpenDeformationFieldFromLastScale = true;
    HAMMER_CORE(p_Running_Parameter);
  }
}
void HE_ALG_Registration::HAMMER_CORE(HAMMER_Param *ptParm)
{
	unsigned char ***Img;
	ImgAttribute  ***MdlImg ;
	ImgAttribute  ***ObjImg ;
	unsigned char ***ObjOriginalImg ;
	Fvector3d     ***DeformFld ;
	float         total;
	int           i,j,k,c,num,resolution;
	FILE          *fp;
	char          filename[180] ;
	int           scale ;
	int           s, sx, sy, sz;
    int Img_XY;
    int TempVNvlm_DN;
    int   hierarchicalSmth;  /* used for soft correspondence*/

    Img_XY = ptParm->Img_XY;
    
	/***** Model image, segmented *****/
	/*Img_XY = 256 ;*/
#ifdef HAMMER_WIN32
	fp=myopen(ptParm->TemplateFileName, "rb");
#else
	fp=myopen(ptParm->TemplateFileName, "r");
#endif
	fseek(fp,0,SEEK_END);
	Img_Z=ftell(fp)/(Img_XY*Img_XY);
	rewind(fp);
	
	Img = UCalloc3d(Img_XY,Img_XY,Img_Z);
	
	for(k=0;k<Img_Z;k++)
		for(i=0;i<Img_XY;i++)
			fread(Img[k][i],1,Img_XY,fp);
	fclose(fp);
	printf("\n\n^^^^ Segmented modle image input!\n") ;
	
	image_size = Img_XY/ptParm->XYZres ;
	z_size = Img_Z/ptParm->XYZres ;
	printf("Im_XY=%d\n Img_Z=%d\n", Img_XY, Img_Z ) ;
	printf("image_size=%d\n z_size=%d\n", image_size, z_size) ;
	
	MdlImg    = ImgAttributealloc3d(image_size,image_size,z_size); 
	DeformFld = Fvector3dalloc3d(image_size,image_size,z_size);
	
	for(k=0; k<z_size; k++)
		for(i=0; i<image_size; i++)
			for(j=0; j<image_size; j++)
			{
				MdlImg[k][i][j].Tiss=Img[(int)(k*ptParm->XYZres)][(int)(i*ptParm->XYZres)][(int)(j*ptParm->XYZres)] ;
				DeformFld[k][i][j].x = 0 ;
				DeformFld[k][i][j].y = 0 ;
				DeformFld[k][i][j].z = 0 ;
			}
	UCfree3d(Img, Img_Z, Img_XY) ;
				
	/* get its edge map, geometric features */
	Get_WMedge_GmVnEdge_FromSegmentedImg(MdlImg) ;
	scale = 7*(1./ptParm->XYZres) ;
	if(scale<3) 
		scale=3;
	printf("scale=%d\n", scale) ;
	Compute_GeometricFeatures(MdlImg, scale, 1., 1., 1.5) ;

    if(ptParm->OutputTemporayResults == true)
    {
      sprintf(filename, "%sMdlImg", ptParm->OutputDir);
      WriteImgAttribute(filename, MdlImg, image_size, z_size) ;
	}
    
	/* Select edge points in the model image to be focused */
	MdlThreshold.Geom_UP = 0.9*255 ;
	MdlThreshold.Geom_DN = 0.4*255 ;
	MdlThreshold.VNvlm_UP = 255/12 ;
	MdlThreshold.CSFBG_UP = 255/4 ;
    MdlThreshold.VNvlm_DN = 250;
    
	Select3DEdgePointsInModelTO1D( &MdlVer_Num, MdlImg, DeformFld, image_size, z_size) ; /* get  MdlVer, FixedMdlVer, MdlVer_Fea*/
				
				
				
	/***** Object image, segmented  *****/
	/*Img_XY = 256 ;	 */
#ifdef HAMMER_WIN32
	fp=myopen(ptParm->SubjectFileName,"rb");
#else
	fp=myopen(ptParm->SubjectFileName,"r");
#endif

	fseek(fp,0,SEEK_END);
	Img_Z=ftell(fp)/(Img_XY*Img_XY);
	rewind(fp);
				
	Img = UCalloc3d(Img_XY,Img_XY,Img_Z);
		
	for(k=0;k<Img_Z;k++)
		for(i=0;i<Img_XY;i++)
			fread(Img[k][i],1,Img_XY,fp);
	fclose(fp);
	printf("\n\n^^^^ Segmented object image input!\n") ;
	
	
	ObjImg = ImgAttributealloc3d(image_size,image_size,z_size); 
	
	for(k=0; k<z_size; k++)
	{
      if(k<Img_Z/ptParm->XYZres) 
        for(i=0; i<image_size; i++)
          for(j=0; j<image_size; j++)
            ObjImg[k][i][j].Tiss=Img[(int)(k*ptParm->XYZres)][(int)(i*ptParm->XYZres)][(int)(j*ptParm->XYZres)] ;
      else
        for(i=0; i<image_size; i++)
          for(j=0; j<image_size; j++)
            ObjImg[k][i][j].Tiss=0;
	}
	UCfree3d(Img, Img_Z, Img_XY) ;
	
	/* get its edge map, geometric features */
	Get_WMedge_GmVnEdge_FromSegmentedImg(ObjImg) ;
	scale = 7*(1./ptParm->XYZres) ; if(scale<3) scale=3; printf("scale=%d\n", scale) ;
	Compute_GeometricFeatures(ObjImg, scale, 1., 1., 1.5) ;

    if(ptParm->OutputTemporayResults == true)
    {
      sprintf(filename, "%sObjImg", ptParm->OutputDir);
      WriteImgAttribute(filename, ObjImg, image_size, z_size) ;
	}
    
	/* Select edge points in the object image to be used as landmarks */
	Select3DEdgePointsInObjectTO1D(&ObjVer_Num, ObjImg, image_size, z_size) ; /* got ObjVer, ObjVer_Fea*/
	forceByFocusedPntInObj = Fvector3dalloc1d(MdlVer_Num); 
	multiple         = Falloc1d(MdlVer_Num); 
	MyHoodSize       = ptParm->search_resolution[ptParm->Current_Level]/2*2+12+1;  /*20+1 ;*/
	MyHood           = Ivector3dalloc1d(MyHoodSize*MyHoodSize*MyHoodSize) ;
	calculate_hood_byIncreasingRadius(MyHood, MyHoodSize, &pixelNumIn_MyHood, 1., 1., 1.) ;
	
	
	/***** Check here whether to input original Object image for warping it *****/
	if( ptParm->InputOriginalObjImg == true )
	{
		/*Img_XY = 256 ;  */
#ifdef HAMMER_WIN32
		fp=myopen(ptParm->ObjOriginalImgFile,"rb");
#else
		fp=myopen(ptParm->ObjOriginalImgFile,"r");
#endif
		fseek(fp,0,SEEK_END);
		Img_Z=ftell(fp)/(Img_XY*Img_XY);
		rewind(fp);
		Img = UCalloc3d(Img_XY,Img_XY,Img_Z);
		for(k=0;k<Img_Z;k++)
			for(i=0;i<Img_XY;i++)
				fread(Img[k][i],1,Img_XY,fp);
		fclose(fp);
		printf("\n\n^^^^  Original object image input!\n") ;
		/*image_size = Img_XY/XYZres ; z_size = Img_Z/XYZres ; */
		
		ObjOriginalImg = UCalloc3d(image_size,image_size,z_size); 
		
		for(k=0; k<z_size; k++)
		{
			if(k<Img_Z/ptParm->XYZres) 
			{
				for(i=0; i<image_size; i++)
					for(j=0; j<image_size; j++)
						ObjOriginalImg[k][i][j]=Img[(int)(k*ptParm->XYZres)][(int)(i*ptParm->XYZres)][(int)(j*ptParm->XYZres)] ;
			}
			else
			{
				for(i=0; i<image_size; i++)
					for(j=0; j<image_size; j++)
						ObjOriginalImg[k][i][j]=0;
			}
		}
		UCfree3d(Img, Img_Z, Img_XY) ;
	}
	
	
	if( ptParm->OpenDeformationFieldFromLastScale == true )     
	{ 
		printf("Opening deformation field from last resolution...\n");
		sprintf(filename, "%sDeformationField.float.img", ptParm->OutputDir);
		OpenDeformationField(filename, DeformFld, image_size, z_size, ptParm) ;    
		SaveCurrentWarpingResultOnSegmentedObj( ObjImg, DeformFld, image_size, z_size, (int)ptParm->XYZres, 999 , ptParm) ;
		
		if( ptParm->InputOriginalObjImg == true )
          SaveCurrentWarpingResultOnOriginalObjImg( ObjOriginalImg, DeformFld, image_size, z_size, (int)ptParm->XYZres, 999, ptParm ) ;
		
		/* update the initial deformations in MdlVer; Added on Oct 23, 2002  */
		/* Theoretically, we need to update MdlVer by initial input. But it is removed, for robustness issues */
		if(ptParm->InitialUpdate == true)
		{
			printf("Update VerMdl by the result from the last resolution.") ;
			for(s=0; s<MdlVer_Num; s++)
			{
				sx = FixedMdlVer[s].x ;
				sy = FixedMdlVer[s].y ; 
				sz = FixedMdlVer[s].z ; 
				
				MdlVer[s].x = DeformFld[sz][sx][sy].x + sx ; 
				MdlVer[s].y = DeformFld[sz][sx][sy].y + sy ; 
				MdlVer[s].z = DeformFld[sz][sx][sy].z + sz ; 
			}
		}
		else
			printf("No initial update for VerMdl!\n") ;
		
	}
	
	/* global transformation matrix */
	CreateMatrix(&Transform,    4, 4);
	
	/* deform */
    Start_Search_Point = 0;  //for the purpose of bit matching
	ratio_iteration=0;
	for(i=0;i<ptParm->iter;i++)
	{
		if(ratio_iteration>0.5) /*0.5*/ 
		{
			printf("focus change!\n") ;
			/* focuse on more edge points */
			free(MdlVer) ;
			free(FixedMdlVer) ;
			free(MdlVer_Fea) ;
			free(forceByFocusedPntInObj) ;
			free(multiple) ;
			
			MdlThreshold.Geom_UP = 0.9*(1-ratio_iteration)*255 ;
			MdlThreshold.Geom_DN = 0.4*(2.*ratio_iteration)*255 ;
			MdlThreshold.VNvlm_UP = 255/4 ;
			MdlThreshold.CSFBG_UP = 255/4 ;
            TempVNvlm_DN = 250+(255-250)*ratio_iteration*1.1 ; /* 127: ~65% added on Dec 2006 */
            if(TempVNvlm_DN>255)
              MdlThreshold.VNvlm_DN = 255 ;
            else
              MdlThreshold.VNvlm_DN = TempVNvlm_DN ;

			Select3DEdgePointsInModelTO1D( &MdlVer_Num, MdlImg, DeformFld, image_size, z_size) ; /* get  MdlVer, FixedMdlVer, MdlVer_Fea*/
			
			forceByFocusedPntInObj = Fvector3dalloc1d(MdlVer_Num); 
			multiple               = Falloc1d(MdlVer_Num); 
		}
		
		ratio_iteration = (float)i/(float)(ptParm->iter) ;
		resolution = ptParm->search_resolution[ptParm->Current_Level]*exp(-ratio_iteration*ratio_iteration/2./0.36) ;
        if(resolution<1) resolution=1 ;
		printf("\n\n\n****************i=%d:   resolution=%d  ratio_iteration=%f************\n", i, resolution, ratio_iteration) ;
		SMR_THR = ptParm->PointSimilarity*(1-ratio_iteration)+0.001 ; /* 0.8 */ 
		printf("SMR_THR=%f\n", SMR_THR) ;
       
#ifdef HAMMER_SHEN        
		AffineDeform3D(MdlVer, FixedMdlVer, MdlVer_Num, MdlVer_Fea, DeformFld, MdlImg, \
			ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg, \
                       image_size, z_size, resolution, ptParm) ;
#else
		if(ptParm->UsingTPSRegularization == true && i%5==0)
		{
			HierarchicalDeform3D_TPS_Regularization(MdlVer, FixedMdlVer, MdlVer_Num, MdlVer_Fea, DeformFld, MdlImg, \
			ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg, image_size, z_size, resolution, ptParm) ;
		}
		else
		{
			HierarchicalDeform3D(MdlVer, FixedMdlVer, MdlVer_Num, MdlVer_Fea, DeformFld, MdlImg, \
				ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg, image_size, z_size, resolution, ptParm) ;
		}
#endif
        if(ptParm->Soft_Correspondence == true)
        {
          hierarchicalSmth = (1 - ratio_iteration/2)*ptParm->XYZres*ptParm->AdditionalSmth + 0.5 ;
          printf("level=%f:  iter=%d  hierarchicalSmth=%d\n",ptParm->XYZres, i, hierarchicalSmth) ;
          if( hierarchicalSmth>0 )
          {
            for(num=0; num<hierarchicalSmth; num++)
              SmoothDeformationField(DeformFld, image_size, z_size,  MdlImg, ptParm) ;
          }
        }
        

		/* save temporary results */
		if(ptParm->OutputTemporayResults == true || i==ptParm->iter-1)
		{
			SaveCurrentWarpingResultOnSegmentedObj( ObjImg, DeformFld, image_size, z_size, (int)ptParm->XYZres, i, ptParm) ;
			if( ptParm->InputOriginalObjImg == true )
              SaveCurrentWarpingResultOnOriginalObjImg( ObjOriginalImg, DeformFld, image_size, z_size, (int)ptParm->XYZres, i, ptParm) ;
        }
		/*EvaluationOfRegistration( MdlImg, ObjImg, DeformFld, image_size, z_size, (int)XYZres, i )  ;*/
		/* June 28, 2001: for movie */
		/*sprintf(filename, "DeformationField.float.img%d.%d", (int)XYZres, i); 
		if( XYZres>1.0 ) WriteDeformationField(filename, DeformFld, image_size, z_size) ;*/
	}
	
	/* smooth */
	if(ptParm->UsingTPSRegularization == false)
		SmoothDeformationField(DeformFld, image_size, z_size, MdlImg, ptParm) ;
	
	if(ptParm->XYZres>=1.0 )
	{
		sprintf(filename, "%sDeformationField.float.img", ptParm->OutputDir);
		WriteDeformationField(filename, DeformFld, image_size, z_size) ;
	}
	printf("Deformation step on scale %d has been finished!\n", (int)ptParm->XYZres) ;
}


float HE_ALG_Registration::SubVolumnMatching(ImgAttribute ***MdlImg, ImgAttribute ***ObjImg, Ivector3d Template_Driving_Point, Fvector3d Candidate, Ivector3d *SubVolumn_Searching_Neighbor, int Search_Neighbor_Size, Fvector3d ***DeformFld, float *Min_Dist, SubVolumnParm *ptSubVolumn_Parm)
{
	int x, y, z;
	int n;
	int real_size;
	float OverlapDegree, CurrentDegree, DistSeg, Distance;
	Ivector3d Grid;
	Fvector3d Crnt, Tmp;
	float Overall_Count;

	Overall_Count = Search_Neighbor_Size/ptSubVolumn_Parm->Step_of_NBR;
	OverlapDegree = 0 ;
	DistSeg = 0 ;
	real_size = 0 ;
	for(n=0; n<Search_Neighbor_Size; n+=ptSubVolumn_Parm->Step_of_NBR)
	{
		/* Coordinate In Template */
		Grid.x = Template_Driving_Point.x + SubVolumn_Searching_Neighbor[n].x;
		Grid.y = Template_Driving_Point.y + SubVolumn_Searching_Neighbor[n].y;
		Grid.z = Template_Driving_Point.z + SubVolumn_Searching_Neighbor[n].z;
			
		if(Grid.x<ptSubVolumn_Parm->Image_X_Size && Grid.y<ptSubVolumn_Parm->Image_Y_Size && Grid.z<ptSubVolumn_Parm->Image_Z_Size && Grid.x>=0 && Grid.y>=0 && Grid.z>=0 ) /* true */
		{			
			Crnt.x = DeformFld[Grid.z][Grid.x][Grid.y].x + Grid.x ;
			Crnt.y = DeformFld[Grid.z][Grid.x][Grid.y].y + Grid.y ;
			Crnt.z = DeformFld[Grid.z][Grid.x][Grid.y].z + Grid.z ;
			
			/* shift for every vertex in this set of neighborhood */
			Distance = (abs(SubVolumn_Searching_Neighbor[n].x)+abs(SubVolumn_Searching_Neighbor[n].y)+abs(SubVolumn_Searching_Neighbor[n].z))/3.0 ; 
			
			ShiftByGuassianWeight(Crnt, &Tmp, Candidate, Distance, ptSubVolumn_Parm->Deform_Diffusion_Weight) ;
			
			x = (int)(Tmp.x + 0.5) ;
			y = (int)(Tmp.y + 0.5) ;
			z = (int)(Tmp.z + 0.5) ;
									
			if( x<ptSubVolumn_Parm->Image_X_Size && y<ptSubVolumn_Parm->Image_Y_Size && z<ptSubVolumn_Parm->Image_Z_Size && x>=0 && y>=0 && z>=0 )
			{
				CurrentDegree = SimilarityBetweenFeaturesInMdlAndObjImgs( ObjImg, x, y, z, MdlImg, Grid.x, Grid.y, Grid.z ) ;
				
				/* March 27, 2003: This is added for considering   */
				/* (1) binary tissue matching, (2) BG effect.      */    /*good for yng brain*/
				if( ptSubVolumn_Parm->IsYoungBrain==true  && MdlImg[Grid.z][Grid.x][Grid.y].Edge==0 && CurrentDegree<0.6 ) 
					CurrentDegree=0;				
				real_size += 1.0;
				if( MdlImg[Grid.z][Grid.x][Grid.y].Edge>0 ) /* June 6, 2001*/
				{
					CurrentDegree *= 1.2 ;
					real_size += (1.2-1.0) ;
				}
			}
			else
				CurrentDegree = 0 ;			
			
			DistSeg += (1-CurrentDegree)/Overall_Count;
			if( DistSeg>ptSubVolumn_Parm->MinDist) 
				break ; /* no need to continue on this selected deformation */
			OverlapDegree += CurrentDegree ; 
		}//end of Grid search
	}//end of for(n=0; n<Search_Neighbor_Size; n+=ptSubVolumn_Parm->Step_of_NBR)
	if(real_size>0) 
		OverlapDegree = OverlapDegree/real_size ; 
	else
		OverlapDegree = 0;
	*Min_Dist = DistSeg;
	return OverlapDegree;
}


void HE_ALG_Registration::CorrespondenceDetection(ImgAttribute ***MdlImg, ImgAttribute ***ObjImg, ImgAttribute *MdlVer_Fea, ImgAttribute *ObjVer_Fea, Fvector3d ***DeformFld, Ivector3d Template_Driving_Point, int Driving_Point_Index, Fvector3d *Point_Deformation, Ivector3d *Search_Range, int Search_Neighbor_Size, SubVolumnParm *ptSubVolumn_Parm)
{
	int x,y,z;
	int sz, sx, sy;
	Ivector3d Search;
	int Radius, Incre;
	Fvector3d TentativeWarp;
	float Subvolumn_Matching_Degree, SubVolum_Min_Dist;

	Radius = ptSubVolumn_Parm->Search_Radius;
	Incre = ptSubVolumn_Parm->Search_Step;
	sx = Template_Driving_Point.x;
	sy = Template_Driving_Point.y;
	sz = Template_Driving_Point.z;
	Point_Deformation->x = 0;
	Point_Deformation->y = 0;
	Point_Deformation->z = 0;

	for(Search.x=-Radius; Search.x<=Radius; Search.x+=Incre)
		for(Search.y=-Radius; Search.y<=Radius; Search.y+=Incre)
			for(Search.z=-Radius; Search.z<=Radius; Search.z+=Incre)
			{
				/* MdlVer[s]'s current position */
				x = (int)(DeformFld[sz][sx][sy].x + sx + Search.x + 0.5) ;
				y = (int)(DeformFld[sz][sx][sy].y + sy + Search.y + 0.5) ;
				z = (int)(DeformFld[sz][sx][sy].z + sz + Search.z + 0.5) ;
				
				if( x<ptSubVolumn_Parm->Image_X_Size && y<ptSubVolumn_Parm->Image_Y_Size && z<ptSubVolumn_Parm->Image_Z_Size && x>=0 && y>=0 && z>=0 && \
					(SimilarityBetweenFeaturesInImgAndFeaturesInMdl(ObjImg,x,y,z,MdlVer_Fea,Driving_Point_Index)>ptSubVolumn_Parm->Point_Similarity_Threshold || \
					(ptSubVolumn_Parm->IsBigVN==true && MdlVer_Fea[Driving_Point_Index].VNvlm>0 && ObjImg[z][x][y].VNvlm>0)) ) 
				{
					TentativeWarp.x = Search.x;
					TentativeWarp.y = Search.y;
					TentativeWarp.z = Search.z;
					Subvolumn_Matching_Degree = SubVolumnMatching(MdlImg, ObjImg, Template_Driving_Point, TentativeWarp, Search_Range, Search_Neighbor_Size, DeformFld, &SubVolum_Min_Dist, ptSubVolumn_Parm);
					
					if( Subvolumn_Matching_Degree>ptSubVolumn_Parm->Subvolumn_Similarity)
					{
						ptSubVolumn_Parm->MinDist = SubVolum_Min_Dist;
						ptSubVolumn_Parm->Subvolumn_Similarity = Subvolumn_Matching_Degree ;
						Point_Deformation->x = TentativeWarp.x ;
						Point_Deformation->y = TentativeWarp.y ;	    
						Point_Deformation->z = TentativeWarp.z ;
					}
				}
			}
}

void HE_ALG_Registration::HierarchicalDeform3D(Fvector3d *MdlVer, Ivector3d *FixedMdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, int image_size, int z_size, int resolution, HAMMER_Param *ptParm)
{
	int   i,j,k,g,l,m,n,old_count,num,how_many,max,size,t, SHIFT, incre, LocalM, scale, beforeN, SelectVerNum, vv, RealVV ;
	float weight, CurrentDegree, OverlapDegree, MaxDegree, AdaptiveFactor, DistSeg, MinDist ;
	Fvector3d Search, Crnt, Tmp, dfm, parallel, globl;
	float mag, factor, Delta, level, magDfm ;
	int   x,y,z, sx,sy,sz ;
	SubVolumnParm *p_SubVolumn_Parm, m_SubVolumn_Parm;
	int Template_Driving_Point_Index;
	
	/* Bubble for checking similarity */
	Ivector3d  StudiedPoint, Grid;
	Ivector3d  *Subvolumn_Matching_Area;
	int      Subvolumn_Matching_Size ;
	int      Subvolumn_Radius;
	/* Bubble for transforming subvolume */
	Ivector3d  *SubV_pnt;
	int        SubVNum, SubVsize, UsedVNum ;
	float      UsedGuassianSigma ;
	
	/* for local geometric features of 3D shape */
	float     CenterRate, LocalRatio ;
	Fvector3d *verModelLast, nbr_tot ;
	int       numTEMP, Last_searched_point, temp_num ;
	
	
	/* to speed up, the neighboring driving voxels are not necessary to deform for multiple times. */
	unsigned char ***SearchingStatus ;
	int           FilterSize ;
	
	/* June 5, 2001 */
	Fvector3d  ***DeformFld_Last ;

	DeformFld_Last=Fvector3dalloc3d(image_size,image_size,z_size);	
	/* global constraints  */
	verModelLast      = Fvector3dalloc1d(MdlVer_Num); /* used as model */
	/* remember */
	for(numTEMP=0; numTEMP<MdlVer_Num; numTEMP++)
    {
		verModelLast[numTEMP].x=MdlVer[numTEMP].x; 
		verModelLast[numTEMP].y=MdlVer[numTEMP].y; 
		verModelLast[numTEMP].z=MdlVer[numTEMP].z;
    }
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
			{
				DeformFld_Last[k][i][j].x=DeformFld[k][i][j].x ;
				DeformFld_Last[k][i][j].y=DeformFld[k][i][j].y ;
				DeformFld_Last[k][i][j].z=DeformFld[k][i][j].z ;
			}
			
			
	/* shift assigned */
	SHIFT = resolution/2 ; 
	if(SHIFT<1)
		SHIFT=1; 
	printf("Shift=%d\n", SHIFT) ;
	incre = 2*SHIFT/6; /*8, 20, May 2001*/ 
	if(incre<1) 
		incre=1 ;

	max = SHIFT+1 ;
	Subvolumn_Radius = max*2+1; /*nb_size should be odd number */ 
	Subvolumn_Matching_Area = Ivector3dalloc1d(Subvolumn_Radius*Subvolumn_Radius*Subvolumn_Radius) ;
	calculate_hood_byIncreasingRadius(Subvolumn_Matching_Area, Subvolumn_Radius, &Subvolumn_Matching_Size, 1., 1., 1.) ; 
	printf("nbr num:%d with rad %d\n", Subvolumn_Radius, Subvolumn_Matching_Size) ;
	/* May 24, 2001 */
	m_STEPNBR = Subvolumn_Matching_Size/20 ;  
	if(m_STEPNBR<1) 
		m_STEPNBR=1 ;
	p_SubVolumn_Parm = &m_SubVolumn_Parm;
	p_SubVolumn_Parm->Deform_Diffusion_Weight = Subvolumn_Radius;
	p_SubVolumn_Parm->Image_X_Size = image_size;
	p_SubVolumn_Parm->Image_Y_Size = image_size;
	p_SubVolumn_Parm->Image_Z_Size = z_size;
	p_SubVolumn_Parm->IsBigVN = ptParm->BigVN;
	p_SubVolumn_Parm->IsYoungBrain = ptParm->YoungBrain;
	p_SubVolumn_Parm->Point_Similarity_Threshold = SMR_THR;
	p_SubVolumn_Parm->Search_Step = incre;
	p_SubVolumn_Parm->Step_of_NBR = m_STEPNBR;
	p_SubVolumn_Parm->Search_Radius = SHIFT;
	p_SubVolumn_Parm->Smooth_Factor = ptParm->smoothFactor;
    p_SubVolumn_Parm->Deform_Rate = ptParm->Deform_RATE;
    p_SubVolumn_Parm->CurrentLevel = ptParm->Current_Level;
    p_SubVolumn_Parm->SubVolumn_Similarity_Threshold = ptParm->MatchingDegreeOfMdlOnImgEdge;
    
    printf("############### Subvolumn Parameters ####################\n");
    
    PrintSubVolumnParm(p_SubVolumn_Parm);
    printf("########################################################\n");
    
    
	/* for transformation in Subvolume */
	SubVsize = 41 ; /* nb_size+2*0 */
	SubV_pnt = Ivector3dalloc1d(SubVsize*SubVsize*SubVsize) ;
	calculate_hood_byIncreasingRadius(SubV_pnt, SubVsize, &SubVNum, 1., 1., 1.) ; 
	printf("Subvolume num:%d with rad %d\n", SubVsize, SubVNum) ;
	t = 0;   /* 3 8 */ /* 0 ~ 9*/
	t = resolution/10 ;if(t>2) t=2 ;
	SelectVerNum = MdlVer_Num ;
	printf("incre=%d  max=%d   searched Num=%d    t=%d\n", incre, max, SelectVerNum, t ) ;
    /* Feb 27, 2002: To speed up, the neighboring driving voxels are not necessary to deform for multiple times. */
	SearchingStatus = UCalloc3d(image_size, image_size, z_size);
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				SearchingStatus[k][i][j]=OOK ;
	/* get the forces from the landmarks */

	printf("before ObjVer_Num=%d\n", ObjVer_Num) ;
	if(ratio_iteration<=ITER_THRD && ptParm->UsingForcesFromObject==true) 
      FindForceFromObject(ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg, MdlVer, MdlVer_Num, MdlVer_Fea, FixedMdlVer, MdlImg, DeformFld, SHIFT+1, ptParm);
	//SearchTheNearestVertexForEachLandmark_March2003(ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg,    MdlVer, MdlVer_Num, MdlVer_Fea, FixedMdlVer, MdlImg, DeformFld,  image_size, z_size,  SHIFT+1) ;
	/*SearchTheNearestVertexForEachLandmark_NewFeb2002(ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg,   MdlVer, MdlVer_Num, MdlVer_Fea, MdlImg, DeformFld, image_size, z_size) ; used before March 2003*/
	/*SearchTheNearestVertexForEachLandmark( ObjVer, ObjVer_Num, ObjVer_Fea, MdlVer, MdlVer_Num, MdlVer_Fea, image_size, z_size ) ;*/
	
		

	RealVV = 0 ;
    printf("################# START LOCAL CORRESPONDENCE DETECTON############################\n");
    
	for(vv=0; vv<MdlVer_Num; vv+=STEPPNT)  /*for(s=0; s<MdlVer_Num; s+=STEPPNT)*/
	{
		Template_Driving_Point_Index = (vv+Start_Search_Point)%MdlVer_Num ; 
		
		if( (RealVV<SelectVerNum || Fvector3dmag(forceByFocusedPntInObj[Template_Driving_Point_Index])!=0) && SearchingStatus[FixedMdlVer[Template_Driving_Point_Index].z][FixedMdlVer[Template_Driving_Point_Index].x][FixedMdlVer[Template_Driving_Point_Index].y]==OOK )
		{
			RealVV ++ ;
			Last_searched_point = Template_Driving_Point_Index ;
#ifdef DUMP_DATA
			if( Template_Driving_Point_Index%100==0 )
			{ 
				printf("\ns=%d  Last_searched_point= %d   ", Template_Driving_Point_Index, Last_searched_point) ;
				printf("percent finished = %f\n", (float)RealVV/SelectVerNum) ; 
			}
#endif
			
			if( Fvector3dmag(forceByFocusedPntInObj[Template_Driving_Point_Index])==0 || ratio_iteration>ITER_THRD)
			{
				dfm.x = 0 ;
				dfm.y = 0 ; 
				dfm.z = 0 ;
				p_SubVolumn_Parm->MinDist = 1000000000.0;
				p_SubVolumn_Parm->Subvolumn_Similarity = 0;
                if(ptParm->Soft_Correspondence == true)
                  SoftCorrespondenceDetection(MdlImg, ObjImg, MdlVer_Fea, ObjVer_Fea, DeformFld, FixedMdlVer[Template_Driving_Point_Index], Template_Driving_Point_Index, &dfm, Subvolumn_Matching_Area, Subvolumn_Matching_Size, p_SubVolumn_Parm);
                else
                  CorrespondenceDetection(MdlImg, ObjImg, MdlVer_Fea, ObjVer_Fea, DeformFld, FixedMdlVer[Template_Driving_Point_Index], Template_Driving_Point_Index, &dfm, Subvolumn_Matching_Area, Subvolumn_Matching_Size, p_SubVolumn_Parm);
				MaxDegree = p_SubVolumn_Parm->Subvolumn_Similarity;
			}//end of if ( Fvector3dmag(forceByFocusedPntInObj[s])==0 || ratio_iteration>ITER_THRD)
			else
			{
				MaxDegree = 10000.0 ;
				
				x = FixedMdlVer[Template_Driving_Point_Index].x ;
				y = FixedMdlVer[Template_Driving_Point_Index].y ;
				z = FixedMdlVer[Template_Driving_Point_Index].z ;

                if(ptParm->Soft_Correspondence ==  true)
                {
                  dfm.x = (DeformFld_Last[z][x][y].x-DeformFld[z][x][y].x+forceByFocusedPntInObj[Template_Driving_Point_Index].x) ; 
                  dfm.y = (DeformFld_Last[z][x][y].y-DeformFld[z][x][y].y+forceByFocusedPntInObj[Template_Driving_Point_Index].y) ;
                  dfm.z = (DeformFld_Last[z][x][y].z-DeformFld[z][x][y].z+forceByFocusedPntInObj[Template_Driving_Point_Index].z) ;
                }
                else
                {
                  dfm.x = (DeformFld_Last[z][x][y].x-DeformFld[z][x][y].x+forceByFocusedPntInObj[Template_Driving_Point_Index].x)*(1.0+(1+ratio_iteration))/2. ;  /*5.*/
                  dfm.y = (DeformFld_Last[z][x][y].y-DeformFld[z][x][y].y+forceByFocusedPntInObj[Template_Driving_Point_Index].y)*(1.0+(1+ratio_iteration))/2. ;	    
                  dfm.z = (DeformFld_Last[z][x][y].z-DeformFld[z][x][y].z+forceByFocusedPntInObj[Template_Driving_Point_Index].z)*(1.0+(1+ratio_iteration))/2. ; /* May 2001 */
                  /*printf("dfm=(%f,%f,%f)\n", dfm.x, dfm.y, dfm.z) ;*/
				
                  /* scale it */
                  magDfm = Fvector3dmag(dfm) ;
                  if( magDfm>Subvolumn_Radius/2 ) 
                  {
					dfm.x = dfm.x/magDfm*(Subvolumn_Radius/2) ;
					dfm.y = dfm.y/magDfm*(Subvolumn_Radius/2) ;
					dfm.z = dfm.z/magDfm*(Subvolumn_Radius/2) ;
                  }
                }
                
			}
					
			if( MaxDegree>ptParm->MatchingDegreeOfMdlOnImgEdge )
			{
#ifdef DUMP_DATA
              if( Template_Driving_Point_Index%100==0 )
              {
                printf("%d->   OL(%d)=%f: (%f,%f,%f)\n", SelectVerNum, Template_Driving_Point_Index, MaxDegree, dfm.x, dfm.y, dfm.z) ;
              }
#endif
				UsedVNum = Subvolumn_Matching_Size;
				UsedGuassianSigma = Subvolumn_Radius ;
#ifdef DUMP_DATA
				if( Template_Driving_Point_Index%100==0 )
					printf("MaxDegree=%f   Current Sigma =%f  volNum=%d\n", MaxDegree, UsedGuassianSigma, UsedVNum) ;
#endif
								
				/* Begin to deform the subvolume at Gaussian way */
				WarpSubVolume(FixedMdlVer, DeformFld, dfm, Template_Driving_Point_Index, SubV_pnt, UsedVNum, UsedGuassianSigma, p_SubVolumn_Parm);
			}//end of else
		}//end of if( (RealVV<SelectVerNum || Fvector3dmag(forceByFocusedPntInObj[s])!=0) && SearchingStatus[FixedMdlVer[s].z][FixedMdlVer[s].x][FixedMdlVer[s].y]==OOK ) 
	}//end of vv loop
	
	
	Start_Search_Point = Last_searched_point ;
	
	/* get update MdlVer's position from the DeformFld, for estimating global transformation*/
	for(Template_Driving_Point_Index=0; Template_Driving_Point_Index<MdlVer_Num; Template_Driving_Point_Index++)
	{  
		x = FixedMdlVer[Template_Driving_Point_Index].x ;
		y = FixedMdlVer[Template_Driving_Point_Index].y ;
		z = FixedMdlVer[Template_Driving_Point_Index].z ;
		
		MdlVer[Template_Driving_Point_Index].x = DeformFld[z][x][y].x + x ;
		MdlVer[Template_Driving_Point_Index].y = DeformFld[z][x][y].y + y ;
		MdlVer[Template_Driving_Point_Index].z = DeformFld[z][x][y].z + z ;
	}
	
	/*0.3*//*0.3*/
	/*0.4*//*0.4*/
	/*0.6*//*0.4*/
	/*0.5*//*0.5*/   /* probably for EN** et al */
	LocalRatio = 0.25 + 0.65*exp(-(ratio_iteration-1.)*(ratio_iteration-1.)/2./.25/.25) ; /* (0.3,0.3),  directly 0.88 */
	/* deformation modified by global affine-transformation plus local deformation */
	GlobalAffineUpdatePlusLocalDeformation( MdlVer, verModelLast, MdlVer_Num ) ;
	Mat_Print(Transform) ;
	/* update deformation matrix */
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
			{
				Crnt.x = DeformFld_Last[k][i][j].x + i ;
				Crnt.y = DeformFld_Last[k][i][j].y + j ;
				Crnt.z = DeformFld_Last[k][i][j].z + k ;
				
				globl.x = Transform->data[0][0]*Crnt.x + Transform->data[0][1]*Crnt.y + Transform->data[0][2]*Crnt.z + Transform->data[0][3] -i ;
				globl.y = Transform->data[1][0]*Crnt.x + Transform->data[1][1]*Crnt.y + Transform->data[1][2]*Crnt.z + Transform->data[1][3] -j ;
				globl.z = Transform->data[2][0]*Crnt.x + Transform->data[2][1]*Crnt.y + Transform->data[2][2]*Crnt.z + Transform->data[2][3] -k ;
				
				DeformFld[k][i][j].x = globl.x + (DeformFld[k][i][j].x-globl.x)*LocalRatio/1.2;
				DeformFld[k][i][j].y = globl.y + (DeformFld[k][i][j].y-globl.y)*LocalRatio/1.2;
				DeformFld[k][i][j].z = globl.z + (DeformFld[k][i][j].z-globl.z)*LocalRatio/1.2;
				
				/* boundary constraints */
				if(DeformFld[k][i][j].x+i<0) DeformFld[k][i][j].x=-i ;
				if(DeformFld[k][i][j].y+j<0) DeformFld[k][i][j].y=-j ;
				if(DeformFld[k][i][j].z+k<0) DeformFld[k][i][j].z=-k ;
				
				if(DeformFld[k][i][j].x+i>=(image_size-1)) DeformFld[k][i][j].x=(image_size-1)-i ;
				if(DeformFld[k][i][j].y+j>=(image_size-1)) DeformFld[k][i][j].y=(image_size-1)-j ;
				if(DeformFld[k][i][j].z+k>=(z_size-1))     DeformFld[k][i][j].z=(z_size-1)-k ;
			}
	SmoothDeformationField(DeformFld, image_size, z_size,  MdlImg, ptParm) ;
	if(ptParm->SmoothingTimes>0) 
      SmoothDeformationFieldWithEdgePreserving( FixedMdlVer, MdlVer_Num, DeformFld, MdlImg, image_size, z_size, ratio_iteration, ptParm) ;
	/* focused edge points in the model */
	for(Template_Driving_Point_Index=0; Template_Driving_Point_Index<MdlVer_Num; Template_Driving_Point_Index++)
	{  
		x = FixedMdlVer[Template_Driving_Point_Index].x ;
		y = FixedMdlVer[Template_Driving_Point_Index].y ;
		z = FixedMdlVer[Template_Driving_Point_Index].z ;
		
		MdlVer[Template_Driving_Point_Index].x = DeformFld[z][x][y].x + x ;
		MdlVer[Template_Driving_Point_Index].y = DeformFld[z][x][y].y + y ;
		MdlVer[Template_Driving_Point_Index].z = DeformFld[z][x][y].z + z ;
	}
		  
	/* free */
	free(Subvolumn_Matching_Area) ;
	free(SubV_pnt) ;	
	UCfree3d(SearchingStatus, z_size, image_size) ;
		  
	/* geometric */
	free(verModelLast) ;		
	Fvector3dfree3d(DeformFld_Last, z_size, image_size) ;
}


void HE_ALG_Registration::WarpSubVolume(Ivector3d *FixedMdlVer, Fvector3d ***DeformFld, Fvector3d Point_Deform, int Template_Driving_Point_Index, Ivector3d *SubVolumn, int SubVolumn_Num,int Gaussian_Sigma, SubVolumnParm *ptSubVolumn_Parm)
{
	int n,i;
	float level, weight;
	Ivector3d StudiedPoint, Grid;
	Fvector3d nbr_tot;
	float temp_num;
	float CenterRate, Delta;

	CenterRate = ptSubVolumn_Parm->Smooth_Factor ; /*0.05 */
	Delta=0.005*ratio_iteration ; /* June 6, 2001*/
	for(n=0; n<SubVolumn_Num; n++)
	{
		StudiedPoint.x = FixedMdlVer[Template_Driving_Point_Index].x+SubVolumn[n].x ;
		StudiedPoint.y = FixedMdlVer[Template_Driving_Point_Index].y+SubVolumn[n].y ;
		StudiedPoint.z = FixedMdlVer[Template_Driving_Point_Index].z+SubVolumn[n].z ;
		
		if( StudiedPoint.x<ptSubVolumn_Parm->Image_X_Size && StudiedPoint.y<ptSubVolumn_Parm->Image_Y_Size && \
			StudiedPoint.z<ptSubVolumn_Parm->Image_Z_Size && StudiedPoint.x>=0 && StudiedPoint.y>=0 && StudiedPoint.z>=0 )
		{
			
			/* shift for every vertex in this set of neighborhood */
			level = (abs(SubVolumn[n].x)+abs(SubVolumn[n].y)+abs(SubVolumn[n].z))/3.0 ;
			/*level = sqrt( SubV_pnt[n].x*SubV_pnt[n].x + SubV_pnt[n].y*SubV_pnt[n].y + SubV_pnt[n].z*SubV_pnt[n].z ) ; */ /* tried before June 18, 2001 */
			weight = GuassianWeight( level, Gaussian_Sigma) ;  /*nb_size*/ 
			/*weight = exp(-level*level/(2.*nb_size*nb_size)) ;*/
	
			/* converge to its center */
			nbr_tot.x = 0 ;  nbr_tot.y = 0 ;  nbr_tot.z = 0 ;
			temp_num = 0 ;
			for(i=1;i<27;i++) /* 26 neighbor */
			{
				Grid.x = StudiedPoint.x+SubVolumn[i].x ;
				Grid.y = StudiedPoint.y+SubVolumn[i].y ;
				Grid.z = StudiedPoint.z+SubVolumn[i].z ;
				
				if( Grid.x<ptSubVolumn_Parm->Image_X_Size && Grid.y<ptSubVolumn_Parm->Image_Y_Size && Grid.z<ptSubVolumn_Parm->Image_Z_Size && Grid.x>=0 && Grid.y>=0 && Grid.z>=0 )
				{
					nbr_tot.x += DeformFld[Grid.z][Grid.x][Grid.y].x;
					nbr_tot.y += DeformFld[Grid.z][Grid.x][Grid.y].y;
					nbr_tot.z += DeformFld[Grid.z][Grid.x][Grid.y].z;					
					temp_num += 1.0;
				}
			}
			if(temp_num>0)
			{
				nbr_tot.x /= temp_num ;
				nbr_tot.y /= temp_num ;
				nbr_tot.z /= temp_num ;
			}
			else
				printf("(%d,%d,%d) temp_num=%d (total 8)\n", StudiedPoint.x, StudiedPoint.y, StudiedPoint.z, temp_num) ;
						
			nbr_tot.x =  (nbr_tot.x - DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].x)*CenterRate ; 
			nbr_tot.y =  (nbr_tot.y - DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].y)*CenterRate ;
			nbr_tot.z =  (nbr_tot.z - DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].z)*CenterRate ;			
			
			/*printf("weight=%f (%d)", weight, level[n]) ; getchar() ;*/
			DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].x += (Point_Deform.x*weight + nbr_tot.x)*(ptSubVolumn_Parm->Deform_Rate+Delta) ;
			DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].y += (Point_Deform.y*weight + nbr_tot.y)*(ptSubVolumn_Parm->Deform_Rate+Delta) ;  
			DeformFld[StudiedPoint.z][StudiedPoint.x][StudiedPoint.y].z += (Point_Deform.z*weight + nbr_tot.z)*(ptSubVolumn_Parm->Deform_Rate+Delta) ;  
		}
	}
}



void HE_ALG_Registration::FindForceFromObject(Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, Fvector3d *MdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Ivector3d *FixedMdlVer, ImgAttribute ***MdlImg, Fvector3d ***DeformFld, int max, HAMMER_Param *ptHAMMER_Parm)
{
	int        i, j, k, l ;
	int        ***VerticesImg, x, y, z, r, t, px, py, pz, vx, vy, vz, s ;
	int        TotalMatchingPoints, TotalMdlPntMatched, TotalSamples ;
	float      degree, StepDesign, Pointer ,Min_seg;
	
	/* for subvolume matching*/
	float level, CurrentDegree, OverlapDegree, MaxDegree ;
	Fvector3d Crnt, Tmp, Search, SubjNb, dfm;
	int   sx,sy,sz, real_size, SmplStep, incre, dfm_s ;
	
	/* subvolume */
	Ivector3d  *nb_pnt, Grid;
	int        nb_size, n,count ;
    SubVolumnParm *ptSubVolumn_Parm, m_SubVolumn_Parm;
    float Distance, Weight;
    

    /* For saving searching time */
    ptSubVolumn_Parm = &m_SubVolumn_Parm;
    
    VerticesImg = Ialloc3d(image_size, image_size, z_size);

    nb_size = max*2 + 1;
	nb_pnt= Ivector3dalloc1d((nb_size*nb_size*nb_size)) ;
	calculate_hood_byIncreasingRadius(nb_pnt, nb_size, &count, 1., 1., 1.) ;
    SmplStep = count/20 ;
    if(SmplStep<1) SmplStep=1 ;
    printf("   nbr num:%d with rad %d <- sampling step=%d\n", count,nb_size, SmplStep) ;
	//printf("nb_size = %d  count = %d\n", nb_size, count);

    if (!VerticesImg) 
		printf("   memeoy application in VerticesImg\n") ;
	/* transfering surface's vertices */
	for(k=0; k<z_size; k++)
		for(i=0; i<image_size; i++)
			for(j=0; j<image_size; j++)
				VerticesImg[k][i][j] = -1 ;

    printf("being image setting\n");
    
	for( i=0; i<MdlVer_Num; i++)
	{
		x = (int)(MdlVer[i].x) ;
		y = (int)(MdlVer[i].y) ;
		z = (int)(MdlVer[i].z) ;
		
		if( x<image_size && y<image_size && z<z_size && x>=0 && y>=0 && z>=0 )
			VerticesImg[z][x][y] = i ;
	}
	printf(" image setting\n") ;
	
	/* reset */
	for( i=0; i<MdlVer_Num; i++)
	{
		forceByFocusedPntInObj[i].x = 0 ;
		forceByFocusedPntInObj[i].y = 0 ;
		forceByFocusedPntInObj[i].z = 0 ;
		multiple[i] = 0 ;
	}
	
	
	TotalSamples = MdlVer_Num/2;
	if(TotalSamples>ObjVer_Num) 
		TotalSamples = ObjVer_Num ;
	if(TotalSamples>20000)  
		TotalSamples = 20000 ;
	StepDesign = (float)ObjVer_Num/(float)TotalSamples ; 
	printf("   StepDesign=%f\n", StepDesign) ;
	
	incre = 2*max/6 ; 
	if(incre<1)
		incre=1 ;  
	printf("   incre=%d\n", incre);

    ptSubVolumn_Parm->Image_X_Size = image_size;
    ptSubVolumn_Parm->Image_Y_Size = image_size;
    ptSubVolumn_Parm->Image_Z_Size = z_size;
    ptSubVolumn_Parm->Point_Similarity_Threshold = SMR_THR;
    ptSubVolumn_Parm->IsBigVN = ptHAMMER_Parm->BigVN;
    ptSubVolumn_Parm->IsYoungBrain = ptHAMMER_Parm->YoungBrain;
    ptSubVolumn_Parm->Step_of_NBR = SmplStep;
    ptSubVolumn_Parm->Deform_Diffusion_Weight = nb_size;
    ptSubVolumn_Parm->Search_Step = incre;
    ptSubVolumn_Parm->Search_Radius = max;
    ptSubVolumn_Parm->SubVolumn_Similarity_Threshold = ptHAMMER_Parm->MatchingDegreeOfMdlOnImgEdge;
    ptSubVolumn_Parm->Smooth_Factor = ptHAMMER_Parm->smoothFactor;
    ptSubVolumn_Parm->Deform_Rate = ptHAMMER_Parm->Deform_RATE;
    ptSubVolumn_Parm->MinDist = 100000.0;
    
	printf("################### START FINDING FORCE FROM SUBJECT\n");
    
	TotalMatchingPoints = 0;

	Min_seg = 10000.0;
    
	for(Pointer=0, l=0; l<ObjVer_Num; Pointer += StepDesign, l=(int)Pointer)
	{
      px = ObjVer[l].x ;
      py = ObjVer[l].y ;
      pz = ObjVer[l].z ;	  
      
      dfm.x = 0 ; dfm.y = 0 ; dfm.z = 0 ;
      MaxDegree = 0 ;
      
      for(SubjNb.x=-max; SubjNb.x<=max; SubjNb.x+=incre)
        for(SubjNb.y=-max; SubjNb.y<=max; SubjNb.y+=incre)
          for(SubjNb.z=-max; SubjNb.z<=max; SubjNb.z+=incre)
            /*for(t=0; t<pixelNumIn_MyHood && Status==FFAIL; t++)*/
          {
            vx = px + SubjNb.x ; /*+ MyHood[t].x ;*/
            vy = py + SubjNb.y ; /*+ MyHood[t].y ;*/
            vz = pz + SubjNb.z ; /*+ MyHood[t].z ;*/
			
            if( vx<image_size && vy<image_size && vz<z_size && vx>=0 && vy>=0 && vz>=0)
            {
              s = VerticesImg[vz][vx][vy] ;
              
              if( s>=0 && px<image_size && py<image_size && pz<z_size && px>=0 && py>=0 && pz>=0)
              {
                degree = SimilarityBetweenFocusedPointsInMdlObjImgs(ObjVer_Fea,l, MdlVer_Fea,s) ;
                if( degree>ptSubVolumn_Parm->Point_Similarity_Threshold)
                {
                  /* get subvolume similarity */
                  /*****************************************/
                  sx = FixedMdlVer[s].x ;
                  sy = FixedMdlVer[s].y ;
                  sz = FixedMdlVer[s].z ;
                  
                  Search.x = -SubjNb.x ;  /*+ MyHood[t].x ;*/
                  Search.y = -SubjNb.y ;  /*+ MyHood[t].y ;*/
                  Search.z = -SubjNb.z ;  /*+ MyHood[t].z ;*/			
                  
                  OverlapDegree = SubVolumnMatching(MdlImg, ObjImg, FixedMdlVer[s], Search, nb_pnt, count, DeformFld, &Min_seg, ptSubVolumn_Parm);
                  //printf("s=%d (%fx%fx%f)-> OverlapDegree = %f\n", s,Search.x, Search.y, Search.z, OverlapDegree);
                  
                  if(ptHAMMER_Parm->Soft_Correspondence == true)
                  {
                    TotalMatchingPoints ++;
                    Distance = (abs(Search.x)+abs(Search.y)+abs(Search.z))/3.0 ;
                    //weight = exp(-level*level/(2.*max*max)) ;
                    Weight = GuassianWeight(Distance, max);
                    OverlapDegree *= Weight ;
                    forceByFocusedPntInObj[s].x += OverlapDegree*Search.x ;
                    forceByFocusedPntInObj[s].y += OverlapDegree*Search.y ;
                    forceByFocusedPntInObj[s].z += OverlapDegree*Search.z ;
                    multiple[s] += OverlapDegree ;
                  }
                  else
                  {
                    if( OverlapDegree>MaxDegree )
                    {
                      MaxDegree = OverlapDegree ;
                      dfm.x = Search.x ;
                      dfm.y = Search.y ;	    
                      dfm.z = Search.z ;
                      dfm_s = s ;
                    }
                  }
                  
                }
              }//end of if (s>0...)
            }
          }//end of triple for SubjNb
      
      /* get a maximal one */
      if( MaxDegree>ptSubVolumn_Parm->SubVolumn_Similarity_Threshold && ptHAMMER_Parm->Soft_Correspondence==false)
      {
        TotalMatchingPoints ++;
        forceByFocusedPntInObj[dfm_s].x += dfm.x ;
        forceByFocusedPntInObj[dfm_s].y += dfm.y ;
        forceByFocusedPntInObj[dfm_s].z += dfm.z ;
        multiple[dfm_s] += 1.0 ;
      }
    }//end of for(pointer=0)
	printf("   TotalMatchingPoints=%d (%f)\n", TotalMatchingPoints, (float)TotalMatchingPoints/(float)ObjVer_Num*100.0) ;
	
	
	TotalMdlPntMatched = 0 ;
	for(i=0; i<MdlVer_Num; i++)
	{
      if( multiple[i]>0 )
      {
        //printf("i=%d num=%d\n", i,multiple[i]) ;
        forceByFocusedPntInObj[i].x /= multiple[i] ;
        forceByFocusedPntInObj[i].y /= multiple[i] ;
        forceByFocusedPntInObj[i].z /= multiple[i] ;
        TotalMdlPntMatched ++ ;
      }
	}
    
	printf("   TotalMdlPntMatched=%d (%f)\n", TotalMdlPntMatched, (float)TotalMdlPntMatched/(float)MdlVer_Num*100.0) ;
		
	/* free */
	Ifree3d(VerticesImg, ptSubVolumn_Parm->Image_Z_Size, ptSubVolumn_Parm->Image_Y_Size) ;
    printf("################## END OF FINDING FORCE FROM SUBJECT\n");
}

void  HE_ALG_Registration::PrintSubVolumnParm(SubVolumnParm *ptParm)
{
  printf("the image size is %dx%dx%d\n", ptParm->Image_X_Size, ptParm->Image_Y_Size, ptParm->Image_Z_Size);
  printf("Search_Radius = %d\n", ptParm->Search_Radius);
  printf("Search_Step = %d\n", ptParm->Search_Step);
  printf("Point Similairty Threshold = %f\n", ptParm->Point_Similarity_Threshold);
  printf("Step_of_NBR = %d\n", ptParm->Step_of_NBR);
  printf("Deformation_Diffusiong_Weight = %f\n", ptParm->Deform_Diffusion_Weight);
  printf("Subvolumn similarity = %f   MinDist = %f\n", ptParm->Subvolumn_Similarity, ptParm->MinDist);
  printf("smooth_Factor = %f\n", ptParm->Smooth_Factor);
  printf("Deform_Rate = %f\n", ptParm->Deform_Rate);
  if(ptParm->IsYoungBrain == true)
    printf("Young Brain\n");
  if(ptParm->IsBigVN == true)
    printf("Is big ventricel.\n");
} 


void HE_ALG_Registration::SoftCorrespondenceDetection(ImgAttribute ***MdlImg, ImgAttribute ***ObjImg, ImgAttribute *MdlVer_Fea, ImgAttribute *ObjVer_Fea, Fvector3d ***DeformFld, Ivector3d Template_Driving_Point, int Driving_Point_Index, Fvector3d *Point_Deformation, Ivector3d *Search_Range, int Search_Neighbor_Size, SubVolumnParm *ptSubVolumn_Parm)
{
	int x,y,z;
	int sz, sx, sy;
	Ivector3d Search;
	int Radius, Incre;
	Fvector3d TentativeWarp;
	float Subvolumn_Matching_Degree, SubVolum_Min_Dist;
    float BestDegree, MatchedNum, WtDegree;
    Fvector3d BestDfm, AveageDfm;
    float Distance, Weight;
    

	Radius = ptSubVolumn_Parm->Search_Radius;
	Incre = ptSubVolumn_Parm->Search_Step;
	sx = Template_Driving_Point.x;
	sy = Template_Driving_Point.y;
	sz = Template_Driving_Point.z;
	AveageDfm.x = 0;
    AveageDfm.y = 0;
    AveageDfm.z = 0;
    BestDegree = 0;
    MatchedNum = 0;
    WtDegree = 0;
    Point_Deformation->x = 0;
    Point_Deformation->y = 0;
    Point_Deformation->z = 0;
    
	for(Search.x=-Radius; Search.x<=Radius; Search.x+=Incre)
		for(Search.y=-Radius; Search.y<=Radius; Search.y+=Incre)
			for(Search.z=-Radius; Search.z<=Radius; Search.z+=Incre)
			{
				/* MdlVer[s]'s current position */
				x = (int)(DeformFld[sz][sx][sy].x + sx + Search.x + 0.5) ;
				y = (int)(DeformFld[sz][sx][sy].y + sy + Search.y + 0.5) ;
				z = (int)(DeformFld[sz][sx][sy].z + sz + Search.z + 0.5) ;
				
				if( x<ptSubVolumn_Parm->Image_X_Size && y<ptSubVolumn_Parm->Image_Y_Size && z<ptSubVolumn_Parm->Image_Z_Size && x>=0 && y>=0 && z>=0 && \
					(SimilarityBetweenFeaturesInImgAndFeaturesInMdl(ObjImg,x,y,z,MdlVer_Fea,Driving_Point_Index)>ptSubVolumn_Parm->Point_Similarity_Threshold || \
					(ptSubVolumn_Parm->IsBigVN==true && MdlVer_Fea[Driving_Point_Index].VNvlm>0 && ObjImg[z][x][y].VNvlm>0)) ) 
				{
					TentativeWarp.x = Search.x;
					TentativeWarp.y = Search.y;
					TentativeWarp.z = Search.z;
					Subvolumn_Matching_Degree = SubVolumnMatching(MdlImg, ObjImg, Template_Driving_Point, TentativeWarp, Search_Range, Search_Neighbor_Size, DeformFld, &SubVolum_Min_Dist, ptSubVolumn_Parm);

                    if(Subvolumn_Matching_Degree>ptSubVolumn_Parm->SubVolumn_Similarity_Threshold && Subvolumn_Matching_Degree>BestDegree)
                    {
                      BestDegree = Subvolumn_Matching_Degree;
                      BestDfm.x = TentativeWarp.x;
                      BestDfm.y = TentativeWarp.y;
                      BestDfm.z = TentativeWarp.z;
                    }
                    
					if( Subvolumn_Matching_Degree>ptSubVolumn_Parm->SubVolumn_Similarity_Threshold)
					{
						MatchedNum += 1.0;
                        Distance = (abs(TentativeWarp.x)+abs(TentativeWarp.y)+abs(TentativeWarp.z))/3.0;
                        Weight = GuassianWeight(Distance, ptSubVolumn_Parm->Search_Radius);
                        Subvolumn_Matching_Degree *= Weight;
                        WtDegree += Subvolumn_Matching_Degree;
                        AveageDfm.x += Subvolumn_Matching_Degree*TentativeWarp.x;
                        AveageDfm.y += Subvolumn_Matching_Degree*TentativeWarp.y;
                        AveageDfm.z += Subvolumn_Matching_Degree*TentativeWarp.z;
					}
				}
			}
    if(MatchedNum>0)
    {
      Point_Deformation->x = AveageDfm.x/WtDegree;
      Point_Deformation->y = AveageDfm.y/WtDegree;
      Point_Deformation->z = AveageDfm.z/WtDegree;
      WtDegree = ptSubVolumn_Parm->SubVolumn_Similarity_Threshold + 0.001;
    }
    if(ptSubVolumn_Parm->CurrentLevel>=MID_LEVEL && ratio_iteration>=ITER_THRD \
       && BestDegree>ptSubVolumn_Parm->SubVolumn_Similarity_Threshold)
    {
      Point_Deformation->x = BestDfm.x;
      Point_Deformation->y = BestDfm.y;
      Point_Deformation->z = BestDfm.z;
      WtDegree = ptSubVolumn_Parm->SubVolumn_Similarity_Threshold + 0.001;
    }
    ptSubVolumn_Parm->Subvolumn_Similarity = WtDegree;
}
 
void HE_ALG_Registration::GenerateDeformationbyTPS(Fvector3d ***PrevDeformFld, Fvector3d ***OutputDeformFld, Fvector3d *DeformArray, Ivector3d *TemplateDrivingPoint, int Template_DrivingPixel_Num, int Image_X_Size, int Image_Y_Size, int Image_Z_Size, float Lemda, float Lemda2, TPSParm *ptParm)
{
	int i, j, k, l, m, n, s, t, x, y, z;
	int DrivingPointNum_in_Block, Prev_Num;
	int ***DrivingPointImage, ***BlockIndex, ***PrevBlockIndex;
	Fvector3d ***BlockDeform, ***DeformFld, *Residual_Deform;
	float ***WeighImg, weight;
	int index;
	int Cluster_Radius;
	Fvector3d Mean_Deform;
	int x1, y1, z1;
	vnl_matrix<double> V, Y;
	Fvector3d *Neighbor;
	int Neighbor_Num;
	float Level, displace_weight;
	float Overall_Residual_Error, Residual_Error;
	int TotalPixelNum, MinPixelNum;

	TotalPixelNum = ptParm->BlockSize*ptParm->BlockSize*ptParm->BlockSize;
	MinPixelNum = (int)(TotalPixelNum*MIN_TPS_POINT_RATIO);
	DrivingPointImage = Ialloc3d(Image_X_Size, Image_Y_Size, Image_Z_Size);
	Residual_Deform = Fvector3dalloc1d(Template_DrivingPixel_Num);
	WeighImg = Falloc3d(Image_X_Size, Image_Y_Size, Image_Z_Size);
	BlockDeform = Fvector3dalloc3d(ptParm->BlockSize, ptParm->BlockSize, ptParm->BlockSize);
	DeformFld = Fvector3dalloc3d(Image_X_Size, Image_Y_Size, Image_Z_Size);
	Neighbor = Fvector3dalloc1d(TotalPixelNum);
	//FixedCord = Fvector3dalloc1d(ptParm->BlockSize*ptParm->BlockSize*ptParm->BlockSize);
	//MovingCord = Fvector3dalloc1d(ptParm->BlockSize*ptParm->BlockSize*ptParm->BlockSize);
	BlockIndex = Ialloc3d(ptParm->BlockSize, ptParm->BlockSize, ptParm->BlockSize);
	PrevBlockIndex = Ialloc3d(ptParm->BlockSize, ptParm->BlockSize, ptParm->BlockSize);
	FixedCord.set_size(TotalPixelNum, 4);
	PrevFixedCord.set_size(TotalPixelNum, 4);
	MovingCord.set_size(TotalPixelNum, 4);
	FixedCord.set_column(0, 1);
	MovingCord.set_column(0, 1);

	for(k=0;k<Image_Z_Size;k++)
		for(i=0;i<Image_X_Size;i++)
			for(j=0;j<Image_Y_Size;j++)
			{
				DrivingPointImage[k][i][j] = -1;
				WeighImg[k][i][j] = 0;
				DeformFld[k][i][j].x = 0;
				DeformFld[k][i][j].y = 0;
				DeformFld[k][i][j].z = 0;
			}
	for(t=0;t<Template_DrivingPixel_Num;t++)
	{
		k = TemplateDrivingPoint[t].z;
		i = TemplateDrivingPoint[t].x;
		j = TemplateDrivingPoint[t].y;
		DrivingPointImage[k][i][j] = t;
		Residual_Deform[t].x = DeformArray[t].x - PrevDeformFld[k][i][j].x;
		Residual_Deform[t].y = DeformArray[t].y - PrevDeformFld[k][i][j].y;
		Residual_Deform[t].z = DeformArray[t].z - PrevDeformFld[k][i][j].z;
	}

	printf("Regularize the deformation field with TPS \n");
	for(k=0;k<Image_Z_Size;k+=ptParm->OverStep)
	{
		for(i=0;i<Image_X_Size;i+=ptParm->OverStep)
		{
			for(j=0;j<Image_Y_Size;j+=ptParm->OverStep)
			{
				/************************************************************************/
				/* Step1 Determine whether need to do TPS in current blcok              */
				/************************************************************************/
				Overall_Residual_Error = 0;
				for(l=0;l<ptParm->BlockSize;l++)
				{
					z = min(Image_Z_Size-1, k+l);
					for(m=0;m<ptParm->BlockSize;m++)
					{
						x = min(Image_X_Size-1, i+m);
						for(n=0;n<ptParm->BlockSize;n++)
						{
							y = min(Image_Y_Size-1, j+n);							
							index = DrivingPointImage[z][x][y];
							if(index>=0)
							{								
								Residual_Error = SQR(PrevDeformFld[z][x][y].x-DeformArray[index].x) + \
									SQR(PrevDeformFld[z][x][y].y-DeformArray[index].y) + \
									SQR(PrevDeformFld[z][x][y].z-DeformArray[index].z);
								Overall_Residual_Error += sqrt(Residual_Error);
							}
						}
					}
				}
				if(Overall_Residual_Error<ptParm->Residual_Tolerance)
				{
					//printf("(%d %d %d)-->%f   (no need to fit the residual error)", k, i, j, Overall_Residual_Error);
					continue;
				}
				/************************************************************************/
				/* Step2 Collect the TPS Data                                           */
				/************************************************************************/
				DrivingPointNum_in_Block = 0;				
				for(l=0;l<ptParm->BlockSize;l++)
				{
					z = min(Image_Z_Size-1, k+l);
					for(m=0;m<ptParm->BlockSize;m++)
					{
						x = min(Image_X_Size-1, i+m);
						for(n=0;n<ptParm->BlockSize;n++)
						{
							y = min(Image_Y_Size-1, j+n);
							BlockDeform[l][m][n].x = 0;
							BlockDeform[l][m][n].y = 0;
							BlockDeform[l][m][n].z = 0;
							if(DrivingPointImage[z][x][y]>=0)
							{
								index = DrivingPointImage[z][x][y];
								BlockDeform[l][m][n].x = Residual_Deform[index].x;
								BlockDeform[l][m][n].y = Residual_Deform[index].y;
								BlockDeform[l][m][n].z = Residual_Deform[index].z;
								MovingCord(DrivingPointNum_in_Block,1) = Residual_Deform[index].x + m;
								MovingCord(DrivingPointNum_in_Block,2) = Residual_Deform[index].y + n;
								MovingCord(DrivingPointNum_in_Block,3) = Residual_Deform[index].z + l;
								FixedCord(DrivingPointNum_in_Block,1) = m;
								FixedCord(DrivingPointNum_in_Block,2) = n;
								FixedCord(DrivingPointNum_in_Block,3) = l;
								BlockIndex[l][m][n] = DrivingPointNum_in_Block;
								DrivingPointNum_in_Block ++;
							}
							else
							{
								BlockIndex[l][m][n] = -1;
								BlockDeform[l][m][n].x = 0;
								BlockDeform[l][m][n].y = 0;
								BlockDeform[l][m][n].z = 0;
							}
						}
					}
				}//end of l,m,n
				printf("Initial Driving Point Number is %d ", DrivingPointNum_in_Block);
				if(DrivingPointNum_in_Block > ptParm->MaxTPSPoint)
				{
					//cluster the driving point
					Cluster_Radius = 1;
					for(l=0;l<ptParm->BlockSize;l++)
						for(m=0;m<ptParm->BlockSize;m++)
							for(n=0;n<ptParm->BlockSize;n++)
								PrevBlockIndex[l][m][n] = BlockIndex[l][m][n];
					Prev_Num = DrivingPointNum_in_Block;
					PrevFixedCord= FixedCord;
					PrevMovingCord = MovingCord;
					while(DrivingPointNum_in_Block>ptParm->MaxTPSPoint)
					{
						calculate_hood_special(Neighbor, Cluster_Radius, &Neighbor_Num, 1, 1, 1);
						DrivingPointNum_in_Block = 0;
						for(l=0;l<ptParm->BlockSize;l++)
							for(m=0;m<ptParm->BlockSize;m++)
								for(n=0;n<ptParm->BlockSize;n++)
									BlockIndex[l][m][n] = PrevBlockIndex[l][m][n];
						for(t=0;t<Prev_Num;t++)
						{							
							m = PrevFixedCord(t, 1);
							n = PrevFixedCord(t, 2);
							l = PrevFixedCord(t, 3);
							if(BlockIndex[l][m][n]<0)
								continue;
							Mean_Deform.x = 0;
							Mean_Deform.y = 0;
							Mean_Deform.z = 0;
							weight = 0;
							for(s=0;s<Neighbor_Num;s++)
							{
								x = m + Neighbor[s].x;
								y = n + Neighbor[s].y;
								z = l + Neighbor[s].z;
								if(x<0 || y<0 || z<0 || x>=ptParm->BlockSize || y>=ptParm->BlockSize || z>=ptParm->BlockSize)
									continue;
								if(PrevBlockIndex[z][x][y]>=0)
								{
									Level = (abs(Neighbor[s].x) + abs(Neighbor[s].y) + abs(Neighbor[s].z))/3.0;
									displace_weight = Cluster_Radius + 1.0 - Level;
									Mean_Deform.x += BlockDeform[z][x][y].x*displace_weight;
									Mean_Deform.y += BlockDeform[z][x][y].y*displace_weight;
									Mean_Deform.z += BlockDeform[z][x][y].z*displace_weight;
									if(x!=m || y!=n || z!=l)
										BlockIndex[z][x][y] = -1;
									weight += displace_weight;
								}
							}
							if(weight>0)
							{
								MovingCord(DrivingPointNum_in_Block, 1) = m + Mean_Deform.x/weight;
								MovingCord(DrivingPointNum_in_Block, 2) = n + Mean_Deform.y/weight;
								MovingCord(DrivingPointNum_in_Block, 3) = l + Mean_Deform.z/weight;
							}
							else
							{
								MovingCord(DrivingPointNum_in_Block, 1) = m + BlockDeform[l][m][n].x;
								MovingCord(DrivingPointNum_in_Block, 2) = n + BlockDeform[l][m][n].y;
								MovingCord(DrivingPointNum_in_Block, 3) = l + BlockDeform[l][m][n].z;
							}
							FixedCord(DrivingPointNum_in_Block, 1) = m;
							FixedCord(DrivingPointNum_in_Block, 2) = n;
							FixedCord(DrivingPointNum_in_Block, 3) = l;
							DrivingPointNum_in_Block++;
						}
						printf("->%d ", DrivingPointNum_in_Block);
						Cluster_Radius++;
					}
					/*
					Cluster_Radius = 3;
					while (DrivingPointNum_in_Block>ptParm->MaxTPSPoint)
					{
						DrivingPointNum_in_Block = 0;
						for(l=0;l<ptParm->BlockSize;l+=Cluster_Radius)
							for(m=0;m<ptParm->BlockSize;m+=Cluster_Radius)
								for(n=0;n<ptParm->BlockSize;n+=Cluster_Radius)
								{
									Mean_Deform.x = 0;
									Mean_Deform.y = 0;
									Mean_Deform.z = 0;
									weight = 0;
									for(z=0;z<Cluster_Radius;z++)
									{
										z1 = min(ptParm->BlockSize-1, l+z);
										for(x=0;x<Cluster_Radius;x++)
										{
											x1 = min(ptParm->BlockSize-1, m+x);
											for(y=0;y<Cluster_Radius;y++)
											{
												y1 = min(ptParm->BlockSize-1, n+y);
												if(BlockIndex[z1][x1][y1]>=0)
												{
													Mean_Deform.x += BlockDeform[z1][x1][y1].x;
													Mean_Deform.y += BlockDeform[z1][x1][y1].y;
													Mean_Deform.z += BlockDeform[z1][x1][y1].z;
													weight += 1.0;
												}
											}
										}
									}
									if(weight>0)
									{										
										FixedCord(DrivingPointNum_in_Block, 1) = m + Cluster_Radius/2;
										FixedCord(DrivingPointNum_in_Block, 2) = n + Cluster_Radius/2;
										FixedCord(DrivingPointNum_in_Block, 3) = l + Cluster_Radius/2;
										MovingCord(DrivingPointNum_in_Block, 1) = Mean_Deform.x /weight + FixedCord(DrivingPointNum_in_Block, 1);
										MovingCord(DrivingPointNum_in_Block, 2) = Mean_Deform.y /weight + FixedCord(DrivingPointNum_in_Block, 2);
										MovingCord(DrivingPointNum_in_Block, 3) = Mean_Deform.z /weight + FixedCord(DrivingPointNum_in_Block, 3);										
										DrivingPointNum_in_Block ++;
									}
								}
						Cluster_Radius += 2;
					}
					*/
				}
				printf("\n");
				/*End of Step 2*/
				
				/**********************************************************************************/
				/* Step 3 Compute the  RESIDUAL deformation field which is represented by TPS     */
				/**********************************************************************************/
				if(DrivingPointNum_in_Block<MinPixelNum)
				{
					//printf("DNP ");
					continue;
				}
				V = FixedCord.extract(DrivingPointNum_in_Block, 4, 0, 0);
				Y = MovingCord.extract(DrivingPointNum_in_Block, 4, 0, 0);
#ifdef DEBUG_TPS
				FILE *V_fp = myopen("V.txt", "wt");
				for(l=0;l<DrivingPointNum_in_Block;l++)
					fprintf(V_fp, "%f %f %f %f\n", V(l, 0), V(l,1), V(l,2), V(l,3));
				fclose(V_fp);
				FILE *Y_fp = myopen("Y.txt", "wt");
				for(l=0;l<DrivingPointNum_in_Block;l++)
					fprintf(Y_fp, "%f %f %f %f\n", Y(l, 0), Y(l,1), Y(l,2), Y(l,3));
				fclose(Y_fp);
#endif
				PrepareTPSKernel(V, Y, DrivingPointNum_in_Block);
				double BendingEnergy = UpdateTPSParameter(V, Y, Lemda, Lemda2);
				printf("%f\t", BendingEnergy);
				GenerateBlockDeform(BlockDeform, V, ptParm->BlockSize, DrivingPointNum_in_Block);

				/************************************************************************/
				/* Step3 Store the data                                                 */
				/************************************************************************/
				for(l=0;l<ptParm->BlockSize;l++)
				{
					z = min(Image_Z_Size-1, k+l);
					for(m=0;m<ptParm->BlockSize;m++)
					{
						x = min(Image_X_Size-1, i+m);
						for(n=0;n<ptParm->BlockSize;n++)
						{
							y = min(Image_Y_Size-1, j+n);
							DeformFld[z][x][y].x += BlockDeform[l][m][n].x;
							DeformFld[z][x][y].y += BlockDeform[l][m][n].y;
							DeformFld[z][x][y].z += BlockDeform[l][m][n].z;
							WeighImg[z][x][y] += 1.0;
						}
					}
				}//end of step 3
			}//end of i,j,k
			printf("\n");
		}
		printf("END of %d\n", k);
	}
	for(k=0;k<Image_Z_Size;k++)
		for(i=0;i<Image_X_Size;i++)
			for(j=0;j<Image_Y_Size;j++)
			{
				weight = WeighImg[k][i][j];
				if(weight > 0)
				{										
					//printf("(%d %d %d): ", i, j, k);
					//printf("Original: (%f %f %f)", OutputDeformFld[k][i][j].x, OutputDeformFld[k][i][j].y, OutputDeformFld[k][i][j].z);
					OutputDeformFld[k][i][j].z = DeformFld[k][i][j].z / weight;
					OutputDeformFld[k][i][j].x = DeformFld[k][i][j].x / weight;
					OutputDeformFld[k][i][j].y = DeformFld[k][i][j].y / weight;
					//printf("Ouptut: (%f %f %f)\n", OutputDeformFld[k][i][j].x, OutputDeformFld[k][i][j].y, OutputDeformFld[k][i][j].z);
				}
				else
				{
					OutputDeformFld[k][i][j].z = 0;
					OutputDeformFld[k][i][j].x = 0;
					OutputDeformFld[k][i][j].y = 0;
				}
			}
	
	Ifree3d(DrivingPointImage, Image_Z_Size, Image_Y_Size);
	Fvector3dfree3d(DeformFld, Image_Z_Size, Image_X_Size);
	Fvector3dfree3d(BlockDeform, ptParm->BlockSize, ptParm->BlockSize);
	Ffree3d(WeighImg, Image_Z_Size, Image_Y_Size);
	Ifree3d(BlockIndex, ptParm->BlockSize, ptParm->BlockSize);
	Ifree3d(PrevBlockIndex, ptParm->BlockSize, ptParm->BlockSize);
	free(Residual_Deform);
	free(Neighbor);
}

void HE_ALG_Registration::PrepareTPSKernel(vnl_matrix<double> FixedPoint, vnl_matrix<double> MovingPoint, int PointNum)
{
	int i, j;
	vnl_vector<double> v_ij;	

	TPS_Psi.set_size(PointNum, PointNum);
	for (int i=0;i<PointNum;i++)
	{
		for (int j=i;j<PointNum;j++)
		{
			v_ij = FixedPoint.get_row(i) - FixedPoint.get_row(j);
			double r = v_ij.two_norm();
			TPS_Psi(i,j) = -r;

		}
	}
	for (int i=0;i<PointNum;i++)
		for (int j=0;j<i;j++)
			TPS_Psi(i,j) = TPS_Psi(j,i);

#ifdef DEBUG_TPS
	FILE *Psi = myopen("Psi.txt", "wt");
	for(i=0;i<PointNum;i++)
	{
		for(j=0;j<PointNum;j++)
			fprintf(Psi, "%f ", TPS_Psi(i, j));
		fprintf(Psi, "\n");
	}
	fclose(Psi);
#endif

	vnl_qr<double> qr_FixedPoint(FixedPoint);
	Q1 = qr_FixedPoint.Q().extract(PointNum, 4, 0, 0);
	Q2 = qr_FixedPoint.Q().extract(PointNum, PointNum-4, 0, 4);
	R = qr_FixedPoint.R().extract(4, 4, 0, 0);
	vnl_svd<double> svd(R);
	inverse_R = svd.inverse();
#ifdef DEBUG_TPS
	vcl_cerr << R;
	vcl_cerr << inverse_R;

	FILE *q1=myopen("Q1.txt", "wt");
	for(i=0;i<PointNum;i++)
	{
		for(j=0;j<4;j++)
			fprintf(q1, "%f ", Q1(i,j));
		fprintf(q1, "\n");
	}
	fclose(q1);
	FILE *q2=myopen("Q2.txt", "wt");
	for(i=0;i<PointNum;i++)
	{
		for(j=0;j<PointNum-4;j++)
			fprintf(q2, "%f ", Q2(i,j));
		fprintf(q2, "\n");
	}
	fclose(q2);
#endif
}

double HE_ALG_Registration::UpdateTPSParameter(vnl_matrix<double> FixedCord, vnl_matrix<double> MovingCord, double Lemda, double Lemda2)
{
	int i, j;
	vnl_matrix<double> T, S, I, I4, Gamma;
	vnl_matrix<double> inverse_T;
	double BendingEnergy;

	I.set_size(FixedCord.rows()-4, FixedCord.rows()-4);
	I4.set_size(4, 4);
	I.set_identity();
	I4.set_identity();
	I = I*Lemda;
	T = Q2.transpose()*TPS_Psi*Q2 + I;
	
	vnl_svd<double> svd(T);
	inverse_T = svd.inverse();

	Gamma = inverse_T * Q2.transpose() * MovingCord;

#ifdef DEBUG_TPS
	FILE *Psi = myopen("Psi2.txt", "wt");
	for(i=0;i<308;i++)
	{
		for(j=0;j<308;j++)
			fprintf(Psi, "%f ", TPS_Psi(i, j));
		fprintf(Psi, "\n");
	}
	fclose(Psi);
	Psi = myopen("I304.txt", "wt");
	for(i=0;i<304;i++)
	{
		for(j=0;j<304;j++)
			fprintf(Psi, "%f ", I(i,j));
		fprintf(Psi, "\n");
	}
	fclose(Psi);
	Psi = myopen("gamma.txt", "wt");
	for(i=0;i<304;i++)
	{
		for(j=0;j<4;j++)
			fprintf(Psi, "%f ", Gamma(i,j));
		fprintf(Psi, "\n");
	}
	fclose(Psi);
	Psi = myopen("MovingPoint.txt", "wt");
	for(i=0;i<308;i++)
	{
		for(j=0;j<4;j++)
			fprintf(Psi, "%f ", MovingCord(i,j));
		fprintf(Psi, "\n");
	}
	fclose(Psi);
	Psi = myopen("T.txt", "wt");
	for(i=0;i<304;i++)
	{
		for(j=0;j<304;j++)
			fprintf(Psi, "%f ", T(i,j));
		fprintf(Psi, "\n");
	}	
	fclose(Psi);
#endif

	TPS_Param = Q2 * Gamma;
	//TPS_Affine = inverse_R * Q1.transpose() * (MovingCord - TPS_Psi*TPS_Param);
	//A = inv(R'*R + lamda2 * eye(length(R),length(R))) * ( R'*q1'*(y-K*q2*gamma) - R'*R);
	//d = A + eye(dim+1,dim+1);
	S = R.transpose()*R + Lemda2*I4;
	vnl_svd<double> svd2(S);
	TPS_Affine = svd2.inverse() * (R.transpose()*Q1.transpose()*(MovingCord-TPS_Psi*TPS_Param) - R.transpose()*R) + I4;

	BendingEnergy = vnl_trace(TPS_Param*MovingCord.transpose()) * Lemda;
#ifdef DEBUG_TPS
	printf("Affine matrix:\n");
	vcl_cerr << TPS_Affine;
	FILE *tps_parm = myopen("tps_parm.txt", "wt");
	for(i=0;i<308;i++)
	{
		for(j=0;j<4;j++)
			fprintf(tps_parm, "%f ", TPS_Param(i,j));
		fprintf(tps_parm, "\n");
	}
	fclose(tps_parm);
#endif
	return BendingEnergy;
}

void HE_ALG_Registration::GenerateBlockDeform(Fvector3d ***BlockDeformFld, vnl_matrix<double> FixedPoint, int BlockSize, int PointNum)
{
	int i, j, k, index;
	int Block_Point_Num;
	vnl_vector<double> v_ij;
	vnl_matrix<double> U, D;

	Block_Point_Num = BlockSize*BlockSize*BlockSize;
	U.set_size(Block_Point_Num, 4);
	TPS_Kernel.set_size(Block_Point_Num, PointNum);
	U.set_column(0, 1);
	index = 0;
	for(k=0;k<BlockSize;k++)
		for(i=0;i<BlockSize;i++)
			for(j=0;j<BlockSize;j++)
			{
				BlockDeformFld[k][i][j].x = 0;
				BlockDeformFld[k][i][j].y = 0;
				BlockDeformFld[k][i][j].z = 0;
				U(index,1) = i;
				U(index,2) = j;
				U(index,3) = k;
				index++;
			}
	//obtain the TPS Kernel
	for(i=0;i<Block_Point_Num;i++)
		for(j=0;j<PointNum;j++)
		{
			v_ij = U.get_row(i) - FixedPoint.get_row(j);
			double r = v_ij.two_norm();
			TPS_Kernel(i,j) = -r;
		}	

	D = U * TPS_Affine + TPS_Kernel * TPS_Param;
//	printf("D:\n");
// 	index = 0;
// 	for(k=0;k<BlockSize;k++)
// 		for(i=0;i<BlockSize;i++)
// 			for(j=0;j<BlockSize;j++)
// 			{
// 				printf("(%d %d %d) -> %f %f %f \n", i, j, k, D(index, 1), D(index,2), D(index,3));
// 				index++;
// 			}
	index = 0;
	for(k=0;k<BlockSize;k++)
		for(i=0;i<BlockSize;i++)
			for(j=0;j<BlockSize;j++)
			{
				BlockDeformFld[k][i][j].x = D(index, 1) - i;
				BlockDeformFld[k][i][j].y = D(index, 2) - j;
				BlockDeformFld[k][i][j].z = D(index, 3) - k;
				//printf("(%f %f %f) = (%f %f %f) - (%d %d %d)\n", BlockDeformFld[k][i][j].x, BlockDeformFld[k][i][j].y, BlockDeformFld[k][i][j].z, \
					D(index, 1), D(index, 2), D(index, 3), i, j, k);
				index++;
			}	
}

void HE_ALG_Registration::HierarchicalDeform3D_TPS_Regularization(Fvector3d *MdlVer, Ivector3d *FixedMdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, int image_size, int z_size, int resolution, HAMMER_Param *ptParm)
{
	int   i,j,k,g,l,m,n,old_count,num,how_many,max,size,t, SHIFT, incre, LocalM, scale, beforeN, SelectVerNum, vv, RealVV ;
	float weight, CurrentDegree, OverlapDegree, MaxDegree, AdaptiveFactor, DistSeg, MinDist ;
	Fvector3d Search, Crnt, Tmp, dfm, parallel, globl;
	float mag, factor, Delta, level, magDfm ;
	int   x,y,z, sx,sy,sz ;
	SubVolumnParm *p_SubVolumn_Parm, m_SubVolumn_Parm;
	TPSParm *p_TPS_Parm, m_TPS_Parm;
	int Template_Driving_Point_Index;
	float Lemda, Lemda2;

	/* Bubble for checking similarity */
	Ivector3d  StudiedPoint, Grid;
	Ivector3d  *Subvolumn_Matching_Area;
	int      Subvolumn_Matching_Size ;
	int      Subvolumn_Radius;
	/* Bubble for transforming subvolume */
	Ivector3d  *SubV_pnt;
	int        SubVNum, SubVsize, UsedVNum ;
	float      UsedGuassianSigma ;

	/* for local geometric features of 3D shape */
	float     CenterRate, LocalRatio ;
	Fvector3d *verModelLast, nbr_tot ;
	int       numTEMP, Last_searched_point, temp_num ;


	/* to speed up, the neighboring driving voxels are not necessary to deform for multiple times. */
	unsigned char ***SearchingStatus ;
	int           FilterSize ;

	/* June 5, 2001 */
	Fvector3d  ***DeformFld_Last, ***Deform_Increament;

	DeformFld_Last=Fvector3dalloc3d(image_size,image_size,z_size);	
	Deform_Increament = Fvector3dalloc3d(image_size, image_size, z_size);
	/* global constraints  */
	verModelLast      = Fvector3dalloc1d(MdlVer_Num); /* used as model */
	/* remember */
	for(numTEMP=0; numTEMP<MdlVer_Num; numTEMP++)
	{
		verModelLast[numTEMP].x=MdlVer[numTEMP].x; 
		verModelLast[numTEMP].y=MdlVer[numTEMP].y; 
		verModelLast[numTEMP].z=MdlVer[numTEMP].z;
	}
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
			{
				DeformFld_Last[k][i][j].z = DeformFld[k][i][j].z;
				DeformFld_Last[k][i][j].x = DeformFld[k][i][j].x;
				DeformFld_Last[k][i][j].y = DeformFld[k][i][j].y;
			}
	/* shift assigned */
	SHIFT = resolution/2 ; 
	if(SHIFT<1)
		SHIFT=1; 
	printf("Shift=%d\n", SHIFT) ;
	incre = 2*SHIFT/6; /*8, 20, May 2001*/ 
	if(incre<1) 
		incre=1 ;

	max = SHIFT+1 ;
	Subvolumn_Radius = max*2+1; /*nb_size should be odd number */ 
	Subvolumn_Matching_Area = Ivector3dalloc1d(Subvolumn_Radius*Subvolumn_Radius*Subvolumn_Radius) ;
	calculate_hood_byIncreasingRadius(Subvolumn_Matching_Area, Subvolumn_Radius, &Subvolumn_Matching_Size, 1., 1., 1.) ; 
	printf("nbr num:%d with rad %d\n", Subvolumn_Radius, Subvolumn_Matching_Size) ;
	/* May 24, 2001 */
	m_STEPNBR = Subvolumn_Matching_Size/20 ;  
	if(m_STEPNBR<1) 
		m_STEPNBR=1 ;
	p_SubVolumn_Parm = &m_SubVolumn_Parm;
	p_SubVolumn_Parm->Deform_Diffusion_Weight = Subvolumn_Radius;
	p_SubVolumn_Parm->Image_X_Size = image_size;
	p_SubVolumn_Parm->Image_Y_Size = image_size;
	p_SubVolumn_Parm->Image_Z_Size = z_size;
	p_SubVolumn_Parm->IsBigVN = ptParm->BigVN;
	p_SubVolumn_Parm->IsYoungBrain = ptParm->YoungBrain;
	p_SubVolumn_Parm->Point_Similarity_Threshold = SMR_THR;
	p_SubVolumn_Parm->Search_Step = incre;
	p_SubVolumn_Parm->Step_of_NBR = m_STEPNBR;
	p_SubVolumn_Parm->Search_Radius = SHIFT;
	p_SubVolumn_Parm->Smooth_Factor = ptParm->smoothFactor;
	p_SubVolumn_Parm->Deform_Rate = ptParm->Deform_RATE;
	p_SubVolumn_Parm->CurrentLevel = ptParm->Current_Level;
	p_SubVolumn_Parm->SubVolumn_Similarity_Threshold = ptParm->MatchingDegreeOfMdlOnImgEdge;

	printf("############### Subvolumn Parameters ####################\n");

	PrintSubVolumnParm(p_SubVolumn_Parm);
	printf("########################################################\n");


	/* for transformation in Subvolume */
	SubVsize = 41 ; /* nb_size+2*0 */
	SubV_pnt = Ivector3dalloc1d(SubVsize*SubVsize*SubVsize) ;
	calculate_hood_byIncreasingRadius(SubV_pnt, SubVsize, &SubVNum, 1., 1., 1.) ; 
	printf("Subvolume num:%d with rad %d\n", SubVsize, SubVNum) ;
	t = 0;   /* 3 8 */ /* 0 ~ 9*/
	t = resolution/10 ;if(t>2) t=2 ;
	SelectVerNum = MdlVer_Num ;
	printf("incre=%d  max=%d   searched Num=%d    t=%d\n", incre, max, SelectVerNum, t ) ;
	/* Feb 27, 2002: To speed up, the neighboring driving voxels are not necessary to deform for multiple times. */
	SearchingStatus = UCalloc3d(image_size, image_size, z_size);
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
				SearchingStatus[k][i][j]=OOK ;
	/* get the forces from the landmarks */

	printf("before ObjVer_Num=%d\n", ObjVer_Num) ;
	if(ratio_iteration<=ITER_THRD && ptParm->UsingForcesFromObject==true) 
		FindForceFromObject(ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg, MdlVer, MdlVer_Num, MdlVer_Fea, FixedMdlVer, MdlImg, DeformFld, SHIFT+1, ptParm);
	//SearchTheNearestVertexForEachLandmark_March2003(ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg,    MdlVer, MdlVer_Num, MdlVer_Fea, FixedMdlVer, MdlImg, DeformFld,  image_size, z_size,  SHIFT+1) ;
	/*SearchTheNearestVertexForEachLandmark_NewFeb2002(ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg,   MdlVer, MdlVer_Num, MdlVer_Fea, MdlImg, DeformFld, image_size, z_size) ; used before March 2003*/
	/*SearchTheNearestVertexForEachLandmark( ObjVer, ObjVer_Num, ObjVer_Fea, MdlVer, MdlVer_Num, MdlVer_Fea, image_size, z_size ) ;*/



	RealVV = 0 ;
	printf("################# START LOCAL CORRESPONDENCE DETECTON############################\n");

	for(vv=0; vv<MdlVer_Num; vv+=STEPPNT)  /*for(s=0; s<MdlVer_Num; s+=STEPPNT)*/
	{
		Template_Driving_Point_Index = (vv+Start_Search_Point)%MdlVer_Num ; 

		if( (RealVV<SelectVerNum || Fvector3dmag(forceByFocusedPntInObj[Template_Driving_Point_Index])!=0) && SearchingStatus[FixedMdlVer[Template_Driving_Point_Index].z][FixedMdlVer[Template_Driving_Point_Index].x][FixedMdlVer[Template_Driving_Point_Index].y]==OOK )
		{
			RealVV ++ ;
			Last_searched_point = Template_Driving_Point_Index ;
#ifdef DUMP_DATA
			if( Template_Driving_Point_Index%100==0 )
			{ 
				printf("\ns=%d  Last_searched_point= %d   ", Template_Driving_Point_Index, Last_searched_point) ;
				printf("percent finished = %f\n", (float)RealVV/SelectVerNum) ; 
			}
#endif

			if( Fvector3dmag(forceByFocusedPntInObj[Template_Driving_Point_Index])==0 || ratio_iteration>ITER_THRD)
			{
				dfm.x = 0 ;
				dfm.y = 0 ; 
				dfm.z = 0 ;
				p_SubVolumn_Parm->MinDist = 1000000000.0;
				p_SubVolumn_Parm->Subvolumn_Similarity = 0;
				if(ptParm->Soft_Correspondence == true)
					SoftCorrespondenceDetection(MdlImg, ObjImg, MdlVer_Fea, ObjVer_Fea, DeformFld, FixedMdlVer[Template_Driving_Point_Index], Template_Driving_Point_Index, &dfm, Subvolumn_Matching_Area, Subvolumn_Matching_Size, p_SubVolumn_Parm);
				else
					CorrespondenceDetection(MdlImg, ObjImg, MdlVer_Fea, ObjVer_Fea, DeformFld, FixedMdlVer[Template_Driving_Point_Index], Template_Driving_Point_Index, &dfm, Subvolumn_Matching_Area, Subvolumn_Matching_Size, p_SubVolumn_Parm);
				MaxDegree = p_SubVolumn_Parm->Subvolumn_Similarity;
			}//end of if ( Fvector3dmag(forceByFocusedPntInObj[s])==0 || ratio_iteration>ITER_THRD)
			else
			{
				MaxDegree = 10000.0 ;

				x = FixedMdlVer[Template_Driving_Point_Index].x ;
				y = FixedMdlVer[Template_Driving_Point_Index].y ;
				z = FixedMdlVer[Template_Driving_Point_Index].z ;

				if(ptParm->Soft_Correspondence ==  true)
				{
					dfm.x = (DeformFld_Last[z][x][y].x-DeformFld[z][x][y].x+forceByFocusedPntInObj[Template_Driving_Point_Index].x) ; 
					dfm.y = (DeformFld_Last[z][x][y].y-DeformFld[z][x][y].y+forceByFocusedPntInObj[Template_Driving_Point_Index].y) ;
					dfm.z = (DeformFld_Last[z][x][y].z-DeformFld[z][x][y].z+forceByFocusedPntInObj[Template_Driving_Point_Index].z) ;
				}
				else
				{
					dfm.x = (DeformFld_Last[z][x][y].x-DeformFld[z][x][y].x+forceByFocusedPntInObj[Template_Driving_Point_Index].x)*(1.0+(1+ratio_iteration))/2. ;  /*5.*/
					dfm.y = (DeformFld_Last[z][x][y].y-DeformFld[z][x][y].y+forceByFocusedPntInObj[Template_Driving_Point_Index].y)*(1.0+(1+ratio_iteration))/2. ;	    
					dfm.z = (DeformFld_Last[z][x][y].z-DeformFld[z][x][y].z+forceByFocusedPntInObj[Template_Driving_Point_Index].z)*(1.0+(1+ratio_iteration))/2. ; /* May 2001 */
					/*printf("dfm=(%f,%f,%f)\n", dfm.x, dfm.y, dfm.z) ;*/

					/* scale it */
					magDfm = Fvector3dmag(dfm) ;
					if( magDfm>Subvolumn_Radius/2 ) 
					{
						dfm.x = dfm.x/magDfm*(Subvolumn_Radius/2) ;
						dfm.y = dfm.y/magDfm*(Subvolumn_Radius/2) ;
						dfm.z = dfm.z/magDfm*(Subvolumn_Radius/2) ;
					}
				}

			}

			if( MaxDegree>ptParm->MatchingDegreeOfMdlOnImgEdge )
			{
#ifdef DUMP_DATA
				if( Template_Driving_Point_Index%100==0 )
				{
					printf("%d->   OL(%d)=%f: (%f,%f,%f)\n", SelectVerNum, Template_Driving_Point_Index, MaxDegree, dfm.x, dfm.y, dfm.z) ;
				}
#endif
				UsedVNum = Subvolumn_Matching_Size;
				UsedGuassianSigma = Subvolumn_Radius ;
#ifdef DUMP_DATA
				if( Template_Driving_Point_Index%100==0 )
					printf("MaxDegree=%f   Current Sigma =%f  volNum=%d\n", MaxDegree, UsedGuassianSigma, UsedVNum) ;
#endif

				/* Begin to deform the subvolume at Gaussian way */
				WarpSubVolume(FixedMdlVer, DeformFld, dfm, Template_Driving_Point_Index, SubV_pnt, UsedVNum, UsedGuassianSigma, p_SubVolumn_Parm);
			}//end of else
		}//end of if( (RealVV<SelectVerNum || Fvector3dmag(forceByFocusedPntInObj[s])!=0) && SearchingStatus[FixedMdlVer[s].z][FixedMdlVer[s].x][FixedMdlVer[s].y]==OOK ) 
	}//end of vv loop


	Start_Search_Point = Last_searched_point ;

	/* get update MdlVer's position from the DeformFld, for estimating global transformation*/
	for(Template_Driving_Point_Index=0; Template_Driving_Point_Index<MdlVer_Num; Template_Driving_Point_Index++)
	{  
		x = FixedMdlVer[Template_Driving_Point_Index].x ;
		y = FixedMdlVer[Template_Driving_Point_Index].y ;
		z = FixedMdlVer[Template_Driving_Point_Index].z ;
		MdlVer[Template_Driving_Point_Index].x = DeformFld[z][x][y].x;// + x ;
		MdlVer[Template_Driving_Point_Index].y = DeformFld[z][x][y].y;// + y ;
		MdlVer[Template_Driving_Point_Index].z = DeformFld[z][x][y].z;// + z ;
	}

	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
			{				
				//DeformFld_Last[k][i][j].x = 0 ;
				//DeformFld_Last[k][i][j].y = 0 ;
				//DeformFld_Last[k][i][j].z = 0 ;
				Deform_Increament[k][i][j].x = 0;
				Deform_Increament[k][i][j].y = 0;
				Deform_Increament[k][i][j].z = 0;				
 				DeformFld[k][i][j].x = DeformFld_Last[k][i][j].x;
 				DeformFld[k][i][j].y = DeformFld_Last[k][i][j].y;
 				DeformFld[k][i][j].z = DeformFld_Last[k][i][j].z;
			}

	p_TPS_Parm = &m_TPS_Parm;
	p_TPS_Parm->MaxTPSPoint = ptParm->MaxTPSPoint;
	p_TPS_Parm->TPS_Lemda = ptParm->TPS_Lemda;
	p_TPS_Parm->Residual_Tolerance = ptParm->Residual_Tolerance;
	Lemda = p_TPS_Parm->TPS_Lemda * (1.1 - ratio_iteration);
	Lemda2 = Lemda*0.1;
	for(l=0;l<ptParm->TPS_Decomposition_Level;l++)
	{
		p_TPS_Parm->BlockSize = ptParm->BlockSize>>l;
		p_TPS_Parm->OverStep = min(p_TPS_Parm->BlockSize-2, (ptParm->OverStep>>l));		
		GenerateDeformationbyTPS(DeformFld_Last, Deform_Increament, MdlVer, FixedMdlVer, MdlVer_Num, image_size, image_size, z_size, Lemda, Lemda2, p_TPS_Parm);
		for(k=0;k<z_size;k++)
			for(i=0;i<image_size;i++)
				for(j=0;j<image_size;j++)
				{
					DeformFld[k][i][j].x += Deform_Increament[k][i][j].x;
					DeformFld[k][i][j].y += Deform_Increament[k][i][j].y;
					DeformFld[k][i][j].z += Deform_Increament[k][i][j].z;
					DeformFld_Last[k][i][j].x = DeformFld[k][i][j].x ;
					DeformFld_Last[k][i][j].y = DeformFld[k][i][j].y ;
					DeformFld_Last[k][i][j].z = DeformFld[k][i][j].z ;
					Deform_Increament[k][i][j].x = 0;
					Deform_Increament[k][i][j].y = 0;
					Deform_Increament[k][i][j].z = 0;
				}
	}
	for(Template_Driving_Point_Index=0; Template_Driving_Point_Index<MdlVer_Num; Template_Driving_Point_Index++)
	{  
		x = FixedMdlVer[Template_Driving_Point_Index].x ;
		y = FixedMdlVer[Template_Driving_Point_Index].y ;
		z = FixedMdlVer[Template_Driving_Point_Index].z ;
		DeformFld[z][x][y].x = MdlVer[Template_Driving_Point_Index].x;
		DeformFld[z][x][y].y = MdlVer[Template_Driving_Point_Index].y;
		DeformFld[z][x][y].z = MdlVer[Template_Driving_Point_Index].z;
	}

	SmoothDeformationFieldWithEdgePreserving(FixedMdlVer, MdlVer_Num, DeformFld_Last, MdlImg, image_size, z_size, ratio_iteration, ptParm);

	//remove the deformation on background 
	for(k=0;k<z_size;k++)
		for(i=0;i<image_size;i++)
			for(j=0;j<image_size;j++)
			{
				if(MdlImg[k][i][j].Tiss == 0)
				{
					DeformFld[k][i][j].z = 0;
					DeformFld[k][i][j].x = 0;
					DeformFld[k][i][j].y = 0;
				}
			}
	
	
#ifdef DUMP_DEFORMATION_EVERY_ITER
	WriteDeformationField("DeformationField.Temp", DeformFld, image_size, z_size);
#endif
	/* focused edge points in the model */
	for(Template_Driving_Point_Index=0; Template_Driving_Point_Index<MdlVer_Num; Template_Driving_Point_Index++)
	{  
		x = FixedMdlVer[Template_Driving_Point_Index].x ;
		y = FixedMdlVer[Template_Driving_Point_Index].y ;
		z = FixedMdlVer[Template_Driving_Point_Index].z ;

		MdlVer[Template_Driving_Point_Index].x = DeformFld[z][x][y].x + x ;
		MdlVer[Template_Driving_Point_Index].y = DeformFld[z][x][y].y + y ;
		MdlVer[Template_Driving_Point_Index].z = DeformFld[z][x][y].z + z ;
	}
	/* free */
	free(Subvolumn_Matching_Area) ;
	free(SubV_pnt) ;	
	UCfree3d(SearchingStatus, z_size, image_size) ;
	/* geometric */
	free(verModelLast) ;		
	Fvector3dfree3d(DeformFld_Last, z_size, image_size) ;
	Fvector3dfree3d(Deform_Increament, z_size, image_size);
}
