#include "Hammer_Def.h"
#include "common.h"

Definition_of_HAMMER::Definition_of_HAMMER()
{
	SetDefaultParm();
}

Definition_of_HAMMER::~Definition_of_HAMMER()
{

}

void Definition_of_HAMMER::ObtainParm(int argc, char *argv[], int MinParm)
{
	char acString[256];
	//char ModelDir[300], ObjFile[300], OutputDir[300];

	if(argc<=MinParm)
	{
		PrintUsage(argv[0]);
		exit(0);
	}
	SetDefaultParm();

	ARG_GET_PROGNAME(argv, pcProgramName);

	sprintf(TemplateFileName, "%s", argv[1]);
	sprintf(SubjectFileName, "%s", argv[2]);
	sprintf(WarpedFileName, "%s", argv[3]);
	argv+=(MinParm+1);
	argc-=(MinParm+1);
	while(argc>0)
	{
		if((*argv)[0]=='-')
		{
			if(!strcmp(*argv, "-R"))  //1
				ARG_GET_FLOAT(argc, argv, Deform_RATE , pcProgramName )
			else if(!strcmp(*argv, "-r"))  //2
			{
				NEXT_ARG(argc, argv, pcProgramName);
				sscanf(*argv, "%d,%d,%d", &search_resolution[LOW_LEVEL], &search_resolution[MID_LEVEL], &search_resolution[HIGH_LEVEL]);
				//ARG_GET_INT(argc, argv, ptParam->search_resolution[LOW_LEVEL], ptParam->pcProgramName )
				//ARG_GET_INT(argc, argv, ptParam->search_resolution[MID_LEVEL], ptParam->pcProgramName )
				//ARG_GET_INT(argc, argv, ptParam->search_resolution[HIGH_LEVEL], ptParam->pcProgramName )
			}
			else if(!strcmp(*argv, "-i"))  //3
				ARG_GET_INT(argc, argv, iter , pcProgramName )			
			else if(!strcmp(*argv, "-a"))  //5
			ARG_GET_FLOAT(argc, argv, Affine_Degree , pcProgramName )
			else if(!strcmp(*argv, "-m"))  //6
			ARG_GET_FLOAT(argc, argv, MatchingDegreeOfMdlOnImgEdge, pcProgramName )
			else if (!strcmp(*argv, "-t"))
			ARG_GET_FLOAT(argc, argv, PointSimilarity, pcProgramName)
			else if(!strcmp(*argv, "-e"))  //7
			ARG_GET_BOOL(EstimateTransformOrNot , pcProgramName )
			else if(!strcmp(*argv, "-c"))  //8
			ARG_GET_FLOAT(argc, argv, smoothFactor , pcProgramName )
			else if(!strcmp(*argv, "-F"))  //10
			ARG_GET_BOOL(OpenDeformationFieldFromLastScale , pcProgramName )
			else if(!strcmp(*argv, "-E"))  //11
			ARG_GET_INT(argc, argv, SmoothingTimes , pcProgramName )
			else if(!strcmp(*argv, "-N"))  //12
			ARG_GET_BOOL(UsingForcesFromObject , pcProgramName )
			else if(!strcmp(*argv, "-U")) //13
			ARG_GET_BOOL(InitialUpdate , pcProgramName )
			else if(!strcmp(*argv, "-X")) //14
			ARG_GET_INT(argc, argv, Img_XY , pcProgramName )
			else if(!strcmp(*argv, "-C"))  //15
			ARG_GET_FLOAT(argc, argv, ConfidenceOnLastDeformation , pcProgramName )
			else if(!strcmp(*argv, "-O"))  //16
			{
				InputOriginalObjImg = true;
				ARG_GET_STRING(argc, argv, ObjOriginalImgFile , pcProgramName )
			}		
			else if(!strcmp(*argv, "-B"))  //18
				ARG_GET_BOOL(BigVN , pcProgramName )  
			else if(!strcmp(*argv, "-Y"))  //19
				ARG_GET_BOOL(YoungBrain , pcProgramName )
			else if(!strcmp(*argv, "-T"))  //20
				ARG_GET_BOOL(OutputTemporayResults, pcProgramName)
			else if(!strcmp(*argv, "-D"))
				ARG_GET_STRING(argc, argv, OutputDir, pcProgramName)
			else if(!strcmp(*argv, "-h"))  //21
				PrintUsage(pcProgramName );			
			else if(!strcmp(*argv, "-p"))
			{
				NEXT_ARG(argc, argv, pcProgramName);
				sscanf(*argv, "%f,%d", DfmSmthCoeff, DfmSmthTimes);
				//ARG_GET_FLOAT(argc, argv, ptParam->DfmSmthCoeff , ptParam->pcProgramName )
				//ARG_GET_INT(argc, argv, ptParam->DfmSmthTimes , ptParam->pcProgramName )
			}
			else if(!strcmp(*argv, "-S"))
				ARG_GET_BOOL(Soft_Correspondence, pcProgramName)
			else if(!strcmp(*argv, "-A"))
			ARG_GET_INT(argc, argv, AdditionalSmth, pcProgramName)
			else if(!strcmp(*argv, "-TPS"))
			ARG_GET_BOOL(UsingTPSRegularization, pcProgramName)
			else if(!strcmp(*argv, "-b"))
			ARG_GET_INT(argc, argv, BlockSize, pcProgramName)
			else if(!strcmp(*argv, "-l"))
			ARG_GET_FLOAT(argc, argv, TPS_Lemda, pcProgramName)
			else if(!strcmp(*argv, "-o"))
			ARG_GET_INT(argc, argv, OverStep, pcProgramName)
			else if(!strcmp(*argv, "-n"))
			ARG_GET_INT(argc, argv, MaxTPSPoint, pcProgramName)
			else if(!strcmp(*argv, "-tps_e"))
			ARG_GET_FLOAT(argc, argv, Residual_Tolerance, pcProgramName)
			else if(!strcmp(*argv, "-tps_l"))
			ARG_GET_INT(argc, argv, TPS_Decomposition_Level, pcProgramName)
			else
			ARG_UNKNOWN(argv, pcProgramName )
			++argv; --argc;
		}
		else
			ARG_UNKNOWN(argv, pcProgramName )
	}//while (argc>0)
}

void Definition_of_HAMMER::SetDefaultParm()
{
	sprintf(TemplateFileName, "%s", "TEMPLATE");
	sprintf(SubjectFileName, "%s", "SUBJECT");
	sprintf(WarpedFileName, "%S", "RESULT");
	Deform_RATE = 0.05;
	search_resolution[LOW_LEVEL] = 12;
	search_resolution[MID_LEVEL] = 10;
	search_resolution[HIGH_LEVEL] = 8;
	iter = 50;
	XYZres = 1.0;
	Affine_Degree = 0.2;
	MatchingDegreeOfMdlOnImgEdge = 0.6;
	PointSimilarity = 0.8;
	EstimateTransformOrNot = false;
	smoothFactor = 0.01;
	SmoothingTimes = 1;
	OpenDeformationFieldFromLastScale = false;
	UsingForcesFromObject = false;
	InitialUpdate = false;
	Img_XY = 256;
	ConfidenceOnLastDeformation = 0;
	InputOriginalObjImg = false;
	BigVN = false;
	YoungBrain = false;
	OutputTemporayResults = false;
	DfmSmthTimes = 1;
	DfmSmthCoeff = 0.5;
	Soft_Correspondence = false;
	AdditionalSmth = 3;
	UsingTPSRegularization = false;
	BlockSize = 36;
	OverStep = 32;
	TPS_Lemda = 0.1;
	MaxTPSPoint = 100;
	TPS_Decomposition_Level = 3;
	Residual_Tolerance = 0.05;
}

void Definition_of_HAMMER::PrintUsage(const char *pcProgramName)
{
	int i;
	fprintf(stderr, "\n Usage: %s Template_File Subject_Seg_File ", pcProgramName);
	for(i=0;apcHelpInfo[i];i++)
		fprintf(stderr, "%s", apcHelpInfo[i]);

	fprintf(stderr, acVersion);
	exit(EXIT_FAILURE);
}