#ifndef COMMON_H
#define COMMON_H

#define HAMMER_WIN32

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mvcd.h"
#include "cres.h"
#include "matrixSHEN.h"  /*by SHEN*/


#define SQR(a) ((a)*(a))
#define max(a,b) ((a)>(b)?(a):(b))
#define min(a,b) ((a)<(b)?(a):(b))
#define _FMAX 9999999999999999999999999999999999999999999999999999999999999999.99
#define _FMIN -9999999999999999999999999999999999999999999999999999999999999999.9

#define NEXT_ARG(argc, argv, progname)\
	{\
	++(argv), --(argc);\
	if(argc==0)\
	{\
	fprintf(stderr, "\nError: missing argument for option[%s].\n", (--(argv))[0]);\
	PrintUsage(progname);\
	}\
	}

#define ARG_UNKNOWN(argv, progname)\
	{\
	fprintf(stderr, "\nError: unknown option [%s].\n", *argv);\
	PrintUsage(progname);\
	}

#define ARG_GET_PROGNAME(argv, progname)\
	{\
	int sl=strlen(*argv);\
	for(progname = *argv+sl-1;progname != *argv; progname--)\
	if(*progname=='/' || *progname=='\\') {progname++; break;}\
	}

#define ARG_GET_FILENAME(argc, argv, fileanme, mode, progname)\
	{\
	NEXT_ARG(argc, argv, progname);\
	filename=*argv;\
	CHECK_FILE_ACCESS(filename, mode, progname)\
	}

#define ARG_GET_STRING(argc, argv, str, progname)\
	{\
	NEXT_ARG(argc, argv, progname);\
	sprintf(str, "%s", *argv);\
	}

#define ARG_GET_INT(argc, argv, var, progname)\
	{\
	NEXT_ARG(argc, argv, progname);\
	var=atoi(*argv);\
	}

#define ARG_GET_FLOAT(argc, argv, var, progname)\
	{\
	NEXT_ARG(argc, argv, progname);\
	var=(float)atof(*argv);\
	}

#define ARG_GET_BOOL(var, progname)\
	{\
	var=YYES;\
	}

#define CHECK_FILENAME(filename, description, progname)\
	{\
	if((filename==NULL)\
	{\
	fprintf(stderr, "\nError: No %s file.\n", description);\
	PrintUsage(progname);\
	}\
	if((filename[0]==0))\
	{\
	fprintf(stderr, "\nError: No %s files.\n", description);\
	PrintUsage(progname);\
	}\
	}

#define CHECK_FILE_ACCESS(fileaname, mode, progname)\
	{\
	FILE *file;\
	if((file=fopen(filename, mode))==NULL)\
	{\
	fprintf(stderr, "\nError: Can't open file %s.\n", filename);\
	PrintUsage(progname);\
	}\
	fclose(fp);\
	}

//for the utility functions
void NormalizeVector(float *kern, int kern_size);
void NormalizeFImg(float ***Img, int x_size, int y_size, int z_size);
void ReadUCImg(char *filename, unsigned char ***Img, int x_size, int y_size, int z_size);
void UCImg2FImg(unsigned char ***UCImg, float ***FImg,int x_size, int y_size, int z_size, int need_normalize);
void FImg2UCImg(float ***FImg, unsigned char ***UCImg, int x_size, int y_size, int z_size, int need_normalize);
void WriteUCImg(char *filename, unsigned char ***Img, int x_size, int y_size, int z_size);
void ReadFloatImg(char *filename, float ***Img, int x_size, int y_size, int z_size);
void WriteFloatImg(char *filename, float ***Img, int x_size, int y_size, int z_size);
void ReadIntImg(char *filename, int ***Img, int x_size, int y_size, int z_size);
void WriteIntImg(char *filename, int ***Img, int x_size, int y_size, int z_size);
void ReadDeformationField(char *filename, Fvector3d ***Deform, int x_size, int y_size, int z_size, bool HasHeadInfo);
void WriteDeformationField(char *filename, Fvector3d ***Deform, int x_size, int y_size, int z_size, bool HasHeadInfo);
unsigned char InterpolatedIntensity(float ii, float jj, float kk, unsigned char ***Img, int y_size, int x_size, int z_size);
void WarpIntensityImage(unsigned char ***OriginalImage, unsigned char ***WarpedImage, Fvector3d ***Deform, int x_size, int y_size, int z_size);
void EnlargeImage(char *InputFile, char *OutputFile, int input_X, int input_Y, int input_Z, int output_X, int output_Y, int output_Z);
void ConvertUCImg2FImg(char *UC_Img_FileName, char *F_Img_FileName, int x_size, int y_size, int z_size);
void ConvertFImg2UCImg(char *F_Img_FileName, char *UC_Img_FileName, int x_size, int y_size, int z_size);
float FindMaxInQueue(float *Queue, int *index, int Num);
void DownSampleImage(char *FileName, char *OutFileName, int x_size, int y_size, int z_size, int Down_Scale);
void NearestUpSampleImage(char *InputFileName, char *OutputFileName, int x_size, int y_size, int z_size, int Up_Scale);

#endif
