
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#include "itkOrientedImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"

#include "itkOrientImageFilter.h"

typedef itk::OrientedImage<unsigned char, 3> ImageType;

int main( int argc, char *argv[] )
{

  itk::ImageFileReader<ImageType>::Pointer imageReader = itk::ImageFileReader<ImageType>::New();
  imageReader->SetFileName( argv[1] );
  imageReader->Update();
  ImageType::Pointer image = imageReader->GetOutput();

  // set the right direction cosine
  ImageType::DirectionType directions;
  directions[0][0] = 1;   directions[0][1] = 0;   directions[0][2] = 0; 
  directions[1][0] = 0;   directions[1][1] = 0;   directions[1][2] = 1; 
  directions[2][0] = 0;   directions[2][1] = -1;  directions[2][2] = 0; 

  image->SetDirection( directions );

  itk::OrientImageFilter<ImageType, ImageType>::Pointer orient = itk::OrientImageFilter<ImageType, ImageType>::New();
  orient->SetInput( image );
  orient->SetDesiredCoordinateOrientation( itk::SpatialOrientation::ITK_COORDINATE_ORIENTATION_RPS );

  itk::ImageFileWriter<ImageType>::Pointer wImage = itk::ImageFileWriter<ImageType>::New();
  wImage->SetFileName( argv[2] );
  wImage->SetInput( orient->GetOutput() );

  try
    {
    wImage->Update();
    }
  catch (itk::ExceptionObject * ob)
    {
    std::cerr << ob << std::endl;
    }
  return 0;
}


