#ifndef afcm_grid_regression_h_
#define afcm_grid_regression_h_

#include <vcl_vector.h>

#include <3d_image/3d_image_base.h>

//===================================================================
// Regression on grid block intensity

void grid_regression_linear (const vcl_vector<vcl_vector<float> >& centroid_v_grid,
                             const vcl_vector<ImageType::IndexType>& grid_center_index,
                             vnl_matrix<double>& B);

void grid_regression_quadratic (const vcl_vector<vcl_vector<float> >& centroid_v_grid,
                                const vcl_vector<ImageType::IndexType>& grid_center_index,
                                vnl_matrix<double>& B);

//===================================================================

void centroid_linear_fit (const vcl_vector<ImageType::IndexType>& grid_center_index,  
                          const vnl_matrix<double>& B, 
                          vcl_vector<float>& centroid_vn_grid);

void centroid_quadratic_fit (const vcl_vector<ImageType::IndexType>& grid_center_index,  
                             const vnl_matrix<double>& B, 
                             vcl_vector<float>& centroid_vn_grid);

bool test_1st_convergence (const vnl_matrix<double>& B);

bool test_2nd_convergence (const vnl_matrix<double>& B);

#endif