#include <itkVariableLengthVector.h>
#include <iostream>
#include <fstream>
#include <string>
#include <list>
//#include <itkImage.h>
#include <itkOrientedImage.h>
#include <itkImageFileReader.h>
#include "itkNumericsListSample.h"
#include <itkMembershipSample.h>

#include "itkSupportVectorMachine.h"
#include "itkSVMSolver1.h"

class SVMTrainer
{
public:

typedef double                                      ValueType;
typedef itk::VariableLengthVector<ValueType>       MeasurementVectorType;
typedef itk::Statistics::NumericsListSample<MeasurementVectorType> SampleType;
typedef itk::Statistics::SupportVectorMachine<MeasurementVectorType>        SVMType;
typedef itk::Statistics::SVMSolver1<SampleType, SampleType>SVMSolverType;
typedef itk::VariableLengthVector<double>          TargetVectorType;

#ifdef SVM_WRITE
typedef itk::SVMFileWriter<MeasurementVectorType, TargetVectorType>  SVMWriterType;
#endif // SVM_WRITE
typedef double                                        ClassLabelType;
typedef itk::VariableLengthVector<ClassLabelType>  LabelVectorType;


typedef std::vector<std::string> StringVectorType;  

SVMTrainer(){};
~SVMTrainer(){};


bool ParseSVMKernel( SampleType::Pointer sample, SVMType::Pointer svm,
               const std::string& kernelTypeString,
               const std::vector<std::string>& kernelParameters);


void Training(std::string& kernelType, StringVectorType& kernelParameters, std::ostringstream& svmOutputFilename, std::string&  svmOutputFormat, std::string& trainfilename, float epsilon);



private:

protected:
};
