#ifndef __itkAffineRegistration_h
#define __itkAffineRegistration_h

#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <cstdio>

#include <cstdlib>

#include "math.h"
#include "set"


#include <math.h>
#include <stdlib.h>

#include <itkOrientedImage.h>
#define ORIENT

template <class TImage>
class myAffReg
{

public:

  /** ImageDimension enumeration */
  itkStaticConstMacro(ImageDimension, unsigned int,
                        TImage::ImageDimension);
  typedef TImage ImageType;
  typedef typename TImage::PixelType PixelType;
  typedef typename ImageType::Pointer ImagePointerType;


  int myregistration(ImageType *outputimage);
  int mytransformation(std::string& fixedimagename, std::string& movingimagename, std::string& outimagename, std::string& transformname);

  int  DoIt(TImage *outputimage);

  void SetHistogramBin(int histbin);
  void SetSpatialSamples(int spatialsample);
  void SetIteration(int iter);
  void SetTransScale(double transscale);

  void SetInitTransform(std::string& inittrans);
  void SetOutputTransform(std::string& outtrans);
  void SetFixedImage(ImageType *fixedimage);
  void SetMovingImage(ImageType *movingimage);
  void SetOutputImageFilename(std::string& outimagename);

  TImage* GetRegisteredImage();

  myAffReg(){};
  ~myAffReg(){};


private:

  int m_HistogramBins;
  int m_SpatialSamples;
  int m_Iterations;
  double m_TranslationScale ;
  std::string m_InitialTransform;
  std::string m_OutputTransform;
  //    std::string m_FixedImageFileName;
  //    std::string m_MovingImageFileName;

  ImagePointerType m_FixedImage;
  ImagePointerType m_MovingImage;

  ImagePointerType m_OutputImage;

  std::string m_ResampledImageFileName;
  //    bool echoSwitch;
  //    bool xmlSwitch;
  //    std::string processInformationAddressString;


protected:

};

#ifndef ITK_MANUAL_INSTANTIATION
#include "itkAffineRegistration.txx"
#endif

#endif
