#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <cstdio>

#include <cstdlib>
#include "math.h"
#include "set"


#include <math.h>
#include <stdlib.h>

#include <itkHistogram.h>

#include "itkScalarImageToHistogramGenerator.h"


class HistMatch
{

public:
  typedef short InputPixelType;
  typedef itk::Image< InputPixelType, 3 >   InputImageType;

  typedef itk::Statistics::ScalarImageToHistogramGenerator<
                                 InputImageType >   HistogramGeneratorType;

  typedef HistogramGeneratorType::HistogramType  HistogramType;
  typedef itk::Statistics::Histogram< float > myHistogramType ;
  typedef itk::VariableLengthVector<float> FloatVectorType;

HistMatch(){};
~HistMatch(){};

void matching(std::string& inputVolume, std::string& referenceVolume, std::string& outputVolume, bool is_flair);
//template<class T> int DoIt();
int DoIt(std::string& inputVolume, std::string& referenceVolume, std::string& outputVolume);
void LinearlyInterpolateHistogram(myHistogramType::Pointer histo);

void smooth_histogram_byMedianFilter(myHistogramType::Pointer histo);

float medianvalue(FloatVectorType vec, int len);

void mysort(FloatVectorType vec, int len);

float GetMax(FloatVectorType vec, int len);

void Vector_Normalization(myHistogramType::Pointer vec, int len);

void vector_transform(myHistogramType::Pointer vec, int len, float s, int t);
void vector_InverseTransform(myHistogramType::Pointer vec, int len, float s, int t);

float  vector_distance(myHistogramType::Pointer vec1, myHistogramType::Pointer vec2, int len);

void ThresholdFlairHistogram (HistogramType* histo);

void        LinearlyInterpolateHistogram(float *histo);
void        smooth_histogram_byMedianFilter(float *histo);
float       medianvalue(float *vec, int len);
void        mysort(float *vec, int len);
void        MatchingTwoImages3D(int argc, char *argv[]);
float       vector_distance(float *vec1, float *vec2, int len);
void        vector_transform(float *vec, int len, float s, int t);
void        vector_InverseTransform(float *vec, int len, float s, int t);
float       GetMax(float *vec, int len) ;
void        Vector_Normalization(float *vec, int len) ;
void        ThresholdFlairHistogram(float *histo);



private:

int m_IsFlair;

protected:


};
