#ifndef __itkRemoveEyeRegion_txx
#define __itkRemoveEyeRegion_txx

#include "itkRemoveEyeRegion.h"

using namespace std;



#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkRescaleIntensityImageFilter.h"
#include "itkOutputWindow.h"
#include "itkTextOutput.h"
#include "itkImageDuplicator.h"

#include <iostream>
#include <sstream>
#include <vector>
#include <string>

#include <math.h>
#include <stdlib.h>

#define ALLPLN 1658
#define X_PLN  11
#define Y_PLN  22
#define Z_PLN  33
#define FAIL   0
#define OOKK   1
#define NNO    0
#define YYES   1



namespace itk
{
namespace Statistics
{ 

template <class TInputImage, class TOutputImage>
RemoveEyeRegion<TInputImage, TOutputImage>
::RemoveEyeRegion()
{
}

template <class TInputImage, class TOutputImage>
RemoveEyeRegion<TInputImage, TOutputImage>
::~RemoveEyeRegion()
{
}

template <class TInputImage, class TOutputImage>
void
RemoveEyeRegion<TInputImage, TOutputImage>
::PrintSelf(std::ostream& os, Indent indent) const
{
   Superclass::PrintSelf( os, indent );
}


template <class TInputImage, class TOutputImage>
void
RemoveEyeRegion<TInputImage, TOutputImage>
::removeregion(std::string& filename)
{
  cout << "RemoveEyeRegion::removeregion()" << endl;

  // CAUTION : parameter pass!
  dim_x = dim_y = 256; dim_z = 46;
  CSF_ratio_threshold = 0.1;  EYE_ratio_threshold = 0.998;
  res_x = res_y = 0.9375; res_z = 3.0;
  iter = 35;
  ratio_distance = 0.25;

  int i, j, k;

  printf("image dimension: (%d, %d, %d)\n(CSF, EYE) intensity threshold: (%f, %f)\n", dim_x, dim_y, dim_z, CSF_ratio_threshold, EYE_ratio_threshold);
  printf("image resolution: (%f, %f, %f)\n", res_x, res_y, res_z);
  printf("ratio of distance: %f\n", ratio_distance);
  printf("iter number: %d\n", iter);

  // memory alloc for images
  //in -- from ImageReader
  ImageReaderType::Pointer imageReader  = ImageReaderType::New();

  imageReader->SetFileName(filename);  // CAUTION -- TODO: parameter pass
  imageReader->Update();
 
  in = imageReader->GetOutput();

  // for debug
  typedef itk::ImageFileWriter<ImageType> WriterType;
  typename WriterType::Pointer writer = WriterType::New();

  writer->SetInput (in);
  writer->SetFileName( "beforeeyeremove.mha" );
  writer->Update();


  diff_img = ImageType::New();
  mask_img = ImageType::New();
  closed_img = ImageType::New();
  opened_img = ImageType::New();
  tmp_img = ImageType::New();
  dist = ImageType::New();

  ImageType::IndexType start;
  start[0] = 0; start[1] = 0; start[2] = 0;

  ImageType::SizeType size;
  size[0] = dim_x; size[1] = dim_y; size[2] = dim_z;

  ImageType::RegionType region;
  region.SetSize(size);
  region.SetIndex(start);

  diff_img->SetRegions(region);
  diff_img->Allocate();

  mask_img->SetRegions(region);
  mask_img->Allocate();

  closed_img->SetRegions(region);
  closed_img->Allocate();

  opened_img->SetRegions(region);
  opened_img->Allocate();

  tmp_img->SetRegions(region);
  tmp_img->Allocate();

  dist->SetRegions(region);
  dist->Allocate();


 

  ImageType::IndexType index;

  cen.SetSize(3);
  cen.Fill(0);

  histo.SetSize(256);
  histo.Fill(0); 

  total_volume = 0;

  totalx=totaly=totalz=0.0;

  for (k=0; k<dim_z; k++)
    for (j=0; j<dim_y; j++)
      for (i=0; i<dim_x; i++) {
	
        index[0] = i; index[1] = j; index[2] = k;

	if (in->GetPixel(index) !=0) {
	  histo[in->GetPixel(index)]++;
          total_volume++;
          totalx += i;
          totaly += j;
          totalz += k;
	}
    }

//  PrintVectorINT(histo, 256);
  cen.SetElement(0, (int)(totalx / total_volume));
  cen.SetElement(1, (int)(totaly / total_volume));
  cen.SetElement(2, (int)(totalz / total_volume));
  printf("image center: (%d, %d, %d)\n", cen.GetElement(0), cen.GetElement(1), cen.GetElement(2));


  ComputeDistImg(in, dist);

   max_dist = 0;

   for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {
 
	index[0] = i; index[1] = j; index[2] = k;
  
       if (dist->GetPixel(index)>max_dist) 
	 max_dist = dist->GetPixel(index);
   }

  dist_threshold = (int)(ratio_distance*max_dist);
  printf("(max dist, distance threshold): (%d, %d)\n", max_dist, dist_threshold);//exit(1);

    partial_volume = 0;  CSF_threshold = 0;
  for (i=1; i<256; i++) {
    partial_volume += histo[i];
    tmp_ratio = (float)partial_volume / total_volume;
    if (tmp_ratio>CSF_ratio_threshold) break;
  }
  CSF_threshold = i;

    partial_volume = 0;  EYE_threshold = 0;
  for (i=1; i<256; i++) {
    partial_volume += histo[i];
    tmp_ratio = (float)partial_volume / total_volume;
    if (tmp_ratio>EYE_ratio_threshold) break;
  }
  EYE_threshold = i;
  printf("(CSF, EYE) threshold: (%d, %d)\n", CSF_threshold, EYE_threshold);


  for (r=0; r<iter; r++) {
    printf("iteration: %d\n", r);
    GetMaskImg(in, mask_img);
    ClosingOperationOnBinary3DImage(mask_img, closed_img, 3);

    // InitializedImage diff_img
  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {
        index[0] = i; index[1] = j; index[2] = k;
          diff_img->SetPixel(index, 0);
        }

  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {
	index[0] = i; index[1] = j; index[2] = k;

	if ((mask_img->GetPixel(index)==255) && (closed_img->GetPixel(index)==0))
	  diff_img->SetPixel(index, 255);
     }

  if (IsEmptyImg(diff_img, dist, dist_threshold)) break;
  
  // InitializedImage tmp_img
  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {
        index[0] = i; index[1] = j; index[2] = k;
  
          tmp_img->SetPixel(index, 0);
        }


  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {
        index[0] = i; index[1] = j; index[2] = k;

	  tmp_img->SetPixel(index, in->GetPixel(index));
        }


  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {
        index[0] = i; index[1] = j; index[2] = k;

	  if ((in->GetPixel(index)>EYE_threshold) && (diff_img->GetPixel(index) != 0) && 
	   (dist->GetPixel(index) > dist_threshold))
	    tmp_img->SetPixel(index, 0);

        }


  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {
        index[0] = i; index[1] = j; index[2] = k;

          in->SetPixel(index, tmp_img->GetPixel(index));
        }

//  WriteImgUC(argv[2], in, dim);

  }

  typedef itk::ImageFileWriter<ImageType> WriterType;
  WriterType::Pointer imageWriter = WriterType::New();
  imageWriter->SetInput(in);
  imageWriter->SetFileName("aftereyeremove.mha");
  imageWriter->Update();
}


template <class TInputImage, class TOutputImage>
void
RemoveEyeRegion<TInputImage, TOutputImage>
::ComputeDistImg (ImagePointerType in, ImagePointerType dist)
{
  cout << "RemoveEyeRegion::ComputeDistImg" << endl;

  int        i, j, k, l, x, y, z, t, r, half;
  float      d;

  DoubleVectorType  pt, delta;
  pt.SetSize(3);
  delta.SetSize(3);

  ImageType::IndexType index;

  printf("img center: (%d, %d, %d)\n", cen.GetElement(0), cen.GetElement(1), cen.GetElement(2));

  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {
	
	index[0] = i; index[1] = j; index[2] = k;

	if (in->GetPixel(index)!=0) {
	  delta.SetElement(0, (i - cen.GetElement(0))*res_x);
	  delta.SetElement(1, (j - cen.GetElement(1))*res_y);
	  delta.SetElement(2, (k - cen.GetElement(2))*res_z);

	  d = sqrt(delta.GetElement(0)*delta.GetElement(0) + delta.GetElement(1)*delta.GetElement(1) + delta.GetElement(2)*delta.GetElement(2));
	  dist->SetPixel(index, (int) d);
	}
  }

}

template <class TInputImage, class TOutputImage>
void
RemoveEyeRegion<TInputImage, TOutputImage>
::GetMaskImg(ImagePointerType img, ImagePointerType mask)
{
   cout << "RemoveEyeRegion::GetMaskImg" << endl;

  int        i, j, k;

  ImageType::IndexType index;

  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {

	index[0] = i; index[1] = j; index[2] = k;

	mask->SetPixel(index, 0);
  }

  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++){
 
	index[0] = i; index[1] = j; index[2] = k;

        if (img->GetPixel(index) != 0) 
          mask->SetPixel(index, 255);
	}

}


template <class TInputImage, class TOutputImage>
void
RemoveEyeRegion<TInputImage, TOutputImage>
::ClosingOperationOnBinary3DImage (ImagePointerType in, ImagePointerType out, int Radius)
{
  ImageType::Pointer Temp_Img;

  // alloc Temp_Img

  int                   i, j, k ;
  int                   l, m, n, index ;
  double                TotalWhite ;
  int                   NumInSphere, RealNum ;
  int                   x_Start, x_End, y_Start, y_End, z_Start, z_End ;
  int                   X_Start, X_End, Y_Start, Y_End, Z_Start, Z_End ;
//  FILE                  *fp;
//  Ivector3d             BBStart, BBEnd, SStart, SEnd;

 IntVectorType BBStart, BBEnd, SStart, SEnd;

 IntSampleType::Pointer MyHood = IntSampleType::New();
 IntSampleType::MeasurementVectorType mv;
 mv.SetSize(3);



  int                   MyHoodSize, pixelNumIn_MyHood ;

  ImageType::IndexType imageindex;


  // InitializedImage out
  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {
	imageindex[0] = i; imageindex[1] = j; imageindex[2] = k;
	
	  out->SetPixel(imageindex, 0);
	}

  NumInSphere = (2*Radius+1)*(2*Radius+1)*(2*Radius/res_z+1);
  printf("Closing, radius =%d\t", Radius) ;
  fflush(stdout);

   /* spherical mask */
  MyHoodSize = Radius*2+1 ;
//  MyHood.SetSize(MyHoodSize*MyHoodSize*MyHoodSize) ;

 
 calculate_hood_byIncreasingRadius(MyHood, MyHoodSize, &pixelNumIn_MyHood, 1., 1., res_z);

   /* get bounding box */
  BBStart.SetSize(3);
  BBEnd.SetSize(3);

  BBStart.SetElement(0, 1000); BBStart.SetElement(1, 1000); BBStart.SetElement(2, 1000);
  BBEnd.SetElement(0, -1000); BBEnd.SetElement(1, -1000); BBEnd.SetElement(2, -1000);


   for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) { 

         imageindex[0] = i; imageindex[1] = j; imageindex[2] = k;

	if (in->GetPixel(imageindex)!=0) {

	  if (i<BBStart.GetElement(0)) BBStart.SetElement(0,i);
	  if (j<BBStart.GetElement(1)) BBStart.SetElement(1,j);
	  if (k<BBStart.GetElement(2)) BBStart.SetElement(2,k);

          if (i>BBEnd.GetElement(0)) BBEnd.SetElement(0,1);
          if (j>BBEnd.GetElement(1)) BBEnd.SetElement(1,j);
          if (k>BBEnd.GetElement(2)) BBEnd.SetElement(2,k);
	}
   }

  SStart.SetSize(3); SEnd.SetSize(3);

  /* find mask ... */
  SStart.SetElement(0, BBStart.GetElement(0) - Radius) ;  if (SStart.GetElement(0)<0)      SStart.SetElement(0,0);
  SEnd.SetElement(0,BBEnd.GetElement(0) + Radius) ;  if (SEnd.GetElement(0)>dim_x-1)  SEnd.SetElement(0,dim_x-1) ;
  SStart.SetElement(1, BBStart.GetElement(1) - Radius) ;  if (SStart.GetElement(1)<0)      SStart.SetElement(1,0);
  SEnd.SetElement(1, BBEnd.GetElement(1) + Radius) ;  if (SEnd.GetElement(1)>dim_y-1)  SEnd.SetElement(1,dim_y-1) ;
  SStart.SetElement(2, BBStart.GetElement(2) - Radius) ;  if (SStart.GetElement(2)<0)      SStart.SetElement(0,0);
  SEnd.SetElement(2, BBEnd.GetElement(2) + Radius) ;  if (SEnd.GetElement(2)>dim_z-1)  SEnd.SetElement(2,dim_z-1) ;



  for(k=SStart.GetElement(2); k<=SEnd.GetElement(2); k++)
    for(i=SStart.GetElement(0); i<=SEnd.GetElement(0); i++)
      for(j=SStart.GetElement(1); j<=SEnd.GetElement(1); j++) {

	imageindex[0] = i; imageindex[1] = j; imageindex[2] = k;

        if(in->GetPixel(imageindex)==255) {
          TotalWhite = 0 ;
          RealNum = 0 ;
          for( index=0; index<pixelNumIn_MyHood ; index++) {

	      mv = MyHood->GetMeasurementVector(index);

	      l = mv.GetElement(0); m = mv.GetElement(1); n = mv.GetElement(2);

              if( l*l+m*m+n*n<Radius*Radius && i+l>=0 && i+l<dim_x && j+m>=0 && j+m<dim_y && k+n>=0 && k+n<dim_z ) {
		   
		    imageindex[0] = i+l; imageindex[1] = j+m; imageindex[2] = k+n;

		    TotalWhite += in->GetPixel(imageindex);
                    RealNum ++ ;

                    /* for speeding up*/
                    if( in->GetPixel(imageindex)!=255 ) index = pixelNumIn_MyHood ;
                  }
          }
          TotalWhite /= RealNum;

	  imageindex[0] = i; imageindex[1] = j; imageindex[2] = k;

          if( TotalWhite==255 ) out->SetPixel(imageindex, 255) ;
          else out->SetPixel(imageindex, 0) ;
        }
        else out->SetPixel(imageindex, 0) ;

  } // for

  printf("closed\n");
}


template <class TInputImage, class TOutputImage>
void
RemoveEyeRegion<TInputImage, TOutputImage>
::calculate_hood_byIncreasingRadius(IntSampleType* Hood, int HoodSize, int *pixelNumInHood, float xres,float yres,float zres)
{

  cout << "RemoveEyeRegion::calculate_hood_byIncreasingRadius" << endl;

  int        x, y, z, t, r  ;
  int        half ;

  t = 0;

  IntSampleType::MeasurementVectorType mv;
  mv.SetSize(3);
  mv.SetElement(0, 0); mv.SetElement(1, 0); mv.SetElement(2, 0);

//  Hood[0].x = Hood[0].y = Hood[0].z = 0;
    t++;
    half = HoodSize/2;

  for(r=1; r<=half; r++) {
      for(z=-r; z<=r; z+=2*r)
        for(x=-r; x<=r; x++)
          for(y=-r; y<=r; y++)
            if((x*x+y*y+z*z)<=r*r) {
	      mv.SetElement(0, x/xres); mv.SetElement(1, y/yres); mv.SetElement(2, z/zres);
	
	      Hood->SetMeasurementVector(t, mv);

              //Hood[t].x = x/xres;             Hood[t].y = y/yres;             Hood[t].z = z/zres;
              t++;
            }
      for(x=-r; x<=r; x+=2*r)
        for(z=-r+1; z<=r-1; z++)
          for(y=-r; y<=r; y++)
            if((x*x+y*y+z*z)<=r*r) {
             mv.SetElement(0, x/xres); mv.SetElement(1, y/yres); mv.SetElement(2, z/zres);

  	     Hood->SetMeasurementVector(t, mv);

//              Hood[t].x = x/xres;             Hood[t].y = y/yres;             Hood[t].z = z/zres;
              t++;
            }
      for(y=-r; y<=r; y+=2*r)
        for(z=-r+1; z<=r-1; z++)
          for(x=-r+1; x<=r-1; x++)
            if((x*x+y*y+z*z)<=r*r) {
             mv.SetElement(0, x/xres); mv.SetElement(1, y/yres); mv.SetElement(2, z/zres);

             Hood->SetMeasurementVector(t, mv);

//              Hood[t].x = x/xres;             Hood[t].y = y/yres;             Hood[t].z = z/zres;
              t++ ;
            }
  }
  (*pixelNumInHood) = t;
//  printf("total %d in the search area!\n", t);

}


template <class TInputImage, class TOutputImage>
int
RemoveEyeRegion<TInputImage, TOutputImage>
::IsEmptyImg(ImagePointerType img, ImagePointerType dist_img, int dist_threshold)
{

   cout << "RemoveEyeRegion::IsEmptyImg" << endl;

  int        i, j, k;

  ImageType::IndexType index;

  for (k=0; k<dim_z; k++)
    for (i=0; i<dim_x; i++)
      for (j=0; j<dim_y; j++) {

	index[0] = i; index[1] = j; index[2] = k;
	
        if ((img->GetPixel(index) != 0) && (dist_img->GetPixel(index) > dist_threshold)) 
	   return 0;
      }

  return 1;


}



} // namespace Statistics
}  // namespace itk

#endif

