/*=========================================================================

  Program:   Registration stand-alone
  Module:    $RCSfile: $
  Language:  C++
  Date:      $Date: 2008-07-30 22:35:51 +0900 (水, 30 7 2008) $
  Version:   $Revision: 7363 $

=========================================================================*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <iostream>

//#include "AffineRegistrationCLP.h"

//#include "itkOrientedImage.h"
//#include "itkOrientImageFilter.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkTransformFileReader.h"
#include "itkTransformFileWriter.h"

#include "itkRegularStepGradientDescentOptimizer.h"
#include "itkImageFileWriter.h"
#include "itkImageRegistrationMethod.h"
#include "itkLinearInterpolateImageFunction.h"
#include "itkMattesMutualInformationImageToImageMetric.h"
#include "itkAffineTransform.h"
#include "itkResampleImageFilter.h"
#include "itkCastImageFilter.h"

//#include "itkPluginUtilities.h"

//#include "itkTimeProbesCollectorBase.h"

//#include "ModuleProcessInformation.h"
#include "itkResampImage.h"

//ModuleProcessInformation *CLPProcessInformation = 0;

using namespace std;

#define ORIENT

#ifdef ORIENT
  typedef itk::OrientedImage<short, 3> ImageType;
  typedef itk::OrientedImage<float, 3> OutputImageType;

#else
  typedef itk::Image<short, 3> ImageType;
  typedef itk::Image<float, 3> OutputImageType;
#endif // ORIENT
  typedef ImageType::Pointer ImagePointerType;
  typedef OutputImageType::Pointer OutputImagePointerType;

//  typedef itk::Image<double, 3> DoubleImageType;





//  The following section of code implements a Command observer
//  used to monitor the evolution of the registration process.
//


int myAffTrans::DoIt(ImagePointerType outputimage)
//template<class T> int DoIt( int argc, char * argv[], T )
{
  //
  // Command line processing
  //
  //PARSE_ARGS;

  const    unsigned int  ImageDimension = 3;
//  typedef  T  PixelType;  // CAUTION
  typedef short PixelType;

//  typedef itk::OrientedImage<PixelType, ImageDimension> ImageType;

  typedef itk::ImageFileReader<ImageType> FileReaderType;
//  typedef itk::OrientImageFilter<ImageType,ImageType> OrientFilterType;
 // typedef itk::LinearInterpolateImageFunction<ImageType, double>  InterpolatorType;
//  typedef itk::AffineTransform<double> TransformType;
  //typedef OptimizerType::ScalesType OptimizerScalesType;
  typedef itk::ResampleImageFilter<ImageType,ImageType> FilterType;
//  typedef itk::LinearInterpolateImageFunction<ImageType, double> ResampleInterpolatorType;
  typedef itk::ImageFileWriter<ImageType> WriterType;
//  typedef itk::ContinuousIndex<double, 3> ContinuousIndexType;
  typedef itk::CastImageFilter<ImageType, OutputImageType >  InputCastFilterType;
  typedef itk::CastImageFilter<OutputImageType, ImageType>  OutputCastFilterType;

  


  // Add a time probe

  // Read the fixed and moving volumes
  //
  //

  /*
  FileReaderType::Pointer fixedReader = FileReaderType::New();
    fixedReader->SetFileName ( m_FixedImageFileName.c_str() );

  try
    {
    collector.Start( "Read fixed volume" );
    fixedReader->Update();
    collector.Stop( "Read fixed volume" );
    }
  catch( itk::ExceptionObject & err )
    {
    std::cerr << "Error Reading Fixed image: " << std::endl;
    std::cerr << err << std::endl;
    return EXIT_FAILURE;
    }
  */

   FileReaderType::Pointer reader = FileReaderType::New();
    reader->SetFileName ( "T1.brain.mask.mha" );

   WriterType::Pointer writer = WriterType::New();
   writer->SetFileName ( "transformed.mha");

   const double angleInDegrees = 30.0;


/*
  try
    {
    reader->Update();
    }
  catch( itk::ExceptionObject & err )
    {
    std::cerr << "Error Reading Moving image: " << std::endl;
    std::cerr << err << std::endl;
    return EXIT_FAILURE;
    }
*/

  typedef itk::ResampleImageFilter<ImageType, ImageType >  FilterType;
  InputCastFilterType::Pointer       inputcastFilter       = InputCastFilterType::New();
  OutputCastFilterType::Pointer	      outputcastFilter   = OutputCastFilterType::New();

  FilterType::Pointer filter = FilterType::New();

   typedef itk::AffineTransform< double, ImageDimension >  TransformType;
  TransformType::Pointer transform = TransformType::New();
  // Software Guide : EndCodeSnippet


  typedef itk::LinearInterpolateImageFunction<
                       ImageType, double >  InterpolatorType;
  InterpolatorType::Pointer interpolator = InterpolatorType::New();

  filter->SetInterpolator( interpolator );

 // filter->SetDefaultPixelValue( 100 );


  reader->Update();
  const ImageType::SpacingType&
    spacing = reader->GetOutput()->GetSpacing();
  const ImageType::PointType&
    origin  = reader->GetOutput()->GetOrigin();
  ImageType::SizeType size =
      reader->GetOutput()->GetLargestPossibleRegion().GetSize();
  filter->SetOutputOrigin( origin );
  filter->SetOutputSpacing( spacing );
  filter->SetSize( size );

  inputcastFilter->SetInput(reader->GetOutput());
  inputcastFilter->Update();
  filter->SetInput( reader->GetOutput() );




  TransformType::OutputVectorType translation1;

  const double imageCenterX = origin[0] + spacing[0] * size[0] / 2.0;
  const double imageCenterY = origin[1] + spacing[1] * size[1] / 2.0;

  translation1[0] =   1;
  translation1[1] =   1;
  translation1[2] = 1;

//  translation1[0] =   -imageCenterX;
//  translation1[1] =   -imageCenterY;

  transform->Translate( translation1 );
  // Software Guide : EndCodeSnippet

//  std::cout << "imageCenterX = " << imageCenterX << std::endl;
//  std::cout << "imageCenterY = " << imageCenterY << std::endl;


//  const double degreesToRadians = atan(1.0) / 45.0;
//  const double angle = angleInDegrees * degreesToRadians;
//  transform->Rotate2D( -angle, false );


//  TransformType::OutputVectorType translation2;
//  translation2[0] =   imageCenterX;
//  translation2[1] =   imageCenterY;
//  transform->Translate( translation2, false );


 
  filter->SetTransform( transform );

  filter->Update();
  writer->SetInput( filter->GetOutput() );

  // for debug
  int i,j,k;

  ImageType::IndexType index;


//  writer->SetInput( filter->GetOutput() );

  for(i=0; i<size[0]; i++)
   for (j=0;j<size[1];j++)
    for(k=0; k<size[2]; k++)
    {
      index[0] = i; index[1] = j; index[2] = k;

      if(filter->GetOutput()->GetPixel(index)>0) cout <<"# " ;

    }
   // --





  try
    {
    writer->Update();
    }
  catch( itk::ExceptionObject & excep )
    {
    std::cerr << "Exception caught !" << std::endl;
    std::cerr << excep << std::endl;
    }








  
/*   // for additional moving image
    FileReaderType::Pointer addmovingReader = FileReaderType::New();

  if ( m_AddImageFilename != "") 
  {
    addmovingReader->SetFileName ( m_AddImageFilename.c_str() );

  try
    {
    collector.Start( "Read moving volume" );
    addmovingReader->Update();
    collector.Stop( "Read moving volume" );
    }
  catch( itk::ExceptionObject & err )
    {
    std::cerr << "Error Reading Moving image: " << std::endl;
    std::cerr << err << std::endl;
    return EXIT_FAILURE;
    }


   ImageType::IndexType index;
   index[0] = 128; index[1] = 128; index[2] = 23;

   cout << "addmovingReader pixel: " << addmovingReader->GetOutput()->GetPixel(index);
  }
*/

 
/*
  // If an initial transform was specified, read it
  //
  //
  typedef itk::TransformFileReader TransformReaderType;
  TransformReaderType::Pointer initialTransform;

  if (m_InitialTransform != "")
    {
    initialTransform= TransformReaderType::New();
    initialTransform->SetFileName( m_InitialTransform );
    try
      {
      initialTransform->Update();
      }
    catch (itk::ExceptionObject &err)
      {
      std::cerr << err << std::endl;
      return  EXIT_FAILURE;
      }
    }


  // Reorient to axials to avoid issues with registration metrics not
  // transforming image gradients with the image orientation in
  // calculating the derivative of metric wrt transformation
  // parameters.
  //
  // Forcing image to be axials avoids this problem. Note, that
  // reorientation only affects the internal mapping from index to
  // physical coordinates.  The reoriented data spans the same
  // physical space as the original data.  Thus, the registration
  // transform calculated on the reoriented data is also the
  // transform forthe original un-reoriented data. 

  OrientFilterType::Pointer orientFixed = OrientFilterType::New();
  //itk::PluginFilterWatcher watchOrientFixed(orientFixed,
  //                                          "Orient Fixed Image",
  //                                          CLPProcessInformation,
  //                                          1.0/3.0, 0.0);
  orientFixed->UseImageDirectionOn();
  orientFixed->SetDesiredCoordinateOrientationToAxial();
  //orientFixed->SetInput (fixedReader->GetOutput());
  orientFixed->SetInput (m_FixedImage);
  orientFixed->Update();

  OrientFilterType::Pointer orientMoving = OrientFilterType::New();
 // itk::PluginFilterWatcher watchOrientMoving(orientMoving,
 //                                            "Orient Moving Image",
//                                             CLPProcessInformation,
//                                             1.0/3.0, 1.0/3.0);
  orientMoving->UseImageDirectionOn();
  orientMoving->SetDesiredCoordinateOrientationToAxial();
//  orientMoving->SetInput (movingReader->GetOutput());
  orientMoving->SetInput (m_MovingImage);
  orientMoving->Update();


   // new
  OrientFilterType::Pointer orientAddMoving = OrientFilterType::New();
  orientAddMoving->UseImageDirectionOn();
  orientAddMoving->SetDesiredCoordinateOrientationToAxial();
//  orientMoving->SetInput (movingReader->GetOutput());
  orientAddMoving->SetInput (m_AddMovingImage);
  orientAddMoving->Update();



  TransformType::Pointer transform = TransformType::New();
  OptimizerScalesType scales( transform->GetNumberOfParameters() );
    scales.Fill ( 1.0 );
  for( unsigned j = 9; j < 12; j++ )
    {
    scales[j] = 1.0 / vnl_math_sqr(m_TranslationScale);
    }
    optimizer->SetScales( scales );



   cout << "before transform" << endl;

  // Initialize the transform
  //
  //
  TransformType::InputPointType centerFixed;
  ImageType::RegionType::SizeType sizeFixed = orientFixed->GetOutput()->GetLargestPossibleRegion().GetSize();
  //ImageType::RegionType::SizeType sizeFixed = m_FixedImage->GetLargestPossibleRegion().GetSize();
  // Find the center
  ContinuousIndexType indexFixed;
  for ( unsigned j = 0; j < 3; j++ )
    {
    indexFixed[j] = (sizeFixed[j]-1) / 2.0;
    }
  orientFixed->GetOutput()->TransformContinuousIndexToPhysicalPoint ( indexFixed, centerFixed );
  //m_FixedImage->TransformContinuousIndexToPhysicalPoint ( indexFixed, centerFixed );

  TransformType::InputPointType centerMoving;
  ImageType::RegionType::SizeType sizeMoving = orientMoving->GetOutput()->GetLargestPossibleRegion().GetSize();
  //ImageType::RegionType::SizeType sizeMoving = m_MovingImage->GetLargestPossibleRegion().GetSize();
  // Find the center
  ContinuousIndexType indexMoving;
  for ( unsigned j = 0; j < 3; j++ )
    {
    indexMoving[j] = (sizeMoving[j]-1) / 2.0;
    }
  orientMoving->GetOutput()->TransformContinuousIndexToPhysicalPoint ( indexMoving, centerMoving );
   //m_MovingImage->TransformContinuousIndexToPhysicalPoint ( indexMoving, centerMoving );

  transform->SetCenter( centerFixed );
  transform->Translate(centerMoving-centerFixed);
  std::cout << "Centering transform: "; transform->Print( std::cout );

  // If an initial transformation was provided, then use it instead.
  // (Should this be instead of the centering transform or composed
  // with the centering transform.)
  //
  if (m_InitialTransform != ""
      && initialTransform->GetTransformList()->size() != 0)
    {
    TransformReaderType::TransformType::Pointer initial
      = *(initialTransform->GetTransformList()->begin());

    // most likely, the transform coming in is a subclass of
    // MatrixOffsetTransformBase 
    typedef itk::MatrixOffsetTransformBase<double,3,3> DoubleMatrixOffsetType;
    typedef itk::MatrixOffsetTransformBase<float,3,3> FloatMatrixOffsetType;

    DoubleMatrixOffsetType::Pointer da
      = dynamic_cast<DoubleMatrixOffsetType*>(initial.GetPointer());
    FloatMatrixOffsetType::Pointer fa
      = dynamic_cast<FloatMatrixOffsetType*>(initial.GetPointer());

    if (da)
      {
      transform->SetMatrix( da->GetMatrix() );
      transform->SetOffset( da->GetOffset() );
      }
    else if (fa)
      {
      vnl_matrix<double> t(3,3);
      for (int i=0; i < 3; ++i)
        {
        for (int j=0; j <3; ++j)
          {
          t.put(i, j, fa->GetMatrix().GetVnlMatrix().get(i, j));
          }
        }

      transform->SetMatrix( t );
      transform->SetOffset( fa->GetOffset() );
      }
    else
      {
      std::cout << "Initial transform is an unsupported type." << std::endl;
      }

    std::cout << "Initial transform: "; transform->Print ( std::cout );
    }


   cout << "before metric" << endl;

  // Set up the metric
  //
   MetricType::Pointer  metric        = MetricType::New();
    metric->SetNumberOfHistogramBins ( m_HistogramBins );
    metric->SetNumberOfSpatialSamples( m_SpatialSamples );

   cout << "before interpolator" << endl;


  // Create the interpolator
  //
  InterpolatorType::Pointer interpolator = InterpolatorType::New();

   cout << "before registration" << endl;


  // Set up the registration
  //
   RegistrationType::Pointer registration = RegistrationType::New();
    registration->SetTransform ( transform );
    registration->SetInitialTransformParameters ( transform->GetParameters() );
    registration->SetMetric ( metric );
    registration->SetOptimizer ( optimizer );
    registration->SetInterpolator ( interpolator );
    registration->SetFixedImage ( orientFixed->GetOutput() );
    registration->SetMovingImage ( orientMoving->GetOutput() );
     //registration->SetFixedImage ( m_FixedImage);
     //registration->SetMovingImage(m_MovingImage);

   cout << " before registration update" << endl;


  try
    {
    //itk::PluginFilterWatcher watchRegistration(registration,
    //                                           "Registering",
    //                                           CLPProcessInformation,
    //                                          1.0/3.0, 2.0/3.0);
//    collector.Start( "Register" );
    registration->Update();
//    collector.Stop( "Register" );
    }
  catch( itk::ExceptionObject & err )
    {
    std::cout << err << std::endl;
    std::cerr << err << std::endl;
    return  EXIT_FAILURE ;
    }
  catch ( ... )
    {
    return  EXIT_FAILURE ;
    }


  cout << " before transform" << endl;

  transform->SetParameters ( registration->GetLastTransformParameters() );



  // for debug 
  cout << "m_OutputTransform: " << m_OutputTransform.c_str() << endl;

  if (m_OutputTransform != "")
    {
    typedef itk::TransformFileWriter TransformWriterType;
    TransformWriterType::Pointer outputTransformWriter;

    outputTransformWriter= TransformWriterType::New();
    outputTransformWriter->SetFileName( m_OutputTransform );
    outputTransformWriter->SetInput( transform );
    try
      {
      outputTransformWriter->Update();
      }
    catch (itk::ExceptionObject &err)
      {
      std::cerr << err << std::endl;
      return  EXIT_FAILURE ;
      }
    }

  cout << " before resample" << endl;

  // Resample to the original coordinate frame (not the reoriented
  // axial coordinate frame) of the fixed image


  //
  if (m_ResampledImageFileName != "")
    {
     ResampleType::Pointer resample = ResampleType::New();
     ResampleInterpolatorType::Pointer Interpolator = ResampleInterpolatorType::New();
    //itk::PluginFilterWatcher watchResample(resample,
    //                                       "Resample",
    //                                       CLPProcessInformation,
    //                                       1.0/3.0, 2.0/3.0);



    //resample->SetInput ( orientAddMoving->GetOutput() );
    resample->SetInput (m_MovingImage);
    resample->SetTransform ( transform );
    resample->SetInterpolator ( Interpolator );
   // resample->SetOutputParametersFromImage ( fixedReader->GetOutput() );
    resample->SetOutputParametersFromImage(m_FixedImage);

    resample->Update();

    WriterType::Pointer resampledWriter = WriterType::New();
    resampledWriter->SetFileName ( "test.mha" );
    resampledWriter->SetInput ( resample->GetOutput() );
    //resampledWriter->SetInput (m_AddMovingImage);





    try
      {
      resampledWriter->Write();
      }
    catch( itk::ExceptionObject & err )
      {
      std::cerr << err << std::endl;
      std::cerr << err << std::endl;
      return EXIT_FAILURE;
      }

    //outputimage = resample->GetOutput();   // pass the registered image
    //outputimage->Update();
*/
/*
    m_OutputImage = ImageType::New();

    ImageType::IndexType start;
    start[0] = 0; start[1] = 0; start[2] = 0;

    ImageType::SizeType size;
    size = m_FixedImage->GetBufferedRegion().GetSize();

    ImageType::RegionType region;
    region.SetSize(size);
    region.SetIndex(start);

    m_OutputImage->SetRegions(region);
    m_OutputImage->Allocate();
*/


//    }


  // Report the time taken by the registration


  return EXIT_SUCCESS;
}


int myAffTrans::myregistration(ImagePointerType outputimage)  // main
{

  //PARSE_ARGS;
/*
    m_HistogramBins = 30;
    m_SpatialSamples = 10000;
    m_Iterations = 2000;
    m_TranslationScale = 100.0;
    m_InitialTransform = "";
    m_OutputTransform = "output.trans";
    m_FixedImageFileName = "fixedFL.mha";
    m_MovingImageFileName = "movingT1.mha";
    m_ResampledImageFileName = "affreg.mha";
    //echoSwitch = false;
    //xmlSwitch = false;
    //processInformationAddressString = "0";
*/

   // for debug
/*
   typedef itk::ImageFileWriter<ImageType> WriterType;
   WriterType::Pointer writer = WriterType::New();

   writer->SetInput (m_FixedImage);
   writer->SetFileName( "reg_input1.mha" );
   writer->Update();

   writer->SetInput (m_MovingImage);
   writer->SetFileName( "reg_input2.mha" );
   writer->Update();
*/
 
   DoIt(outputimage);

/*
  itk::ImageIOBase::IOPixelType pixelType;
  itk::ImageIOBase::IOComponentType componentType;

  typedef itk::Image<unsigned char, 3> ImageType;
  itk::ImageFileReader<ImageType>::Pointer imageReader =
    itk::ImageFileReader<ImageType>::New();
  imageReader->SetFileName(FixedImageFileName.c_str());
  imageReader->UpdateOutputInformation();

  pixelType = imageReader->GetImageIO()->GetPixelType();
  componentType = imageReader->GetImageIO()->GetComponentType();


//  try
//    {
    //itk::GetImageType (FixedImageFileName, pixelType, componentType);


    // This filter handles all types

    switch (componentType)
      {
      case itk::ImageIOBase::CHAR:
      case itk::ImageIOBase::UCHAR:
      case itk::ImageIOBase::USHORT:
      case itk::ImageIOBase::SHORT:
        return DoIt( argc, argv, static_cast<short>(0));
        break;
      case itk::ImageIOBase::ULONG:
      case itk::ImageIOBase::LONG:
      case itk::ImageIOBase::UINT:
      case itk::ImageIOBase::INT:
        return DoIt( argc, argv, static_cast<int>(0));
        break;
      case itk::ImageIOBase::DOUBLE:
      case itk::ImageIOBase::FLOAT:
        return DoIt( argc, argv, static_cast<float>(0));
        break;
      case itk::ImageIOBase::UNKNOWNCOMPONENTTYPE:
      default:
        std::cout << "unknown component type" << std::endl;
        break;
      }
 //   }
 // catch( itk::ExceptionObject &excep)
 //   {
 //   std::cerr << argv[0] << ": exception caught !" << std::endl;
 //   std::cerr << excep << std::endl;
 //   return EXIT_FAILURE;
 //   }
*/
  return EXIT_SUCCESS;

}


myAffTrans::myAffTrans()
{
}

myAffTrans::~myAffTrans()
{
}


void myAffTrans::SetHistogramBin(int histbin)
{

  m_HistogramBins = histbin;
   
}

void myAffTrans::SetSpatialSamples(int spatialsample)
{
  m_SpatialSamples = spatialsample;
}


void myAffTrans::SetIteration(int iter)
{
  m_Iterations = iter;
}

void myAffTrans::SetTransScale(double transscale)
{
  m_TranslationScale = transscale;
}

void myAffTrans::SetInitTransform(std::string& inittrans)
{
  m_InitialTransform = inittrans;
}

void myAffTrans::SetOutputTransform(std::string& outtrans)
{
  m_OutputTransform = outtrans;
}

void myAffTrans::SetFixedImage(ImagePointerType fixedimage)
{
  m_FixedImage = fixedimage;
}

void myAffTrans::SetMovingImage(ImagePointerType movingimage)
{
  m_MovingImage = movingimage;
}

void myAffTrans::SetOutputImageFilename(std::string& outimagename)
{
  m_ResampledImageFileName = outimagename;
}

/*
ImagePointerType myAffTrans::GetRegisteredImage()
{

  return m_OutputImage;

}
*/

void myAffTrans::SetAdditionalImageFilename(std::string& addimagename)
{

  m_AddImageFilename = addimagename;

}

void myAffTrans::SetAdditionalMovingImage(ImagePointerType addmovingimage)
{
  m_AddMovingImage = addmovingimage;

}


#ifdef NOT
int myAffTrans::mytransformation(ImagePointerType outputimage)
{

  const    unsigned int  ImageDimension = 3;
  typedef short PixelType;

  typedef itk::OrientedImage<PixelType, ImageDimension> ImageType;

  typedef itk::ImageFileReader<ImageType> FileReaderType;
  typedef itk::OrientImageFilter<ImageType,ImageType> OrientFilterType;
//  typedef itk::MattesMutualInformationImageToImageMetric<ImageType, ImageType>  MetricType;
 // typedef itk::RegularStepGradientDescentOptimizer    OptimizerType;
  typedef itk::LinearInterpolateImageFunction<ImageType, double>  InterpolatorType;
//  typedef itk::ImageRegistrationMethod<ImageType,ImageType>    RegistrationType;
  typedef itk::AffineTransform<double> TransformType;
//  typedef OptimizerType::ScalesType OptimizerScalesType;
  typedef itk::ResampleImageFilter<DoubleImageType, DoubleImageType> ResampleType;
  typedef itk::LinearInterpolateImageFunction<DoubleImageType, double> ResampleInterpolatorType;
  typedef itk::ImageFileWriter<ImageType> WriterType;
//  typedef itk::ContinuousIndex<double, 3> ContinuousIndexType;

   typedef itk::CastImageFilter< ImageType, DoubleImageType > CastingFilterType;
   CastingFilterType::Pointer caster = CastingFilterType::New();

   typedef itk::CastImageFilter< DoubleImageType, ImageType> CastingFilterType2;
   CastingFilterType2::Pointer caster2 = CastingFilterType2::New();

   ImageType::SpacingType spacing;





  typedef itk::TransformFileReader TransformReaderType;
  TransformReaderType::Pointer initialTransform;

  if (m_InitialTransform != "")
    {

    initialTransform= TransformReaderType::New();
    initialTransform->SetFileName( m_InitialTransform );
    try
      {
      initialTransform->Update();
      }
    catch (itk::ExceptionObject &err)
      {
      std::cerr << err << std::endl;
      return  EXIT_FAILURE;
      }
    }


  OrientFilterType::Pointer orientFixed = OrientFilterType::New();
  orientFixed->UseImageDirectionOn();
  orientFixed->SetDesiredCoordinateOrientationToAxial();
  orientFixed->SetInput (m_FixedImage);
  orientFixed->Update();

  OrientFilterType::Pointer orientMoving = OrientFilterType::New();
  orientMoving->UseImageDirectionOn();
  orientMoving->SetDesiredCoordinateOrientationToAxial();
  orientMoving->SetInput (m_MovingImage);
  orientMoving->Update();

   cout << "before optimizer" << endl;



  // Initialize the transform
  //
  //
/*
  TransformType::InputPointType centerFixed;
  ImageType::RegionType::SizeType sizeFixed = orientFixed->GetOutput()->GetLargestPossibleRegion().GetSize();
  ContinuousIndexType indexFixed;
  for ( unsigned j = 0; j < 3; j++ )
    {
    indexFixed[j] = (sizeFixed[j]-1) / 2.0;
    }
  orientFixed->GetOutput()->TransformContinuousIndexToPhysicalPoint ( indexFixed, centerFixed );

  TransformType::InputPointType centerMoving;
  ImageType::RegionType::SizeType sizeMoving = orientMoving->GetOutput()->GetLargestPossibleRegion().GetSize();
  // Find the center
  ContinuousIndexType indexMoving;
  for ( unsigned j = 0; j < 3; j++ )
    {
    indexMoving[j] = (sizeMoving[j]-1) / 2.0;
    }
  orientMoving->GetOutput()->TransformContinuousIndexToPhysicalPoint ( indexMoving, centerMoving );
   //m_MovingImage->TransformContinuousIndexToPhysicalPoint ( indexMoving, centerMoving );

  transform->SetCenter( centerFixed );
  transform->Translate(centerMoving-centerFixed);
  std::cout << "Centering transform: "; transform->Print( std::cout );
 */

  // If an initial transformation was provided, then use it instead.
  // (Should this be instead of the centering transform or composed
  // with the centering transform.)
  //
  if (m_InitialTransform != ""
      && initialTransform->GetTransformList()->size() != 0)
    {
    TransformReaderType::TransformType::Pointer initial
      = *(initialTransform->GetTransformList()->begin());

    // most likely, the transform coming in is a subclass of
    // MatrixOffsetTransformBase 
    typedef itk::MatrixOffsetTransformBase<double,3,3> DoubleMatrixOffsetType;
    typedef itk::MatrixOffsetTransformBase<float,3,3> FloatMatrixOffsetType;


    DoubleMatrixOffsetType::Pointer da
      = dynamic_cast<DoubleMatrixOffsetType*>(initial.GetPointer());
    FloatMatrixOffsetType::Pointer fa
      = dynamic_cast<FloatMatrixOffsetType*>(initial.GetPointer());

    if (da)
      {
      transform->SetMatrix( da->GetMatrix() );
      transform->SetOffset( da->GetOffset() );
      }
    else if (fa)
      {
      vnl_matrix<double> t(3,3);
      for (int i=0; i < 3; ++i)
        {
        for (int j=0; j <3; ++j)
          {
          t.put(i, j, fa->GetMatrix().GetVnlMatrix().get(i, j));
          }
        }

      transform->SetMatrix( t );
      transform->SetOffset( fa->GetOffset() );
      }
    else
      {
      std::cout << "Initial transform is an unsupported type." << std::endl;
      }

    std::cout << "Initial transform: "; transform->Print ( std::cout );
    }


   cout << "before metric" << endl;


/*
  // Set up the metric
  //
   MetricType::Pointer  metric        = MetricType::New();
    metric->SetNumberOfHistogramBins ( m_HistogramBins );
    metric->SetNumberOfSpatialSamples( m_SpatialSamples );

   cout << "before interpolator" << endl;
*/

  // Create the interpolator
  //

/*
  InterpolatorType::Pointer interpolator = InterpolatorType::New();

   cout << "before registration" << endl;


  // Set up the registration
  //
   RegistrationType::Pointer registration = RegistrationType::New();
    registration->SetTransform ( transform );
    registration->SetInitialTransformParameters ( transform->GetParameters() );
    registration->SetMetric ( metric );
    registration->SetOptimizer ( optimizer );
    registration->SetInterpolator ( interpolator );
    registration->SetFixedImage ( orientFixed->GetOutput() );
    registration->SetMovingImage ( orientMoving->GetOutput() );

   cout << " before registration update" << endl;


  try
    {
    registration->Update();
    }
  catch( itk::ExceptionObject & err )
    {
    std::cout << err << std::endl;
    std::cerr << err << std::endl;
    return  EXIT_FAILURE ;
    }
  catch ( ... )
    {
    return  EXIT_FAILURE ;
    }


  cout << " before transform" << endl;


  transform->SetParameters ( registration->GetLastTransformParameters() );


  // for debug 
  cout << "m_OutputTransform: " << m_OutputTransform.c_str() << endl;

  if (m_OutputTransform != "")
    {
    typedef itk::TransformFileWriter TransformWriterType;
    TransformWriterType::Pointer outputTransformWriter;

    outputTransformWriter= TransformWriterType::New();
    outputTransformWriter->SetFileName( m_OutputTransform );
    outputTransformWriter->SetInput( transform );
    try
      {
      outputTransformWriter->Update();
      }
    catch (itk::ExceptionObject &err)
      {
      std::cerr << err << std::endl;
      return  EXIT_FAILURE ;
      }
    }
*/
  cout << " before resample" << endl;

  // Resample to the original coordinate frame (not the reoriented
  // axial coordinate frame) of the fixed image
  //
//  if (m_ResampledImageFileName != "")
//    {
     ResampleType::Pointer resample = ResampleType::New();
     ResampleInterpolatorType::Pointer Interpolator = ResampleInterpolatorType::New();
    //itk::PluginFilterWatcher watchResample(resample,
    //                                       "Resample",
    //                                       CLPProcessInformation,
    //                                       1.0/3.0, 2.0/3.0);

    //resample->SetInput ( movingReader->GetOutput() );
 

    caster->SetInput(m_MovingImage);

    resample->SetOutputOrigin( m_FixedImage->GetOrigin() );
    resample->SetOutputSpacing( m_FixedImage->GetSpacing() );
    resample->SetSize(m_FixedImage->GetBufferedRegion().GetSize());

    //resample->SetInput (m_MovingImage);
    resample->SetInput (caster->GetOutput());
    resample->SetTransform ( transform );
    resample->SetInterpolator ( Interpolator );
    //resample->SetOutputParametersFromImage(m_FixedImage);

    resample->Update();

    caster2->SetInput(resample->GetOutput());


    WriterType::Pointer resampledWriter = WriterType::New();
    resampledWriter->SetFileName ( "transformed.mha" );
   // resampledWriter->SetInput ( resample->GetOutput() );
   // resampledWriter->SetInput (m_MovingImage);
    resampledWriter->SetInput ( caster2->GetOutput() );

    try
      {
      resampledWriter->Write();
      }
    catch( itk::ExceptionObject & err )
      {
      std::cerr << err << std::endl;
      std::cerr << err << std::endl;
      return EXIT_FAILURE;
      }


/*
    m_OutputImage = ImageType::New();

    ImageType::IndexType start;
    start[0] = 0; start[1] = 0; start[2] = 0;

    ImageType::SizeType size;
    size = m_FixedImage->GetBufferedRegion().GetSize();

    ImageType::RegionType region;
    region.SetSize(size);
    region.SetIndex(start);

    m_OutputImage->SetRegions(region);
    m_OutputImage->Allocate();
*/

  //  }

  return EXIT_SUCCESS;
}

#endif // NOT





