/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkSVMSolverBase.h,v $
  Language:  C++
  Date:      $Date: 2006/09/07 11:48:50 $
  Version:   $Revision: 1.1 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __SVMSolverBase_h
#define __SVMSolverBase_h

#include "itkLightProcessObject.h"
#include <vector>


namespace itk
{
namespace Statistics
{
typedef struct Liste_
{
    double *adr;
    int index;
    Liste_ *prev;
    Liste_ *suiv;
} Liste;

template<class TXSample, class TYSample>
class SVMSolverBase : public LightProcessObject
{
public:

  typedef SVMSolverBase Self;
  typedef LightProcessObject Superclass;
  typedef SmartPointer<Self> Pointer;
  typedef SmartPointer<const Self> ConstPointer;
  itkTypeMacro(SVMSolverBase, LightProcessObject);

  typedef typename TXSample::MeasurementVectorType XVectorType;
  typedef typename TYSample::MeasurementVectorType YVectorType;
//  typedef typename TXSample::ConstPointer InputSamplePointerType;
  typedef typename TXSample::Pointer InputSamplePointerType;
  typedef typename TXSample::Pointer OutputSamplePointerType;

  typedef Array<double> InternalVectorType;
  typedef std::vector<XVectorType> InputSampleVectorType;
  typedef std::vector<YVectorType> OutputSampleVectorType;
  typedef SupportVectorMachine<XVectorType> SVMType;

//  typedef int ClassLabelType;
//  typedef itk::VariableLengthVector<ClassLabelType>  LabelVectorType;
  typedef itk::VariableLengthVector<double> LabelVectorType;


  typedef itk::VariableLengthVector<double> DoubleVectorType;
  typedef itk::VariableLengthVector<int> IntVectorType;
  typedef itk::VariableLengthVector<char> CharVectorType;

  typedef vnl_vector<double> VnlVectorType;
  typedef vnl_matrix<double> VnlMatrixType;
  typedef vnl_vector<int> VnlIntVectorType;

  bool sparse_mode;
  bool deja_shrink;
  bool unshrink_mode;

  DoubleVectorType alpha;
  DoubleVectorType grad;

  double eps_shrink;
  double eps_fin;
  double eps_bornes;

  double b;

  int n_active_var;

  IntVectorType active_var;
  IntVectorType not_at_bound_at_iter;
  int iter;
  int n_iter_min_to_shrink;

  CharVectorType status_alpha;

  double *Cx;


  bool bCompute();
  bool selectVariables(int &i, int &j);
  int checkShrinking(double bmin, double bmax);
  void shrink();
  void unShrink();
  void solve();

  virtual void analyticSolve(int xi, int xj) = 0;
  virtual void setOption();

  void updateStatus(int i);
  //inline bool isNotUp(int i)   {  return(status_alpha[i] != 2); };
  //inline bool isNotDown(int i) {  return(status_alpha[i] != 1); };

  bool isNotUp(int i);
   bool isNotDown(int i);

  /////
  
  void SetClassTrainingSamples(TXSample* samples);
  void SetTestingSamples(TXSample* samples);
 

  void SetLabel(LabelVectorType& label);


  itkSetMacro(NumSamples,long);
  itkGetMacro(NumSamples,long);

  itkSetMacro(NumFeatures,long);
  itkGetMacro(NumFeatures,long);

  itkSetObjectMacro(SVM, SVMType);
  itkGetObjectMacro(SVM, SVMType);

  itkSetMacro(EPS, double);
  itkGetMacro(EPS, double);

// for Cache
  void Cache(double taille_en_megs);
  double *adresseCache(int index);
  void efface();
  void CacheClassification (double taille_en_megs);
  virtual void rempliColonne(int index, double *adr);

  InputSamplePointerType m_SamplePointer;
  OutputSamplePointerType m_OutputSamplePointer;

protected:

  SVMSolverBase();
  ~SVMSolverBase();
  
  /** Method to print the object. */
  virtual void PrintSelf( std::ostream& os, Indent indent ) const;

  InputSampleVectorType     m_InputSamples;   
  OutputSampleVectorType    m_Targets;
    

  LabelVectorType		    m_Label;
//  LabelVectorType		    myLabel;

  long m_NumSamples;
  long m_NumFeatures;

  typename SVMType::Pointer                m_SVM;


// for SVMTorch
  double *k_xi;
  double *k_xj;

  double old_alpha_xi;
  double old_alpha_xj;
  double current_error;

//  int *active_var_new;
  IntVectorType active_var_new;
  int n_active_var_new;

  double m_EPS;  


// for Cache
  //virtual void rempliColonne(int index, double *adr) = 0;

private: 
// for SVMTorch
  int n_unshrink;
  int n_max_unshrink;

// for Cache
  int taille;
  Liste *cached, *cached_sauve;
  Liste **index_dans_liste;
 
};




} // end namespace Statistics
} // end namespace itk

#ifndef ITK_MANUAL_INSTANTIATION
  #include "itkSVMSolverBase.txx"
#endif

#endif
