#ifndef __itkWMLAdaptiveBooster_txx
#define __itkWMLAdaptiveBooster_txx
#include "itkWMLAdaptiveBooster.h"


// for region growing
#define ALLPLN 1658
#define X_PLN  11
#define Y_PLN  22
#define Z_PLN  33
#define FAIL   0
#define OOKK   1
#define NNO    0
#define YYES   1


using namespace std;

namespace itk
{

    /**
    * Default constructor
    */
    //template <class TFixedImage, class TMovingImage, class TDeformationField, class TAVFilterType>
    template <class TImage, class TMeasurementVector >
    WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::WMLAdaptiveBooster()
    {
      cout << "WMLAdaptiveBooster::WMLAdaptiveBooster()\n" << endl;

    }



    //template <class TFixedImage, class TMovingImage, class TDeformationField, class TAVFilterType>
    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::PrintSelf(std::ostream& os, Indent indent) const
    { 
      Superclass::PrintSelf( os, indent );
    }

    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::WMLTestSingleImageKeepAllFunctionValue_NoSmoothPre(int id, ImagePointerType T1Image, ImagePointerType T2Image, ImagePointerType PDImage, ImagePointerType FLImage, ImagePointerType MaskImage, int have_mask, IntSampleType* list)
    {

      cout << "WMLAdaptiveBooster::WMLTestSingleImageKeepAllFunctionValue_NoSmoothPre" << endl;

      // Mask image here should be Premask image!

      typename ImageType::IndexType  imageindex;
      int test_index;

      //  voxel_list = IntSampleType::New();

      //  IntSampleType::Pointer templist = IntSampleType::New();

      test_index = 0;
      // calculate number of voxels
      for (int kk=0; kk<dim_z; kk++)
        for (int jj=0; jj<dim_y; jj++)
          for (int ii=0; ii<dim_x; ii++)    // CAUTION
          {
            imageindex[0]=ii; imageindex[1] = jj; imageindex[2] = kk;

            // only for have_mask
            if (IsValidVoxel_Neighbor(T1Image, imageindex) &&
              IsValidVoxel_Neighbor(T2Image, imageindex) &&
              IsValidVoxel_Neighbor(PDImage, imageindex) &&
              IsValidVoxel_Neighbor(FLImage, imageindex) &&
              (MaskImage->GetPixel(imageindex)!=0)) {

                IntSampleType::MeasurementVectorType  mv;
                mv.SetSize(4);

                mv.SetElement(0, 0);
                mv.SetElement(1, 0);
                mv.SetElement(2, 0);
                mv.SetElement(3, 0);
                list->PushBack(mv);

                test_index++;
            }
          }

          cout << "test_index: " << test_index << endl;


          test_index = 0;
          for (int kk=0; kk<dim_z; kk++)
            for (int jj=0; jj<dim_y; jj++)
              for (int ii=0; ii<dim_x; ii++)    // CAUTION
              {
                imageindex[0]=ii; imageindex[1] = jj; imageindex[2] = kk;

                // only for have_mask
                if (IsValidVoxel_Neighbor(T1Image, imageindex) &&
                  IsValidVoxel_Neighbor(T2Image, imageindex) &&
                  IsValidVoxel_Neighbor(PDImage, imageindex) &&
                  IsValidVoxel_Neighbor(FLImage, imageindex) &&
                  (MaskImage->GetPixel(imageindex)!=0)) {

                    IntSampleType::MeasurementVectorType  mv;
                    mv.SetSize(4);

                    mv.SetElement(0, ii);
                    mv.SetElement(1, jj);
                    mv.SetElement(2, kk);
                    mv.SetElement(3, -1.0);

                    list->SetMeasurementVector(test_index, mv);

                    test_index++;
                }
              }

              printf("index value at WMLTestSingleImageKeepAllFunctionValue_NoSmooth(): %d\n\n", test_index);

              //cout << "writing " << testfilename.str().c_str() << "..." << endl;


              m_MaskVoxels[id] = test_index;



              // Saving test.example

              FILE *fp;

              //fp = fopen(testfilename.str().c_str(), "w");
              std::ostringstream testfilename;
              testfilename << "test" << id << ".example" << ends;
              fp = fopen(testfilename.str().c_str(), "w"); // CAUTION!

              fprintf(fp, "%d %d\n", test_index, pixelNumInBubble*4);
              printf("%d %d\n", test_index, pixelNumInBubble*4);

              //  for (int i=0; i<m_total_voxel_number; i++) {
              for (int i=0; i<test_index; i++) {
                IntSampleType::MeasurementVectorType  mv;
                mv.SetSize(4);
                mv = list->GetMeasurementVector(i);

                for (int j=0; j<pixelNumInBubble; j++) {

                  IntSampleType::MeasurementVectorType mv2;
                  mv2.SetSize(pixelNumInBubble);
                  mv2 = bubble->GetMeasurementVector(j);

                  imageindex[0] = static_cast<long int>(mv.GetElement(0) + mv2.GetElement(1));  // CAUTION!!!
                  imageindex[1] = static_cast<long int>(mv.GetElement(1) + mv2.GetElement(0));
                  imageindex[2] = static_cast<long int>(mv.GetElement(2) + mv2.GetElement(2));

                  if ((imageindex[0]>=0) && (imageindex[1]>=0) && (imageindex[2]>=0) &&
                    (imageindex[0]<dim_x) && (imageindex[1]<dim_y) && (imageindex[2]<dim_z))
                    fprintf(fp, "%f %f %f %f ", (float) T1Image->GetPixel(imageindex), (float) T2Image->GetPixel(imageindex),
                    (float) PDImage->GetPixel(imageindex), (float) FLImage->GetPixel(imageindex)); // weight
                }
                fprintf(fp, "\n");
              }

              fclose(fp);


              /*
              // Saving voxel_list

              IntSampleType::MeasurementVectorType mv_list;
              mv_list.SetSize(3*test_index); 

              cout << "length of list: " << 3*test_index << endl;

              for (int i=0; i<test_index; i=i+3) {
              IntSampleType::MeasurementVectorType  mv;
              mv.SetSize(3);
              mv = list->GetMeasurementVector(i);

              mv_list.SetElement(i, mv.GetElement(0));
              mv_list.SetElement(i+1, mv.GetElement(1));
              mv_list.SetElement(i+2, mv.GetElement(2));
              }


              list->PushBack(mv_list);
              */


              // Export voxel_list to file 
              FILE *gfp;

              std::ostringstream voxellistfilename;
              voxellistfilename << "nonlesion_voxellist" << id << ".txt" << ends;
              gfp = fopen(voxellistfilename.str().c_str(), "w");

              int ii;
              for (ii=0; ii<test_index; ii++) {
                IntSampleType::MeasurementVectorType  mv;
                mv.SetSize(4);
                mv = list->GetMeasurementVector(ii);

                for (unsigned int j=0; j<mv.Size(); j++) {
                  fprintf (gfp, "%d ", mv.GetElement(j));
                }
                fprintf (gfp, "\n");
              }

              fclose(gfp);


              printf("before svm_test\n");

    }

    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::WMLTestSingleImageKeepAllFunctionValue_NoSmooth(int id, std::ostringstream& testfilename, std::ostringstream&
      svmtestoutfile,  std::ostringstream& svmfilename)
    {

      cout << "WMLAdaptiveBooster::WMLTestSingleImageKeepAllFunctionValue_NoSmooth" << endl;
      cout << "Image ID: " << id << endl;
      cout << "testfilename: " << testfilename.str().c_str() << endl;
      cout << "svmtestoutfile: " << svmtestoutfile.str().c_str() << endl;
      cout << "svmfilename: " << svmfilename.str().c_str() << endl;
      cout << endl;

      cout << "m_PreIter: " << m_PreIter << endl;



      // SVM Test

      cout << "SVM Testing..." << endl;

      cout << "testfilename: " << testfilename.str().c_str() << endl;
      cout << "svmfilename: " << svmfilename.str().c_str() << endl;
      cout << "svmtestoutfile: " << svmtestoutfile.str().c_str() << endl;

      Tester.Testing(testfilename, svmfilename, svmtestoutfile);  //TODO: functions for parameter setting for svm tester

    }




    template <class TImage, class TMeasurementVector >
    int
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::WMLTestSingleImageKeepAllFunctionValue_NoSmooth_NoMask(ImagePointerType T1Image, ImagePointerType T2Image, ImagePointerType PDImage, ImagePointerType FLImage, ImagePointerType FLThresholdImage, ImagePointerType outimg, std::ostringstream& testfilename, std::ostringstream& svmtestoutfile, std::ostringstream& svmfilename)
    {
      cout << "WMLAdaptiveBooster::WMLTestSingleImageKeepAllFunctionValue_NoSmooth_NoMask" << endl;

      typename ImageType::IndexType  imageindex;
      test_voxel_list = IntSampleType::New();

      int test_index = 0;

      typename ImageType::SizeType size = T1Image->GetLargestPossibleRegion().GetSize();

      for (unsigned int kk=0; kk<size[2]; kk++)
        for (unsigned int jj=0; jj<size[1]; jj++)
          for (unsigned int ii=0; ii<size[0]; ii++)    // CAUTION
          {
            imageindex[0]=ii; imageindex[1] = jj; imageindex[2] = kk;

            if (IsValidVoxel_Neighbor(T1Image, imageindex) &&
              IsValidVoxel_Neighbor(T2Image, imageindex) &&
              IsValidVoxel_Neighbor(PDImage, imageindex) &&
              IsValidVoxel_Neighbor(FLImage, imageindex) && 
	      (FLThresholdImage->GetPixel(imageindex)>0)  )  // 0318
            {
              IntSampleType::MeasurementVectorType  mv;
              mv.SetSize(4);

              mv.SetElement(0, ii);
              mv.SetElement(1, jj);
              mv.SetElement(2, kk);
              mv.SetElement(3, -1.0);

              test_voxel_list->PushBack(mv);

              test_index++;
            }
          }

          printf("index value at WMLTestSingleImageKeepAllFunctionValue_NoSmooth(): %d\n", test_index);

          //    if (test_index!=m_total_voxel_number)  {
          //      printf("valid voxel number doesn't match\n");
          //      exit(2);
          //    }


          FILE *fp;

          //   fp = fopen("test.example", "w");
          fp = fopen(testfilename.str().c_str(), "w");

          // for only voxel-wise neighbor

          fprintf(fp, "%d %d\n", test_index, pixelNumInBubble*4);
          printf("%d %d\n", test_index, pixelNumInBubble*4);

          //  for (int i=0; i<m_total_voxel_number; i++) {
          for (int i=0; i<test_index; i++) {
            IntSampleType::MeasurementVectorType  mv;
            mv.SetSize(4);
            mv = test_voxel_list->GetMeasurementVector(i);

            for (int j=0; j<pixelNumInBubble; j++) {

              IntSampleType::MeasurementVectorType mv2;
              mv2.SetSize(pixelNumInBubble);
              mv2 = bubble->GetMeasurementVector(j);

              imageindex[0] = static_cast<long int>(mv.GetElement(0) + mv2.GetElement(1));  // CAUTION!!!
              imageindex[1] = static_cast<long int>(mv.GetElement(1) + mv2.GetElement(0));
              imageindex[2] = static_cast<long int>(mv.GetElement(2) + mv2.GetElement(2));
              // --


              if ((imageindex[0]>=0) && (imageindex[1]>=0) && (imageindex[2]>=0) &&
                (imageindex[0]<dim_x) && (imageindex[1]<dim_y) && (imageindex[2]<dim_z))
                fprintf(fp, "%f %f %f %f ", (float) T1Image->GetPixel(imageindex), (float) T2Image->GetPixel(imageindex),
                (float) PDImage->GetPixel(imageindex), (float) FLImage->GetPixel(imageindex)); // weight
            }
            fprintf(fp, "\n");
          }

          fclose(fp);

          printf("before svm_test\n");

          // SVM Test
          Tester.Testing(testfilename, svmfilename, svmtestoutfile);  //TODO: functions for parameter setting for svm tester

          return test_index;



    }

    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::InvertImgFloat(FloatImagePointerType img, FloatImagePointerType out)
    {
      // parameter: in_image, out_image

      cout << "WMLAdaptiveBooster::InvertImgFloat()" << endl;


      /*
      FloatImagePointerType out = FloatImageType::New();
      FloatImageType::IndexType start;
      start[0] = 0; start[1] = 0; start[2] = 0;

      FloatImageType::SizeType size;
      size[0] = dim_x; size[1] = dim_y; size[2] = dim_z;

      FloatImageType::RegionType region;
      region.SetSize(size);
      region.SetIndex(start);

      out->SetRegions(region);
      out->Allocate();
      */

      double minvalue, maxvalue;
      maxvalue = -100000.0; minvalue = 100000.0;
      int i,j,k;

      FloatImageType::IndexType  imageindextemp;    

      for (k=0; k<dim_z; k++)
        for (i=0; i<dim_x; i++)
          for (j=0; j<dim_y; j++) {

            imageindextemp[0] = i; imageindextemp[1] = j; imageindextemp[2] = k;

            img->SetPixel(imageindextemp, img->GetPixel(imageindextemp)*10000.0);

            if (img->GetPixel(imageindextemp) < minvalue) minvalue = img->GetPixel(imageindextemp);
            if (img->GetPixel(imageindextemp) > maxvalue) maxvalue = img->GetPixel(imageindextemp);

            //img[k][i][j] *= 10000.0;
            //if (img[k][i][j] < minvalue) minvalue = img[k][i][j];
            //if (img[k][i][j] > maxvalue) maxvalue = img[k][i][j];
          }
          printf("(min, max): (%f, %f)\n", minvalue, maxvalue);

          for (k=0; k<dim_z; k++)
            for (i=0; i<dim_x; i++)
              for (j=0; j<dim_y; j++) {

                imageindextemp[0] = i; imageindextemp[1] = j; imageindextemp[2] = k;

                if (fabs(img->GetPixel(imageindextemp)) < 0.01 )   // CAUTION!!!
                  out->SetPixel(imageindextemp, -10000.0);
                else
                  out->SetPixel(imageindextemp, img->GetPixel(imageindextemp)*(-1.0));

                //  if (fabs(img[k][i][j]) < 0.01) out[k][i][j] = -10000.0;
                //  else out[k][i][j] = -img[k][i][j];
              }

              maxvalue = -100000.0; minvalue = 100000.0;
              for (k=0; k<dim_z; k++)
                for (i=0; i<dim_x; i++)
                  for (j=0; j<dim_y; j++) {
                    imageindextemp[0] = i; imageindextemp[1] = j; imageindextemp[2] = k;

                    if (out->GetPixel(imageindextemp) < minvalue) minvalue = out->GetPixel(imageindextemp);
                    if (out->GetPixel(imageindextemp) > maxvalue) maxvalue = out->GetPixel(imageindextemp);

                    // if (out[k][i][j] < minvalue) minvalue = out[k][i][j];
                    // if (out[k][i][j] > maxvalue) maxvalue = out[k][i][j];
                  }
                  printf("(min, max): (%f, %f)\n", minvalue, maxvalue);

                  for (k=0; k<dim_z; k++)
                    for (i=0; i<dim_x; i++)
                      for (j=0; j<dim_y; j++) {
                        imageindextemp[0] = i; imageindextemp[1] = j; imageindextemp[2] = k;

                        out->SetPixel(imageindextemp, (out->GetPixel(imageindextemp))/10000.0);

                        // out[k][i][j] /= 10000.0;
                      }

                      maxvalue = -100000.0; minvalue = 100000.0;
                      for (k=0; k<dim_z; k++)
                        for (i=0; i<dim_x; i++)
                          for (j=0; j<dim_y; j++) {
                            imageindextemp[0] = i; imageindextemp[1] = j; imageindextemp[2] = k;

                            if (out->GetPixel(imageindextemp) < minvalue) minvalue = out->GetPixel(imageindextemp);
                            if (out->GetPixel(imageindextemp) > maxvalue) maxvalue = out->GetPixel(imageindextemp);

                            // if (out[k][i][j] < minvalue) minvalue = out[k][i][j];
                            // if (out[k][i][j] > maxvalue) maxvalue = out[k][i][j];
                          }
                          printf("(min, max): (%f, %f)\n", minvalue, maxvalue);
    }

    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::ThresholdImage(FloatImagePointerType inimg, float threshold, int id, std::ostringstream& filename)
    {
      // parameter: image, threshold
      // just call threshold function in ITK

      cout << "WMLAdaptiveBooster::ThresoldImage()" << endl;

      // ITK Binary Threshold 

      int i, j, k;

      typename ImageType::IndexType index;

      typename ImageType::Pointer intimg = ImageType::New();
      typename ImageType::IndexType start;
      start[0] = 0; start[1] = 0; start[2] = 0;

      typename ImageType::SizeType size;
      size[0] = dim_x; size[1] = dim_y; size[2] = dim_z;

      typename ImageType::RegionType region;
      region.SetSize(size);
      region.SetIndex(start);

      intimg->SetRegions(region);
      intimg->Allocate();

#define READFILE
#ifdef READFILE
      typedef itk::ImageFileReader<FloatImageType> FloatReaderType;
      FloatReaderType::Pointer floatreader = FloatReaderType::New();

      FloatImageType::Pointer input = FloatImageType::New();

      floatreader->SetFileName(filename.str().c_str());
      floatreader->Update();
      input = floatreader->GetOutput();
#endif // READFILE

      typedef itk::ImageFileWriter<FloatImageType> FloatWriterType;
      FloatWriterType::Pointer floatwriter = FloatWriterType::New();

      floatwriter->SetFileName("beforethreshold.mha");
      floatwriter->SetInput(input);
      floatwriter->Update();

      cout << "threshold: " << threshold << endl;


      //   typename BinaryThresholdImageFilter<FloatImageType, ImageType>::Pointer thresh_filter =
      //    BinaryThresholdImageFilter<FloatImageType, ImageType>::New();

      for(k=0; k<dim_z; k++)
        for(i=0; i<dim_x; i++)
          for(j=0; j<dim_y; j++) {

            index[0] = i; index[1] = j; index[2] = k;

#ifdef READFILE
            if (input->GetPixel(index) >= threshold) {
              intimg->SetPixel(index, 255);
            }
            else intimg->SetPixel(index, 0);
#else
            if (inimg->GetPixel(index) >= threshold) {
              intimg->SetPixel(index, 255);
            }
            else intimg->SetPixel(index, 0);
#endif
          }
          cout << endl;

          /*
          thresh_filter->SetInsideValue( 0 ); 
          thresh_filter->SetOutsideValue( 255 ); 
          //        thresh_filter->SetLowerThreshold(threshold); 
          thresh_filter->SetUpperThreshold( threshold ); 
          thresh_filter->SetInput( inimg );   
          thresh_filter->Update();
          outimg = thresh_filter->GetOutput();


          for(k=0; k<dim_z; k++)
          for(i=0; i<dim_x; i++)
          for(j=0; j<dim_y; j++) {

          index[0] = i; index[1] = j; index[2] = k;

          intimg->SetPixel(index, (int) outimg->GetPixel(index));
          }

          */

          for(k=0; k<dim_z; k++)
            for(i=0; i<dim_x; i++)
              for(j=0; j<dim_y; j++) {
                index[0] = i; index[1] = j; index[2] = k;

                m_AutoMaskImage[id]->SetPixel(index, intimg->GetPixel(index));
              }


              std::ostringstream th_img;
              th_img << "threshold" << id << "_" << m_PreIter << ".mha" << ends;

              typedef itk::ImageFileWriter<ImageType> WriterType;
              typename WriterType::Pointer writer = WriterType::New();

              writer->SetFileName(th_img.str());
              writer->SetInput(m_AutoMaskImage[id]);
              writer->Update();
    }


    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::WMLGetAutoManualMaskDiff(ImageVectorType rator1Img, ImageVectorType rator2Img)
    {

#define READ_THFILE

      // rator1Img: manual masked image, rator2Image: automatically masked image

      cout << "WMLAdaptiveBooster::WMLGetAutoManualMaskDiff()" << endl;

      // current input: manual+mask.lst, auto_mask.lst  -> image vector

      ImagePointerType rator1Flag, rator2Flag, ratorAllImg, ratorAllFlag, VoxelInStack;  
      int  rator1LabelCnt, rator2LabelCnt, ratorAllLabelCnt;

      float       TP = 0.0, TN = 0.0, FP = 0.0, FN = 0.0, CT = 0.0, UMINUSCT = 0.0;
      // float       TPVF = 0.0, TNVF = 0.0, FPVF = 0.0, FNVF = 0.0, FPVFR = 0.0;  

      int s, i, j, k;
      unsigned int id;
      typename ImageType::IndexType  imageindextemp;

      // alloc images
      rator1Flag = ImageType::New();
      rator2Flag = ImageType::New();
      ratorAllImg  = ImageType::New();
      ratorAllFlag = ImageType::New();
      VoxelInStack = ImageType::New();  

      typename ImageType::IndexType start;
      start[0] = 0; start[1] = 0; start[2] = 0;

      typename ImageType::SizeType size;
      size[0] = dim_x; size[1] = dim_y; size[2] = dim_z;

      typename ImageType::RegionType region;
      region.SetSize(size);
      region.SetIndex(start);

      rator1Flag->SetRegions(region);
      rator1Flag->Allocate();

      rator2Flag->SetRegions(region);
      rator2Flag->Allocate();

      ratorAllImg->SetRegions(region);
      ratorAllImg->Allocate();

      ratorAllFlag->SetRegions(region);
      ratorAllFlag->Allocate();

      VoxelInStack->SetRegions(region);  
      VoxelInStack->Allocate();  

      DoubleSampleType::MeasurementVectorType stack_mv;


      if (m_PreIter == 0) {
        DiffStack = DoubleSampleType::New();
        DiffStack->SetMeasurementVectorSize(3);

        stack_mv.SetSize(DiffStack->GetMeasurementVectorSize());

        for (i=0; i<dim_x*dim_y*dim_z; i++) {
          stack_mv.SetElement(0, 0);  stack_mv.SetElement(1, 0);  stack_mv.SetElement(2, 0);
          DiffStack->PushBack(stack_mv);
        }
      }
      else {
        stack_mv.SetSize(DiffStack->GetMeasurementVectorSize());
        for (i=0; i<dim_x*dim_y*dim_z; i++) {
          stack_mv.SetElement(0,0); stack_mv.SetElement(1,0); stack_mv.SetElement(2,0);
          DiffStack->SetMeasurementVector(i, stack_mv);
        }
      }


      // alloc stack
      // for debug
      typedef itk::ImageFileWriter<ImageType> WriterType;
      typename WriterType::Pointer writer = WriterType::New();
      typename WriterType::Pointer writer2 = WriterType::New();


      for (id=0; id<m_NumImages; id++) {

        std::ostringstream rator1name;
        std::ostringstream rator2name;

        rator1name << "rator1Img" << id << "_" << m_PreIter << ".mha" << ends;
        rator2name << "rator2Img" << id << "_" << m_PreIter << ".mha" << ends;

        std::ostringstream filename2;

        filename2 << "threshold" << id << "_" << m_PreIter << ".mha" << ends;

#ifdef READ_THFILE
        typedef itk::ImageFileReader<ImageType> ReaderType;
        //   ReaderType::Pointer reader1 = ReaderType::New();
        typename ReaderType::Pointer reader2 = ReaderType::New();

        //   ImageType::Pointer input1 = ImageType::New();
        typename ImageType::Pointer input2 = ImageType::New();

        //   reader1->SetFileName(filename1.str().c_str());
        //   reader1->Update();
        //   input1 = reader1->GetOutput();

        reader2->SetFileName(filename2.str().c_str());
        reader2->Update();
        input2 = reader2->GetOutput();
#endif // READ_THFILE


#ifdef READ_THFILE
        writer->SetFileName(rator1name.str());
        writer->SetInput(rator1Img[id]);
        writer->Update();

        writer2->SetFileName(rator2name.str());
        writer2->SetInput(input2);
        writer2->Update();

#else
        writer->SetFileName(rator1name.str());
        writer->SetInput(rator1Img[id]);
        writer->Update();

        writer2->SetFileName(rator2name.str());
        writer2->SetInput(rator2Img[id]);
        writer2->Update();
#endif

        cout << "dim_x: " << dim_x << endl;
        cout << "dim_y: " << dim_y << endl;
        cout << "dim_z: " << dim_z<< endl;



        for(k=0; k<dim_z; k++)
          for(i=0; i<dim_x; i++)
            for(j=0; j<dim_y; j++) {

              imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

              rator1Flag->SetPixel(imageindextemp, 0);
              rator2Flag->SetPixel(imageindextemp, 0);
              ratorAllImg->SetPixel(imageindextemp, 0);
              ratorAllFlag->SetPixel(imageindextemp, 0);
              VoxelInStack->SetPixel(imageindextemp, 0); 
            }


            for (i=0; i<dim_x*dim_y*dim_z; i++) {
              stack_mv.SetElement(0, 0);  stack_mv.SetElement(1, 0);  stack_mv.SetElement(2, 0);
              DiffStack->SetMeasurementVector(i, stack_mv);
            }


            for(k=0; k<dim_z; k++)
              for(i=0; i<dim_x; i++)
                for(j=0; j<dim_y; j++) {
                  imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;
#ifdef READ_THFILE
                  if( rator1Img[id]->GetPixel(imageindextemp)!= 0 || input2->GetPixel(imageindextemp)!= 0 )
                    ratorAllImg->SetPixel(imageindextemp, 255);
#else
                  if( rator1Img[id]->GetPixel(imageindextemp)!= 0 || rator2Img[id]->GetPixel(imageindextemp)!= 0 )
                    ratorAllImg->SetPixel(imageindextemp, 255);
#endif
                }

                /* assume the outer pixel is not lesion pixel */
                rator1LabelCnt = rator2LabelCnt = ratorAllLabelCnt = 0;

                for(k=1; k<dim_z-1; k++)
                  for(i=1; i<dim_x-1; i++)
                    for(j=1; j<dim_y-1; j++) {
                      imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

#ifdef READ_THFILE
                      if ((input2->GetPixel(imageindextemp)>0)  && (rator2Flag->GetPixel(imageindextemp)==0))
                      {
                        rator2LabelCnt++;
                        labelThisPoint(k, i, j, input2, rator2Flag, rator2LabelCnt, VoxelInStack);
                      }
#else
                      if ((rator2Img[id]->GetPixel(imageindextemp)>0)  && (rator2Flag->GetPixel(imageindextemp)==0))
                      {
                        rator2LabelCnt++;
                        labelThisPoint(k, i, j, rator2Img[id], rator2Flag, rator2LabelCnt, VoxelInStack); 
                      }
#endif
                    }
                    printf("there are %d labels in rater 2's result\n",rator2LabelCnt);


                    VoxelInStack->FillBuffer(0);
                    //   for(k=0; k<dim_z; k++)
                    //     for(i=0; i<dim_x; i++)
                    //        for(j=0; j<dim_y; j++) {
                    //         imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;
                    //         VoxelInStack->SetPixel(imageindextemp, 0);
                    //     }
                    // --

                    for(k=1; k<dim_z-1; k++)
                      for(i=1; i<dim_x-1; i++)
                        for(j=1; j<dim_y-1; j++) {

                          imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

#ifdef READ_THFILE
                          if((rator1Img[id]->GetPixel(imageindextemp) > 0) &&  (rator1Flag->GetPixel(imageindextemp) == 0)){
                            rator1LabelCnt++;
                            labelThisPoint(k, i, j, rator1Img[id], rator1Flag, rator1LabelCnt, VoxelInStack);
                          }
#else
                          if((rator1Img[id]->GetPixel(imageindextemp) > 0) &&  (rator1Flag->GetPixel(imageindextemp) == 0)){
                            rator1LabelCnt++;
                            labelThisPoint(k, i, j, rator1Img[id], rator1Flag, rator1LabelCnt, VoxelInStack); 
                          }
#endif
                        }  // for
                        printf("there are %d labels in rater 1's result\n",rator1LabelCnt);


                        /* initialize the stack info */
                        VoxelInStack->FillBuffer(0);
                        //    for(k=0; k<dim_z; k++)
                        //      for(i=0; i<dim_x; i++)
                        //        for(j=0; j<dim_y; j++) {
                        //         imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;
                        //         VoxelInStack->SetPixel(imageindextemp, 0);
                        //    }
                        // --

                        for(k=1; k<dim_z-1; k++)
                          for(i=1; i<dim_x-1; i++ )
                            for(j=1; j<dim_y-1; j++) {

                              imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

                              if(ratorAllImg->GetPixel(imageindextemp)> 0 && ratorAllFlag->GetPixel(imageindextemp)== 0){
                                ratorAllLabelCnt++;
                                labelThisPoint(k, i, j, ratorAllImg, ratorAllFlag, ratorAllLabelCnt, VoxelInStack);  
                              } // if
                            } // for

                            printf("there are %d labels in these two rater's result\n",ratorAllLabelCnt);

                            for(k=1; k<dim_z-1; k++)
                              for(i=1; i<dim_x-1; i++ )
                                for(j=1; j<dim_y-1; j++) {

                                  imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

#ifdef READ_THFILE
                                  if(rator1Img[id]->GetPixel(imageindextemp)!= 0 && ratorAllFlag->GetPixel(imageindextemp)!= 0 )
                                    rator1Flag->SetPixel(imageindextemp, ratorAllFlag->GetPixel(imageindextemp));
                                  if(input2->GetPixel(imageindextemp)!= 0 && ratorAllFlag->GetPixel(imageindextemp)!= 0 )
                                    rator2Flag->SetPixel(imageindextemp, ratorAllFlag->GetPixel(imageindextemp)); 
#else
                                  if(rator1Img[id]->GetPixel(imageindextemp)!= 0 && ratorAllFlag->GetPixel(imageindextemp)!= 0 )
                                    rator1Flag->SetPixel(imageindextemp, ratorAllFlag->GetPixel(imageindextemp));
                                  if(rator2Img[id]->GetPixel(imageindextemp)!= 0 && ratorAllFlag->GetPixel(imageindextemp)!= 0 )	
                                    rator2Flag->SetPixel(imageindextemp, ratorAllFlag->GetPixel(imageindextemp));
#endif
                                }


                                /* calculate overlap percentage for all painting voxels */
                                for(k=1; k<dim_z-1; k++)
                                  for(i=1; i<dim_x-1; i++)
                                    for(j=1; j<dim_y-1; j++) {

                                      imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

                                      if (rator1Flag->GetPixel(imageindextemp)>0 && rator2Flag->GetPixel(imageindextemp)==0){
                                        CT += 1.0;
                                        FN += 1.0;
                                      }
                                      else if (rator2Flag->GetPixel(imageindextemp) > 0 && rator1Flag->GetPixel(imageindextemp)==0) {
                                        UMINUSCT += 1.0;
                                        FP += 1.0;
                                      }
                                      else if (rator1Flag->GetPixel(imageindextemp) > 0 && rator2Flag->GetPixel(imageindextemp) > 0 
                                        && rator2Flag->GetPixel(imageindextemp) == rator1Flag->GetPixel(imageindextemp)) {
                                          CT += 1.0;
                                          TP += 1.0;
                                      } 
                                      else{
                                        UMINUSCT += 1.0;
                                        TN += 1.0;
                                      }

                                    } // for

                                    s = m_NumImages;
                                    printf("(TP,TN,FP,FN,CT,UMINUSCT) are (%d,%d,%d,%d,%d,%d)...", (int)TP, (int)TN, (int)FP, (int)FN, (int)CT, (int)UMINUSCT);
                                    printf("%.2f finished\n", (float)s/m_NumImages*100);

      } // for : m_NumImages

      printf("(TP, TN, FP, FN, CT, UMINUSCT) are (%f, %f, %f, %f, %f, %f)\n", TP, TN, FP, FN, CT, UMINUSCT);
      printf("TPVF,FPVF,FNVF are %f, %f, %f\n", TP/CT, FP/CT, FN/CT);

      // save error
      m_err[0] = TP/CT; m_err[1] = FP/CT; m_err[2] = FN/CT;
      // --
    }

    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::labelThisPoint(int k, int i, int j, ImagePointerType inpImg, ImagePointerType inpFlag, int label, ImagePointerType VoxelInStack) 
    {

      // cout << "WMLAdaptiveBooster::labelThisPoint()" << endl;
      int        kk,ii,jj;
      int        k_plus_nbrSize, k_minus_nbrSize, i_plus_nbrSize;
      int        i_minus_nbrSize, j_plus_nbrSize, j_minus_nbrSize;
      long int   Pointer ;
      int nbrSize = 1;

      typename ImageType::IndexType  imageindextemp;

      Pointer = 0 ;
      //Stack[Pointer].x = i;  Stack[Pointer].y = j;  Stack[Pointer].z = k;

      DoubleSampleType::MeasurementVectorType stack_mv;
      stack_mv.SetSize(DiffStack->GetMeasurementVectorSize());

      stack_mv = DiffStack->GetMeasurementVector(Pointer); 
      stack_mv.SetElement(0, i); stack_mv.SetElement(1, j); stack_mv.SetElement(2, k);

      DiffStack->SetMeasurementVector(Pointer, stack_mv);


      do{

        stack_mv = DiffStack->GetMeasurementVector(Pointer);
        i = static_cast<int> (stack_mv.GetElement(0));
        j = static_cast<int> (stack_mv.GetElement(1));
        k = static_cast<int> (stack_mv.GetElement(2));


        Pointer -- ;

        imageindextemp[0] = i;  imageindextemp[1] = j; imageindextemp[2] = k; 
        inpFlag->SetPixel(imageindextemp, label);

        k_plus_nbrSize =k+nbrSize;    k_minus_nbrSize=k-nbrSize;
        i_plus_nbrSize =i+nbrSize;    i_minus_nbrSize=i-nbrSize;
        j_plus_nbrSize =j+nbrSize;    j_minus_nbrSize=j-nbrSize;

        if (k_plus_nbrSize>=dim_z) k_plus_nbrSize=dim_z-1;
        if (k_minus_nbrSize<0)     k_minus_nbrSize=0;
        if (j_plus_nbrSize>=dim_y) j_plus_nbrSize=dim_y-1;
        if (j_minus_nbrSize<0)     j_minus_nbrSize=0;
        if (i_plus_nbrSize>=dim_x) i_plus_nbrSize=dim_x-1;
        if (i_minus_nbrSize<0)     i_minus_nbrSize=0;

        for(kk=k_minus_nbrSize; kk<=k_plus_nbrSize; kk++){
          for(ii=i_minus_nbrSize; ii<=i_plus_nbrSize; ii++){
            for(jj=j_minus_nbrSize; jj<=j_plus_nbrSize; jj++){
              imageindextemp[0] = ii;  imageindextemp[1] = jj; imageindextemp[2] = kk; 

              if ( !(kk==k && jj==j && ii==i) &&
                (kk==k&&jj==j || kk==k&&ii==i || jj==j&&ii==i) &&
                inpImg->GetPixel(imageindextemp) != 0 && inpFlag->GetPixel(imageindextemp) == 0 && VoxelInStack->GetPixel(imageindextemp)==0) {

                  Pointer ++ ;

                  stack_mv.SetElement(0, ii); stack_mv.SetElement(1, jj); stack_mv.SetElement(2, kk);
                  DiffStack->SetMeasurementVector(Pointer, stack_mv);  

                  VoxelInStack->SetPixel(imageindextemp, 1);
              }

            } // for jj
          }
        }
      } while(Pointer>=0);
    }

    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::MaskOutImg(ImagePointerType img, ImagePointerType mask, float threshold, int id)
    {
      cout << "WMLAdaptiveBooster::MaskOutImg()" << endl;

      //parameter: WML.mask.img.pre_iter,rg, manualmaskfile_open, threshold 

      int   i, j, k, l, histo[256], label2remove_num, label2keep_num;
      // *label2remove, *label2keep;
      float overlap_degree;
      //  FILE  *fp;

      // for debugging

      std::ostringstream filename;
      filename << "maskout_input" << m_PreIter << ".mha" << ends;

      typedef itk::ImageFileWriter<ImageType> WriterType;
      typename WriterType::Pointer writer = WriterType::New();

      writer->SetFileName(filename.str().c_str());
      writer->SetInput(img);
      writer->Update();
      // --

#define RGFILE  // CAUTION: should be read from file!
#ifdef RGFILE

      std::ostringstream rgfilename;
      rgfilename << "regiongrowing0_" << m_PreIter << ".mha" << ends; 

      typename itk::ImageFileReader<ImageType>::Pointer reader = itk::ImageFileReader<ImageType>::New();
      reader->SetFileName(rgfilename.str().c_str());
      reader->Update();

      typename ImageType::Pointer input = reader->GetOutput();
#endif // RGFILE


      typename ImageType::IndexType  imageindextemp;

      for (i=0; i<256; i++) histo[i] = 0;

      for (k=0; k<dim_z; k++)
        for (i=0; i<dim_x; i++)
          for (j=0; j<dim_y; j++) {

            imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

#ifdef RGFILE
            if(input->GetPixel(imageindextemp)!= 0)
              histo[input->GetPixel(imageindextemp)]++;
#else
            if(img->GetPixel(imageindextemp)!= 0) 
              histo[img->GetPixel(imageindextemp)]++;
#endif
          }

          // for debugging
          cout << "print histogram..." << endl;
          for (i=0; i<256; i++)
            cout << histo[i] << " " ;
          cout << endl;
          // --

          IntVectorType label2remove;
          label2remove.SetSize(256);

          label2remove_num = 0;

          IntVectorType label2keep;
          label2keep.SetSize(256);

          label2keep_num = 0;

          for (i=0; i<256; i++)
            if (histo[i] != 0) {
#ifdef RGFILE
              overlap_degree = get_label_overlap_degree(i, input, mask);
#else
              overlap_degree = get_label_overlap_degree(i, img, mask);  
#endif

              // for debbugging 
              printf ("overlap_degree: %f\n", overlap_degree);

              // --

              if (overlap_degree < threshold) {
                label2remove[label2remove_num] = i;
                label2remove_num++;
              }
              if (overlap_degree >= threshold) {
                label2keep[label2keep_num] = i;
                label2keep_num++;
              }
            }

            // for debbugging
            cout << "label2remove_num: " << label2remove_num << endl;
            cout << "label2keep_num: " << label2keep_num << endl;

            for (l=0; l<label2keep_num; l++)
              for (k=0; k<dim_z; k++)
                for (i=0; i<dim_x; i++)
                  for (j=0; j<dim_y; j++) {
                    imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;
#ifdef RGFILE
                    if(input->GetPixel(imageindextemp)== label2keep[l]) input->SetPixel(imageindextemp, 0);
#else 
                    if(img->GetPixel(imageindextemp)== label2keep[l]) img->SetPixel(imageindextemp, 0);
#endif // RGFILE

                  }

                  for (k=0; k<dim_z; k++)
                    for (i=0; i<dim_x; i++)
                      for (j=0; j<dim_y; j++){
                        imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;
#ifdef RGFILE
                        if(input->GetPixel(imageindextemp)!= 0) {
                          input->SetPixel(imageindextemp, 255);
                        }
#else
                        if(img->GetPixel(imageindextemp)!= 0) 
                          img->SetPixel(imageindextemp, 255);
#endif // RGFILE
                      }

                      // for debugging

                      std::ostringstream maskout_filename;
                      maskout_filename << "maskoutimg" << id << "_" << m_PreIter << ".mha" << ends;

                      //    typedef itk::ImageFileWriter<ImageType> WriterType;
                      //   WriterType::Pointer writer = WriterType::New();

                      writer->SetFileName(maskout_filename.str());
#ifdef RGFILE
                      writer->SetInput(input);
#else
                      writer->SetInput(img);
#endif // RGFILE
                      writer->Update();
                      // --

    }

    template <class TImage, class TMeasurementVector >
    float
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::get_label_overlap_degree(int label, ImagePointerType img, ImagePointerType mask)
    {
      //cout << "WMLAdaptiveBooster::get_label_overlap_degree()" << endl;

      int        i, j, k, label_total_volume, overlap_volume;
      typename ImageType::IndexType imageindex;

      label_total_volume = 0;
      overlap_volume = 0;
      for (k=0; k<dim_z; k++)
        for (i=0; i<dim_x; i++)
          for (j=0; j<dim_y; j++) {

            imageindex[0] = i; imageindex[1] = j; imageindex[2] = k;

            if (img->GetPixel(imageindex) == label) {
              if (mask->GetPixel(imageindex) != 0) overlap_volume++;
              label_total_volume++;
            }
          }

          return ((float)overlap_volume/label_total_volume);


    }

    template <class TImage, class TMeasurementVector >
    int
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::IsValidVoxel_Neighbor(ImagePointerType img, 
      itk::Index<3> pt)
    {
      // cout << "WMLGetSelectedFeature::IsValidVoxel_Neighbor()" << endl;

      int tmp_pos_x, tmp_pos_y, tmp_pos_z;

      typename ImageType::IndexType  imageindex;
      typename ImageType::PixelType  pixel;


      for (int i=0; i<pixelNumInBubble; i++) {

        IntSampleType::MeasurementVectorType mv;
        mv.SetSize(bubble->GetMeasurementVectorSize());
        mv = bubble->GetMeasurementVector(i);

        tmp_pos_x = mv.GetElement(0)+pt.GetElement(0);
        tmp_pos_y = mv.GetElement(1)+pt.GetElement(1);
        tmp_pos_z = mv.GetElement(2)+pt.GetElement(2);


        imageindex[0]=tmp_pos_x; imageindex[1]=tmp_pos_y; imageindex[2]=tmp_pos_z;
        pixel = img->GetPixel(imageindex);


        if ( (tmp_pos_x<0) || (tmp_pos_y<0) || (tmp_pos_z<0) ||
          (tmp_pos_x>dim_x) || (tmp_pos_y>dim_y) || (tmp_pos_z>dim_z) ||
          (pixel==0)) return 0;
      }

      return 1;
    }


    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::RegionGrowing(ImagePointerType in, int nbrSize, int GreySelected, int RegionPointNum, int GrowingOnPlan, int id)
    {
      cout << "WMLAdaptiveBooster::RegionGrowing()" << endl;

      // typename RegionGrowImageFilter<TImage, TImage>::Pointer rg_filter =
      //     RegionGrowImageFilter<TImage, TImage>::New();

      int order;
      int                   i,j,k, ii,jj,kk;
      long int              PointNum;
      //FILE                  *fp;
      IntVectorType		PointNumInCertainOrder;
      int                   ActualUsedRegionPointNum;

      // for debug

      typedef itk::ImageFileWriter<ImageType> WriterType;
      typename WriterType::Pointer writer = WriterType::New();

      /* std::ostringstream beforergfilename;
      beforergfilename << "beforeregiongrowing" << id << "_" << m_PreIter << ".mha" << ends;

      writer->SetFileName(beforergfilename.str().c_str());
      writer->SetInput(in);
      writer->Update();
      */

#define DIFFFILE
#ifdef DIFFFILE

      std::ostringstream difffilename;
      difffilename << "rator2Img"   << id << "_" << m_PreIter << ".mha" << ends;

      typedef itk::ImageFileReader<ImageType> ReaderType;
      typename ReaderType::Pointer reader = ReaderType::New();

      typename ImageType::Pointer input = ImageType::New();

      reader->SetFileName(difffilename.str().c_str());
      reader->Update();
      input = reader->GetOutput();

#endif // DIFFFILE

      // for debug
      typename ImageType::IndexType imageindextemp;
      int histo[256];
      for (i=0; i<256; i++) histo[i] = 0;

      for (k=0; k<dim_z; k++)
        for (i=0; i<dim_x; i++)
          for (j=0; j<dim_y; j++) {

            imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

#ifdef DIFFFILE
            if(input->GetPixel(imageindextemp)!= 0)
              histo[input->GetPixel(imageindextemp)]++;
#else
            if(in->GetPixel(imageindextemp)!= 0)
              histo[in->GetPixel(imageindextemp)]++;
#endif
          }

          cout << "histogram in BEFORE region growing..." << endl;

          for (i=0; i<256; i++)
            cout << histo[i] << " " ;

          cout << endl;

          // --


          // image types
          ImagePointerType status = ImageType::New();
          ImagePointerType VoxelInStack = ImageType::New();
          IntImagePointerType Detected_Region = IntImageType::New(); 
          ImagePointerType Result_Detected_Region = ImageType::New();  

          typename ImageType::IndexType start;
          start[0] = 0; start[1] = 0; start[2] = 0;

          typename ImageType::SizeType size;
          size[0] = dim_x; size[1] = dim_y; size[2] = dim_z;

          typename ImageType::RegionType region;
          region.SetSize(size);
          region.SetIndex(start);

          typename ImageType::IndexType index;

          status->SetRegions(region);
          status->Allocate();
          //   status->SetSpacing(m_FLImage[0]->GetSpacing());

          Result_Detected_Region->SetRegions(region);
          Result_Detected_Region->Allocate();
          //   Result_Detected_Region->SetSpacing(m_FLImage[0]->GetSpacing());

          VoxelInStack->SetRegions(region);
          VoxelInStack->Allocate();
          //   VoxelInStack->SetSpacing(m_FLImage[0]->GetSpacing());

          IntImageType::IndexType intstart;
          intstart[0] = 0; intstart[1] = 0; intstart[2] = 0;

          IntImageType::SizeType intsize;
          intsize[0] = dim_x; intsize[1] = dim_y; intsize[2] = dim_z;

          IntImageType::RegionType intregion;
          intregion.SetSize(intsize);
          intregion.SetIndex(intstart);

          IntImageType::IndexType intindex;

          Detected_Region->SetRegions(intregion); 
          Detected_Region->Allocate(); 
          //   Detected_Region->SetSpacing(m_FLImage[0]->GetSpacing());

          // Stack
          IntSampleType::Pointer RgStack = IntSampleType::New();
          RgStack->SetMeasurementVectorSize(3);

          IntSampleType::MeasurementVectorType stack_mv;
          stack_mv.SetSize(RgStack->GetMeasurementVectorSize());

          //   if (m_PreIter == 0 ){ 
          for (i=0; i<dim_x*dim_y*dim_z; i++) {
            stack_mv.SetElement(0, 0);  stack_mv.SetElement(1, 0);  stack_mv.SetElement(2, 0);
            RgStack->PushBack(stack_mv);
          }
          //    }


          printf("\n\n nbrSize=%d\n GreySelected=%d\n RegionPointNum=%d\n GrowingOnPlan=%d\n \n", 
            nbrSize, GreySelected, RegionPointNum, GrowingOnPlan) ;  


          // memory alloc
          PointNumInCertainOrder.SetSize(dim_x*dim_y*dim_z);
          PointNumInCertainOrder.Fill(0);

          /* reset ... */
          for(i=0; i<dim_x; i++)
            for(j=0; j<dim_y; j++)
              for(k=0; k<dim_z; k++) {
                index[0] = i; index[1] = j; index[2] = k;

                status->SetPixel(index, FAIL);

                Result_Detected_Region->SetPixel(index, 0);

                intindex[0] = i; intindex[1] = j; intindex[2] = k;
                Detected_Region->SetPixel(intindex, 0);
              }


              /* status for representing whether current voxel already in stack? */
              for(kk=0; kk<dim_z; kk++)
                for(ii=0; ii<dim_x; ii++)
                  for(jj=0; jj<dim_y; jj++) {
                    index[0] = ii; index[1] = jj; index[2] = kk;

                    VoxelInStack->SetPixel(index, NNO);
                  }

                  /* region growing ... */
                  printf("Region growing ...\n") ;
                  order = 1;

                  // for debug
                  int tempcnt = 0;

                  // CAUTION!!! : ORDER
                  for(k=0; k<dim_z; k++) 
                    for(j=0; j<dim_y; j++)
                      for(i=0; i<dim_x; i++)
                      { 
                        index[0] = i; index[1] = j; index[2] = k;

#ifdef DIFFFILE
                        if(input->GetPixel(index)==GreySelected && status->GetPixel(index)==FAIL) {
#else
                        if(in->GetPixel(index)==GreySelected && status->GetPixel(index)==FAIL) {
#endif // DIFFFILe

                          // for debug
                          tempcnt++;

                          PointNum = 0;

#ifdef DIFFFILE
                          NeighboringSimilarPointsSearch(&PointNum, Detected_Region, order, input, status, i, j, k, GreySelected,
                            RgStack, VoxelInStack, nbrSize, GrowingOnPlan);
#else
                          NeighboringSimilarPointsSearch(&PointNum, Detected_Region, order, in, status, i, j, k, GreySelected, 
                            RgStack, VoxelInStack, nbrSize, GrowingOnPlan);
#endif // DIFFFILE

                          if( PointNum > RegionPointNum ) printf("PointNum=%ld\n", PointNum);
                          PointNumInCertainOrder.SetElement(order, PointNum);
                          order ++;

                          //cout << "order: " << order << endl;

                        }
                      }  // for

                      // for debug
                      //  cout << "tempcnt: " << tempcnt << endl;


                      for(i=0; i<dim_x; i++)
                        for(j=0; j<dim_y; j++)
                          for(k=0; k<dim_z; k++) {

                            index[0] = i; index[1] = j; index[2] = k;

                            intindex[0] = i; intindex[1] = j; intindex[2] = k;  

                            order = Detected_Region->GetPixel(intindex);  
                            ActualUsedRegionPointNum = RegionPointNum;

                            //   if (order>0) cout << "order: " << order << endl;
#ifdef DIFFFILE
                            if(order>=1 && PointNumInCertainOrder.GetElement(order)<ActualUsedRegionPointNum) input->SetPixel(index,255-GreySelected);
#else 
                            if(order>=1 && PointNumInCertainOrder.GetElement(order)<ActualUsedRegionPointNum) in->SetPixel(index,255-GreySelected);
#endif
                          }  // for


                          for(k=0; k<dim_z; k++) /* It's important to use this order, z-axis first*/
                            for(i=0; i<dim_x; i++)
                              for(j=0; j<dim_y; j++) {

                                intindex[0] = i; intindex[1] = j; intindex[2] = k;
                                index[0] = i; index[1] = j; index[2] = k;

                                order = Detected_Region->GetPixel(intindex);

                                if (order>=1 && PointNumInCertainOrder.GetElement(order)>RegionPointNum) {
                                  Result_Detected_Region->SetPixel(index, (unsigned char)Detected_Region->GetPixel(intindex));
#ifdef DIFFFILE
                                  input->SetPixel(index, (unsigned char)Detected_Region->GetPixel(intindex));
#else
                                  in->SetPixel(index, (unsigned char)Detected_Region->GetPixel(intindex));
#endif 
                                }

                              }


                              // for debugging

                              std::ostringstream rg_filename;
                              rg_filename << "regiongrowing" << id << "_" << m_PreIter << ".mha" << ends;

                              //    typedef itk::ImageFileWriter<ImageType> WriterType;
                              //    WriterType::Pointer writer = WriterType::New();

                              writer->SetFileName(rg_filename.str());
                              writer->SetInput(Result_Detected_Region); 
                              writer->Update();

                              // for debug
                              //  ImageType::IndexType imageindextemp;
                              //  int histo[256];
                              for (i=0; i<256; i++) histo[i] = 0;

                              for (k=0; k<dim_z; k++)
                                for (i=0; i<dim_x; i++)
                                  for (j=0; j<dim_y; j++) {

                                    imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

#ifdef DIFFFILE
                                    if(input->GetPixel(imageindextemp)!= 0)
                                      histo[Result_Detected_Region->GetPixel(imageindextemp)]++;
#else
                                    if(in->GetPixel(imageindextemp)!= 0)
                                      histo[Result_Detected_Region->GetPixel(imageindextemp)]++;
#endif
                                  }

                                  cout << "histogram in region growing..." << endl;

                                  for (i=0; i<256; i++) 
                                    cout <<  histo[i] << " " ;

                                  cout << endl;


    }



    template <class TImage, class TMeasurementVector >
    void
      WMLAdaptiveBooster<TImage, TMeasurementVector>
      ::NeighboringSimilarPointsSearch(long int *PointNum, IntImagePointerType Detected_Region, int order, ImagePointerType src,
      ImagePointerType status, int i, int j, int k, int GreySelected, 
      IntSampleType* Stack, ImagePointerType VoxelInStack, int nbrSize, int GrowingOnPlan) 
    {

      //   cout << "WMLAdaptiveBooster::NeighboringSimilarPointsSearch" << endl; 

      //  cout << "i: " << i << ", j:" << j << ", k:" << k << endl;

      int        kk,ii,jj;
      int        k_plus_nbrSize, k_minus_nbrSize, i_plus_nbrSize, i_minus_nbrSize, j_plus_nbrSize, j_minus_nbrSize;

      typename ImageType::IndexType imageindex;

      IntImageType::IndexType intimageindex;


      /* stack */
      long int   Pointer ;

      IntSampleType::MeasurementVectorType stack_mv;
      stack_mv.SetSize(Stack->GetMeasurementVectorSize());


      /* add the first searched point */
      Pointer = 0;

      stack_mv.SetElement(0, i); stack_mv.SetElement(1, j); stack_mv.SetElement(2, k);
      //  stack_mv.SetElement(0, j); stack_mv.SetElement(1, i); stack_mv.SetElement(2, k); // CAUTION

      Stack->SetMeasurementVector(Pointer, stack_mv);


      do{
        stack_mv = Stack->GetMeasurementVector(Pointer);

        i = stack_mv.GetElement(0);
        j = stack_mv.GetElement(1);
        k = stack_mv.GetElement(2);

        // CAUTION
        //     i = stack_mv.GetElement(1);
        //     j = stack_mv.GetElement(0);
        //    k = stack_mv.GetElement(2);



        Pointer --;

        imageindex[0] = i; imageindex[1] = j; imageindex[2] = k;

        status->SetPixel(imageindex, OOKK);

        (*PointNum) ++;

        intimageindex[0] = i; intimageindex[1] = j; intimageindex[2] = k;  
        Detected_Region->SetPixel(intimageindex, order);   

        k_plus_nbrSize =k+nbrSize;
        k_minus_nbrSize=k-nbrSize;
        i_plus_nbrSize =i+nbrSize;
        i_minus_nbrSize=i-nbrSize;
        j_plus_nbrSize =j+nbrSize;
        j_minus_nbrSize=j-nbrSize;

        if (k_plus_nbrSize>=dim_z) k_plus_nbrSize=dim_z-1;
        if (k_minus_nbrSize<0)     k_minus_nbrSize=0;
        if (j_plus_nbrSize>=dim_y) j_plus_nbrSize=dim_y-1;
        if (j_minus_nbrSize<0)     j_minus_nbrSize=0;
        if (i_plus_nbrSize>=dim_x) i_plus_nbrSize=dim_x-1;
        if (i_minus_nbrSize<0)     i_minus_nbrSize=0;


        // TODO: check x<->y in PointNum
        /* now we can check immediately adjacent points to see if they too could be added to the track */
        for(kk=k_minus_nbrSize; kk<=k_plus_nbrSize; kk++)
          for(ii=i_minus_nbrSize; ii<=i_plus_nbrSize; ii++)
            for(jj=j_minus_nbrSize; jj<=j_plus_nbrSize; jj++) {

              imageindex[0] = ii; imageindex[1] = jj; imageindex[2] = kk;

              if( !(kk==k && jj==j && ii==i) &&
                ((GrowingOnPlan!=X_PLN || ii==i) && (GrowingOnPlan!=Y_PLN || jj==j) && (GrowingOnPlan!=Z_PLN || kk==k)) &&
                (kk==k&&jj==j || kk==k&&ii==i || jj==j&&ii==i) &&
                src->GetPixel(imageindex)==GreySelected && status->GetPixel(imageindex)==FAIL && VoxelInStack->GetPixel(imageindex)==NNO) {
                  Pointer ++ ;

                  stack_mv.SetElement(0, ii); stack_mv.SetElement(1, jj); stack_mv.SetElement(2, kk);
                  //stack_mv.SetElement(0, jj); stack_mv.SetElement(1, ii); stack_mv.SetElement(2, kk);  // CAUTION
                  Stack->SetMeasurementVector(Pointer, stack_mv);  

                  VoxelInStack->SetPixel(imageindex, YYES) ;
              }
            }
      }while(Pointer>=0) ;

    }

} // end namespace itk

#endif
