#ifndef __itkWMLGetSelectedFeature_h
#define __itkWMLGetSelectedFeature_h

#if defined(_MSC_VER)
#pragma warning ( disable : 4996 )
#endif

#include "itkWMLAdaptiveBooster.h"
#include "itkImageRegionConstIterator.h"
#include "itkImageRegionIterator.h"

#include <itkBinaryThresholdImageFilter.h>

#include <itkOrientedImage.h>

#define ORIENT

namespace itk {

template<class TImage, class TMeasurementVector >
class ITK_EXPORT WMLGetSelectedFeature : 
	public WMLAdaptiveBooster<TImage, TMeasurementVector >

{
public:
  /** Standard class typedefs. */
  typedef WMLGetSelectedFeature                  Self;

  typedef WMLAdaptiveBooster<TImage, TMeasurementVector > Superclass;
  typedef SmartPointer<Self>                        Pointer;
  typedef SmartPointer<const Self>                  ConstPointer;

  /** Method for creation through the object factory. */
  itkNewMacro(Self);

  /** Run-time type information (and related methods). */
  itkTypeMacro( WMLGetSelectedFeature, WMLAdaptiveBooster);

  // vector types
  typedef itk::VariableLengthVector<double> DoubleVectorType;
  typedef itk::VariableLengthVector<int> IntVectorType;
  typedef itk::VariableLengthVector<char> CharVectorType;

  typedef float                                      FloatValueType;
  typedef itk::VariableLengthVector<FloatValueType>       FloatMeasurementVectorType;
  typedef itk::Statistics::NumericsListSample<FloatMeasurementVectorType> FloatSampleType;
  typedef FloatSampleType::Pointer FloatSamplePointerType;

  typedef int                                      IntValueType;
  typedef itk::VariableLengthVector<IntValueType>  IntMeasurementVectorType;
  typedef itk::Statistics::NumericsListSample<IntMeasurementVectorType> IntSampleType;

  typedef double                                      DoubleValueType;
  typedef itk::VariableLengthVector<DoubleValueType>  DoubleMeasurementVectorType;
  typedef itk::Statistics::NumericsListSample<DoubleMeasurementVectorType> DoubleSampleType;


  typedef vnl_vector<double> VnlVectorType;
  typedef vnl_matrix<double> VnlMatrixType;
  typedef vnl_vector<int> VnlIntVectorType;
  typedef vnl_matrix<int> VnlIntMatrixType;

 //MJ_TEMP
  typedef typename Superclass::ImageType ImageType;
//  typedef itk::OrientedImage<short, 3> ImageType;
  typedef typename ImageType::Pointer ImagePointerType;

  typedef float                                      ValueType;
  typedef itk::VariableLengthVector<ValueType>       MeasurementVectorType;


  typedef itk::OrientedImage<float, 3> FloatImageType;
  typedef FloatImageType::Pointer FloatImagePointerType;

  typedef std::vector<ImagePointerType> ImageVectorType;

  void SetT1Image (ImageVectorType T1Image);
  void SetT2Image (ImageVectorType T2Image);
  void SetPDImage (ImageVectorType PDImage);
  void SetFLImage (ImageVectorType FLImage);
  void SetMaskImage (ImageVectorType MaskImage);
  void SetPremaskImage (ImageVectorType PremaskImage);
  void SetMaskOpenImage (ImageVectorType MaskOpenImage);

  void Update();
  void calculate_hood_special_improve (int bubble_size);
  void  create_training_file(IntSampleType* lesionlst, IntSampleType* nonlesionlst, IntSampleType* outlst, std::ostringstream& trainfilename); 
  void  create_training_file2(IntSampleType* lesionlst, IntSampleType* initial_nonlesionlst, IntSampleType* nonlesionlst, IntSampleType* outlst, std::ostringstream& trainfilename);

  itkSetMacro(Radius, int);
  itkGetMacro(Radius, int);


  void SetNumImages(int numimg);

  int IsPtInLst(FloatMeasurementVectorType pt, IntSampleType* lst, int lst_len);

  int  ExtractLesionVoxels(IntSampleType* lst, ImageVectorType MaskImage, std::string& filename, int type); 
  int ExtractLesionVoxels2(IntSampleType* lst, ImageVectorType MaskImage, std::string& filename, int type);
  void ExtractNonLesionVoxels(IntSampleType* lst);
  void RandomSelectNonLesionVoxels(IntSampleType* lst);

  void RefinedClassifier();

  void Testing(ImagePointerType t1image, ImagePointerType t2image, ImagePointerType pdimage, ImagePointerType flimage, ImagePointerType flthresholdimage, std::ostringstream& svmfilename);


  int m_Iter;
  int m_IterPlus1;
  int m_MaxIter;
//  int m_PreIter;
  double m_Accuracy;
  double m_SVMError;

  double m_selected_threshold;
  double m_it;

  DoubleVectorType  m_threshold;

  int m_current_total_nonlesion_number;
//  float m_SVM_Error;

  IntVectorType  nonlesion_voxel_numbers;




protected:

  WMLGetSelectedFeature();
  ~WMLGetSelectedFeature() {}
  void PrintSelf(std::ostream& os, Indent indent) const;

  unsigned int m_NumImages;


private:
  WMLGetSelectedFeature(const Self&); //purposely not implemented
  void operator=(const Self&); //purposely not implemented

};

} //  end namespace itk

#ifndef ITK_MANUAL_INSTANTIATION
#include "itkWMLGetSelectedFeature.txx"
#endif

#endif
