#ifndef __itkWMLGetSelectedFeature_txx
#define __itkWMLGetSelectedFeature_txx
#include "itkWMLGetSelectedFeature.h"

#define BASIC_R 0


using namespace std;

namespace itk
{

/**
 * Default constructor
 */
//template <class TFixedImage, class TMovingImage, class TDeformationField, class TAVFilterType>
template <class TImage, class TMeasurementVector >
WMLGetSelectedFeature<TImage, TMeasurementVector>
::WMLGetSelectedFeature()
{
  cout << "WMLGetSelectedFeature::WMLGetSelectedFeature()\n" << endl;

  Superclass::bubble = IntSampleType::New();

//  cout << "number of images: " << m_NumImages << endl;
//  Superclass::m_NumImages = m_NumImages; // TODO: SetMacro

  Superclass::m_Nonlesion_Voxel_Number.SetSize(3);  // CAUTION!
}



//template <class TFixedImage, class TMovingImage, class TDeformationField, class TAVFilterType>
template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::PrintSelf(std::ostream& os, Indent indent) const
{ 
  Superclass::PrintSelf( os, indent );

}


template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::SetT1Image (ImageVectorType T1Image)
{
  cout << "WMLGetSelectedFeature::SetT1Image (TImage* T1Image)" << endl;

  Superclass::m_T1Image = T1Image;

}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::SetT2Image (ImageVectorType T2Image)
{
  cout << "WMLGetSelectedFeature::SetT1Image (TImage* T2Image)" << endl;

  Superclass::m_T2Image = T2Image;
}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::SetPDImage (ImageVectorType PDImage)
{
  cout << "WMLGetSelectedFeature::SetPDImage (TImage* PDImage)" << endl;

  Superclass::m_PDImage = PDImage;
}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::SetFLImage (ImageVectorType FLImage)
{
  cout << "WMLGetSelectedFeature::SetFLImage (TImage* FLImage)" << endl;

  Superclass::m_FLImage = FLImage;
}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::SetMaskImage (ImageVectorType MaskImage)
{
  cout << "WMLGetSelectedFeature::SetMaskImage (TImage* MaskImage)" << endl;

  Superclass::m_MaskImage = MaskImage;
}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::SetMaskOpenImage (ImageVectorType MaskOpenImage)
{
  cout << "WMLGetSelectedFeature::SetMaskOpenImage (TImage* MaskImage)" << endl;

  Superclass::m_MaskOpenImage = MaskOpenImage;
}


template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::SetPremaskImage (ImageVectorType PremaskImage)
{
   cout << "WMLGetSelectedFeature::SetPremaskImage (TImage* PremaskImage)" << endl;

  Superclass::m_PremaskImage = PremaskImage;
}



template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::Update()
{
  cout << "WMLGetSelectedFeature::Update()" << endl;

  nonlesion_voxel_numbers.SetSize(Superclass::m_NumImages);
  nonlesion_voxel_numbers.Fill(0);


  // define variables
  Superclass::dim_x = Superclass::m_FLImage[0]->GetRequestedRegion().GetSize()[0]; 
  Superclass::dim_y = Superclass::m_FLImage[0]->GetRequestedRegion().GetSize()[1];
  Superclass::dim_z = Superclass::m_FLImage[0]->GetRequestedRegion().GetSize()[2];

  typename ImageType::SpacingType sp = Superclass::m_FLImage[0]->GetSpacing();

  std::cout << "Spacing = ";
  std::cout << sp[0] << ", " << sp[1] << ", " << sp[2] << std::endl;

  Superclass::res_x = sp[0];  
  Superclass::res_y = sp[1];
  Superclass::res_z = sp[2];
  
  cout << "image size: " << Superclass::dim_x << ", " << Superclass::dim_y << ", " << Superclass::dim_z << endl;

  Superclass::bubble_size = Superclass::m_Radius;
  calculate_hood_special_improve(Superclass::bubble_size);


  // pos for nonlesion features
  Superclass::pos = IntSampleType::New();
  Superclass::pos->SetMeasurementVectorSize(3);

  // total_features
  
  Superclass::total_lesion_features = IntSampleType::New();
  Superclass::total_lesion_features->SetMeasurementVectorSize(4*Superclass::pixelNumInBubble+1);

  Superclass::total_nonlesion_features = IntSampleType::New();
  Superclass::total_nonlesion_features->SetMeasurementVectorSize(4*Superclass::pixelNumInBubble+1);


  std::string lesionfilename;
  lesionfilename = "lesion.vec.0"; 

  Superclass::m_PreIter = 0;
  ExtractLesionVoxels(Superclass::total_lesion_features, Superclass::m_MaskImage, lesionfilename, -1); cout << "ExtractLesionVoxels: Done.\n" << endl;  

  ExtractNonLesionVoxels(Superclass::total_nonlesion_features); cout << "ExtractNonLesionVoxels: Done.\n" << endl; 
  RandomSelectNonLesionVoxels(Superclass::total_nonlesion_features); cout << "RandomSelectNonLesionVoxels: Done.\n" << endl;  

  
   // reduced_total_features
   Superclass::reduced_total_features = IntSampleType::New();
   Superclass::reduced_total_features->SetMeasurementVectorSize(Superclass::total_lesion_features->GetMeasurementVectorSize()); 

  std::ostringstream filename;
  filename << "train.example" << ends;  
  create_training_file(Superclass::total_lesion_features, Superclass::total_nonlesion_features, Superclass::reduced_total_features, filename);  

  std::string kernelType = "rbf";
  std::vector<std::string> kernelParameters; 
  kernelParameters.push_back("6000");
  std::ostringstream svmOutputFilename;
  svmOutputFilename << "itktest0.mdl" << std::ends;

  std::string svmOutputFormat = "ascii";
  std::string trainfilename           = "train.example";

  Superclass::Trainer.Training(kernelType, kernelParameters, svmOutputFilename, svmOutputFormat, trainfilename, 0.0002);


  cout << svmOutputFilename.str().c_str() << " created" << endl;
}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::calculate_hood_special_improve (int bubble_size)
{
  cout << "WMLGetSelectedFeature::calculate_hood_special_improve" << endl;

  int         i,j,k,t,rad_sqrd,radius, count;

  // bubbles
  FloatSampleType::Pointer bubble_float = FloatSampleType::New();
  bubble_float->SetMeasurementVectorSize(3);

  IntSampleType::Pointer bubble_int = IntSampleType::New();
  bubble_int->SetMeasurementVectorSize(3);

  Superclass::bubble->SetMeasurementVectorSize(3);

  t=0;
  radius=bubble_size+BASIC_R;
  rad_sqrd=radius*radius;

  cout << "bubble_size: " << bubble_size << endl;

  for(i=-radius;i<=radius;i++)
    for(j=-radius;j<=radius;j++)
      for(k=-radius;k<=radius;k++) {
      FloatSampleType::MeasurementVectorType  mv;
      mv.SetSize(3); // x, y, z

      if((i*i+j*j+k*k)<=rad_sqrd)
        {
        mv.SetElement(0, ((float) i)/Superclass::res_x);
        mv.SetElement(1, ((float) j)/Superclass::res_y);
        mv.SetElement(2, ((float) k)/Superclass::res_z);

        bubble_float->PushBack(mv);
        t++;
        }
      }


  for (i=0; i<t; i++) {
  FloatSampleType::MeasurementVectorType mv_float;
  mv_float.SetSize(bubble_float->GetMeasurementVectorSize());

  IntSampleType::MeasurementVectorType mv_int;
  mv_int.SetSize(bubble_int->GetMeasurementVectorSize());

  mv_float = bubble_float->GetMeasurementVector(i);

  mv_int = mv_float;

  bubble_int->PushBack(mv_int);
  }

  count = 0;


  IntSampleType::MeasurementVectorType  mv_bubble;
  mv_bubble.SetSize(bubble_float->GetMeasurementVectorSize());
  
  FloatSampleType::MeasurementVectorType  mv_bubble_float;
  mv_bubble_float.SetSize(bubble_float->GetMeasurementVectorSize());


  for (i=0; i<3; i++) {
  mv_bubble.SetElement(i,(int) mv_bubble_float.GetElement(i) );
  }
  cout << endl;
  
  cout << "t: " << t << endl;


  // Check same element in the bubble -- from IsPtInLst
  count = t;
  
  int tempcnt = 0;
  IntSampleType::MeasurementVectorType mv;
  mv.SetSize(bubble_int->GetMeasurementVectorSize());
  
  mv = bubble_int->GetMeasurementVector(0);
  
  Superclass::bubble->PushBack(mv);
  tempcnt++; count++;
  bool is_pt_list = false;
  
  for (i=1; i<t; i++) {
  
  IntSampleType::MeasurementVectorType mv_temp1;
  mv_temp1.SetSize(bubble_int->GetMeasurementVectorSize());
  mv_temp1 = bubble_int->GetMeasurementVector(i);

  for (int j=0; j<tempcnt; j++) {
  IntSampleType::MeasurementVectorType mv_temp2;
  mv_temp2.SetSize(bubble_int->GetMeasurementVectorSize());
  mv_temp2 = bubble_int->GetMeasurementVector(j);

  if ((mv_temp1.GetElement(0)==mv_temp2.GetElement(0)) && (mv_temp1.GetElement(1)==mv_temp2.GetElement(1)) && (mv_temp1.GetElement(2)==mv_temp2.GetElement(2)) ) {

  count--;
  is_pt_list = true;
  }
  }
  
  if (is_pt_list== false) {
  Superclass::bubble->PushBack(mv_temp1);
  }
  tempcnt++; 
  is_pt_list = false;
  
  }

  for (i=0; i<(int) Superclass::bubble->Size(); i++)
    {
    IntSampleType::MeasurementVectorType mv_temp2;
    mv_temp2.SetSize(Superclass::bubble->GetMeasurementVectorSize());
    mv_temp2 = Superclass::bubble->GetMeasurementVector(i);
    }

  Superclass::pixelNumInBubble = count;
}


template <class TImage, class TMeasurementVector >
int
WMLGetSelectedFeature<TImage, TMeasurementVector>
::IsPtInLst(FloatMeasurementVectorType pt, IntSampleType* lst, int lst_len)
{
  cout << "WMLGetSelectedFeature::IsPtInLst" << endl;

  int        i;
  int pt_x, pt_y, pt_z;

  IntSampleType::MeasurementVectorType  tmp_pt;
  tmp_pt.SetSize(3);

  pt_x = (int) pt.GetElement(0);
  pt_y = (int) pt.GetElement(1);
  pt_z = (int) pt.GetElement(2);

  tmp_pt.SetElement(0, pt_x);
  tmp_pt.SetElement(1, pt_y);
  tmp_pt.SetElement(2, pt_z);

  for (i=0; i<lst_len; i++){
  IntSampleType::MeasurementVectorType lst_mv;
  lst_mv.SetSize(3);

  lst_mv = lst->GetMeasurementVector(i);

  if ( (tmp_pt.GetElement(0)==lst_mv.GetElement(0)) && (tmp_pt.GetElement(1)==lst_mv.GetElement(1)) && (tmp_pt.GetElement(2)==lst_mv.GetElement(2))){
  return 1;
  }
  }

  return 0;
}


template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
//::create_training_file(IntSampleType* lesionlst, IntSampleType* nonlesionlst, IntSampleType* outlst, std::string& trainfilename)  
::create_training_file(IntSampleType* lesionlst, IntSampleType* nonlesionlst, IntSampleType* outlst, std::ostringstream& trainfilename)
{
  cout << "WMLGetSelectedFeature::create_training_file()" << endl;

  // from RemoveDuplicateElementFromList.pl
  // Compare two lists to see whether each element in list1 is in list2

   cout << "WMLGetSelectedFeature::RemoveDuplicateElementFromList()" << endl;

   unsigned int cnt = 0;
   unsigned int s, ss, sss; 

   IntSampleType::MeasurementVectorType  lesion_mv;
   lesion_mv.SetSize(lesionlst->GetMeasurementVectorSize());  

   IntSampleType::MeasurementVectorType  nonlesion_mv;
   nonlesion_mv.SetSize(lesionlst->GetMeasurementVectorSize());  

   IntSampleType::MeasurementVectorType  out_mv;
   out_mv.SetSize(outlst->GetMeasurementVectorSize());

   cout << "Superclass::m_total_voxel_number: " << Superclass::m_total_voxel_number << endl;
   cout << "lesionlst->Size(): " << lesionlst->Size() << endl;


  // for lesion features 
  for (s=0; s<lesionlst->Size();s++)
  {
	lesion_mv = lesionlst->GetMeasurementVector(s);

	for (ss=0; ss<outlst->Size(); ss++)
	{
	   out_mv = outlst->GetMeasurementVector(ss);

	cnt=0;   
	   for (sss=0; sss<lesionlst->GetMeasurementVectorSize(); sss++)  
	   {
		if (lesion_mv.GetElement(sss)==out_mv.GetElement(sss)) { 
		  cnt++;
		}
	   }
	}
	if (cnt==lesionlst->GetMeasurementVectorSize())  
	{
	    cout << "same element: " << s << endl;
	}
	else {
	   outlst->PushBack(lesion_mv);	
	}
  }


  // for nonlesion features
  for (s=0; s<nonlesionlst->Size();s++)
  {
        nonlesion_mv = nonlesionlst->GetMeasurementVector(s);

        for (ss=0; ss<outlst->Size(); ss++)
        {
           out_mv = outlst->GetMeasurementVector(ss);

        cnt=0;  
           for (sss=0; sss<nonlesionlst->GetMeasurementVectorSize(); sss++)  
           {
                if (nonlesion_mv.GetElement(sss)==out_mv.GetElement(sss)) {
                  cnt++;
                }
           }
        }
        if (cnt==nonlesionlst->GetMeasurementVectorSize())  
        {
            cout << "same element: " << s << endl;
        }
        else {
           outlst->PushBack(nonlesion_mv);
        }
  }



   Superclass::m_total_voxel_number = outlst->Size();
   cout << "New Superclass::m_total_voxel_number: " << Superclass::m_total_voxel_number << endl;

  
    FILE *fp;
    fp = fopen(trainfilename.str().c_str(), "w"); // output  

    fprintf(fp, "%d %u\n", outlst->Size(), outlst->GetMeasurementVectorSize());

    for (s=0; s<outlst->Size(); s++)
    {
     out_mv = outlst->GetMeasurementVector(s);
     for (ss=0; ss<outlst->GetMeasurementVectorSize()-1; ss++)
        {
        fprintf(fp, "%f ", (float) out_mv.GetElement(ss)); 
	}
    fprintf(fp, "%d\n",  out_mv.GetElement(outlst->GetMeasurementVectorSize()-1));
    }

   fclose(fp);
}

// --



template <class TImage, class TMeasurementVector >
int 
WMLGetSelectedFeature<TImage, TMeasurementVector>
::ExtractLesionVoxels(IntSampleType* lst, ImageVectorType MaskImage, std::string& filename, int type) 
{
  cout << "WMLGetSelectedFeature::ExtractLesionVoxels()" << endl;

   typename ImageType::IndexType  imageindex, tmp_pos;

   FILE *fp;

   fp = fopen(filename.c_str(), "w"); 
  
   int l_index = 0;

   cout << "collecting lesion features..." << endl;
   cout << "# of images: " << Superclass::m_NumImages << endl;

   bool is_lesion = false;


  // for debug

   std::ostringstream inputfilename;
   inputfilename << "extractlesion" << Superclass::m_PreIter << ".mha" << ends;

    MaskImage[0]->SetDirection(MaskImage[0]->GetDirection());
    typedef itk::ImageFileWriter<ImageType> WriterType;
    typename WriterType::Pointer writer = WriterType::New();

    writer->SetFileName(inputfilename.str().c_str());
    writer->SetInput(MaskImage[0]);
    writer->Update();
  // --


   for (unsigned int id=0; id<Superclass::m_NumImages; id++)  {

   for (int k=Superclass::m_Radius; k<Superclass::dim_z-Superclass::m_Radius; k++)
    for (int j=Superclass::m_Radius; j<Superclass::dim_y-Superclass::m_Radius; j++)
     for (int i=Superclass::m_Radius; i<Superclass::dim_x-Superclass::m_Radius; i++)   // CAUTION!: ORDER
       {

        // lesion vectors
        imageindex[0]=i; imageindex[1]=j; imageindex[2]=k;

        if (MaskImage[id]->GetPixel(imageindex)==255) {  

        IntSampleType::MeasurementVectorType  total_feature_mv;
        total_feature_mv.SetSize(lst->GetMeasurementVectorSize());

        for (int ii=0; ii<Superclass::pixelNumInBubble; ii++) {

        IntSampleType::MeasurementVectorType  mv;
        mv.SetSize(Superclass::bubble->GetMeasurementVectorSize());
        mv = Superclass::bubble->GetMeasurementVector(ii);

        //tmp_pos[0] = i + mv.GetElement(0); tmp_pos[1] = j + mv.GetElement(1); tmp_pos[2] = k + mv.GetElement(2);
        tmp_pos[0] = i + mv.GetElement(1); tmp_pos[1] = j + mv.GetElement(0); tmp_pos[2] = k + mv.GetElement(2);  // CAUTION!: ORDER


        if ((tmp_pos[0]>=0) && (tmp_pos[0]<Superclass::dim_x) && (tmp_pos[1]>=0) &&
            (tmp_pos[1]<Superclass::dim_y) && (tmp_pos[2]>=0) && (tmp_pos[2]<Superclass::dim_z)) {

        // TODO: Weight 
        fprintf(fp, "%f %f %f %f ", (float) Superclass::m_T1Image[id]->GetPixel(tmp_pos), (float) Superclass::m_T2Image[id]->GetPixel(tmp_pos),
               (float) Superclass::m_PDImage[id]->GetPixel(tmp_pos), (float) Superclass::m_FLImage[id]->GetPixel(tmp_pos));


        // save to total_features
        total_feature_mv.SetElement(0+ii*4, static_cast<int>( Superclass::m_T1Image[id]->GetPixel(tmp_pos)) );
        total_feature_mv.SetElement(1+ii*4, static_cast<int>( Superclass::m_T2Image[id]->GetPixel(tmp_pos)) );
        total_feature_mv.SetElement(2+ii*4, static_cast<int>( Superclass::m_PDImage[id]->GetPixel(tmp_pos)) );
        total_feature_mv.SetElement(3+ii*4, static_cast<int>( Superclass::m_FLImage[id]->GetPixel(tmp_pos)) );

        is_lesion = true;

        } // if
        }

        if (is_lesion) {	
	total_feature_mv.SetElement(total_feature_mv.Size()-1, type);  // CAUTION!!!
        lst->PushBack(total_feature_mv);
        is_lesion = false;
	}

        //if (special_case == 0)
        fprintf(fp, "        %d\n", type);   // CAUTION!!!
        // else {fprintf(fp, "\n");fprintf(fp_pos, "%d %d %d\n", i, j, k);}
        //if (special_case == 1) fprintf(fp, "        1\n");
        l_index++;
         }
         } // for -- lesion


   // NEW: using image region iterator in ITK

   }  // for -- all images

   fclose(fp);

   cout << "total lesion voxel number: " << l_index << endl;

   Superclass::m_average_manual_seg_voxel_number = l_index / Superclass::m_NumImages;

   return l_index;  

}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::ExtractNonLesionVoxels(IntSampleType* lst)
{
   cout << "WMLGetSelectedFeature::ExtractNonLesionVoxels()" << endl;

   // nonlesion vectors; type1, method1

   typename ImageType::IndexType  imageindex;

 //MJ_TEMP
   int nl_index = 0;
   Superclass::m_total_voxel_number = 0 ;

   cout << "collecting nonlesion features..." << endl;
   cout << "Superclass::pos->GetMeasurementVectorSize(): " << Superclass::pos->GetMeasurementVectorSize() << endl;

   for (unsigned int id=0; id<Superclass::m_NumImages; id++)  {

   nl_index=0;

   for (int kk=0; kk<Superclass::dim_z; kk++) 
    for (int jj=0; jj<Superclass::dim_y; jj++)
     for (int ii=0; ii<Superclass::dim_x; ii++)
     {
 	imageindex[0]=ii; imageindex[1]=jj; imageindex[2]=kk;
	  
        if ((Superclass::m_MaskImage[id]->GetPixel(imageindex)!=255) && (IsValidVoxel_Neighbor(Superclass::m_T1Image[id], imageindex)) 
        && (IsValidVoxel_Neighbor(Superclass::m_T2Image[id], imageindex)) && (IsValidVoxel_Neighbor(Superclass::m_PDImage[id], imageindex))
	&& (IsValidVoxel_Neighbor(Superclass::m_FLImage[id], imageindex))  ) {

         IntSampleType::MeasurementVectorType  nl_mv;
	 nl_mv.SetSize(Superclass::pos->GetMeasurementVectorSize());
	 nl_mv.SetElement(0,ii); nl_mv.SetElement(1,jj); nl_mv.SetElement(2,kk);
 	 Superclass::pos->PushBack(nl_mv);
  	 nl_index++;
        }
      } // for -- nonlesion

      cout << "final index: " << nl_index << endl;
      nonlesion_voxel_numbers.SetElement(id, nl_index);

      Superclass::m_total_voxel_number += nl_index; // will be used in the WMLTestSingleImageKeepAllFunctionValue_NoSmooth

      // MJ_TEMP
      cout << "Superclass::m_total_voxel_number: " << Superclass::m_total_voxel_number << endl;
    }
}


template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::RandomSelectNonLesionVoxels(IntSampleType* lst)
{
  cout << "WMLGetSelectedFeature::RandomSelectNonLesionVoxels()" << endl;

   typename ImageType::IndexType  imageindex;

   FILE *fp;
   fp = fopen("nonlesion.vec.0", "w");

   // for debug -- CAUTION: to be removed

   cout << "collecting lesion features..." << endl;
   cout << "Superclass::m_total_voxel_number: " << Superclass::m_total_voxel_number << endl;
   cout << "Superclass::m_average_manual_seg_voxel_number: " << Superclass::m_average_manual_seg_voxel_number << endl;


   
  for (unsigned int id=0; id<Superclass::m_NumImages; id++)  {

    int selected_voxel_number = Superclass::m_average_manual_seg_voxel_number; 
    cout << "selected_voxel_number: " << selected_voxel_number << endl;

    cout << "nonlesion_voxel_numbers.GetElement(" << id << "): " << nonlesion_voxel_numbers.GetElement(id) << endl;

    float ratio;
    int ind, x, y, z;

    for (int s=0; s<selected_voxel_number; s++) {

        ratio = rand() / (double)RAND_MAX;

	 if (id==0) ind = (int)(ratio*nonlesion_voxel_numbers.GetElement(id) + 0.5);
	 else 
	    ind = (int)(ratio*nonlesion_voxel_numbers.GetElement(id) + 0.5) + nonlesion_voxel_numbers.GetElement(id-1);	 

	IntSampleType::MeasurementVectorType  nl_mv;
        nl_mv.SetSize(Superclass::pos->GetMeasurementVectorSize());
	nl_mv = Superclass::pos->GetMeasurementVector(ind);

	x = nl_mv.GetElement(0); y = nl_mv.GetElement(1); z = nl_mv.GetElement(2);

        IntSampleType::MeasurementVectorType  total_feature_mv;
        total_feature_mv.SetSize(lst->GetMeasurementVectorSize());


	for (int i=0; i<Superclass::pixelNumInBubble; i++) {

	    IntSampleType::MeasurementVectorType mv;
	    mv.SetSize(Superclass::bubble->GetMeasurementVectorSize());
	    mv = Superclass::bubble->GetMeasurementVector(i);

	  // imageindex[0] = x + mv.GetElement(0); imageindex[1] = y + mv.GetElement(1); imageindex[2] = z + mv.GetElement(2);
	     imageindex[0] = x + mv.GetElement(1); imageindex[1] = y + mv.GetElement(0); imageindex[2] = z + mv.GetElement(2);


	   // Weight
           fprintf(fp, "%f %f %f %f ", (float) Superclass::m_T1Image[id]->GetPixel(imageindex), (float) Superclass::m_T2Image[id]->GetPixel(imageindex),
               (float) Superclass::m_PDImage[id]->GetPixel(imageindex), (float) Superclass::m_FLImage[id]->GetPixel(imageindex));

		total_feature_mv.SetElement(0+i*4, (float) Superclass::m_T1Image[id]->GetPixel(imageindex));
                total_feature_mv.SetElement(1+i*4, (float) Superclass::m_T2Image[id]->GetPixel(imageindex));
                total_feature_mv.SetElement(2+i*4, (float) Superclass::m_PDImage[id]->GetPixel(imageindex));
                total_feature_mv.SetElement(3+i*4, (float) Superclass::m_FLImage[id]->GetPixel(imageindex));
	}
        fprintf(fp, "        1\n");

	total_feature_mv.SetElement(total_feature_mv.Size()-1, 1);

	lst->PushBack(total_feature_mv);
     }
    }


      fclose(fp);


   Superclass::m_Nonlesion_Voxel_Number.SetElement(0, Superclass::m_average_manual_seg_voxel_number);  // CAUTION!
}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::RefinedClassifier()
{
  cout << "WMLGetSelectedFeature::RefinedClassifier()" << endl;

///////////////////////////////////////////////////////////////////////////
//                      Iteratively refine SVM model                    ///
///////////////////////////////////////////////////////////////////////////

  Superclass::m_MaskVoxels.SetSize(Superclass::m_NumImages);

  // Iteration 
  m_Iter = 0;
  m_IterPlus1 = m_Iter+1;

  m_MaxIter = 10;  

  if (m_MaxIter>2) m_MaxIter=2;

  m_Accuracy=0.9; m_SVMError=0.005;


  // memory allocation for image vector: Superclass::SVMTestImage, Superclass::m_AutoMaskImage

  FloatImageType::Pointer floattestimage = FloatImageType::New();
  typename ImageType::Pointer testimage = ImageType::New();

  FloatImageType::IndexType f_start;
  f_start[0] = 0; f_start[1] = 0; f_start[2] = 0;

  FloatImageType::SizeType f_size;
  f_size[0] = Superclass::dim_x; f_size[1] = Superclass::dim_y; f_size[2] = Superclass::dim_z;

  FloatImageType::RegionType f_region;
  f_region.SetSize(f_size);
  f_region.SetIndex(f_start);

  floattestimage->SetRegions(f_region);
  floattestimage->Allocate();
  floattestimage->FillBuffer(0);

  testimage->SetRegions(f_region);
  testimage->Allocate();
  testimage->FillBuffer(0);
 
  for (unsigned int id=0; id<Superclass::m_NumImages; id++)
  {
   Superclass::SVMTestImage.push_back(floattestimage); 
   Superclass::m_AutoMaskImage.push_back(testimage);
  }

  cout << "Superclass::SVMTestImage ready" << endl;
  cout << "Superclass::m_AutoMaskImage ready" << endl;

  cout << endl;
  cout << " *************************************************" << endl;
  cout << "              * S * T * A * R * T * "               << endl;
  cout << " *************************************************" << endl;
  cout << endl;

  FILE *fp;
  fp = fopen("progress.dat", "w");

  fprintf (fp, "threshold\tTPVF\tFPVF\n=================================\n");

  typename ImageType::IndexType  imageindex;
  ImagePointerType outimg;

  DoubleSampleType::MeasurementVectorType mv;
  mv.SetSize(4);

  FILE *gfp, *gfp2;

  Superclass::m_err.SetSize(3);   
  m_threshold.SetSize(2);

  for (unsigned int id=0; id<Superclass::m_NumImages; id++) {
  Superclass::voxel_list = IntSampleType::New();

  this->WMLTestSingleImageKeepAllFunctionValue_NoSmoothPre(id, Superclass::m_T1Image[id],
   Superclass::m_T2Image[id], Superclass::m_PDImage[id], Superclass::m_FLImage[id], Superclass::m_PremaskImage[id],
    1 /*have_mask*/, Superclass::voxel_list );
   }

  while(1)
  {
  Superclass::current_features = IntSampleType::New();
  Superclass::current_features->SetMeasurementVectorSize(4*Superclass::pixelNumInBubble+1);

  Superclass::reduced_current_features = IntSampleType::New();
  Superclass::reduced_current_features->SetMeasurementVectorSize(Superclass::current_features->GetMeasurementVectorSize());

  Superclass::m_PreIter = m_Iter;  m_Iter++;
  cout << "*****************************iteration " << m_Iter << "******************************************" << endl;

  ///////////////////////////////////////////////////////////////////////////
  //    Generate evaluation map using SVM model from previous iteration    //
  ///////////////////////////////////////////////////////////////////////////

  cout << "m_Iter: " << m_Iter << endl;
  cout << "Superclass::m_PreIter: " << Superclass::m_PreIter << endl;

  std::ostringstream svmmdlname;

  svmmdlname << "itktest" << Superclass::m_PreIter << ".mdl" << std::ends;

  cout << "model file name: " << svmmdlname.str() << endl;


  cout << "--- Generating evaluation map using SVM model from previous iteration..." << endl;

  // ************************************************************************************
  for (unsigned int id=0; id<Superclass::m_NumImages; id++) {

  std::ostringstream svmtestfilename;
  svmtestfilename << "test" << id <<".example" << ends;
  cout <<"svmtestfilename: " << svmtestfilename.str().c_str() << endl;

  std::ostringstream svmoutputname;
  svmoutputname << "test" << id << "_" << Superclass::m_PreIter << ".result" << std::ends;
  cout << "svmoutputname: " << svmoutputname.str().c_str() << endl;


  cout << "--- Gather image information inside mask region and perform SVM Testing..." << endl;

  this->WMLTestSingleImageKeepAllFunctionValue_NoSmooth(id, svmtestfilename, svmoutputname, svmmdlname );

  cout << "Superclass::m_MaskVoxels: " << Superclass::m_MaskVoxels[id] << endl;

  cout << "--- Set Superclass::SVMTestImages... " << endl;

  cout << "reading result of SVM Testing from" << svmoutputname.str().c_str() << "..." << endl;

  gfp = fopen(svmoutputname.str().c_str(), "r"); // current: read result file from svm tester -> TODO: getResult function in svm tester
  float tmp; // float!

  if(gfp==NULL) {
	cout << "file error" << endl;
	exit(0);
  }


 std::ostringstream voxellistfilename;
 voxellistfilename << "nonlesion_voxellist" << id << ".txt" << ends;  

  gfp2 = fopen(voxellistfilename.str().c_str(), "r"); // read voxel list

  if(gfp2==NULL) {
        cout << "file error" << endl;
        exit(0);
  }


  // clear SVMTestImage
  Superclass::SVMTestImage[id]->FillBuffer(0);
  cout << "id: " << id << endl;
  cout << "Superclass::m_MaskVoxels: " << Superclass::m_MaskVoxels[id] << endl;

/*
  IntSampleType::MeasurementVectorType mv_list;
  mv_list.SetSize(3*Superclass::m_MaskVoxels[id]);

  mv_list = Superclass::voxel_list->GetMeasurementVector(id);

  // voxel_list: nonlesion voxel number * 3 (xx,yy,zz,-1)
   int mv_index = 0;
    for (int t=0; t<Superclass::m_MaskVoxels[id]; t++) {
    fscanf(gfp, "%f\n", &tmp); // from test.result

    imageindex[0] = static_cast<long int> (mv_list.GetElement(mv_index)); mv_index++;
    imageindex[1] = static_cast<long int> (mv_list.GetElement(mv_index)); mv_index++;
    imageindex[2] = static_cast<long int> (mv_list.GetElement(mv_index)); mv_index++;

    Superclass::SVMTestImage[id]->SetPixel(imageindex, tmp);
  }
*/

  int voxel_x, voxel_y, voxel_z;
  int tempint;

  for (int t=0; t<Superclass::m_MaskVoxels[id]; t++) {
    fscanf(gfp, "%f\n", &tmp); // from test.result


    fscanf(gfp2, "%d", &voxel_x);
    fscanf(gfp2, "%d", &voxel_y);
    fscanf(gfp2, "%d", &voxel_z);
    fscanf(gfp2, "%d\n", &tempint);

    imageindex[0] = voxel_x;
    imageindex[1] = voxel_y;
    imageindex[2] = voxel_z;

    Superclass::SVMTestImage[id]->SetPixel(imageindex, tmp);
  }

  fclose(gfp);
  fclose(gfp2);

  cout << "read test.result: pass" << endl;



  std::ostringstream testimagename;
  testimagename << "wml.mask.allvalue" << id << "_" << Superclass::m_PreIter << ".mha" << ends;
  typedef itk::ImageFileWriter<FloatImageType> WriterType;
  WriterType::Pointer writer = WriterType::New();

  writer->SetFileName(testimagename.str().c_str());
  writer->SetInput(Superclass::SVMTestImage[id]);
  writer->Update();

  cout << "voxel_list created" << endl;
  cout << "finished creating mask" << endl;

  cout << "SVMTestImage calculated" << endl;

  // InvertImgFloat -- in fact, invert and normalize

  cout << "--- Invert image values..." << endl;

  this->InvertImgFloat(Superclass::SVMTestImage[id], Superclass::SVMTestImage[id]);

  std::ostringstream testimagename2;
  testimagename2 << "wml.mask.allvalue.invert" << id << "_" << Superclass::m_PreIter << ".mha" << ends;

  writer->SetFileName(testimagename2.str().c_str());
  writer->SetInput(Superclass::SVMTestImage[id]);
  writer->Update();

  cout << "InvertImgFloat passed" << endl;

  } // for:m_NumImages 

  cout << "after get emap based on SVM model from previous iteration" << endl;



  ///////////////////////////////////////////////////////////////////////////
  //    threshold evaluation map to get binary lesion masks                //
  ///////////////////////////////////////////////////////////////////////////
  m_selected_threshold = 0.0; m_it = 1.0;

  m_threshold[0] = 0.9; m_threshold[1] = 0.1;   
  Superclass::m_err[0]=0.0; Superclass::m_err[1]=0.0; Superclass::m_err[2]=0.0;  

 while ( (Superclass::m_err[0]<m_Accuracy)&&(m_it>-0.9)) {  
   cout << "threshold: " << m_it << endl;

   for (unsigned id2=0; id2<Superclass::m_NumImages; id2++) {

    std::ostringstream thimagename;
    thimagename << "wml.mask.allvalue.invert" << id2 << "_" << Superclass::m_PreIter << ".mha" << ends;

    Superclass::m_threshold = m_it;   
    this->ThresholdImage(Superclass::SVMTestImage[id2],  Superclass::m_threshold, id2, thimagename);
   } // for

   m_it = m_it - 0.1;

   cout << "Superclass::m_NumImages: " << Superclass::m_NumImages << endl;

   // for all images at once
   this->WMLGetAutoManualMaskDiff(Superclass::m_MaskImage, Superclass::m_AutoMaskImage); 
  } // inner while 

  m_Accuracy = m_Accuracy - 0.02;

  cout << "after threshold evaluation map to get binary lesion masks" << endl;

  m_selected_threshold = m_it + 0.1;

  // progress.dat
  fprintf (fp, "%f\t%f\t%f\n", m_selected_threshold, Superclass::m_err[0], Superclass::m_err[1]); 

  cout << "m_selected_threshold: " << m_selected_threshold << ", Superclass::m_err[0]: " << Superclass::m_err[0] << ", Superclass::m_err[1]: " << Superclass::m_err[1] << endl; 

  cout << "after writing PROGRESS" << endl;

  cout << "err: " << Superclass::m_err[0] << ", " << Superclass::m_err[1] << endl;
  cout << "threshold: " << m_threshold[0] << ", " << m_threshold[1] << endl;

  if ((Superclass::m_err[0]>m_threshold[0] && Superclass::m_err[1]<m_threshold[1]) || (m_Iter>m_MaxIter)) {  
    cout << "going to exit..." << endl;
    m_Iter = m_Iter - 1;
    exit(1);   
  }

   cout << endl;
   cout << " CHECKED: no problem so far for ALL iteration. " << endl;
   cout << endl;


  for (unsigned int i=0; i<Superclass::m_NumImages; i++) {
   // OpeningCloseingRegiongrowing3DBinaryImg_special -- region growing
   // TODO: find ITK region growing
   this->RegionGrowing(Superclass::m_AutoMaskImage[i], 1, 255, 1, 1658, i); 

   // Calculate the difference between automatically masked image and manual mask image
   this->MaskOutImg(Superclass::m_AutoMaskImage[i], Superclass::m_MaskOpenImage[i], 0.08, i); 
   }  

   // WMLGetSelectedFeature
   
   std::ostringstream nonlesionfilename;
   nonlesionfilename << "nonlesion.vec." << m_Iter << ends;

   std::string nlfilename;
   nlfilename = nonlesionfilename.str();

   m_current_total_nonlesion_number = ExtractLesionVoxels2(Superclass::current_features, Superclass::m_AutoMaskImage, nlfilename, 1); 

   cout << "current_total_nonlesion_number: " << m_current_total_nonlesion_number << endl;  

  if (m_current_total_nonlesion_number < 50) {
    cout << "no further nonlesion tissue need to be selected" << endl;
    m_Iter = m_Iter - 1;
    exit(2);
  }

  m_IterPlus1 = m_Iter + 1;



  std::ostringstream svmtestfilename2;
  svmtestfilename2 << "train2_" << Superclass::m_PreIter << ".example" << ends;
  create_training_file2(Superclass::total_lesion_features, Superclass::total_nonlesion_features, Superclass::current_features, Superclass::reduced_current_features, svmtestfilename2);

  std::string kernelType = "rbf";
  std::vector<std::string> kernelParameters;
  kernelParameters.push_back("6000");
  std::ostringstream svmOutputFilename;
  svmOutputFilename << "itktest" << m_Iter << ".mdl" << std::ends;
  std::string svmOutputFormat = "ascii";
  std::string trainfilename  = svmtestfilename2.str();

  Superclass::Trainer.Training(kernelType, kernelParameters, svmOutputFilename, svmOutputFormat, trainfilename, 0.0005); 
  //m_SVM_Error = m_SVM_Error + 0.005;

  cout <<  svmOutputFilename.str().c_str() << " created" << endl;

  Superclass::current_features->Clear();
  Superclass::reduced_current_features->Clear();
 } // while

  fclose(fp);
}


template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::SetNumImages(int numimg)
{
   cout << "WMLGetSelectedFeature::SetNumImages(int numimg)" << endl;

   Superclass::m_NumImages = numimg; 
}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::Testing(ImagePointerType t1image, ImagePointerType t2image, ImagePointerType pdimage, ImagePointerType flimage, ImagePointerType flthresholdimage, std::ostringstream& svmfilename)
{
   cout << "WMLAdaptiveBooster::Testing()" << endl;

   ImagePointerType outimg;
   int test_index;

   std::ostringstream testfilename;
   std::ostringstream svmtestoutfile;

   testfilename << "finaltest.example" << ends;
  svmtestoutfile << "finaltest.result" << ends;

  Superclass::dim_x = t1image->GetRequestedRegion().GetSize()[0];
  Superclass::dim_y = t1image->GetRequestedRegion().GetSize()[1];
  Superclass::dim_z = t1image->GetRequestedRegion().GetSize()[2];

  typename ImageType::SpacingType sp = t1image->GetSpacing();

  std::cout << sp[0] << ", " << sp[1] << ", " << sp[2] << std::endl;

  Superclass::res_x = sp[0];
  Superclass::res_y = sp[1];
  Superclass::res_z = sp[2];

  Superclass::bubble_size = Superclass::m_Radius;

  calculate_hood_special_improve(Superclass::bubble_size); // CAUTION!

  test_index = this->WMLTestSingleImageKeepAllFunctionValue_NoSmooth_NoMask(t1image, t2image, pdimage, flimage,  flthresholdimage, outimg, testfilename, svmtestoutfile, svmfilename);

   cout << "test_index: " << test_index << endl;

   // Make test image

  // memory alloc 
  Superclass::FinalTestImage = FloatImageType::New();

  FloatImageType::IndexType f_start;
  f_start[0] = 0; f_start[1] = 0; f_start[2] = 0;

  FloatImageType::SizeType f_size;
  f_size[0] = Superclass::dim_x; f_size[1] = Superclass::dim_y; f_size[2] = Superclass::dim_z;

  FloatImageType::RegionType f_region;
  f_region.SetSize(f_size);
  f_region.SetIndex(f_start);

  Superclass::FinalTestImage->SetSpacing(t1image->GetSpacing());
  Superclass::FinalTestImage->SetRegions(f_region);
  Superclass::FinalTestImage->Allocate();
  Superclass::FinalTestImage->FillBuffer(0);

  FloatImageType::IndexType imageindex;

  FILE *gfp;
  gfp = fopen("finaltest.result", "r"); // current: read result file from svm tester -> TODO: getResult function in svm tester
  float tmp; // float!

  if(gfp==NULL) cout << "file error" << endl;

  // clear SVMTestImage
  Superclass::FinalTestImage->FillBuffer(0);

   DoubleSampleType::MeasurementVectorType mv;
   mv.SetSize(4);


  for (int t=0; t<test_index; t++) {
    fscanf(gfp, "%f\n", &tmp);

    mv = Superclass::test_voxel_list->GetMeasurementVector(t);
    imageindex[0] = static_cast<long int> (mv.GetElement(0));
    imageindex[1] = static_cast<long int> (mv.GetElement(1));
    imageindex[2] = static_cast<long int> (mv.GetElement(2));

    Superclass::FinalTestImage->SetPixel(imageindex, tmp);
  }
  fclose(gfp);

  cout << "read test.result: pass" << endl;


   typedef itk::ImageFileWriter<FloatImageType> WriterType;
   WriterType::Pointer writer = WriterType::New();

    writer->SetFileName("afterfinaltest.mha");
    writer->SetInput(Superclass::FinalTestImage);
    writer->Update();

  cout << "voxel_list created" << endl;
  cout << "finished creating mask" << endl;


   // InvertImageFloat
   this->InvertImgFloat(Superclass::FinalTestImage, Superclass::FinalTestImage);

   // lesion_threshold
   int i,j,k;

   // temp -- replaced by function
   typename BinaryThresholdImageFilter<FloatImageType, ImageType>::Pointer thresh_filter =
    BinaryThresholdImageFilter<FloatImageType, ImageType>::New();

    for(k=0; k<Superclass::dim_z; k++)
      for(i=0; i<Superclass::dim_x; i++)
        for(j=0; j<Superclass::dim_y; j++) {

          imageindex[0] = i; imageindex[1] = j; imageindex[2] = k;

            if (Superclass::FinalTestImage->GetPixel(imageindex) >= 0.0) {
                Superclass::FinalTestImage->SetPixel(imageindex, 255.0);
             }
            else Superclass::FinalTestImage->SetPixel(imageindex, 0.0);
        }


    writer->SetFileName("afterfinaltest_threshold.mha");
    writer->SetInput(Superclass::FinalTestImage);
    writer->Update();

}


template <class TImage, class TMeasurementVector >
int
WMLGetSelectedFeature<TImage, TMeasurementVector>
::ExtractLesionVoxels2(IntSampleType* lst, ImageVectorType MaskImage, std::string& filename, int type)
{
  cout << "WMLGetSelectedFeature::ExtractLesionVoxels2()" << endl;


   typename ImageType::IndexType  imageindex, tmp_pos;

   FILE *fp;

   fp = fopen(filename.c_str(), "w");

   int l_index = 0;

   cout << "collecting lesion features..." << endl;
   cout << "# of images: " << Superclass::m_NumImages << endl;
   cout << "filename: " << filename << endl; 

   bool is_lesion = false;
   int i, j, k; 

  // for debug
/*
   std::ostringstream inputfilename;
   inputfilename << "extractlesion" << Superclass::m_PreIter << ".mha" << ends;

    MaskImage[0]->SetDirection(MaskImage[0]->GetDirection());
    typedef itk::ImageFileWriter<ImageType> WriterType;
    WriterType::Pointer writer = WriterType::New();

    writer->SetFileName(inputfilename.str().c_str());
    writer->SetInput(MaskImage[0]);
    writer->Update();
  // --
*/

#define LVOXEL  // CAUTION: should be read from file!
#ifdef LVOXEL

 std::ostringstream lvfilename;
 lvfilename << "maskoutimg0_" << Superclass::m_PreIter << ".mha" << ends;  // CAUTION 0: 1st image

 typename itk::ImageFileReader<ImageType>::Pointer reader = itk::ImageFileReader<ImageType>::New();
 reader->SetFileName(lvfilename.str().c_str());
 reader->Update();

 typename ImageType::Pointer input = reader->GetOutput();
#endif // LVOXEL



 for ( unsigned int id=0; id<Superclass::m_NumImages; id++)  {
   for (k=Superclass::m_Radius; k<Superclass::dim_z-Superclass::m_Radius; k++)
    for (j=Superclass::m_Radius; j<Superclass::dim_y-Superclass::m_Radius; j++)
     for (i=Superclass::m_Radius; i<Superclass::dim_x-Superclass::m_Radius; i++)   // CAUTION!: ORDER
       {

        // lesion vectors
        imageindex[0]=i; imageindex[1]=j; imageindex[2]=k;

#ifdef LVOXEL
         if (input->GetPixel(imageindex)==255) 
#else
        if (MaskImage[id]->GetPixel(imageindex)==255) 
#endif 
	l_index++;
	}
     }

   cout << "l_index: " << l_index << endl;

/*#ifdef LVOXEL
  IntSampleType::Pointer mylst = IntSampleType::New();
  mylst->SetMeasurementVectorSize(4*Superclass::pixelNumInBubble+1);

   for (i=0; i< l_index; i++) {
        IntSampleType::MeasurementVectorType  total_feature_mv;
        total_feature_mv.SetSize(mylst->GetMeasurementVectorSize());
        total_feature_mv.Fill(0);

        mylst->PushBack(total_feature_mv);
   }
#else
*/
   for (i=0; i< l_index; i++) {
        IntSampleType::MeasurementVectorType  total_feature_mv;
        total_feature_mv.SetSize(lst->GetMeasurementVectorSize());
	total_feature_mv.Fill(0);

	lst->PushBack(total_feature_mv);   
   } 
//#endif


   l_index = 0;
   for ( unsigned int id=0; id<Superclass::m_NumImages; id++)  {

   for ( k=Superclass::m_Radius; k<Superclass::dim_z-Superclass::m_Radius; k++)
    for ( j=Superclass::m_Radius; j<Superclass::dim_y-Superclass::m_Radius; j++)
     for ( i=Superclass::m_Radius; i<Superclass::dim_x-Superclass::m_Radius; i++)   // CAUTION!: ORDER
       {

        // lesion vectors
        imageindex[0]=i; imageindex[1]=j; imageindex[2]=k;

        // if (only_preventricle == 0)

#ifdef LVOXEL
         if (input->GetPixel(imageindex)==255) {
#else
        if (MaskImage[id]->GetPixel(imageindex)==255) {
#endif 

        IntSampleType::MeasurementVectorType  total_feature_mv;
//#ifdef LVOXEL
//	total_feature_mv.SetSize(mylst->GetMeasurementVectorSize());
//#else
        total_feature_mv.SetSize(lst->GetMeasurementVectorSize());
//#endif 

        for (int ii=0; ii<Superclass::pixelNumInBubble; ii++) {

        IntSampleType::MeasurementVectorType  mv;
        mv.SetSize(Superclass::bubble->GetMeasurementVectorSize());
        mv = Superclass::bubble->GetMeasurementVector(ii);

        //tmp_pos[0] = i + mv.GetElement(0); tmp_pos[1] = j + mv.GetElement(1); tmp_pos[2] = k + mv.GetElement(2);
        tmp_pos[0] = i + mv.GetElement(1); tmp_pos[1] = j + mv.GetElement(0); tmp_pos[2] = k + mv.GetElement(2);  // CAUTION!: ORDER


        if ((tmp_pos[0]>=0) && (tmp_pos[0]<Superclass::dim_x) && (tmp_pos[1]>=0) &&
            (tmp_pos[1]<Superclass::dim_y) && (tmp_pos[2]>=0) && (tmp_pos[2]<Superclass::dim_z)) {

        // TODO: Weight
        fprintf(fp, "%f %f %f %f ", (float) Superclass::m_T1Image[id]->GetPixel(tmp_pos), (float) Superclass::m_T2Image[id]->GetPixel(tmp_pos),
               (float) Superclass::m_PDImage[id]->GetPixel(tmp_pos), (float) Superclass::m_FLImage[id]->GetPixel(tmp_pos));


        // save to total_features
        total_feature_mv.SetElement(0+ii*4, static_cast<int>( Superclass::m_T1Image[id]->GetPixel(tmp_pos)) );
        total_feature_mv.SetElement(1+ii*4, static_cast<int>( Superclass::m_T2Image[id]->GetPixel(tmp_pos)) );
        total_feature_mv.SetElement(2+ii*4, static_cast<int>( Superclass::m_PDImage[id]->GetPixel(tmp_pos)) );
        total_feature_mv.SetElement(3+ii*4, static_cast<int>( Superclass::m_FLImage[id]->GetPixel(tmp_pos)) );

        is_lesion = true;

        } // if
        }

        if (is_lesion) {
        total_feature_mv.SetElement(total_feature_mv.Size()-1, type);  // CAUTION!!!
        //lst->PushBack(total_feature_mv);
//#ifdef LVOXEL
//	mylst->SetMeasurementVector (l_index, total_feature_mv);
//#else
         lst->SetMeasurementVector (l_index, total_feature_mv);
//#endif
        is_lesion = false;
        }


        //if (special_case == 0)
        // if (save_position == 0)
        fprintf(fp, "        %d\n", type);   // CAUTION!!!
        // else {fprintf(fp, "\n");fprintf(fp_pos, "%d %d %d\n", i, j, k);}
        //if (special_case == 1) fprintf(fp, "        1\n");
        l_index++;
         }
         } // for -- lesion


   // NEW: using image region iterator in ITK

   }  // for -- all images

   fclose(fp);

   cout << "total lesion voxel number: " << l_index << endl;

   Superclass::m_average_manual_seg_voxel_number = l_index / Superclass::m_NumImages;

  Superclass::m_Nonlesion_Voxel_Number.SetElement(m_Iter, l_index); 


   return l_index;

}

template <class TImage, class TMeasurementVector >
void
WMLGetSelectedFeature<TImage, TMeasurementVector>
::create_training_file2(IntSampleType* lesionlst, IntSampleType* initial_nonlesionlst, IntSampleType* nonlesionlst, IntSampleType* outlst, std::ostringstream& trainfilename)
{
  cout << "WMLGetSelectedFeature::create_training_file2()" << endl;

  // from RemoveDuplicateElementFromList.pl
  // Compare two lists to see whether each element in list1 is in list2

   unsigned int cnt = 0;

   IntSampleType::MeasurementVectorType  lesion_mv;
   lesion_mv.SetSize(lesionlst->GetMeasurementVectorSize());

   IntSampleType::MeasurementVectorType  nonlesion_mv;
   nonlesion_mv.SetSize(lesionlst->GetMeasurementVectorSize());

   IntSampleType::MeasurementVectorType  initial_nonlesion_mv;
   initial_nonlesion_mv.SetSize(lesionlst->GetMeasurementVectorSize());

   IntSampleType::MeasurementVectorType  out_mv;
   out_mv.SetSize(outlst->GetMeasurementVectorSize());

   IntSampleType::MeasurementVectorType  out_mv2;
   out_mv2.SetSize(outlst->GetMeasurementVectorSize());


   cout << "Superclass::m_total_voxel_number: " << Superclass::m_total_voxel_number << endl;
   cout << "lesionlst->Size(): " << lesionlst->Size() << endl;

  // for lesion features
  for (unsigned int s=0; s<lesionlst->Size();s++)
  {
        lesion_mv = lesionlst->GetMeasurementVector(s);

        for (unsigned int ss=0; ss<outlst->Size(); ss++)
        {
           out_mv = outlst->GetMeasurementVector(ss);

        cnt=0;
           for (unsigned int sss=0; sss<lesionlst->GetMeasurementVectorSize()-1; sss++) // CAUTION: -1
           {
                if (lesion_mv.GetElement(sss)==out_mv.GetElement(sss)) {
                  cnt++;
                }
           }
        }
        if (cnt==lesionlst->GetMeasurementVectorSize()-1)
        {
            cout << "same element: " << s << endl;
        }
        else {
           outlst->PushBack(lesion_mv);
        }
  }

  
  cout << "m_IterPlus: " << m_Iter + 1;
 
  IntSampleType::Pointer merged_nonlesionlst= IntSampleType::New();
  merged_nonlesionlst->SetMeasurementVectorSize(lesionlst->GetMeasurementVectorSize());  

  // CAUTION!

  cout << "Nonlesion voxel numbers for each iteration: " << endl;
  cout << Superclass::m_Nonlesion_Voxel_Number.GetElement(0) << endl;
  cout << Superclass::m_Nonlesion_Voxel_Number.GetElement(1) << endl;
  cout << Superclass::m_Nonlesion_Voxel_Number.GetElement(2) << endl;


  for (int s=0; s<m_Iter+1; s++) {  
   cout << "should read nonlesion.vec." << s << endl;

   std::ostringstream filename;
   filename << "nonlesion.vec." << s << ends;
   FILE *gfp;
   gfp = fopen(filename.str().c_str(), "r");

   cout << "reading from " << filename.str().c_str() << endl;
    
   float tmp;
   for (int ss=0; ss<Superclass::m_Nonlesion_Voxel_Number.GetElement(s); ss++) {
    for (unsigned int sss=0; sss<nonlesionlst->GetMeasurementVectorSize(); sss++)
    {
	fscanf (gfp, "%f", &tmp);
	
	//if (sss<10) printf ("%f\n");
        nonlesion_mv.SetElement(sss, tmp);
    }
       merged_nonlesionlst->PushBack(nonlesion_mv);
    }

   fclose(gfp); 
   }

   cout << "size of merged_nonlesionlst: " << merged_nonlesionlst->Size() << endl;

   cout << "merged_nonlesionlst->GetMeasurementVectorSize(): " << merged_nonlesionlst->GetMeasurementVectorSize() << endl; 
   cout << "lesionlst->GetMeasurementVectorSize(): " << lesionlst->GetMeasurementVectorSize() << endl;
   cout << "outlst->GetMeasurementVectorSize(): " << outlst->GetMeasurementVectorSize() << endl;
   cout << "merged_nonlesionlst->Size(): " <<  merged_nonlesionlst->Size() << endl;

  // for nonlesion features
  for (unsigned int t=0; t<merged_nonlesionlst->Size();t++)
  {
        nonlesion_mv = merged_nonlesionlst->GetMeasurementVector(t);

        for (unsigned int tt=0; tt<outlst->Size(); tt++)
        {
          out_mv = outlst->GetMeasurementVector(tt);

	  //if (t==1) 
	   // for (int a=0; a<merged_nonlesionlst->GetMeasurementVectorSize()-1; a++)  cout << out_mv.GetElement(a) << " " ;
           //   cout << endl;

        cnt=0;
           for (unsigned int ttt=0; ttt<merged_nonlesionlst->GetMeasurementVectorSize()-1; ttt++)
           {
                if ( nonlesion_mv.GetElement(ttt)== out_mv.GetElement(ttt)) {
                  cnt++;
	
		  // for debug
		 //cout << nonlesion_mv.GetElement(ttt) << " ";
                }
           }
        }

//	cout << endl;

        if (cnt==merged_nonlesionlst->GetMeasurementVectorSize()-1)
        {
            cout << "same element: " << t << endl;
        }
        else {
           outlst->PushBack(nonlesion_mv);
        }
  }


   // CAUTION !!!
   // Remove redundant samples in outlst


   Superclass::m_total_voxel_number = outlst->Size();
   cout << "New Superclass::m_total_voxel_number: " << Superclass::m_total_voxel_number << endl;


    std::vector<unsigned int> redun_lst;
    int redun_lst_size_cnt = 0;
    for (unsigned int s=0; s<outlst->Size(); s++)
    {
     out_mv = outlst->GetMeasurementVector(s);
     for (unsigned int ss = s+1; ss<outlst->Size(); ss++)
     {
	out_mv2 = outlst->GetMeasurementVector(ss);       
	cnt=0;
	 for (unsigned int sss=0; sss<outlst->GetMeasurementVectorSize()-1; sss++)
	 {
	    if ( out_mv.GetElement(sss) == out_mv2.GetElement(sss) ) cnt++;
	 }
	 if (cnt==outlst->GetMeasurementVectorSize()-1) {
	    cout << "Real same pt" << endl;
	    redun_lst.push_back(ss);
	 }
     }
    }


   redun_lst_size_cnt = outlst->Size() - cnt;

   cout << "redun_lst size: " << redun_lst.size() << endl;
    
    for (unsigned int s=0; s<redun_lst.size(); s++) 
	cout << redun_lst[s] << endl;

   // Calculate sample size after removing redundant ones
   int redun_cnt = 0;
   redun_lst_size_cnt = 0;
   for (unsigned int s=0; s<outlst->Size(); s++)
    {
      redun_cnt = 0;

      for(unsigned int ss=0; ss<redun_lst.size(); ss++)
        if(redun_lst[ss]==s) redun_cnt++;

      if (redun_cnt==0) redun_lst_size_cnt++;
      
    }

    // Write file
    FILE *fp;
    fp = fopen(trainfilename.str().c_str(), "w"); // output
  
    redun_cnt = 0;

    fprintf(fp, "%d %u\n", redun_lst_size_cnt, outlst->GetMeasurementVectorSize());

    for (unsigned int s=0; s<outlst->Size(); s++)
    {
      redun_cnt = 0;

      for(unsigned int ss=0; ss<redun_lst.size(); ss++)
        if(redun_lst[ss]==s) redun_cnt++;

      if (redun_cnt==0) {
	out_mv = outlst->GetMeasurementVector(s);
	 for (unsigned int sss=0; sss<outlst->GetMeasurementVectorSize()-1; sss++)
         {
          fprintf(fp, "%f ", (float) out_mv.GetElement(sss));
         }
         fprintf(fp, "%d\n",  out_mv.GetElement(outlst->GetMeasurementVectorSize()-1));
      } // if
    }

   fclose(fp);
}
} // end namespace itk

#endif
