#ifndef __itkWMLPreprocessor_h
#define __itkWMLPreprocessor_h

#include <itkImage.h>
#include <itkImageToImageFilter.h>

#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkGaussianBlurImageFunction.h"
#include "itkImageRegionIterator.h"
#include "itkSmoothingRecursiveGaussianImageFilter.h"

#include "itkSkullStripping.h"
#include "itkBiasCorrection.h"
#include "itkRemoveEyeRegion.h"
#include "itkHistogramMatching.h"
#include "itkAffineRegistration.h"

#include "itkWMLProcessorBase.h"

#include <itkOrientedImage.h>

namespace itk {
  template<class TInputImage, class TOutputImage>
    class ITK_EXPORT WMLPreprocessor : public WMLProcessorBase<TInputImage, TOutputImage>
    {
    public:

      typedef WMLPreprocessor Self;
      typedef WMLProcessorBase<TInputImage, TOutputImage> Superclass;
      typedef SmartPointer<Self>                        Pointer;
      typedef SmartPointer<const Self>                  ConstPointer;

      typedef itk::OrientedImage<float, 3> FloatImageType;
      typedef FloatImageType::Pointer FloatImagePointerType;

      // MJ_TEMP
      typedef TInputImage ImageType;
      //  typedef itk::OrientedImage<short, 3> ImageType;
      typedef typename ImageType::Pointer ImagePointerType;

      typedef itk::VariableLengthVector<double> DoubleVectorType;
      typedef itk::VariableLengthVector<int> IntVectorType;

      /** Method for creation through the object factory. */
      itkNewMacro(Self);

      /** Run-time type information (and related methods). */
      //  itkTypeMacro(WMLPreprocessor, ImageToImageFilter);
      itkTypeMacro(WMLPreprocessor,WMLProcessorBase);

      HistMatch Histogram;

      myAffReg<TInputImage> myRegister;

      BiasCorr BiasCorrector;

      typedef std::vector<ImagePointerType> ImageVectorType;

      void SetT1Image (ImageVectorType T1Image);
      void SetT2Image (ImageVectorType T2Image);
      void SetPDImage (ImageVectorType PDImage);
      void SetFLImage (ImageVectorType FLImage);
  
      // 0318
      void SetFLThresholdImage (ImageVectorType FLThresholdImage);


      void Coregistration(int id);
      void MaskTransform(int id);
      void GaussianSmoothing(ImagePointerType inputImage, ImagePointerType output, float sigma, std::string& filename);
      void SkullStripping(int id);
      void ThresholdImage(std::string& flmaskname, int id, int threshold);
      void MaskOutImage(ImagePointerType img, ImagePointerType mask, std::string& filename);
      float get_label_overlap_degree(int label, ImagePointerType img, ImagePointerType mask);

      void InhomogeneityCorrection(int id);
      void HistogramMatching();
      void RemoveEyeTissue(int id);
      void AutomaticSegmentation(int id);
      void GetProbabilityMap(int id);

      void preprocessing();

      void SetNumImages(int numimg);

    private:
      WMLPreprocessor(const Self&); //purposely not implemented
      void operator=(const Self&); //purposely not implemented

      int m_NumImages;

    protected:
      WMLPreprocessor();
      ~WMLPreprocessor();
      void PrintSelf(std::ostream& os, Indent indent) const;

    };

} // namespace itk
#ifndef ITK_MANUAL_INSTANTIATION
#include "itkWMLPreprocessor.txx"
#endif

#endif
