#ifndef __itkWMLPreprocessor_txx
#define __itkWMLPreprocessor_txx

#include "itkWMLPreprocessor.h"

using namespace std;

namespace itk
{
  template <class TInputImage, class TOutputImage>
  WMLPreprocessor<TInputImage, TOutputImage>
  ::WMLPreprocessor()
  {
  }

  template <class TInputImage, class TOutputImage>
  WMLPreprocessor<TInputImage, TOutputImage>
  ::~WMLPreprocessor()
  {
  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::PrintSelf(std::ostream& os, Indent indent) const
  {
    Superclass::PrintSelf( os, indent );
  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::Coregistration(int id)
  {
    cout << "WMLPreprocessor::Coregistration()" << endl;

    // parameter setting

    myRegister.SetHistogramBin(30);
    myRegister.SetSpatialSamples(10000);
    myRegister.SetIteration(2000);
    myRegister.SetTransScale(100.0);

    std::string inittrans = "";
    std::string outtrans = "outputtrans.mat";
    std::string outfile;

    myRegister.SetInitTransform(inittrans);
    myRegister.SetOutputTransform(outtrans);

    //TODO: directly pass images
    typedef itk::ImageFileReader< ImageType >  ReaderType;
    typedef itk::ImageFileWriter< ImageType >  WriterType;

    // for registration between FL-T2
    myRegister.SetFixedImage(this->m_FLImage[id]);
    myRegister.SetMovingImage(this->m_T2Image[id]);

    outfile = "affregFL_T2.mha";
    myRegister.SetOutputImageFilename(outfile);
    myRegister.myregistration(Superclass::m_preprocessedT2Image[id]);

    //TODO: directly pass images
    typename ReaderType::Pointer T2reader = ReaderType::New();
    T2reader->SetFileName("affregFL_T2.mha");
    Superclass::m_preprocessedT2Image[id] = T2reader->GetOutput();
    T2reader->Update();

    // for registration between FL-PD
    myRegister.SetFixedImage(Superclass::m_FLImage[id]);
    myRegister.SetMovingImage(Superclass::m_PDImage[id]);

    outfile = "affregFL_PD.mha";
    myRegister.SetOutputImageFilename(outfile);
    myRegister.myregistration(Superclass::m_preprocessedPDImage[id]);

    //TODO: directly pass images
    typename ReaderType::Pointer PDreader = ReaderType::New();
    PDreader->SetFileName("affregFL_PD.mha");
    Superclass::m_preprocessedPDImage[id] = PDreader->GetOutput();
    PDreader->Update();

    // CAUTION: FL-T1 registration should be performed in the final; the matrix should be saved
    // for registration between FL-T1
    myRegister.SetFixedImage(Superclass::m_FLImage[id]);
    myRegister.SetMovingImage(Superclass::m_T1Image[id]);

    outfile = "affregFL_T1.mha";
    myRegister.SetOutputImageFilename(outfile);
    myRegister.myregistration(Superclass::m_preprocessedT1Image[id]);

    typename ReaderType::Pointer T1reader = ReaderType::New();
    T1reader->SetFileName("affregFL_T1.mha");
    Superclass::m_preprocessedT1Image[id] = T1reader->GetOutput();
    T1reader->Update();

    Superclass::m_preprocessedFLImage[id] = Superclass::m_FLImage[id];

    // for debug
    typename WriterType::Pointer writer = WriterType::New();
    writer->SetFileName( "afterreg_T1.mha" );
    writer->SetInput( Superclass::m_preprocessedT1Image[id] );
    writer->Update();

    writer->SetFileName( "afterreg_T2.mha" );
    writer->SetInput( Superclass::m_preprocessedT2Image[id] );
    writer->Update();

    writer->SetFileName( "afterreg_PD.mha" );
    writer->SetInput( Superclass::m_preprocessedPDImage[id] );
    writer->Update();

    writer->SetFileName( "afterreg_FL.mha" );
    writer->SetInput( Superclass::m_preprocessedFLImage[id] );
    writer->Update();
  }


  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::MaskTransform(int id)
  {
    cout << "WMLPreprocessor::MaskTransform()" << endl;

    typedef itk::ImageFileReader< ImageType >  ReaderType;

    //typedef itk::Statistics::ResampImage<ImageType, ImageType> MaskTransformType;
    //MaskTransformType::Pointer masktransform = MaskTransformType::New();

    //masktransform->Update();

    /*
      myRegister.SetHistogramBin(30);
      myRegister.SetSpatialSamples(10000);
      myRegister.SetIteration(2000);
      myRegister.SetTransScale(100.0);

      //   std::string inittrans = "outputtrans.mat";
      std::string inittrans ="";
      std::string outtrans = "";
      std::string outfile;

      myRegister.SetInitTransform(inittrans);
      myRegister.SetOutputTransform(outtrans);

      // for registration between FL-T1
      myRegister.SetFixedImage(Superclass::m_FLImage[id]);
      myRegister.SetMovingImage(Superclass::m_T1Image[id]);

      outfile = "testregFL_T1.mha";
      myRegister.SetOutputImageFilename(outfile);

      typename ReaderType::Pointer reader = ReaderType::New();
      reader->SetFileName("T1.brain.mask.mha");
      ImageType::Pointer image = ImageType::New();
      image = reader->GetOutput();
      reader->Update();
    */


    std::string fixedimagename = "FL.mha";
    std::string movingimagename = "T1.brain.mask.mha";
    std::string outimagename = "T1Mask.mha";
    std::string transformname = "outputtrans.mat";
    myRegister.mytransformation( fixedimagename, movingimagename, outimagename, transformname);

    /*
    //TODO: directly pass images
    typedef itk::ImageFileReader< ImageType >  ReaderType;
    typedef itk::ImageFileWriter< ImageType >  WriterType;

    typename ReaderType::Pointer T1reader = ReaderType::New();
    T1reader->SetFileName("affregFL_T1.mha");
    Superclass::m_preprocessedT1Image[id] = T1reader->GetOutput();
    T1reader->Update();
    */

  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::GaussianSmoothing(ImagePointerType inputImage, ImagePointerType output, float sigma, std::string& filename)
  {
    cout << "WMLPreprocessor::GaussianSmoothing()" << endl;


    typedef itk::SmoothingRecursiveGaussianImageFilter<ImageType, ImageType> smoothfiltertype;
    typename smoothfiltertype::Pointer smoothfilter = smoothfiltertype::New();
    smoothfilter->SetInput( inputImage );
    smoothfilter->SetSigma(sigma);
    smoothfilter->Update();

    typedef itk::RescaleIntensityImageFilter<ImageType, ImageType> RescaleFilterType;

    typename RescaleFilterType::Pointer rescaler  = RescaleFilterType::New();
    rescaler->SetOutputMinimum(   0 );
    rescaler->SetOutputMaximum( 255 );


    typedef itk::ImageFileReader< ImageType >  ReaderType;
    typedef itk::ImageFileWriter< ImageType >  WriterType;

    typename WriterType::Pointer writer = WriterType::New();
    writer->SetFileName( filename );

    rescaler->SetInput( smoothfilter->GetOutput() );
    output = rescaler->GetOutput();
    output->Update();
    writer->SetInput( rescaler->GetOutput() );
    writer->Update();
  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::SkullStripping(int id)
  {
    cout << "WMLPreprocessor::SkullStripping()" << endl;

    typedef itk::Statistics::SkullStripping<ImageType, ImageType> SkullStrippingType;
    typename SkullStrippingType::Pointer skullstripper = SkullStrippingType::New();

    std::string filename = "T1.brain.mha";

    skullstripper->SetInputVolume(Superclass::m_T1Image[id].GetPointer());
    skullstripper->SetOutputVolumeFilename(filename);

    filename = "T1.brain.mask.mha";
    skullstripper->SetOutputMaskFilename(filename);

    skullstripper->Update();

    //  cout << "Skull stripping -- skip for test" << endl;

  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::ThresholdImage(std::string& flmaskname, int id, int threshold)
  {
    // repeated method -> to be removed
    cout << "WMLPreprocessor::ThresholdImage()" << endl;

    cout << "reading " << flmaskname.c_str() << endl;

    // read image from file
    typedef itk::ImageFileReader<ImageType> ReaderType;
    typename ReaderType::Pointer reader = ReaderType::New();

    reader->SetFileName(flmaskname);
    reader->Update();



    unsigned int i, j, k;

    typename ImageType::IndexType index;

    typename ImageType::Pointer inimg = ImageType::New();
    inimg = reader->GetOutput();

    typename ImageType::SizeType size;
    size = inimg->GetBufferedRegion().GetSize();


    typename BinaryThresholdImageFilter<FloatImageType, ImageType>::Pointer thresh_filter =
      BinaryThresholdImageFilter<FloatImageType, ImageType>::New();

    for(k=0; k<size[2]; k++)
      for(i=0; i<size[1]; i++)
	for(j=0; j<size[0]; j++) {

	  index[0] = i; index[1] = j; index[2] = k;

	  if (reader->GetOutput()->GetPixel(index) >=threshold) {
	    inimg->SetPixel(index, 255);
	  }
	  else inimg->SetPixel(index, 0);
	}
    cout << endl;



    typedef itk::ImageFileWriter<ImageType> WriterType;
    typename WriterType::Pointer writer = WriterType::New();

    writer->SetFileName(flmaskname);
    writer->SetInput(inimg);
    writer->Update();

    cout << flmaskname.c_str() << "saved" << endl;

  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::MaskOutImage(ImagePointerType img, ImagePointerType mask, std::string& filename)
  {
    // repeated method -> to be removed

    cout << "WMLPreprocessor::MaskOutImage()" << endl;

    unsigned int   i, j, k;

    typename ImageType::IndexType  imageindextemp;
    typename ImageType::SizeType size;
    size = img->GetBufferedRegion().GetSize();

    /*
      for (i=0; i<256; i++) histo[i] = 0;
      for (k=0; k<size[2]; k++)
      for (i=0; i<size[0]; i++)
      for (j=0; j<size[1]; j++) {

      imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;

      if(img->GetPixel(imageindextemp)!= 0)
      histo[img->GetPixel(imageindextemp)]++;
      }

      // for debugging
      cout << "print histogram..." << endl;
      for (i=0; i<256; i++)
      cout << histo[i] << " " ;
      cout << endl;
      // --

      // label2remove = Ialloc1d(256);

      IntVectorType label2remove;
      label2remove.SetSize(256);

      label2remove_num = 0;

      // label2keep = Ialloc1d(256);
      IntVectorType label2keep;
      label2keep.SetSize(256);

      label2keep_num = 0;

      for (i=0; i<256; i++)
      if (histo[i] != 0) {
      overlap_degree = get_label_overlap_degree(i, img, mask);

      // for debbugging
      cout << "label: " << i << endl;
      cout << "overlap_degree: " << overlap_degree << endl;
      cout << "threshold: " << threshold << endl;

      // --

      if (overlap_degree < threshold) {
      label2remove[label2remove_num] = i;
      label2remove_num++;
      }
      if (overlap_degree >= threshold) {
      label2keep[label2keep_num] = i;
      label2keep_num++;
      }
      }

      // for debbugging
      cout << "label2remove_num: " << label2remove_num << endl;
      cout << "label2keep_num: " << label2keep_num << endl;

      for (l=0; l<label2keep_num; l++)
      for (k=0; k<size[2]; k++)
      for (i=0; i<size[0]; i++)
      for (j=0; j<size[1]; j++) {
      //if (img[k][i][j] == label2keep[l]) img[k][i][j] = 0;

      imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;
      if(img->GetPixel(imageindextemp)== label2keep[l]) img->SetPixel(imageindextemp, 0);

      }

      for (k=0; k<size[2]; k++)
      for (i=0; i<size[0]; i++)
      for (j=0; j<size[1]; j++){
      //if (img[k][i][j] != 0) img[k][i][j] = 255;

      imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;
      if(img->GetPixel(imageindextemp)!= 0)
      img->SetPixel(imageindextemp, 255);
      }
    */

    // CAUTION
    for (k=0; k<size[2]; k++)
      for (i=0; i<size[0]; i++)
	for (j=0; j<size[1]; j++){
	  imageindextemp[0]=i; imageindextemp[1]=j; imageindextemp[2]=k;
	  if(mask->GetPixel(imageindextemp)== 0)
	    img->SetPixel(imageindextemp, 0);
	}


    /* saving ... */
    // WML.mask.nonlesion.diff in original code
    //  fp = fopen(argv[3],"w");
    //  for(k=0; k<dim.z; k++)
    //    for(i=0; i<dim.x; i++) fwrite(img[k][i],1,dim.y,fp);
    // fclose(fp);

    // for debugging
    typedef itk::ImageFileWriter<ImageType> WriterType;
    typename WriterType::Pointer writer = WriterType::New();

    writer->SetFileName(filename);
    writer->SetInput(img);
    writer->Update();
    // --

  }

  template <class TInputImage, class TOutputImage>
  float
  WMLPreprocessor<TInputImage, TOutputImage>
  ::get_label_overlap_degree(int label, ImagePointerType img, ImagePointerType mask)
  {
    cout << "WMLPreprocessor::get_label_overlap_degree" << endl;

    int        i, j, k, label_total_volume, overlap_volume;

    typename ImageType::SizeType size;
    size = img->GetBufferedRegion().GetSize();

    cout << "image dim: " << size[0] << ", " << size[1] << ", " << size[2] << endl;
    cout << "label: " << label << endl;

    typename ImageType::IndexType imageindex;

    label_total_volume = 0;
    overlap_volume = 0;
    for (k=0; k<size[2]; k++)
      for (i=0; i<size[0]; i++)
	for (j=0; j<size[1]; j++) {

	  imageindex[0] = i; imageindex[1] = j; imageindex[2] = k;

	  if (img->GetPixel(imageindex) == label) {
	    if (mask->GetPixel(imageindex) != 0) overlap_volume++;
	    label_total_volume++;
	  }
	}

    return ((float)overlap_volume/label_total_volume);
  }



  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::InhomogeneityCorrection(int id)
  {
    cout << "WMLPreprocessor::InhomogeneityCorrection()" << endl;

    //  typedef itk::Statistics::ProbabilisticBiasCorrection<ImageType, ImageType> ProbabilisticBiasCorrectionType;
    //  ProbabilisticBiasCorrectionType::Pointer probbiascorrector = ProbabilisticBiasCorrectionType::New();

    std::string inputvolname = "T1.mask.brain.mha";
    std::string inputwmvolname = "T1.seg2.mha";
    std::string outputvolname = "T1.mask.brain.match.mha";

    BiasCorrector.BiasCorrection(inputvolname, inputwmvolname, outputvolname);


    inputvolname = "T2.mask.brain.mha";
    inputwmvolname = "T1.seg2.mha";
    outputvolname = "T2.mask.brain.match.mha";

    BiasCorrector.BiasCorrection(inputvolname, inputwmvolname, outputvolname);

    inputvolname = "PD.mask.brain.mha";
    inputwmvolname = "T1.seg2.mha";
    outputvolname = "PD.mask.brain.match.mha";

    BiasCorrector.BiasCorrection(inputvolname, inputwmvolname, outputvolname);


    inputvolname = "FL.mask.brain.mha";
    inputwmvolname = "T1.seg2.mha";
    outputvolname = "FL.mask.brain.match.mha";

    BiasCorrector.BiasCorrection(inputvolname, inputwmvolname, outputvolname);


  }



  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::HistogramMatching()
  {
    cout << "WMLPreprocessor::HistogramMatching()" << endl;

    /*
      typedef itk::Statistics::HistogramMatching<ImageType, ImageType> HistogramMatchingType;
      HistogramMatchingType::Pointer histogrammatching = HistogramMatchingType::New();

      histogrammatching->Update();

    */

    std::string inputVolume = "T1.mask.brain.match.mha";
    std::string referenceVolume = "t1.model.resample.mha";
    std::string outputVolume = "T1.mask.brain.aftermatch.mha";

    Histogram.matching(inputVolume, referenceVolume, outputVolume, 0);


    inputVolume = "T2.mask.brain.match.mha";
    referenceVolume = "t2.model.resample.mha";
    outputVolume = "T2.mask.brain.aftermatch.mha";

    Histogram.matching(inputVolume, referenceVolume, outputVolume, 0);


    // for debug
    cout << "starting histogram matching of PD image" << endl;

    inputVolume = "PD.mask.brain.match.mha";
    referenceVolume = "pd.model.resample.mha";
    outputVolume = "PD.mask.brain.aftermatch.mha";

    Histogram.matching(inputVolume, referenceVolume, outputVolume, 0);

    // TODO: FLAIR -- special case
    inputVolume = "FL.mask.brain.match.mha";
    referenceVolume = "flair.model.resample.mha";
    outputVolume = "FL.mask.brain.aftermatch.mha";

    Histogram.matching(inputVolume, referenceVolume, outputVolume, 1);
  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::RemoveEyeTissue(int id)
  {
    cout << "WMLPreprocessor::RemoveEyeTissue()" << endl;

    std::string flfilename = "FL.mask.brain.aftermatch.mha";
    //  std::string flfilename = "beforeeyeremove.hd";  // CAUTION !!

    typedef itk::Statistics::RemoveEyeRegion<ImageType, ImageType> RemoveEyeRegionType;
    typename RemoveEyeRegionType::Pointer eyeremover = RemoveEyeRegionType::New();

    eyeremover->removeregion(flfilename);


  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::AutomaticSegmentation(int id)
  {
    cout << "WMLPreprocessor::AutomaticSegmentation()" << endl;

    typedef itk::ImageFileReader< ImageType > ReaderType;
    typedef itk::ImageFileWriter< ImageType >  WriterType;

    std::string inputvolname = "aftereyeremove.mha";
    std::string outputbasename = "aftereyeremove.seg";
    int n_class = 6;

    //AFCMSegmenter.Segmentation(inputvolname, outputbasename, n_class);

    // gather all volumes to one volume

    int i,j,k;
    //  typedef std::list<std::string> FilenameList;
    //  FilenameList SegFilename;

    Superclass::EyeRemoveImage = ImageType::New();
    typename ImageType::Pointer ImageMap = ImageType::New();


    typename ImageType::IndexType start;
    start[0] = 0; // first index on X
    start[1] = 0; // first index on Y
    start[2] = 0; // first index on Z

    typename ImageType::SizeType size;
    size = Superclass::m_FLImage[0]->GetBufferedRegion().GetSize(); 

    typename ImageType::RegionType region;
    region.SetSize( size );
    region.SetIndex( start );

    Superclass::EyeRemoveImage->SetRegions( region );
    Superclass::EyeRemoveImage->Allocate();
    Superclass::EyeRemoveImage->SetSpacing(Superclass::m_FLImage[0]->GetSpacing());
    Superclass::EyeRemoveImage->FillBuffer(0);

    ImageMap->SetRegions( region );
    ImageMap->Allocate();
    ImageMap->SetSpacing(Superclass::m_FLImage[0]->GetSpacing());
    ImageMap->FillBuffer(0);


    //  SegFilename.clear();
    //  std::string filenumber;

    /*  
	for (i=0; i<n_class; i++)
	{
	filenumber = i;
	cout << "filenumber: " << filenumber.c_str() << endl;
	SegFilename.push_back (outputbasename + filenumber + ".mha");
	FilenameList::const_iterator SegFilenameListConstIter;
	SegFilenameListConstIter = SegFilename.begin();
	cout << "SegFilename: " << SegFilenameListConstIter->c_str() << std::endl;
	}
    */

    std::string filename = "aftereyeremove.seg0.mha";

    typename ReaderType::Pointer reader1 = ReaderType::New();
    reader1->SetFileName(filename);
    reader1->Update();


    filename = "aftereyeremove.seg1.mha";
    typename ReaderType::Pointer reader2 = ReaderType::New();
    reader2->SetFileName(filename);
    reader2->Update();

    filename = "aftereyeremove.seg2.mha";
    typename ReaderType::Pointer reader3 = ReaderType::New();
    reader3->SetFileName(filename);
    reader3->Update();

    filename = "aftereyeremove.seg3.mha";
    typename ReaderType::Pointer reader4 = ReaderType::New();
    reader4->SetFileName(filename);
    reader4->Update();

    filename = "aftereyeremove.seg4.mha";
    typename ReaderType::Pointer reader5 = ReaderType::New();
    reader5->SetFileName(filename);
    reader5->Update();

    filename = "aftereyeremove.seg5.mha";
    typename ReaderType::Pointer reader6 = ReaderType::New();
    reader6->SetFileName(filename);
    reader6->Update();


    int l_th = 25;
    int h_th = 150;

    typename ImageType::IndexType index;

    for(k=0; k<size[2]; k++)
      for (j=0; j<size[1]; j++)
	for (i=0; i<size[0]; i++)
          {
            index[0] = i; index[1] = j; index[2] = k;

            if(reader1->GetOutput()->GetPixel(index)>Superclass::EyeRemoveImage->GetPixel(index)) {
              Superclass::EyeRemoveImage->SetPixel(index, reader1->GetOutput()->GetPixel(index));
              ImageMap->SetPixel(index, 0);
            }

            if(reader2->GetOutput()->GetPixel(index)>Superclass::EyeRemoveImage->GetPixel(index)) {
              Superclass::EyeRemoveImage->SetPixel(index, reader2->GetOutput()->GetPixel(index));
              ImageMap->SetPixel(index, 1);

            }

            if(reader3->GetOutput()->GetPixel(index)>Superclass::EyeRemoveImage->GetPixel(index)) {
              Superclass::EyeRemoveImage->SetPixel(index, reader3->GetOutput()->GetPixel(index));
              ImageMap->SetPixel(index, 2);
            }

            if(reader4->GetOutput()->GetPixel(index)>Superclass::EyeRemoveImage->GetPixel(index)) {
              Superclass::EyeRemoveImage->SetPixel(index, reader4->GetOutput()->GetPixel(index));
              ImageMap->SetPixel(index, 3);
            }

            if(reader5->GetOutput()->GetPixel(index)>Superclass::EyeRemoveImage->GetPixel(index)) {
              Superclass::EyeRemoveImage->SetPixel(index, reader5->GetOutput()->GetPixel(index));
              ImageMap->SetPixel(index, 4);
            }

            if(reader6->GetOutput()->GetPixel(index)>Superclass::EyeRemoveImage->GetPixel(index)) {
              Superclass::EyeRemoveImage->SetPixel(index, reader6->GetOutput()->GetPixel(index));
              ImageMap->SetPixel(index, 5);
            }
          }




    typename WriterType::Pointer writer = WriterType::New();
    writer->SetFileName( "FL.noeye_seg.mha" );
    writer->SetInput( ImageMap );
    writer->Update();

  }

  /*
    template <class TInputImage, class TOutputImage>
    void
    WMLPreprocessor<TInputImage, TOutputImage>
    ::SumImages(ImagePointerType image, std::string& filename)
    {
    typedef itk::ImageFileReader< ImageType >  ReaderType;
    typename ReaderType::Pointer reader = ReaderType::New();

    reader->SetFileName(filename);
    reader->Update();

    ImageType::SizeType size;
    size = image->GetBufferedRegion().GetSize();

    ImageType::IndexType index;

    int i,j,k;

    for(k=0; k<size[2]; k++)
    for (j=0; j<size[1]; j++)
    for (i=0; i<size[0]; i++)
    {
    index[0] = i; index[1] = j; index[2] = k;

    if(reader->GetOutput()->GetPixel(index)>0)
    image->SetPixel(index, reader->GetOutput()->GetPixel(index));
    }
    }
  */

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::GetProbabilityMap(int id)
  {
    cout << "WMLPreprocessor::GetProbabilityMap()" << endl;

    std::string inputvolname = "T1.mask.brain.mha";
    std::string outputbasename = "T1.seg";

  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::preprocessing()
  {
    cout << "WMLPreprocessor::Update()" << endl;
    int id;

    cout << "m_NumImages: " << m_NumImages << endl;

    typedef itk::ImageFileReader< ImageType >  ReaderType;
    typedef itk::ImageFileWriter< ImageType >  WriterType;

    // memory allocation for image vector (m_preprocessed T1, T2, PD and FL)
    typename ImageType::Pointer processimage = ImageType::New();
    typename ImageType::IndexType start;
    start[0] = 0; start[1] = 0; start[2] = 0;

    typename ImageType::SizeType size;
    size = Superclass::m_FLImage[0]->GetBufferedRegion().GetSize();

    cout << "image dimension: " << size[0] << ", " << size[1] << ", " << size[2] << endl;

    typename ImageType::RegionType region;
    region.SetSize(size);
    region.SetIndex(start);

    processimage->SetRegions(region);
    processimage->Allocate();
    processimage->FillBuffer(0);


    for (id=0; id<m_NumImages; id++)
      {
        Superclass::m_preprocessedT1Image.push_back(processimage);
        Superclass::m_preprocessedT2Image.push_back(processimage);
        Superclass::m_preprocessedPDImage.push_back(processimage);
        Superclass::m_preprocessedFLImage.push_back(processimage);
      }

    std::string filename;
    for (id=0; id<m_NumImages; id++)
      {

        Coregistration(id);

        filename = "smoothT1.mha";
        GaussianSmoothing(Superclass::m_preprocessedT1Image[id], Superclass::m_preprocessedT1Image[id], 0.5, filename);

        filename = "smoothT2.mha";
        GaussianSmoothing(Superclass::m_preprocessedT2Image[id], Superclass::m_preprocessedT2Image[id], 0.5, filename);

        filename = "smoothPD.mha";
        GaussianSmoothing(Superclass::m_preprocessedPDImage[id], Superclass::m_preprocessedPDImage[id], 0.5, filename);

        filename = "smoothFL.mha";
        GaussianSmoothing(Superclass::m_preprocessedFLImage[id], Superclass::m_preprocessedFLImage[id], 0.5, filename);


        typedef itk::ImageFileReader< ImageType >  ReaderType;
        typedef itk::ImageFileWriter< ImageType >  WriterType;


        typename ReaderType::Pointer T1reader = ReaderType::New();
        T1reader->SetFileName("smoothT1.mha");
        Superclass::m_preprocessedT1Image[id] = T1reader->GetOutput();
        T1reader->Update();

        typename ReaderType::Pointer T2reader = ReaderType::New();
        T2reader->SetFileName("smoothT2.mha");
        Superclass::m_preprocessedT2Image[id] = T2reader->GetOutput();
        T2reader->Update();

        typename ReaderType::Pointer PDreader = ReaderType::New();
        PDreader->SetFileName("smoothPD.mha");
        Superclass::m_preprocessedPDImage[id] = PDreader->GetOutput();
        PDreader->Update();

        typename ReaderType::Pointer FLreader = ReaderType::New();
        FLreader->SetFileName("smoothFL.mha");
        Superclass::m_preprocessedFLImage[id] = FLreader->GetOutput();
        FLreader->Update();


        // for debug
        typename WriterType::Pointer writer = WriterType::New();
        writer->SetFileName( "aftersmooth_T1.mha" );
        writer->SetInput( Superclass::m_preprocessedT1Image[id] );
        writer->Update();

        writer->SetFileName( "aftersmooth_T2.mha" );
        writer->SetInput( Superclass::m_preprocessedT2Image[id] );
        writer->Update();

        writer->SetFileName( "aftersmooth_PD.mha" );
        writer->SetInput( Superclass::m_preprocessedPDImage[id] );
        writer->Update();

        writer->SetFileName( "aftersmooth_FL.mha" );
        writer->SetInput( Superclass::m_preprocessedFLImage[id] );
        writer->Update();


        SkullStripping(id);  // CAUTION!

        MaskTransform(id);

        std::string fl_mask = "T1Mask.mha";
        ThresholdImage(fl_mask, id, 150);


        typename ReaderType::Pointer FLMaskReader = ReaderType::New();
        FLMaskReader->SetFileName("T1Mask.mha");  // TODO: CHECK!
        FLMaskReader->Update();
        typename ImageType::Pointer flmaskimage = ImageType::New();
        flmaskimage = FLMaskReader->GetOutput(); 

        typename ReaderType::Pointer T1Reader = ReaderType::New();
        T1Reader->SetFileName("smoothT1.mha");
        T1Reader->Update();
        typename ImageType::Pointer t1image = ImageType::New();
        t1image = T1Reader->GetOutput();

        typename ReaderType::Pointer T2Reader = ReaderType::New();
        T2Reader->SetFileName("smoothT2.mha");
        T2Reader->Update();
        typename ImageType::Pointer t2image = ImageType::New();
        t2image = T2Reader->GetOutput();

        typename ReaderType::Pointer PDReader = ReaderType::New();
        PDReader->SetFileName("smoothPD.mha");
        PDReader->Update();
        typename ImageType::Pointer pdimage = ImageType::New();
        pdimage = PDReader->GetOutput();

        typename ReaderType::Pointer FLReader = ReaderType::New();
        FLReader->SetFileName("smoothFL.mha");
        FLReader->Update();
        typename ImageType::Pointer flimage = ImageType::New();
        flimage = FLReader->GetOutput();


        std::string t1brainfilename = "T1.mask.brain.mha";
        std::string t2brainfilename = "T2.mask.brain.mha";
        std::string pdbrainfilename = "PD.mask.brain.mha";
        std::string flbrainfilename = "FL.mask.brain.mha";


        MaskOutImage(t1image, flmaskimage, t1brainfilename);
        MaskOutImage(t2image, flmaskimage, t2brainfilename);
        MaskOutImage(pdimage, flmaskimage, pdbrainfilename);
        MaskOutImage(flimage, flmaskimage, flbrainfilename);


        GetProbabilityMap(id);

        InhomogeneityCorrection(id);

        HistogramMatching();

        //RemoveEyeTissue(id); // CAUTION !!! for testing AutomaticSegmentation

      }

    cout << "Preprocessing for test image is finished." << endl;

  }


  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::SetT1Image (ImageVectorType T1Image)
  {
    cout << "WMLPreprocessor::SetT1Image" << endl;
    Superclass::m_T1Image = T1Image;
  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::SetT2Image (ImageVectorType T2Image)
  {
    cout << "WMLPreprocessor::SetT2Image" << endl;
    Superclass::m_T2Image = T2Image;
  }

  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::SetPDImage (ImageVectorType PDImage)
  {
    cout << "WMLPreprocessor::SetPDImage" << endl;
    Superclass::m_PDImage = PDImage;
  }


  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::SetFLImage (ImageVectorType FLImage)
  {
    cout << "WMLPreprocessor::SetFLImage" << endl;
    Superclass::m_FLImage = FLImage;
  }

  //0318
  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::SetFLThresholdImage (ImageVectorType FLThresholdImage)
  {
    cout << "WMLPreprocessor::SetFLThresholdImage" << endl;
    Superclass::m_FLThresholdImage = FLThresholdImage;
  }


  template <class TInputImage, class TOutputImage>
  void
  WMLPreprocessor<TInputImage, TOutputImage>
  ::SetNumImages(int numimg)
  {
    cout << "WMLPreprocessor::SetNumImages" << endl;

    m_NumImages = numimg;
  }

}  // namespace itk

#endif
