#ifndef __itkWMLProcessorBase_h
#define __itkWMLProcessorBase_h

#include <itkImage.h>
#include <itkImageToImageFilter.h>

#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIterator.h"

#include <itkOrientedImage.h>

namespace itk {

  template<class TInputImage, class TOutputImage>
    class ITK_EXPORT WMLProcessorBase : public ImageToImageFilter<TInputImage, TOutputImage>
    {
    public:
      
      typedef WMLProcessorBase Self;
      typedef ImageToImageFilter<TInputImage, TOutputImage> Superclass;
      typedef SmartPointer<Self>                        Pointer;
      typedef SmartPointer<const Self>                  ConstPointer;
      
      typedef itk::OrientedImage<float, 3> FloatImageType;
      typedef FloatImageType::Pointer FloatImagePointerType;
      
      // MJ_TEMP
      typedef TInputImage ImageType;
      // typedef itk::OrientedImage<short, 3> ImageType;
      typedef typename ImageType::Pointer ImagePointerType;
      
      
      /** Method for creation through the object factory. */
      itkNewMacro(Self);
      
      /** Run-time type information (and related methods). */
      itkTypeMacro(WMLProcessorBase, ImageToImageFilter);
      
      typedef std::vector<ImagePointerType> ImageVectorType;
      
      ImageVectorType m_T1Image;
      ImageVectorType m_T2Image;
      ImageVectorType m_PDImage;
      ImageVectorType m_FLImage;
      
      ImageVectorType m_preprocessedT1Image;
      ImageVectorType m_preprocessedT2Image;
      ImageVectorType m_preprocessedPDImage;
      ImageVectorType m_preprocessedFLImage; 
      
      ImagePointerType m_currentT1Image;
      ImagePointerType m_currentT2Image;
      ImagePointerType m_currentPDImage;
      ImagePointerType m_currentFLImage;
      
      ImagePointerType  m_T1Mask;
      
      ImagePointerType EyeRemoveImage;
      
    private:
      WMLProcessorBase(const Self&); //purposely not implemented
      void operator=(const Self&); //purposely not implemented
      
    protected:
      WMLProcessorBase();
      ~WMLProcessorBase();
      void PrintSelf(std::ostream& os, Indent indent) const;
      
    };
  
} // namespace itk

#ifndef ITK_MANUAL_INSTANTIATION
#include "itkWMLProcessorBase.txx"
#endif

#endif
