#ifndef __itkWMLTestingProcessor_txx
#define __itkWMLTestingProcessor_txx

#include "itkWMLTestingProcessor.h"



using namespace std;




namespace itk
{
namespace Statistics
{

template <class TInputImage, class TOutputImage>
WMLTestingProcessor<TInputImage, TOutputImage>
::WMLTestingProcessor()
{
}

template <class TInputImage, class TOutputImage>
WMLTestingProcessor<TInputImage, TOutputImage>
::~WMLTestingProcessor()
{
}

template <class TInputImage, class TOutputImage>
void
WMLTestingProcessor<TInputImage, TOutputImage>
::PrintSelf(std::ostream& os, Indent indent) const
{
   Superclass::PrintSelf( os, indent );
}


template <class TInputImage, class TOutputImage>
void
WMLTestingProcessor<TInputImage, TOutputImage>
::Update()
{
   cout << "WMLTestingProcessor::Update()" << endl;

  int test_index;

  ImagePointerType outimg;

  std::string svmmdlname =  "itktest.mdl";
  std::string svmoutputname = "test.result";
  std::string svmtestfilename = "test.example";


   test_index = WMLTestSingleImageKeepAllFunctionValue_NoSmooth(Superclass::m_currentT1Image, Superclass::m_currentT2Image, Superclass::m_currentPDImage, Superclass::m_currentFLImage, outimg, svmtestfilename, svmoutputname, svmmdlname );


}


template <class TInputImage, class TOutputImage>
int
WMLTestingProcessor<TInputImage, TOutputImage>
::WMLTestSingleImageKeepAllFunctionValue_NoSmooth(ImagePointerType T1Image, ImagePointerType T2Image, ImagePointerType PDImage, ImagePointerType FLImage, ImagePointerType outimg, std::string& testfilename, std::string& svmtestoutfile, std::string& svmfilename)
{
  cout << " WMLTestingProcessor::WMLTestSingleImageKeepAllFunctionValue_NoSmooth" << endl;



}



template <class TInputImage, class TOutputImage>
void
WMLTestingProcessor<TInputImage, TOutputImage>
::SetT1Image (ImagePointerType T1Image)
{
  cout << "WMLTestingProcessor::SetT1Image" << endl;

   // memory alloc
  Superclass::m_currentT1Image = ImageType::New();

  ImageType::IndexType start;
  start[0] = 0; start[1] = 0; start[2] = 0;

  ImageType::SizeType size;
  size = T1Image->GetBufferedRegion().GetSize();

  ImageType::RegionType region;
  region.SetSize(size);
  region.SetIndex(start);

  Superclass::m_currentT1Image->SetRegions(region);
  Superclass::m_currentT1Image->SetOrigin(T1Image->GetOrigin());
  Superclass::m_currentT1Image->SetSpacing(T1Image->GetSpacing());
  Superclass::m_currentT1Image->Allocate();
  Superclass::m_currentT1Image->FillBuffer(0);

  Superclass::m_currentT1Image = T1Image;
}

template <class TInputImage, class TOutputImage>
void
WMLTestingProcessor<TInputImage, TOutputImage>
::SetT2Image (ImagePointerType T2Image)
{
  cout << "WMLTestingProcessor::SetT2Image" << endl;

   // memory alloc
  Superclass::m_currentT2Image = ImageType::New();

  ImageType::IndexType start;
  start[0] = 0; start[1] = 0; start[2] = 0;

  ImageType::SizeType size;
  size = T2Image->GetBufferedRegion().GetSize();

  ImageType::RegionType region;
  region.SetSize(size);
  region.SetIndex(start);

  Superclass::m_currentT2Image->SetRegions(region);
  Superclass::m_currentT2Image->Allocate();
  Superclass::m_currentT2Image->FillBuffer(0);

  Superclass::m_currentT2Image = T2Image;
}

template <class TInputImage, class TOutputImage>
void
WMLTestingProcessor<TInputImage, TOutputImage>
::SetPDImage (ImagePointerType PDImage)
{
  cout << "WMLTestingProcessor::SetPDImage" << endl;

   // memory alloc
  Superclass::m_currentPDImage = ImageType::New();

  ImageType::IndexType start;
  start[0] = 0; start[1] = 0; start[2] = 0;

  ImageType::SizeType size;
  size = PDImage->GetBufferedRegion().GetSize();

  ImageType::RegionType region;
  region.SetSize(size);
  region.SetIndex(start);

  Superclass::m_currentPDImage->SetRegions(region);
  Superclass::m_currentPDImage->Allocate();
  Superclass::m_currentPDImage->FillBuffer(0);

  Superclass::m_currentPDImage = PDImage;
}

template <class TInputImage, class TOutputImage>
void
WMLTestingProcessor<TInputImage, TOutputImage>
::SetFLImage (ImagePointerType FLImage)
{
  cout << "WMLTestingProcessor::SetFLImage" << endl;

   // memory alloc
  Superclass::m_currentFLImage = ImageType::New();

  ImageType::IndexType start;
  start[0] = 0; start[1] = 0; start[2] = 0;

  ImageType::SizeType size;
  size = FLImage->GetBufferedRegion().GetSize();

  ImageType::RegionType region;
  region.SetSize(size);
  region.SetIndex(start);

  Superclass::m_currentFLImage->SetRegions(region);
  Superclass::m_currentFLImage->Allocate();
  Superclass::m_currentFLImage->FillBuffer(0);

  Superclass::m_currentFLImage = FLImage;

}

template <class TInputImage, class TOutputImage>
void
WMLTestingProcessor<TInputImage, TOutputImage>
::SetNumImages(int numimg)
{
  cout << "WMLTestingProcessor::SetNumImages" << endl;

  m_NumImages = numimg;
}


} // namespace Statistics
}  // namespace itk

#endif
