#include <cstdlib>
#include <cstdio>
#include <math.h>
#include <string>
#include <vector>

#include "itkFixedArray.h"
#include "itkMatrix.h"
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkShrinkImageFilter.h"

#include "itkVector.h"
#include "itkWMLGetSelectedFeature.h"

#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkRescaleIntensityImageFilter.h"
#include "itkOutputWindow.h"
#include "itkTextOutput.h"
#include "itkImageDuplicator.h"

#include <iostream>
#include <sstream>
#include <vector>
#include <string>

//#include <math.h>
#include <stdlib.h>

#include <list>
#include <fstream>
#include <algorithm>

#include "wmlstrainCLP.h"

#include "itkOrientedImage.h"
#include "itkOrientImageFilter.h"

#ifdef MJ_DEBUG
#include "itkWMLPreprocessor.h"
#endif // MJ_DEBUG
using namespace std;

typedef std::list<std::string>     FilenameList;
std::vector<std::string>           SubjectNames;
std::vector<std::string>           ImageNames;

std::string			   DirConnect = "/";

void strtrim(string& str)
{
  string::size_type pos = str.find_last_not_of(' ');
  if(pos != string::npos)
  {
    str.erase(pos + 1);
    pos = str.find_first_not_of(' ');
    if(pos != string::npos)
    {
      str.erase(0, pos);
    }
  }
  else str.erase(str.begin(), str.end());
}

template <class T> int DoIt( int argc, char *argv[] )
{

  PARSE_ARGS;

  cout << "DoIt()" << endl;

  typedef T PixelType;
  typedef T WritePixelType;

  typedef itk::OrientedImage<PixelType, 3> ImageType;

  unsigned int numSubjects = SubjectNames.size();

  typedef itk::VariableLengthVector<PixelType>       MeasurementVectorType;
 
  typedef itk::WMLGetSelectedFeature <ImageType, MeasurementVectorType> WMLGetSelectedFeatureType;
  typedef typename WMLGetSelectedFeatureType::ImageVectorType ImageVectorType;

//0322 mjkim
  if (T1Switch==true) printf ("T1 included.\n");
  if (T2Switch==true) printf ("T2 included.\n");
  if (PDSwitch==true) printf ("PD included.\n");
  if (FLSwitch==true) printf ("FL included.\n");


  ImageVectorType T1Images(numSubjects); 
  ImageVectorType T2Images(numSubjects);
  ImageVectorType PDImages(numSubjects);
  ImageVectorType FLImages(numSubjects);
  ImageVectorType MaskImages(numSubjects);
  ImageVectorType MaskOpenImages(numSubjects);
  ImageVectorType PremaskImages(numSubjects);

  cout << "Number of subject: " << numSubjects << endl;
    
  // Set file types
  typedef itk::ImageFileReader<ImageType> ReaderType;
  typename ReaderType::Pointer imgReader = ReaderType::New();

 // std::vector<ShortImageType::Pointer> outputImages;

  for (unsigned int i=0; i<numSubjects; i++) 
  {

    std::cout << "Reading " << SubjectNames[i] <<" ..." << std::endl;

    // Set filenames for multiprotocol MRIs and masks 
    std::string imagefilename;
    // Read images and masks

   if (T1Switch==true) { 
    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[0];
    imgReader->SetFileName(imagefilename.c_str());
    cout << "\tT1 FileName: " << imagefilename << endl;
    imgReader->Update();
    T1Images[i] = imgReader->GetOutput();
    T1Images[i]->DisconnectPipeline();
   }

   if (T2Switch==true) {
    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[1];
    imgReader->SetFileName(imagefilename.c_str());
    cout << "\tT2 FileName: " << imagefilename << endl;
    imgReader->Update();
    T2Images[i] = imgReader->GetOutput();
    T2Images[i]->DisconnectPipeline();
   }

   if (PDSwitch==true) {
    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[2];
    imgReader->SetFileName(imagefilename.c_str());
    cout << "\tPD FileName: " << imagefilename << endl;
    imgReader->Update();
    PDImages[i] = imgReader->GetOutput();
    PDImages[i]->DisconnectPipeline();
   }

   if (FLSwitch==true) {
    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[3];
    imgReader->SetFileName(imagefilename.c_str());
    cout << "\tFL FileName: " << imagefilename << endl;
    imgReader->Update();
    FLImages[i] = imgReader->GetOutput();
    FLImages[i]->DisconnectPipeline();
   }

    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[4];
    imgReader->SetFileName(imagefilename.c_str());
    cout << "\tMask FileName: " << imagefilename << endl;
    imgReader->Update();
    MaskImages[i] = imgReader->GetOutput();
    MaskImages[i]->DisconnectPipeline();

    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[5];
    imgReader->SetFileName(imagefilename.c_str());
    cout << "\tMask open FileName: " << imagefilename << endl;
    imgReader->Update();
    MaskOpenImages[i] = imgReader->GetOutput();
    MaskOpenImages[i]->DisconnectPipeline();

    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[6];
    imgReader->SetFileName(imagefilename.c_str());
    cout << "\tPreMask FileName: " << imagefilename << endl;
    imgReader->Update();
    PremaskImages[i] = imgReader->GetOutput();
    PremaskImages[i]->DisconnectPipeline();
  } // for: all images

#ifdef NEED_PREPRO
  typedef itk::Statistics::WMLPreprocessor<ImageType, ImageType> WMLPreprocessorType;
  typename WMLPreprocessorType::Pointer preprocessor = WMLPreprocessorType::New();

  preprocessor->SetNumImages(numImages);
  if (T1Switch==true) preprocessor->SetT1Image(T1Images);
  if (T2Switch==true) preprocessor->SetT2Image(T2Images);
  if (PDSwitch==true) preprocessor->SetPDImage(PDImages);
  if (FLSwitch==true) preprocessor->SetFLImage(FLImages);

  preprocessor->preprocessing();
#endif

// MJ
 if (PreprocessingSwitch==true) std::cout << "Preprocessing applied" << endl;
 else std::cout << "Preprocessing skipped" << endl;


  typename WMLGetSelectedFeatureType::Pointer feature_selector = WMLGetSelectedFeatureType::New();

  feature_selector->SetNumImages(numSubjects);
  feature_selector->SetRadius(1);

  if (T1Switch==true) feature_selector->SetT1Image(T1Images);
  if (T2Switch==true) feature_selector->SetT2Image(T2Images);
  if (PDSwitch==true) feature_selector->SetPDImage(PDImages);
  if (FLSwitch==true) feature_selector->SetFLImage(FLImages);
  feature_selector->SetMaskImage(MaskImages);
  feature_selector->SetMaskOpenImage(MaskOpenImages);
  feature_selector->SetPremaskImage(PremaskImages);

  feature_selector->Update();
  feature_selector->RefinedClassifier();  // temp

  return EXIT_SUCCESS;

}

int main(int argc,char *argv[])
  
{

  PARSE_ARGS;


  std::string buffer;
  // Read file prefixes 
  std::fstream pFile;

// MJ_TEMP
  cout << " subject list: " << SubjectList.c_str() << endl;

  pFile.open (SubjectList.c_str());
  if (pFile == NULL) 
  {
    perror ("Error opening file");
  }
  else
  {
    while ( !pFile.eof() )
    {
      getline (pFile, buffer,'\n');
      strtrim( buffer );
      if (buffer.size() > 0)
      {
        SubjectNames.push_back(buffer);
      }
    }
  }
  pFile.close();

  //echo
  std::cout << "Number of training subjects: " << SubjectNames.size() << std::endl;
  for (unsigned int k = 0; k < SubjectNames.size(); k ++)
  {
    std::cout << SubjectNames[k] << std::endl;
  }
  
  // Read file suffix

  std::cout << SuffixList << std::endl;
  std::fstream sFile;
  sFile.open ( SuffixList.c_str() );
  if (sFile == NULL) 
  {
    perror ("Error opening file");
  }
  else
  {
    while ( ! sFile.eof() )
    {
      getline (sFile, buffer,'\n');
      strtrim( buffer );
      if (buffer.size() > 0)
      {
        ImageNames.push_back(buffer);
      }
    }
  }
  sFile.close();

  //echo
  std::cout << "Number of training subjects: " << ImageNames.size() << std::endl;
  for (unsigned int k = 0; k < ImageNames.size(); k ++)
  {
    std::cout << ImageNames[k] << std::endl;
  }
  
	return DoIt<unsigned short>( argc, argv );
  return EXIT_SUCCESS;



}
