#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <mvcd.h>
#include <mvvt.h>
#include <unistd.h>

#define LEFTBUTTONMASK        1
#define MIDDLEBUTTONMASK      2
#define RIGHTBUTTONMASK       4
#define LORES                 0
#define HIRES                 1

/***** Marc Vaillant's Visualization Toolkit (libmvvt) *****/

static Widget glx_area,form,frame;
static Display *dpy;
static XtAppContext app;
static Fvector3d **v2d[100],**n2d[100],*v1d[100],*n1d[100],center;
static float **c2d[100],*c1d[100],*c1dred[100],*c1dgreen[100],*c1dblue[100];
static float xyzmax,xorigin,yorigin,zoom=1.0;
static int **f2d[100][2],N2d[100],M2d[100],NF1d[100][2],xargc;
static int drawnum=0,qcount=0,tcount=0,totcount[100];
static char **xargv;
static void (*drawfn[200])(int,int);
static void (*initfn)(int,char*[]);
static void drawQuads(int,int);
static void drawTriags(int,int);
static void expose(Widget,XtPointer,XtPointer);
static void input(Widget,XtPointer,XtPointer);
static GLboolean reset_FLAG=TRUE;
static GLboolean mesh_FLAG=FALSE;
static GLboolean firstRend_FLAG=TRUE;
static GLboolean viewportUpdateNeeded=TRUE;
static GLfloat rotatematrix[16];
static String translations=
    "<Btn1Motion>: DrawingAreaInput() ManagerGadgetButtonMotion() \n\
     <Btn1Down>:   DrawingAreaInput() ManagerGadgetArm() \n\
     <Btn1Up>:     DrawingAreaInput() ManagerGadgetArm() \n\
     <Btn2Down>:   DrawingAreaInput() ManagerGadgetArm() \n\
     <Btn2Up>:     DrawingAreaInput() ManagerGadgetArm() \n\
     <Btn2Motion>: DrawingAreaInput() ManagerGadgetButtonMotion() \n\
     <Btn3Down>:   DrawingAreaInput() ManagerGadgetArm() \n\
     <Btn3Up>:     DrawingAreaInput() ManagerGadgetArm() \n\
     <Btn3Motion>: DrawingAreaInput() ManagerGadgetButtonMotion() \n\
     <KeyDown>:    DrawingAreaInput() \n\
     <KeyUp>:      DrawingAreaInput() ";


static void expose(Widget w,XtPointer clientdata,XtPointer calldata)
{
  static int first=1;

  reset_FLAG=FALSE;
  draw(HIRES);
  reset_FLAG=TRUE;
  if(first==1)
    {
      (*initfn)(xargc,xargv);
      first=0;
    }
}

static void resize(Widget w,XtPointer clientdata,XtPointer calldata)
{
  XmDrawingAreaCallbackStruct *cbs=(XmDrawingAreaCallbackStruct *) calldata;

  if(XtIsRealized(w)) 
    updateViewport();
  else
    viewportUpdateNeeded=GL_TRUE;
}

static void input(Widget w,XtPointer clientdata,XtPointer calldata)
{
  XmDrawingAreaCallbackStruct *cbs=(XmDrawingAreaCallbackStruct *) calldata;
  XEvent *event=cbs->event;
  KeySym keysym;
  int rc,x_dist,y_dist,z_dist;
  char buffer[1];
  static unsigned char button_status=0;
  static float startx,starty,endx,endy;
  float phi;

  if(event->type==KeyRelease)
    {
      rc=XLookupString((XKeyEvent *) event,buffer,1,&keysym,NULL);
      switch(keysym)
        {
	case XK_m: case XK_M:
	  mesh_FLAG=!mesh_FLAG;
	  reset_FLAG=FALSE;
	  draw(HIRES);
	  reset_FLAG=TRUE;
	  break;
	case XK_Escape:
	  exit(1);
	  break;
        case XK_q: case XK_Q:
          exit(1);
          break;
        }
    }
  else if(event->xbutton.type==ButtonPress&&(button_status==0||button_status==2))
    {
      button_status=button_status|(1<<(event->xbutton.button-1));
      startx=(float) (event->xbutton.x);
      starty=(float) (event->xbutton.y);
    }
  else if(event->xbutton.type==ButtonRelease)
    {
      if(!(button_status^(1<<(event->xbutton.button-1)))&&(button_status!=1))
	{
	  reset_FLAG=FALSE;
	  draw(HIRES);
	  reset_FLAG=TRUE;
	}
      button_status=button_status&(~(1<<(event->xbutton.button-1)));
    }
  else if(event->xbutton.type==MotionNotify)
    if(button_status&MIDDLEBUTTONMASK)
      if(button_status&(LEFTBUTTONMASK|RIGHTBUTTONMASK))
	{
	  endx=(float) (event->xbutton.x);
	  endy=(float) (event->xbutton.y);      
	  x_dist=startx-xorigin;
	  y_dist=starty-yorigin;
	  phi=atan2(x_dist,y_dist);
	  x_dist=endx-xorigin;
	  y_dist=endy-yorigin;
	  phi=atan2(x_dist,y_dist)-phi;
	  if(phi>2*M_PI) 
	    phi+=2*M_PI;
	  z_dist=phi*180.0/M_PI;

	  glPushMatrix();
	  glRotatef(z_dist,0.0,0.0,1.0);

	  glMultMatrixf(rotatematrix);	  
	  glGetFloatv(GL_MODELVIEW_MATRIX,rotatematrix);
	  glPopMatrix();

	  reset_FLAG=FALSE;
	  draw(LORES);
	  reset_FLAG=TRUE;

	  startx=(float) (event->xbutton.x);
	  starty=(float) (event->xbutton.y);
	}
      else
	{
	  endx=(float) (event->xbutton.x);
	  endy=(float) (event->xbutton.y);      
	  x_dist=endx-startx;
	  y_dist=endy-starty;
	  
	  glPushMatrix();
	  glRotatef(x_dist,0.0,1.0,0.0);
	  glRotatef(y_dist,1.0,0.0,0.0);
	  
	  glMultMatrixf(rotatematrix);	  
	  glGetFloatv(GL_MODELVIEW_MATRIX,rotatematrix);
	  glPopMatrix();
	  
	  reset_FLAG=FALSE;
	  draw(LORES);
	  reset_FLAG=TRUE;
	  
	  startx=(float) (event->xbutton.x);
	  starty=(float) (event->xbutton.y);
	}
    else if(!(button_status^RIGHTBUTTONMASK))
      {
	endy=(float) (event->xbutton.y);
	y_dist=endy-starty;
	if(y_dist<0)
	  zoom+=0.01*fabs(y_dist);
	else
	  zoom-=0.01*fabs(y_dist);
	if(zoom<0)
	  zoom=0;
	if(zoom>10)
	  zoom=10;
	reset_FLAG=FALSE;
	draw(LORES);
	reset_FLAG=TRUE;
	starty=(float) (event->xbutton.y);
      }
}

void scaleColor2d(float **scaled_c,float **c,int N,int M)
{
  int i,j;
  float max,min;

  max=1e-20;
  min=1e20;

  for(i=0;i<N;i++)
    for(j=0;j<M;j++)
      {
	if(c[i][j]>max) max=c[i][j];
	if(c[i][j]<min) min=c[i][j];
      }
  max-=min;

  for(i=0;i<N;i++)
    for(j=0;j<M;j++)
      {
	c[i][j]-=min;
	fflush(stdout);
	if(max!=0)
	  scaled_c[i][j]=1.0-(1.0/max)*c[i][j];
	else
	  scaled_c[i][j]=1.0;
      }

}

void scaleColor1d(float *scaled_c,float *c,int N)
{
  int i;
  float max,min;

  max=1e-20;
  min=1e20;

  for(i=0;i<N;i++)
    {
      if(c[i]>max) max=c[i];
      if(c[i]<min) min=c[i];
    }
  max-=min;

  for(i=0;i<N;i++)
    {
      c[i]-=min;
      fflush(stdout);
      if(max!=0)
	scaled_c[i]=1.0-(1.0/max)*c[i];
      else
	scaled_c[i]=1.0;
    }

}

void setCenter(float tmp_center_x,float tmp_center_y,float tmp_center_z)
{
  center.x=tmp_center_x;
  center.y=tmp_center_y;
  center.z=tmp_center_z;

  glPushMatrix();
  glMultMatrixf(rotatematrix);	  
  glTranslatef(-center.x,-center.y,-center.z);
  glGetFloatv(GL_MODELVIEW_MATRIX,rotatematrix);
  glPopMatrix();
}

void incrementRot(float incr_x,float incr_y, float incr_z)
{
  glPushMatrix();
  incr_x=fmodf(incr_x,360);
  incr_y=fmodf(incr_y,360);
  incr_z=fmodf(incr_z,360);
  glRotatef(incr_x,0.0,1.0,0.0);
  glRotatef(incr_y,1.0,0.0,0.0);
  glRotatef(incr_z,0.0,0.0,1.0);
  glMultMatrixf(rotatematrix);
  glGetFloatv(GL_MODELVIEW_MATRIX,rotatematrix);
  glPopMatrix();
}  

void beginDraw()
{
  if(reset_FLAG)
    drawnum=0;

  if(viewportUpdateNeeded) 
    updateViewport();

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glPushMatrix();
  rotate();
}

void draw(int res)
{
  int i;

  beginDraw();
  if(mesh_FLAG)
    glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
  else
    glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
  if(drawnum>0)
    {
      for(i=0;i<drawnum;i++)
	(*drawfn[i])(totcount[i],res);
    }
  endDraw();
}

void rotate()
{
  glScalef(zoom,zoom,zoom);
  glMultMatrixf(rotatematrix);	  
}

void endDraw()
{
  glPopMatrix();
  glFlush();
  glXSwapBuffers(dpy,XtWindow(glx_area));
}  

void beginDrawContinue()
{
  glDrawBuffer(GL_FRONT_AND_BACK);
  glDisable(GL_DEPTH_TEST);
}

void endDrawContinue()
{
  glDrawBuffer(GL_BACK);
  glEnable(GL_DEPTH_TEST);
}

void drawQuads(int count,int dummy)
{
  int i,j,k;
  
  for(i=0;i<(N2d[count]-1);i++)
    {
      glBegin(GL_QUAD_STRIP);
      for(j=0;j<M2d[count];j++)
	for(k=0;k<2;k++)
	  {
	    glColor3f(c2d[count][i][j],c2d[count][i][j],1.0);
	    glNormal3f(n2d[count][i+k][j].x,n2d[count][i+k][j].y,n2d[count][i+k][j].z);
	    glVertex3f(v2d[count][i+k][j].x,v2d[count][i+k][j].y,v2d[count][i+k][j].z);
	  }
      glEnd();
    }
}  

void drawTriags(int count,int res)
{
  int i,j;

  for(i=0;i<NF1d[count][res];i++)
    {
      glBegin(GL_TRIANGLES);
      for(j=0;j<3;j++)
	{
	  glColor3f(c1dred[count][f2d[count][res][i][j]],c1dgreen[count][f2d[count][res][i][j]],c1dblue[count][f2d[count][res][i][j]]);
	  glNormal3f(-n1d[count][f2d[count][res][i][j]].x,-n1d[count][f2d[count][res][i][j]].y,-n1d[count][f2d[count][res][i][j]].z);
	  glVertex3f(v1d[count][f2d[count][res][i][j]].x,v1d[count][f2d[count][res][i][j]].y,v1d[count][f2d[count][res][i][j]].z);
	}
      glEnd();
    }
}

void drawQuadRegMesh(Fvector3d **v,Fvector3d **n,float **c,int N,int M)
{
  v2d[qcount]=v;
  n2d[qcount]=n;
  c2d[qcount]=c;
  N2d[qcount]=N;
  M2d[qcount]=M;
  drawQuads(qcount,0);
  drawfn[drawnum]=drawQuads;
  totcount[drawnum]=qcount;
  drawnum++;
  qcount++;
}

void drawTriIrregMesh(Fvector3d *v,Fvector3d *n,float *cred,float *cgreen,float *cblue,int **flo,int **fhi,int LO,int HI)
{
  v1d[tcount]=v;
  n1d[tcount]=n;
  c1dred[tcount]=cred;
  c1dgreen[tcount]=cgreen;
  c1dblue[tcount]=cblue;
  f2d[tcount][LORES]=flo;
  f2d[tcount][HIRES]=fhi;
  NF1d[tcount][LORES]=LO;
  NF1d[tcount][HIRES]=HI;
  drawTriags(tcount,HIRES);
  drawfn[drawnum]=drawTriags;
  totcount[drawnum]=tcount;
  drawnum++;
  tcount++;
}

void updateViewport()
{
  Widget w;
  Dimension width,height;

  XtVaGetValues(glx_area, XmNwidth, &width, XmNheight, &height, NULL);
  glViewport(0, 0, (GLint) width, (GLint) height);

  xorigin=width/2.0;
  yorigin=height/2.0;

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  if(width<=height)
    glOrtho(-(xyzmax+20),xyzmax+20,-(xyzmax+20)*height/width,(xyzmax+20)*height/width,-10*xyzmax,10*xyzmax);
  else
    glOrtho(-(xyzmax+20)*width/height,(xyzmax+20)*width/height,-(xyzmax+20),xyzmax+20,-10*xyzmax,10*xyzmax);
  
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  if(firstRend_FLAG)
    {
      glGetFloatv(GL_MODELVIEW_MATRIX,rotatematrix);
      firstRend_FLAG=FALSE;
    }
  viewportUpdateNeeded=GL_FALSE;
}



void xglInit(float bound_max,int wdth,int hght,int argc,char *argv[],void (*tmpfn)(int,char *[]))
{
  GLXContext cx;
  XtWorkProcId testId=0;
  XVisualInfo *vi;
  Widget toplevel;
  Arg args[64];
  int n,ans,dummyargc=0;
  char *dummyargv[100];
  Colormap cmap;
  int dblBuf[]={GLX_RGBA,GLX_DEPTH_SIZE,16,GLX_RED_SIZE,1,GLX_BLUE_SIZE,1,GLX_GREEN_SIZE,1,GLX_DOUBLEBUFFER,None};
  GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
  GLfloat mat_specular1[] = { 1.0, 1.0, 1.0, 0.0 };
  GLfloat light_specular[] = { 0.0, 0.0, 0.0, 0.0 };
  GLfloat mat_shininess[] = { 50.0 };
  GLfloat light_position1[] = { 0, 0, 1.0, 0.0 };
  GLfloat light_position2[] = { 1.0,1.0,1.0,0.0};

  xyzmax=bound_max;
  initfn=tmpfn;
  xargc=argc;
  xargv=argv;
  center.x=center.y=center.z=0.0;

  XtSetLanguageProc(NULL,NULL,NULL);

  toplevel=XtVaAppInitialize(&app,"proj",NULL,0,&dummyargc,dummyargv,NULL,NULL,0);

  dpy=XtDisplay(toplevel);
  vi=glXChooseVisual(dpy,DefaultScreen(dpy),dblBuf);

  cx=glXCreateContext(dpy,vi,None,GL_TRUE);
  cmap=XCreateColormap(dpy,RootWindow(dpy,vi->screen),vi->visual,AllocNone);

  XtVaSetValues(toplevel,
                XtNvisual,vi->visual,
                XtNdepth,vi->depth,
                XtNcolormap,cmap,
                NULL);

  n=0;
  XtSetArg(args[n],XmNwidth,wdth); n++;
  XtSetArg(args[n],XmNheight,hght); n++;
  form=XmCreateForm(toplevel,"form",args,n);
  XtManageChild(form);

  n=0;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  frame=XmCreateFrame(form,"frame",args,n);
  XtManageChild(frame);

  n=0;
  XtSetArg(args[n],XmNtranslations,XtParseTranslationTable (translations));n++;
  glx_area=XmCreateDrawingArea(frame,"glx_area",args,n);
  XtManageChild(glx_area);
  XtAddCallback(glx_area,XmNexposeCallback,expose,NULL);
  XtAddCallback(glx_area,XmNresizeCallback,resize,NULL);
  XtAddCallback(glx_area,XmNinputCallback,input,NULL);

  XtRealizeWidget(toplevel);

  glXMakeCurrent(dpy,XtWindow(glx_area),cx);

  glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
  glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, mat_shininess);
  glLightfv(GL_LIGHT0, GL_POSITION, light_position1);
  glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);       
  /*  glLightModeli(GL_LIGHT_MODEL_TWO_SIDE,GL_TRUE);*/
  glLightModeli(GL_LIGHT_MODEL_TWO_SIDE,GL_FALSE);
  glEnable(GL_COLOR_MATERIAL);
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glDepthFunc(GL_LESS);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_NORMALIZE);

  XtAppMainLoop(app);
}


/* by SHEN */
void VerifyDisplayNumbers()
{
  if(drawnum>=100)  drawnum=0 ;
  if(qcount>=100)   qcount=0 ;
  if(tcount>=100)   tcount=0 ;
}
