#!/usr/bin/perl

#************************************************
# This program compares two lists to see whether*
# each element in list1 is in list2             *
#                                              *
# By: Zhiqiang Lao                             *
#                                              *
# This code is copyrighted and has             *
# limited warranties.                          *
#***********************************************
$argc = @ARGV;
&show_usage if ($argc < 1);

@sub_list1=();
open LIST1, "$ARGV[0]";
$count1 = 0;
while($tmp=<LIST1>) {
    chop($tmp);
    $sub_list1[$count1] = $tmp;
    $count1 = $count1 + 1;
}
close LIST1;
$len1 = $#sub_list1 + 1;

@sub_list2=();

$sub_list1_len = $#sub_list1 + 1;
$count2=0;
open MERGED_LIST, ">$ARGV[1]";
for ($i=0; $i<$sub_list1_len; $i++) {
  $cur_sub = $sub_list1[$i];
  $status = &IsElementInList($cur_sub, *sub_list2);
  if ($status == 0) {
    $sub_list2[$count2] = $sub_list1[$i];
    $count2++;
    print MERGED_LIST "$sub_list1[$i]\n";
  }
}
close MERGED_LIST;

# **********************************************************************************
# call format: IsElementInList($ele, *list)
# **********************************************************************************
sub IsElementInList
  {
    $ele = $_[0];
    (*lst) = $_[1];
    
    $lst_len = $#lst + 1;
    for (local($i)=0; $i<$lst_len; $i++)
      {
	if (index($lst[$i], $ele) != -1) {
	  return 1;
	}
      }
    
    return 0;
  }

# ****************************************************
# calling format: print_list(*list);
# ****************************************************
sub print_list
{
   local(*list) = $_[0];

   local($count) = 0;
   while ($count <= $#list)
   {
      print "$list[$count] ";
      $count = $count + 1;
   }
   print "\n";
}


# **********************************************************************************
# call format: my_get_string($option, *argument_list)
# **********************************************************************************
sub my_get_string
  {
    $option = $_[0];
    (*arg_list) = $_[1];
    
    local($count) = 0;
    while ($count < ($#arg_list + 1))
      {
	if (index($arg_list[$count], $option) != -1)
	  {
	    print "current path: $arg_list[$count]\n";
	    return (substr($arg_list[$count], 2));
	  }
	$count = $count + 1;
      }
  }

#********************************************************
# calling format:                                       *
#    is_subject_in_certain_directory_available($sub, $year)       *
#********************************************************
sub is_subject_in_certain_directory_available
  {
    local($sub)  = @_[0];
    local($year) = @_[1];
    $cur_sub = "$sub" . "0$year";
    $cur_dir = "/sbia/comp_space/zqlao_blsa/year" . "$year/";
    opendir(CURRENT_DIR, $cur_dir);
    while ($file = readdir(CURRENT_DIR))
      {
	if (index($cur_sub, $file) != -1)
	  {
	    closedir(CURRENT_DIR);
	    return 1;
	  }
      }

    closedir(CURRENT_DIR);
    return 0;
  }

sub show_usage
  {
   print "******************************************************************\n";
   print "* This program removes each element in list 2 from list 1        *\n";
   print "*                                                                *\n";
   print "* By: Zhiqiang Lao                                               *\n";
   print "*                                                                *\n";
   print "* This code is copyrighted and has limited warranties.           *\n";
   print "******************************************************************\n";
   print "\n\nUsage: $0 list_with_duplicate_element list_without_duplicate_element[options]\n\n";
   exit(1);
 }
