#!/usr/bin/perl

########################################################################################################################
#                                                                                                                      #
#         This is the main file to segment white matter lesion using multispectral MRI (T1, T2, PD, FLAIR)             #
#         last modified: Sep 27, 2007                                                                                  #
#         Author: Zhiqiang Lao                                                                                         #
#         Comments: Zhiqiang.Lao@uphs.upenn.edu                                                                        #
#                                                                                                                      #
########################################################################################################################

$argc = @ARGV;
&show_usage if ( $argc < 1 );

$intensity_model_path = &my_get_string("-m", *ARGV);

$current_dir = `pwd`; chop($current_dir);
$current_dir = "$current_dir/";
print "current dir: $current_dir\n";

############################################################
#              Reading input parameters                    #
############################################################
$sub_path    = &my_get_string_with_default("-s", *ARGV, $current_dir);
$temp_path   = &my_get_string_with_default("-d", *ARGV, "\/tmp\/");
$result_path = &my_get_string_with_default("-o", *ARGV, $current_dir);
$DoPreprocessing = &my_get_string_with_default("-b", *ARGV, "1");


$lesion_threshold = &my_get_string_with_default("-t", *ARGV, "0.0");
print "threshold: $lesion_threshold\n";
$radius           = &my_get_string_with_default("-r", *ARGV, "2");
@default_weight   = (1.0,1.0,1.0,1.0); @weight = ();
@weight           = &my_get_string_list_with_default("-w", *ARGV, *default_weight);
print "weighting: @weight\n";

$t1Img = $ARGV[0]; $t1Img_prefix = substr($t1Img, 0, length($ARGV[0])-4);
$t2Img = $ARGV[1]; $t2Img_prefix = substr($t2Img, 0, length($ARGV[1])-4);
$pdImg = $ARGV[2]; $pdImg_prefix = substr($pdImg, 0, length($ARGV[2])-4);
$flImg = $ARGV[3]; $flImg_prefix = substr($flImg, 0, length($ARGV[3])-4);

print "t1Img: $t1Img\tt1Img_prefix: $t1Img_prefix\n";
print "t2Img: $t2Img\tt2Img_prefix: $t2Img_prefix\n";
print "pdImg: $pdImg\tpdImg_prefix: $pdImg_prefix\n";
print "flImg: $flImg\tflImg_prefix: $flImg_prefix\n";

############################################################
#              create intermediate folder                  #
############################################################
$t1Img_cbq_img = "$t1Img_prefix" . "_cbq.img";
$t1Img_cbq_hdr = "$t1Img_prefix" . "_cbq.hdr";
$temp_sub_folder = int(100000*rand ());
$temp_folder = "$temp_path"; 	# $temp_folder = "$temp_path\/$temp_sub_folder";
mkdir($temp_folder, 0755);
chdir("$temp_folder");

if ($DoPreprocessing) {
	$cmd = "wmlspreprocess.pl $t1Img $t2Img $pdImg $flImg -s$sub_path -m$intensity_model_path ";
	system($cmd) == 0 or die "$cmd failed: $?";
}	
print "\nContinue with the voxel-wised testing\n\n";

print `pwd`;
##########################################################################################################
#                                 Voxel-wised testing                                                    #
##########################################################################################################
#$svm_model = "$package_path" . "/model/ada.mdl";
$svm_model = $ARGV[4];
$cmd = "wmltestsingleimagekeepallfunctionvaluenosmooth $t1Img_prefix.coreg.smooth.brain.correct.match.img $t2Img_prefix.coreg.smooth.brain.correct.match.img $pdImg_prefix.coreg.smooth.brain.correct.match.img $flImg_prefix.coreg.smooth.brain.correct.match.noeye.img $svm_model WML.lesion.mask.img.allvalue -m1  -r$radius -w$weight[0],$weight[1],$weight[2],$weight[3]";
# $cmd = "$cmd  -M$flImg_prefix.lesion.premask.img";	# this was used until 15Jan2008
system($cmd) == 0 or die "$cmd failed: $?";


##########################################################################################################
#            Invert the intensity values in the evaluation image from "Voxel-wised testing"              #
#  lesion=-1 and non-lesion=1 so the small probabilities are for lesion => invert emap to have the large probabilities for lesion
##########################################################################################################
$cmd = "invertimgfloat WML.lesion.mask.img.allvalue WML.lesion.mask.img.allvalue.invert"; system($cmd) == 0 or die "$cmd failed: $?";


##########################################################################################################
#                  Threshold the evaluation image to get binary lesion mask                              #
##########################################################################################################
$cmd = "oneimgop WML.lesion.mask.img.allvalue.invert WML.lesion.mask.img -t$lesion_threshold -m0 -f1"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "\\mv WML.lesion.mask.img $result_path\/$ARGV[5]"; system($cmd) == 0 or die "$cmd failed: $?";

##########################################################################################################
# Delete SVM output to ensure that this won't be loaded in case of SVM failure - Leave the preprocessed data
##########################################################################################################
#$cmd = "\\rm  test.example test.result  WML.lesion.mask.img.allvalue.invert WML.lesion.mask.img.allvalue"; system($cmd) == 0 or die "$cmd failed: $?";

##########################################################################################################
#                   				clean the rest			                         #
##########################################################################################################
print "\n ******** Remove if you want the folder with temporary files: ********\n ******** $temp_folder ********\n\n";
#$cmd = "\\rm tmp* *coreg.img  *coreg.hdr *smooth.img *smooth.hdr *brain.img *brain.hdr *correct.img *correct.hdr  brain.lao.mask.* "; system($cmd) == 0 or warn "$cmd failed: $?";
#$cmd = "\\rm *.byte.coreg.* test.example *.premask.img WML.lesion.mask.img.allvalu* test.result"; system($cmd) == 0 or die "$cmd failed: $?";

chdir($current_dir);
# $cmd = "\\rm -fr $temp_folder"; system($cmd) == 0 or die "$cmd failed: $?";

#############################################################################
#############################################################################
#                  Main program stops here !!!                              #
#############################################################################
#############################################################################



#############################################################################
#############################################################################
#                  Followings are subroutines                               #
#############################################################################
#############################################################################

###############################################################################
# call format: my_get_string_with_default($option, *argument_list, $default)  #
###############################################################################
sub my_get_string_with_default
  {
    $option = $_[0];
    (*arg_list) = $_[1];
    $default = $_[2];

    local($count) = 0;
    while ($count < ($#arg_list + 1))
      {
        if (index($arg_list[$count], $option) != -1)
          {
            print "option: $arg_list[$count]\n";
            return (substr($arg_list[$count], 2));
          }
        $count = $count + 1;
      }
    return $default;
  }


####################################################################################
#  call format: exec_cmd_parallel_limited_cpu(*cmd, $number_process, $number_cpu)  #
####################################################################################
sub exec_cmd_parallel_limited_cpu  {

  my($number_process,$number_cpu);

  (*lcmd)         = $_[0];
  $number_process = $_[1];
  $number_cpu     = $_[2];

  my($number_process_remain);
  $number_process_remain = $number_process % $number_cpu;
  $number_task = ($number_process - $number_process_remain) / $number_cpu;

  my($i,$j);
  @cmd_here = ();
  for ($i=0; $i<$number_task; $i++) {
    for ($j=0; $j<$number_cpu; $j++) {
      $cmd_here[$j] = $lcmd[$i*$number_cpu+$j];
    }
    &exec_cmd_parallel(*cmd_here, $number_cpu);
  }

  if ($number_process_remain != 0) {
    for ($j=0; $j<$number_process_remain; $j++) {
      $cmd_here[$j] = $lcmd[$number_process-$number_process_remain+$j];
    }
    &exec_cmd_parallel(*cmd_here, $number_process_remain);
  }
}


####################################################################################
#           call format: exec_cmd_parallel(*cmd, $number_process)                  #
####################################################################################
sub exec_cmd_parallel
  {
    my($number_process);
    (*llcmd) = $_[0];
    ($number_process) = $_[1];
#    print "number of process: $number_process\n";

    for ($t=0; $t<1; $t++) {
      print "$llcmd[$t]\n";
    }

    my(@lkidpid,$p);
    @lkidpid = ();
    for ($p=0; $p<$number_process; $p++) {
      if (!defined($lkidpid[$p] = fork())) {
	die "cannot fork: $!";
      } elsif ($lkidpid[$p] == 0) {
	exec("$llcmd[$p]");
	exit;
      }
      sleep 10;
    }

    for ($p=0; $p<$number_process; $p++) {
      waitpid($lkidpid[$p], 0);
    }
  }


####################################################################################
#            call format: my_get_string($option, *argument_list)                   #
####################################################################################
sub my_get_string
  {
    $option = $_[0];
    (*arg_list) = $_[1];

    local($count) = 0;
    while ($count < ($#arg_list + 1))
      {
	if (index($arg_list[$count], $option) != -1)
	  {
	    print "current path: $arg_list[$count]\n";
	    return (substr($arg_list[$count], 2));
	  }
	$count = $count + 1;
      }
  }


####################################################################################
# call format: my_get_string_list_with_default($option, *argument_list, *default)  #
####################################################################################
sub my_get_string_list_with_default
  {
   $option = $_[0];
   (*arg_list) = $_[1];
   (*default) = $_[2];

   local($count) = 0;
   while ($count < ($#arg_list + 1)) 
     {
       if (index($arg_list[$count], $option) != -1)
	 {
	   $tmp_str = substr($arg_list[$count], 2);
	   @lst = split(/,/, substr($arg_list[$count], 2));
	   return (@lst);
	 }
       $count = $count + 1;
     }
   print "count: $count\n";
   return (@default);
 }


####################################################################################
#                  call format: get_file_linenumber(file)                          #
####################################################################################
sub get_file_linenumber
  {
    $file = $_[0];

    open TMP, "$file";
    local($tmp_count) = 0;
    while ($record = <TMP>)
      {
	$tmp_count = $tmp_count + 1;
      }
    close TMP;

    return $tmp_count;
  }


####################################################################################
#                             call format: show_uage                               #
####################################################################################
sub show_usage
{
  print "******************************************************************\n";
  print "*           White Matter Lesion Segmentation Protocol            *\n";
  print "*                                                                *\n";
  print "*          -by Zhiqiang Lao                                      *\n";
  print "*                                                                *\n";
  print "*        Section for Biomedical Image Analysis                   *\n";
  print "*        Department of Radiology, University of Pennsylvania     *\n";
  print "*        3600 Market ST, Suite 380                               *\n";
  print "*        Philadelphia, PA 19104                                  *\n";
  print "*                                                                *\n";
  print "******************************************************************\n";
  print "\n\nUsage: $0 t1_img t2_img pd_img flair_img svm_model  binary_lesion_mask [options]\n\n";
  print "t1_img t2_img pd_img flair_img    : input images (without path); use -s for path\n";
  print "svm_model                         : input svm model  (including path)\n";
  print "binary_lesion_mask                : output lesion segmentation (without path); use -o for path\n";

  print "\nOptions:\n";
  print "-s<string>                        : path to input image (default: .)\n";
  print "-d<string>                        : path to intermediate result (default: /tmp)\n";
  #print "-p<string>                        : path where this package installed\n";
  print "-o<string>                        : path to final result (default: .)\n";
  print "-r<int>              		   : neighbor size (default: 2)\n";
  print "-w<float>,<float>,<float>,<float> : weighting parameter for each modality (default: 1.0,1.0,1.0,1.0)\n";
  print "-t<float>                         : threshold for getting lesion mask (default: 0.0)\n";
  print "-b<int>                           : put 0 if the intermediate results are precalculated; then specify the path (with -d) (default: 1)\n";
  print "-m<string>                        : path for the intensity model if the preprocessing stage needs to be performed.\n";
  print "\n contact: Eva.Zacharaki\@uphs.upenn.edu\n";
  exit(1);
}
