#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <math.h>
#include <strings.h>
#include <mvcd.h>
#include <cres.h>
#include <matrixSHEN.h>  /*by SHEN*/

#define MaxOfUC  255 

void        show_usage(int argc, char **argv);
void        LinearlyInterpolateHistogram(float *histo);
void        smooth_histogram_byMedianFilter(float *histo);
float       medianvalue(float *vec, int len);
void        mysort(float *vec, int len);
void        PrintVector(float *vec, int len);
void        MatchingTwoImages3D(int argc, char *argv[]);
float       vector_distance(float *vec1, float *vec2, int len);
void        vector_transform(float *vec, int len, float s, int t);
void        vector_InverseTransform(float *vec, int len, float s, int t);
float       GetMax(float *vec, int len) ;
void        Vector_Normalization(float *vec, int len) ;

Ivector3d   dimA, dimB;
int         threshold, flair_special;
float       global_scale;



int main(int argc,char *argv[])
{
  int            c, num;
  extern char    *optarg;

  num = 4;
  if(argc < num) show_usage(argc, argv);

  dimA.x = dimA.y = 256; 
  dimB.x = dimB.y = 256; 
  threshold = 0 ;
  global_scale = 2.5;
  flair_special = 0;
  while((c=getopt(argc-3, argv+3,"a:b:t:s:f")) != -1) 
    {
      switch(c) 
	{
	case 'a':
	  sscanf(optarg, "%d,%d", &dimA.x, &dimA.y);
	  break;
	  
	case 'b':
	  sscanf(optarg, "%d,%d", &dimB.x, &dimB.y);
	  break;
	  
	case 't':
	  sscanf(optarg, "%d", &threshold);
	  break;
	  
	case 's':
	  sscanf(optarg, "%f", &global_scale);
	  break;

    case 'f':
      flair_special = 1;
      break;
      
	default:
	  break;
	}
    }
  
  printf("XY dim in img A: (%d, %d)\n", dimA.x, dimA.y);
  printf("XY dim in img B: (%d, %d)\n", dimB.x, dimB.y);
  printf("threshold: %d\n", threshold) ;
  printf("Maximal allowed scale: %f\n", global_scale);
  printf("flair special: %d", flair_special);

  MatchingTwoImages3D(argc, argv);

  return 0;
}


void show_usage(int argc, char **argv)
{
  printf("USAGE: MatchHistogramsOfImgA2ImgB <input.imgA> <input.imgB> <modified.input.imgA>\n\
\t -a <int>,<int>         : XY dimensions of Img A (default: 256,256)\n\
\t -b <int>,<int>         : XY dimensions of Img B (default: 256,256)\n\
\t -t <int>               : threshold, to ignore the intesities less than this; default: 0\n\
\t -s <float>             : Maximal Allowed Scale threshold to zoom histogram; default: 2.5\n\
\t -f                     : FLAIR special\n\
");
  exit(1);
}


void ThresholdFlairHistogram(float *histo)
{
  int                  i, j, count, threshold, new_threshold;
  float                max_num, partial_area, total_area, ratio;
  
/*  printf("enter ThresholdFlairHistogram\n");*/
  histo[0] = 0.0;
  max_num = -100.0;
  for (i=0; i<MaxOfUC+1; i++) {
    if (histo[i]>max_num) {
      max_num = histo[i];
      threshold = i;
    }
  }

/*  printf("threshold in flair: %d\n", threshold);*/
  
  total_area = 0.0;
  for (i=0; i<MaxOfUC+1; i++) total_area += histo[i];
  
  partial_area = histo[threshold];
  ratio = 0.0;
  for (i=0; i<MaxOfUC+1; i++) {
    partial_area += histo[threshold+i] + histo[threshold-i];
    ratio = partial_area / total_area;
/*    printf("delta: %d\tratio: %f\n", i, ratio);*/
    if (ratio > 0.9) break;
  }
  
  new_threshold = threshold - i;
/*  printf("new threshold in flair: %d\n", new_threshold);*/
  for (i=0; i<new_threshold; i++) histo[i] = 0;
}

void MatchingTwoImages3D(int argc, char *argv[])
{
  unsigned char        ***imgA, ***imgB;
  int                  i, j, k, t, shift, temp, histo_threshold;
  float                scale, mindist, s, dist, distA, distB;
  FILE                 *fp, *fpp;
  float                *histoA, *histoB, *histoB_trans, *histoA_trans;


  fp = fopen(argv[1], "r");
  fseek(fp, 0, SEEK_END);
  dimA.z = (ftell(fp))/(dimA.x*dimA.y);
  printf("\n\ndimA: (%d, %d, %d)\n", dimA.x, dimA.y, dimA.z);
  rewind(fp);
  imgA = UCalloc3d(dimA.x, dimA.y, dimA.z);
  for (k=0; k<dimA.z; k++)
    for (i=0; i<dimA.x; i++) fread(imgA[k][i], sizeof(unsigned char), dimA.y, fp);
  fclose(fp);
  printf("%s read ok\n", argv[1]);

  fp = fopen(argv[2], "r");
  fseek(fp, 0, SEEK_END);
  dimB.z = (ftell(fp))/(dimB.x*dimB.y);
  printf("\n\ndimB: (%d, %d, %d)\n", dimB.x, dimB.y, dimB.z);
  rewind(fp);

  imgB = UCalloc3d(dimB.x, dimB.y, dimB.z);
  for (k=0; k<dimB.z; k++)
    for (i=0; i<dimB.x; i++) fread(imgB[k][i], sizeof(unsigned char), dimB.y, fp);
  fclose(fp);
  printf("%s read ok\n", argv[2]);


  /* To ignore background, by thresholding */
  for (k=0; k<dimA.z; k++)
    for (i=0; i<dimA.x; i++) 
      for (j=0; j<dimA.y; j++) 
	if( imgA[k][i][j]<threshold ) imgA[k][i][j]=0 ;
  for (k=0; k<dimB.z; k++)
    for (i=0; i<dimB.x; i++) 
      for (j=0; j<dimB.y; j++) 
	if( imgB[k][i][j]<threshold ) imgB[k][i][j]=0 ;


  /* create histogram */
  histoA = (float *)malloc((MaxOfUC+1)*sizeof(float));
  histoB = (float *)malloc((MaxOfUC+1)*sizeof(float));
  for (i=0; i<(MaxOfUC+1); i++) histoA[i] = histoB[i] = 0;

  for (k=0; k<dimA.z; k++)
    for (i=0; i<dimA.x; i++)
      for (j=0; j<dimA.y; j++) histoA[imgA[k][i][j]] +=1.0;
  if  (flair_special == 1) ThresholdFlairHistogram(histoA);
  for (i=0; i<(MaxOfUC+1); i++) histoA[i] /= (dimA.z*dimA.x*dimA.y) ;

  for (k=0; k<dimB.z; k++)
    for (i=0; i<dimB.x; i++)
      for (j=0; j<dimB.y; j++) histoB[imgB[k][i][j]] +=1.0;
  if  (flair_special == 1) ThresholdFlairHistogram(histoB);
  for (i=0; i<(MaxOfUC+1); i++) histoB[i] /= (dimB.z*dimB.x*dimB.y) ;

  /* to ignore background, and normalize ...  */
  for (i=1; i<(MaxOfUC+1); i++) histoA[i] = histoA[i]/(1.0-histoA[0]) ;
  for (i=1; i<(MaxOfUC+1); i++) histoB[i] = histoB[i]/(1.0-histoB[0]) ;
  histoA[0] = histoB[0] = 0;


  /* interpolate values for those with zeros */
  LinearlyInterpolateHistogram(histoA) ;
  LinearlyInterpolateHistogram(histoB) ;
  /* smooth ... */
  smooth_histogram_byMedianFilter(histoA);
  smooth_histogram_byMedianFilter(histoB);
  /* normalization ... */
  Vector_Normalization(histoA, (MaxOfUC+1)) ;
  Vector_Normalization(histoB, (MaxOfUC+1)) ;

  printf("\n\nhistogram created\n");
  /* PrintVector(histoA, (MaxOfUC+1)); 
     PrintVector(histoB, (MaxOfUC+1)); Aug 25 2003 */


  /* matching imgA to imgB */
  histoB_trans = (float *)malloc((MaxOfUC+1)*sizeof(float));
  histoA_trans = (float *)malloc((MaxOfUC+1)*sizeof(float));
  mindist = 99999999.9;
  for (s=0.4; s<global_scale; s+=0.01)  /* {0.5~1.5 by 0.01} */
    for (t=-150; t<150; t++) 
      {
	/* consitence requirement */
	/* on A space */
	for (i=0; i<(MaxOfUC+1); i++) histoB_trans[i] = histoB[i];
	vector_transform(histoB_trans, (MaxOfUC+1), s, t);	
	 /* fitting, smoothing, normalization */
 	 LinearlyInterpolateHistogram(histoB_trans) ;
	  /*smooth_histogram_byMedianFilter(histoB_trans);*/
	 Vector_Normalization(histoB_trans, (MaxOfUC+1)) ;
     	distA = vector_distance(histoB_trans, histoA, (MaxOfUC+1));

	/* on B space */
	for (i=0; i<(MaxOfUC+1); i++) histoA_trans[i] = histoA[i];
	vector_InverseTransform(histoA_trans, (MaxOfUC+1), s, t);	
	 /* fitting, smoothing, normalization */
 	 LinearlyInterpolateHistogram(histoA_trans) ;
	  /*smooth_histogram_byMedianFilter(histoA_trans);*/
	 Vector_Normalization(histoA_trans, (MaxOfUC+1)) ;
     	distB = vector_distance(histoA_trans, histoB, (MaxOfUC+1));

	/*distA=0;*/

	dist = distA + distB ;

	if (dist < mindist) {
	  mindist = dist;
	  scale = s;
	  shift = t;
	}
      }
  printf("\n\n(scale, shift): (%f, %d)        mindist: %f\n\n\n", scale, shift, mindist);
     /*for (i=0; i<(MaxOfUC+1); i++) histoB_trans[i] = histoB[i];
       vector_transform(histoB_trans, (MaxOfUC+1), scale, shift);
       PrintVector(histoB_trans, (MaxOfUC+1)); 
       dist = vector_distance(histoB_trans, histoA, (MaxOfUC+1));
       printf("dist=%f\n", dist) ; Aug 25 2003 */

  /* transform intensity of imgA */
  for (k=0; k<dimA.z; k++)
    for (i=0; i<dimA.x; i++)
      for (j=0; j<dimA.y; j++) 
	if (imgA[k][i][j] != 0)
	  {
	    temp = (int)((imgA[k][i][j] - shift)*scale + 0.5);
	    if (temp <= 0)   temp = 1; /*0*/
	    if (temp > MaxOfUC) temp = MaxOfUC;
	   
	    imgA[k][i][j] = (unsigned char)temp;	  
	  }
      
  /* save result */
  fp = fopen(argv[3], "w");
  for (k=0; k<dimA.z; k++)
    for (i=0; i<dimA.x; i++) fwrite(imgA[k][i], sizeof(unsigned char), dimA.y, fp);
  fclose(fp);

  free(histoA);
  free(histoB);
  free(histoB_trans);
  free(histoA_trans);
  UCfree3d(imgA, dimA.z, dimA.x);
  UCfree3d(imgB, dimB.z, dimB.x);
}

float vector_distance(float *vec1, float *vec2, int len)
{
  int        i;
  float      dist;

  dist = 0.0;
  for (i=0; i<len; i++) 
    {
      dist += (vec1[i] - vec2[i])*(vec1[i] - vec2[i]); /* overflow*/
      /*      printf("dist=%f  ", dist) ;*/
    } /*printf("\n\n") ;*/
  dist = sqrt(dist);
  
  return dist;
}


void LinearlyInterpolateHistogram(float *histo)
{
  int i, j, size, *tmp;
  float  *histoTmp;
  int Left, Right ;
  float a;


  /* get new values for the positions with value 0*/
  for(i=0; i<(MaxOfUC+1); i++) 
    {
      if( histo[i]==0 )
	{
	  for(Left=i; Left>0; Left--) /* background 0 */
	    if( histo[Left]!=0 ) break ;

	  for(Right=i; Right<(MaxOfUC+1); Right++) 
	    if( histo[Right]!=0 ) break ;

	  /* interpolate ... */
	  if( histo[Left]!=0 && histo[Right]!=0 )
	    {
	      a = (float)Left/(float)(Left+Right) ;
	      histo[i] = (1-a)*histo[Left] + a*histo[Right] ;
	    }
	}
    }
}


void smooth_histogram_byMedianFilter(float *histo)
{
  int        i, j, size ;
  float      *histoTmp, *tmp;

  size = 2;
  tmp = (float *)malloc((2*size+1)*sizeof(float));

  histoTmp = (float *)malloc((MaxOfUC+1)*sizeof(float));
  for (i=0; i<(MaxOfUC+1); i++) histoTmp[i] = histo[i];

  for (i=size; i<(MaxOfUC+1)-size; i++) {

    for (j=-size; j<size+1; j++) tmp[j+size] = histo[i+j];
    histoTmp[i] = medianvalue(tmp, 2*size+1);
  }

  for (i=0; i<(MaxOfUC+1); i++) histo[i] = histoTmp[i];

  free(tmp);
  free(histoTmp);
}

float medianvalue(float *vec, int len)
{
  int        result, i, index;

  mysort(vec, len);

  return vec[(len/2)];
}

void PrintVector(float *vec, int len)
{
  int        i;

  for (i=0; i<len; i++) printf("%f \n", vec[i]);
  printf("\n");
}

void mysort(float *vec, int len)
{
  int    i, j, count ;
  float  *vec1, max;

  for (i=0; i<len; i++) {

    vec1 = (float *)malloc((len-i)*sizeof(float));
    for (j=i; j<len; j++) vec1[j-i] = vec[j];
    max = GetMax(vec1, len-i);
    vec[i] = max;
    count = 1;
    for (j=0; j<len-i; j++)
      if (vec1[j] != max) {
	vec[i+count] = vec1[j];
	count++;
      }
     free(vec1);
  }
}

float GetMax(float *vec, int len)
{
  int    i ;
  float  max;

  max = -999999;
  for (i=0; i<len; i++)
    if (vec[i] > max) max = vec[i];

  return max;
}

void Vector_Normalization(float *vec, int len)
{
  int        i;
  float      total ;
  
  /* normalization ... */
  total = 0 ;
  for (i=0; i<len; i++)  
    total += vec[i] ; 

  for (i=0; i<len; i++)  
    vec[i] = vec[i]/total ;
}

void vector_transform(float *vec, int len, float s, int t)
{
  int        i, j, ind;
  float      *vec1 ;
  int        minV, maxV ;
  float      ProbLeft, ProbRight, total ;

  minV = 10000 ; maxV = -10000 ;
  vec1 = (float *)malloc(len*sizeof(float));
  for (i=0; i<len; i++) vec1[i] = 0;
  for (j=0; j<len; j++) 
    {
      ind = (int)((float)(j-t)*s + 0.5);
      /* used to find whether the transformation is out of domain */
      if( ind<minV )  minV = ind ;
      if( ind>maxV )  maxV = ind ;

      if (ind < 0)       vec1[j] = 0 ;/*= vec[0];*/
      if (ind > (len-1)) vec1[j] = 0 ;/*= vec[len-1];*/
      if ((ind >= 0) && (ind <= (len-1))) vec1[j] = vec[ind];
    }
  
  /* Prob was left in the left side */
  if( minV>0 )
    {
      ProbLeft = 0 ;
      for (i=0; i<minV; i++) ProbLeft += vec[i] ;
    }

  /* Prob was left in the right side */
  if( maxV<MaxOfUC )
    {
      ProbRight = 0 ;
      for (i=maxV; i<MaxOfUC; i++) ProbRight += vec[i] ;
    }

   /* add ...  */
  vec1[0] += ProbLeft ;
  vec1[MaxOfUC] += ProbRight ;


  /* transfer ... */
  for (i=0; i<len; i++) vec[i] = vec1[i];
  free(vec1);
}

void vector_InverseTransform(float *vec, int len, float s, int t)
{
  int        i, j, ind;
  float      *vec1 ;
  int        minV, maxV ;
  float      ProbLeft, ProbRight, total ;

  minV = 10000 ; maxV = -10000 ;
  vec1 = (float *)malloc(len*sizeof(float));
  for (i=0; i<len; i++) vec1[i] = 0;
  for (j=0; j<len; j++) 
    {
      ind = (int)(j/s + t + 0.5);
      /* used to find whether the transformation is out of domain */
      if( ind<minV )  minV = ind ;
      if( ind>maxV )  maxV = ind ;

      if (ind < 0)       vec1[j] = 0 ;/*= vec[0];*/
      if (ind > (len-1)) vec1[j] = 0 ;/*= vec[len-1];*/
      if ((ind >= 0) && (ind <= (len-1))) vec1[j] = vec[ind];
    }

  /* Prob was left in the left side */
  if( minV>0 )
    {
      ProbLeft = 0 ;
      for (i=0; i<minV; i++) ProbLeft += vec[i] ;
    }

  /* Prob was left in the right side */
  if( maxV<MaxOfUC )
    {
      ProbRight = 0 ;
      for (i=maxV; i<MaxOfUC; i++) ProbRight += vec[i] ;
    }

   /* add ...  */
   vec1[0] += ProbLeft ;
   vec1[MaxOfUC] += ProbRight ;


  /* transfer ... */
  for (i=0; i<len; i++) vec[i] = vec1[i];
  free(vec1);
}

