/* RCS Info
   $Author: pham $
   $Date: 1996/04/01 19:36:09 $
   $Log: getopts.c,v $
 * Revision 1.1  1996/04/01  19:36:09  pham
 * Initial revision
 *
**/

#include <pgstd.h>
#include <stdio.h>
#include <string.h>


/* Option arguments variables */
extern int optsind;
extern char optsarg[];

/* This function emulates the operation of the 'getopt' function */
/* found in most standard C libraries on UNIX machines. */
int getopts(int argc,
	    char *const *argv,
	    char *optstring)
{
  int argn;
  int numswitches;
  int *subarg;
  char *switches;
  char theswitch;
  int i,j, dummy;

  /* Count number of different types of switches */
  numswitches = i = 0;
  while (i < strlen(optstring))
    if (optstring[i++] != ':') numswitches += 1;
  /*  printf("numswitches:%d\n",numswitches); /**/

  /* Get switches and check for subarguments */
  switches = (char *)malloc(numswitches*sizeof(char));
  subarg = (int *)malloc(numswitches*sizeof(int));
  i = j = 0;
  while (j < numswitches) {
    switches[j] = optstring[i];
    /*    printf("%d, switches[%d]: %c",i,j,switches[j]); /**/
    if (i < strlen(optstring))
      if (optstring[i+1] == ':') {
	subarg[j++] = PG_TRUE;
	i += 1;
      } 
      else 
	subarg[j++] = PG_FALSE;
    else
      subarg[j++] = PG_FALSE;
    /*    printf(" subarg:%d\n",subarg[j-1]); /**/
    i += 1;
  }

  /* Find next switch */
  argn = optsind;
  /*  printf("optsind:%d\n",optsind); /**/
  while (argv[argn][0] != '-' && argn < (argc-1))
    argn += 1;
  /*  printf("argn:%d\n",argn); /**/
  if (argn >= (argc-1)) {
    /*    optsind = argn; /**/
    free(switches);
    free(subarg);
    return(EOF);
  }
  else {
    optsind = argn + 1;
    /* Make sure it's a valid switch */
    i=0;
    while (argv[argn][1] != switches[i] && i < numswitches)
      i += 1;
    /*    printf("i=%d\n",i); /**/
    if (i >= numswitches) {
      free(switches);
      free(subarg);
      return('?');
    }

    /* Get the subargument if it has one */
    if (subarg[i]) {
      if (strlen(argv[argn]) > 2) /* Case where it's attached to the switch */
	dummy = sscanf(&argv[argn][2],"%s",optsarg);
      else {                      /* Case where it's separated */
	/*	printf("argv:%s\n",argv[argn+1]); /**/
	dummy = sscanf(argv[argn+1],"%s",optsarg); 
	optsind += 1;
      }
    }
    theswitch = switches[i];
    free(switches);
    free(subarg);
    /*    printf("switch %c\n",theswitch); /**/
    return(theswitch);
  }
  
}
