#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <math.h>
#include <strings.h>
#include <mvcd.h>
#include <cres.h>
#include <matrixSHEN.h>  /*by SHEN*/


void show_usage(int argc, char **argv) ;
void NumberoFPoints(int argc, char *argv[], Ivector3d dim, int LabelValue);
int  GetImgZDim(char file[1000], Ivector3d dim);

int main(int argc,char *argv[])
{
  int             c, num, LabelValue;
  extern char     *optarg;
  Ivector3d       dim;

  num=3;
 
  if(argc<num) show_usage(argc, argv) ;

  dim.x = dim.y = 256; dim.z = 124;

  while((c=getopt(argc-2,argv+2,"d:")) != -1)
    {
      switch(c)
	{
	case 'd':
	  sscanf(optarg, "%d,%d", &dim.x, &dim.y);
	  break;
	
	default:
	  break;
	}
    }
  dim.z = GetImgZDim(argv[1], dim);
  printf("image dim: (%d, %d, %d)\n", dim.x, dim.y, dim.z);

  NumberoFPoints(argc, argv, dim, LabelValue);

  return 0;
}

void show_usage(int argc, char **argv)
{
  printf("USAGE: %s <inputed_image> <result_volume> \n\
\t -d <int>,<int>          : image size in x and y dimensions (default:256,256)\n\
", argv[0]);
  exit(1);
}

void NumberoFPoints(int argc, char *argv[], Ivector3d dim, int LabelValue)
{
  unsigned char        ***img;
  int                  i,j,k;
  FILE                 *fp;
  int                  volume;


  fp = fopen(argv[1], "r");
  img = UCalloc3d(dim.x, dim.y, dim.z);
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++) fread(img[k][i], 1, dim.y, fp);
  fclose(fp);

  volume = 0;
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++)
	if (img[k][i][j] != 0) volume++;

  printf("volume = %d\n", volume);

  /* save result */
  fp = fopen(argv[2], "w");
  fprintf(fp, "%d\n", volume);
  fclose(fp);

  /* free */
  UCfree3d(img, dim.z, dim.x) ;
}

int GetImgZDim(char file[1000], Ivector3d dim)
{
  FILE        *fp;

  fp = fopen(file, "r");
  fseek(fp,0,SEEK_END);
  dim.z = (ftell(fp))/(dim.x*dim.y);
  fclose(fp);

  return dim.z;
}
