#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <math.h>
#include <strings.h>
#include <mvcd.h>
#include <cres.h>
#include <matrixSHEN.h>  /*by SHEN*/

void  show_usage(int argc, char **argv);
void  MaskoutImage(int argc, char **argv, Ivector3d dim, int bound[2], int type);
void  MaskoutImage_special(int argc, char **argv, Ivector3d dim, float threshold);
float get_label_overlap_degree(int label, unsigned char ***img, unsigned char ***mask, Ivector3d dim);
int   GetImgZDim(char file[1000], Ivector3d dim);

int main(int argc,char **argv)
{
  Ivector3d        dim;
  int              c, type, bound[2];
  float            threshold;

  dim.x = dim.y = 256;
  dim.z = 124;
  bound[0] = bound[1] = 0;
  type = 0;
  threshold = 0.5;

  if(argc<2) show_usage(argc, argv);
  while((c=getopt(argc-3,argv+3,"d:r:t:T:")) != -1) {
    switch(c) {
    case 'd':
      sscanf(optarg, "%d,%d", &dim.x, &dim.y);
      break;
      
    case 'r':
      sscanf(optarg, "%d,%d", &bound[0], &bound[1]);
      break;
      
    case 't':
      type = atoi(optarg);
      break;

    case 'T':
      threshold = atof(optarg);
      break;
      
    default:
      break;
    }
  }
  
  dim.z = GetImgZDim(argv[1], dim);
  if ((bound[0] == 0) && (bound[1] == 0)) bound[1] = dim.z;
  
  printf("dim: (%d, %d, %d)\n", dim.x, dim.y, dim.z) ;
  printf("slice range: (%d, %d)\n", bound[0], bound[1]);
  printf("type of operation: %d\n", type);
  printf("volume threshold: %f\n", threshold);
  
  if ((type == 0) || (type == 1)) MaskoutImage(argc, argv, dim, bound, type);
  if (type == 2) MaskoutImage_special(argc, argv, dim, threshold);

  return 0;
}


void show_usage(int argc, char **argv)
{
  printf("USAGE: %s <input_img> <mask_img> <output_img> \n\
\t -d <int>,<int>             : image dimension (default: 256,256)\n\
\t -r <int>,<int>             : range of slices(default: whole image)\n\
\t -T <float>                 : threshold for volume overlap between input_img and mask_img (default: 0.5)\n\
\t -t <int>                   : type of operation: (default: 0)\n\
\t                              0: dig out mask region\n\
\t                              1: keep mask region\n\
\t                              2: get rid of overlap part according to volume overlap degree specified by -T\n\
", argv[0]);
  exit(1);
}

void MaskoutImage(int argc, char **argv, Ivector3d dim, int bound[2], int type)
{
  unsigned char ***img, ***mask;
  int   i, j, k, l, m;
  FILE  *fp;

  /***** allocate memory and read image data1 *****/
  fp = fopen(argv[1],"r");
  img = UCalloc3d(dim.x, dim.y, dim.z);
  for(k=0; k<dim.z; k++)
    for(i=0; i<dim.x; i++) fread(img[k][i], 1, dim.y, fp);
  fclose(fp);
  printf("%s read complete \n", argv[1]);

  fp = fopen(argv[2], "r");
  mask = UCalloc3d(dim.x, dim.y, dim.z);
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++) fread(mask[k][i], 1, dim.y, fp);
  fclose(fp);
  printf("%s read complete\n", argv[2]);

  for (k=bound[0]; k<bound[1]; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) {
	if (type ==0) {
	  if (mask[k][i][j] != 0) img[k][i][j] = 0;
	}
	if (type == 1) {
	  if (mask[k][i][j] == 0) img[k][i][j] = 0;
	}
      }
  
  /* saving ... */
  fp = fopen(argv[3],"w"); 
  for(k=0; k<dim.z; k++)
    for(i=0; i<dim.x; i++)
      fwrite(img[k][i],1,dim.y,fp);
  fclose(fp);

  /* free */
  UCfree3d(img, dim.z, dim.x);
  UCfree3d(mask, dim.z, dim.x);
}

void MaskoutImage_special(int argc, char **argv, Ivector3d dim, float threshold)
{
  unsigned char ***img, ***mask;
  int   i, j, k, l, m, histo[256], *label2remove, label2remove_num, *label2keep, label2keep_num;
  float overlap_degree;
  FILE  *fp;

  /***** allocate memory and read image data1 *****/
  fp = fopen(argv[1],"r");
  img = UCalloc3d(dim.x, dim.y, dim.z);
  for(k=0; k<dim.z; k++)
    for(i=0; i<dim.x; i++) fread(img[k][i], 1, dim.y, fp);
  fclose(fp);
  printf("%s read complete \n", argv[1]);

  fp = fopen(argv[2], "r");
  mask = UCalloc3d(dim.x, dim.y, dim.z);
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++) fread(mask[k][i], 1, dim.y, fp);
  fclose(fp);
  printf("%s read complete\n", argv[2]);

  for (i=0; i<256; i++) histo[i] = 0;
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++)
	if (img[k][i][j] != 0) histo[img[k][i][j]]++;

  label2remove = Ialloc1d(256);
  label2remove_num = 0;
  label2keep = Ialloc1d(256);
  label2keep_num = 0;

  for (i=0; i<256; i++)
    if (histo[i] != 0) {
      overlap_degree = get_label_overlap_degree(i, img, mask, dim);
      if (overlap_degree < threshold) {
	label2remove[label2remove_num] = i;
	label2remove_num++;
      }
      if (overlap_degree >= threshold) {
	label2keep[label2keep_num] = i;
	label2keep_num++;
      }
    }

  for (l=0; l<label2keep_num; l++)
    for (k=0; k<dim.z; k++)
      for (i=0; i<dim.x; i++)
	for (j=0; j<dim.y; j++)
	  if (img[k][i][j] == label2keep[l]) img[k][i][j] = 0;

  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) 
	if (img[k][i][j] != 0) img[k][i][j] = 255;

  /* saving ... */
  fp = fopen(argv[3],"w"); 
  for(k=0; k<dim.z; k++)
    for(i=0; i<dim.x; i++) fwrite(img[k][i],1,dim.y,fp);
  fclose(fp);

  /* free */
  UCfree3d(img, dim.z, dim.x);
  UCfree3d(mask, dim.z, dim.x);
  free(label2remove);
  free(label2keep);
}

float get_label_overlap_degree(int label, unsigned char ***img, unsigned char ***mask, Ivector3d dim)
{
  int        i, j, k, label_total_volume, overlap_volume;

  label_total_volume = 0;
  overlap_volume = 0;
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++)
	if (img[k][i][j] == label) {
	  if (mask[k][i][j] != 0) overlap_volume++;
	  label_total_volume++;
	}

  return ((float)overlap_volume/label_total_volume);
}

int GetImgZDim(char file[1000], Ivector3d dim)
{
  FILE        *fp;

  fp = fopen(file, "r");
  fseek(fp,0,SEEK_END);
  dim.z = (ftell(fp))/(dim.x*dim.y);
  fclose(fp);

  return dim.z;
}
