/*=========================================================================

Program:   Hierarchical Attribute Matching Mechanism for Elastic Registration 
Module:    $RCSfile: itkHammerIntensityAttributeVector.h,v $
Language:  C++
Date:      $Date: 2009/01/13 20:19:20 $
Version:   $Revision: 1.4 $

Copyright (c) 

This program is developed under NIH NCBC collaboration grant
R01 EB006733, "Development and Dissemination of Robust Brain MRI
Measurement Tools". 

This software is distributed WITHOUT ANY WARRANTY; without even 
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef __itkHammerIntensityAttributeVector_h
#define __itkHammerIntensityAttributeVector_h

#include "itkHammerAttributeVectorBase.h"

namespace itk
{
/** \class HammerIntensityAttributeVector
  * \brief Class for intensity based attribute vector used by Hammer
  *
  */
	typedef struct 
	{ 
		unsigned char Variance_UP; 
		unsigned char CannyEdge_UP;
		unsigned char CannyMinimalRequiredEdgeValue ;
	} IntensityFeatureThreshold ; 

class ITK_EXPORT HammerIntensityAttributeVector:
    public HammerAttributeVectorBase<unsigned char, 5 > 
{
public:

  typedef HammerIntensityAttributeVector   Self;

  void SetDifferenceThreshold( unsigned char t )
  {
    this->m_DifferenceThreshold = t;
  }

  unsigned char GetDifferenceThreshold( )
  {
    return this->m_DifferenceThreshold;
  }

  /** Length constant */
  unsigned int GetLength() const
  {
    return 5;
  }
  
  /** Dimension constant */
  unsigned int GetDimension() const
  {
    return 5;
  }
  
  /** define interface for computing similarity/difference between two
    * attribute vectors */
  virtual double ComputeSimilarity( Self & vec2 )
  {
    double v0 = static_cast<double>( this->operator[](4) );
    double v1 = static_cast<double>( vec2[4] );
    if ( fabs(v0-v1) > this->m_DifferenceThreshold )
      {
      return 0;
      }
    else 
      {
      double sim = 1;
      for (unsigned int k = 0; k < 5; k++)
        {
	  v0 = static_cast<double>( this->operator[](k) );
	  v1 = static_cast<double>( vec2[k] );
	  sim *= (1.0-fabs(v0-v1)/255.0);
        } 
      return sim;
      }    
  }

  virtual double ComputeDifference( Self & vec2 )
  {
    double diff = ComputeSimilarity( vec2 );
    if (diff == 0)
      {
      return -1;
      }
    else
      {
      return 1/diff;
      }
  }

  virtual bool IsQualifiedDrivingVoxel( std::vector<float> & qualifier )
  {
	
    return true;  
  }

  virtual bool IsQualifiedDrivingVoxel_GR( std::vector<float> & qualifier )
  {
	  //put the code of selection criterion here.
      return false;
  }

  HammerIntensityAttributeVector()
  {
    this->m_DifferenceThreshold = 128;
  }

  ~HammerIntensityAttributeVector()
  {
  }

  void PrintSelf(std::ostream& os, Indent indent) const
  {
  }

private:
  unsigned char m_DifferenceThreshold;
  
};


} // end namespace itk

#endif
