/******************************************************************************/
/*  Changed from Version 1.0                                                  */
/*  1. Subvolume matching is also added for subject driving voxels            */
/*      during correspondence detection.                                      */
/*  2. samll testing                                                          */
/*     (a) Binarize the tissue matching results  -> Good for Young Brain only */
/*     (b) The background effect in subvolume matching is also considered ->  */
/*                                                          NOT GOOD FOR ALL  */
/*  Search 'March ?? 2003' for these changes.                                 */
/******************************************************************************/

#include "hammer.h"

void WriteAttributeComponent( char* filename, AttributeImageType::Pointer avImg, int idx )
{
  ImageType::Pointer cImg = ImageType::New();
  cImg->CopyInformation( avImg );
  cImg->SetRegions( cImg->GetLargestPossibleRegion() );
  cImg->Allocate();

  itk::ImageRegionIteratorWithIndex<ImageType> it( cImg, cImg->GetLargestPossibleRegion() );
  for (it.GoToBegin(); !it.IsAtEnd(); ++it)
    {
    ImageType::IndexType imgIdx = it.GetIndex();
    AttributeImageType::PixelType p = avImg->GetPixel( imgIdx );
    it.Set( p[idx] );
    }
  
  itk::ImageFileWriter<ImageType>::Pointer w = itk::ImageFileWriter<ImageType>::New();
  w->SetFileName( filename );
  w->SetInput( cImg );
  w->Update();
  
  return;
}


/* the following is edited by SHEN */
int main(int argc,char *argv[])
  
{
  //unsigned char ***Img;
  int           Img_XY;
  //ImgAttribute  ***MdlImg ;
  //ImgAttribute  ***ObjImg ;
  //unsigned char ***ObjOriginalImg ;
  //ITKFvector3d     ***DeformFld ;
  int           iter,num,OpenDeformationFieldFromLastScale;
  std::string   ObjOriginalImgFile;
  std::string   SurfVerFileName;
  int           InputOriginalObjImg, InputSurfVer ;
  int           InitialUpdate ;

  itk::OStringStream msg;

  num=3;
  iter=25;
  XYZres = 1. ;
  search_resolution= 6 ;
  last_order       = 0 ;
  Deform_RATE      = 0.025 ;
  Affine_Degree    = 0.2 ; 
  Statistical_factor = 0.1 ;
  MatchingDegreeOfMdlOnImgEdge = 0.1 ;
  AddMthdOfAvoidingContraction = NOTADD;
  EstimateTransformOrNot       = NOTADD ;
  StatisticsEmployedOrNot      = NOTADD ; 
  smoothFactor = 0.01 ;
  OpenDeformationFieldFromLastScale=NNO;
  InputOriginalObjImg = NNO ;
  InputSurfVer = NNO ;
  SmoothingTimes=0 ;
  ObjectForce  = YYES ;
  InitialUpdate = NNO ;
  Img_XY = 256 ;
  YoungBrain = NNO ;   /*March 31 2003*/
  ConfidenceOnLastDeformation = 0.5 ; /* March 2005 */
  GlobalConstraint = YYES; /* April 2004 */
  WrongSegVNasGM = NNO ; /* Dec 2006 */

  int nThreads = 1;
  std::string fixedFilename;
  std::string movingFilename;
  std::string resampledFilename;


  try
    {
    CmdLine cl ( "HAMMER",
		 "Heirarchical Attribute Matching Mechanism for Elastic Registration, NA-MIC Kit",
		 "$Revision: 1.7 $" );

    msg.str ( "" ); msg << "deformation rate (default: " << Deform_RATE << ")";
    ValueArg<float> DeformtionRateArg ( "R", "DeformationRate", msg.str(), false, Deform_RATE, "float", cl );

    msg.str ( "" ); msg << "last iteration order (default: " << last_order << ")";
    ValueArg<int> LastOrderArg ( "l", "LastOrder", msg.str(), false, last_order, "int", cl );
    
    msg.str ( "" ); msg << "search resolution (default: " << search_resolution << ")";
    ValueArg<int> SearchResolutionArg ( "r", "SearchResolution", msg.str(), false, search_resolution, "int", cl );

    msg.str ( "" ); msg << "number of iterations (default: " << iter << ")";
    ValueArg<int> IterationArg ( "i", "Iteration", msg.str(), false, iter, "int", cl );
      
    //   not used in ShowUsage();
    //   -v <int>               : max neighbor size to describe the local connection of the current point (8)
    // msg.str ( "" ); msg << "max neighbor size to describe the local connection of the current point (default: " << iter << ")";
    // ValueArg<int> NeighborhoodArg ( "V", "Neighborhood", msg.str(), false, iter, "int", cl );
    // iter =  NeighborhoodArg.getValue();
	
    //   changed -h to -H
    //   -h <int>               : number of maximum neighborhood (13)
    msg.str ( "" ); msg << "number of maximum neighborhood (default: " << max_nbr << ")";
    ValueArg<int> MaxNbrArg ( "H", "MaxNbr", msg.str(), false, max_nbr, "int", cl );
	
    msg.str ( "" ); msg << "Edge preserving smoothing times (default: " << SmoothingTimes << ")";
    ValueArg<int> EdgePresvArg ( "E", "EdgePreservingSmooth", msg.str(), false, SmoothingTimes, "int", cl );
	  
    msg.str ( "" ); msg << "Number of threads (default: " << nThreads << ")";
    ValueArg<int> ThreadArg ( "T", "Thread", msg.str(), false, nThreads, "int", cl );

    msg.str ( "" ); msg << "size of XY slice image (default: " << Img_XY << ")";
    ValueArg<int> XYSizeArg ( "X", "XYSize", msg.str(), false, Img_XY, "int", cl );

    msg.str ( "" ); msg << "sample rate (default: " << XYZres << ")";
    ValueArg<float> SampleRateArg ( "s", "Sample", msg.str(), false, XYZres, "float", cl );
	    
    msg.str ( "" ); msg << "degree for expressing local affine transformation (default: " << Affine_Degree << ")";
    ValueArg<float> LocalAffineArg ( "a", "localaffine", msg.str(), false, Affine_Degree, "float", cl );
	      
    msg.str ( "" ); msg << "statistical factor (default: " << Statistical_factor << ")";
    ValueArg<float> StatFactorArg ( "b", "statitisticalfactor", msg.str(), false, Statistical_factor, "float", cl );
		
    msg.str ( "" ); msg << "Matching degree between model and image edge (default: " << MatchingDegreeOfMdlOnImgEdge << ")";
    ValueArg<float> MatchingDegreeArg ( "m", "matchingdegree", msg.str(), false, MatchingDegreeOfMdlOnImgEdge, "float", cl );
		  
    msg.str ( "" ); msg << "smoothing factor (default: " << smoothFactor << ")";
    ValueArg<float> SmoothingArg ( "c", "smoothing", msg.str(), false, smoothFactor, "float", cl );
		    
    msg.str ( "" ); msg << "Confidence on deformation field calculated in the last resolution (0~1.0) (default: " << ConfidenceOnLastDeformation << ")";
    ValueArg<float> ConfidenceArg ( "C", "Confidence", msg.str(), false, ConfidenceOnLastDeformation, "float", cl );
    ConfidenceOnLastDeformation =  ConfidenceArg.getValue();
		      
    //msg.str ( "" ); msg << "directory where model is stored (default: " << MdlDirtory << ")";
    //ValueArg<std::string> ModelDirArg ( "D", "ModelDir", msg.str(), false, MdlDirtory, "string", cl );
    //MdlDirtory = ModelDirArg.getValue();

    msg.str ( "" ); msg << "file name of orignal object image (default: " << ObjOriginalImgFile << ")";
    ValueArg<std::string> ObjectFileArg ( "O", "ObjectFile", msg.str(), false, ObjOriginalImgFile, "string", cl );
			
    msg.str ( "" ); msg << "model surface file name (dir/MDL.ver.norm.nbr) (default: " << SurfVerFileName << ")";
    ValueArg<std::string> ModelSurfaceArg ( "S", "ModelSurface", msg.str(), false, SurfVerFileName, "string", cl );
			  
    msg.str ( "" ); msg << "read deformation field from file in the local directory (default: " << OpenDeformationFieldFromLastScale << ")";
    SwitchArg ReadDeformationArg ( "F", "readdeformation", msg.str(), OpenDeformationFieldFromLastScale, cl );
			    
    msg.str ( "" ); msg << "add the method of stopping surface constraction (default: " << AddMthdOfAvoidingContraction << ")";
    SwitchArg StopSurContractionArg ( "t", "stopsurcontraction", msg.str(), AddMthdOfAvoidingContraction, cl );

    msg.str ( "" ); msg << "add estimation procedure for estimating scaling and shift of 3D model from image data (default: " << EstimateTransformOrNot << ")";
    SwitchArg EstimateTransformArg ( "e", "estimatetransform", msg.str(), EstimateTransformOrNot, cl );

    msg.str ( "" ); msg << "add statistics information to constrain deformation procedure (default: " << StatisticsEmployedOrNot << ")";
    SwitchArg StatInformationArg ( "d", "statistics", msg.str(), StatisticsEmployedOrNot, cl );

    msg.str ( "" ); msg << "new force from object (default: " << ObjectForce << ")";
    SwitchArg NewForceArg ( "N", "NewForce", msg.str(), ObjectForce, cl );

    msg.str ( "" ); msg << "Young Brain (less CSF) (default: " << YoungBrain << ")";
    SwitchArg YoungBrainArg ( "Y", "YoungBrain", msg.str(), YoungBrain, cl );

    msg.str ( "" ); msg << "update initial VerMdl by the result from the last resolution) (default: " << InitialUpdate << ")";
    SwitchArg InitialUpdateArg ( "U", "InitialUpdate", msg.str(), InitialUpdate, cl );

    msg.str ( "" ); msg << "no Global linear constraint since the very beginning stage of registration (default: " << GlobalConstraint << ")";
    SwitchArg GlobalConstraintArg ( "n", "GlobalConstraint", msg.str(), GlobalConstraint, cl );

    msg.str ( "" ); msg << "wrong tissue segmentation, segment VN as GM (or GM inside VN) (default: " << WrongSegVNasGM << ")";
    SwitchArg WrongSegVNasGMArg ( "w", "WrongSegVNasGM", msg.str(), WrongSegVNasGM, cl );

    UnlabeledValueArg<std::string> FixedImageArg ( "fixed", "Fixed image filename", "", "string", cl );
    UnlabeledValueArg<std::string> MovingImageArg ( "moving", "Moving image filename", "", "string", cl );
    UnlabeledValueArg<std::string> ResampledImageArg ( "resampled", "Resampled image filename", "", "string", cl );

    cl.parse ( argc, argv );
    Deform_RATE =  DeformtionRateArg.getValue();
    last_order =  LastOrderArg.getValue();
    search_resolution =  SearchResolutionArg.getValue();
    iter =  IterationArg.getValue();
    max_nbr =  MaxNbrArg.getValue();
    nThreads = ThreadArg.getValue();
    SmoothingTimes =  EdgePresvArg.getValue();
    Img_XY =  XYSizeArg.getValue();
    XYZres =  SampleRateArg.getValue();
    Affine_Degree =  LocalAffineArg.getValue();
    Statistical_factor =  StatFactorArg.getValue();
    MatchingDegreeOfMdlOnImgEdge =  MatchingDegreeArg.getValue();
    smoothFactor =  SmoothingArg.getValue();
    ObjOriginalImgFile = ObjectFileArg.getValue();
    SurfVerFileName = ModelSurfaceArg.getValue();
    OpenDeformationFieldFromLastScale = ReadDeformationArg.getValue();
    AddMthdOfAvoidingContraction = StopSurContractionArg.getValue();
    EstimateTransformOrNot = EstimateTransformArg.getValue();
    StatisticsEmployedOrNot = StatInformationArg.getValue();
    ObjectForce = NewForceArg.getValue();
    YoungBrain = YoungBrainArg.getValue();
    InitialUpdate = InitialUpdateArg.getValue();
    GlobalConstraint = GlobalConstraintArg.getValue();
    WrongSegVNasGM = WrongSegVNasGMArg.getValue();

    fixedFilename = FixedImageArg.getValue();
    movingFilename = MovingImageArg.getValue();
    resampledFilename = ResampledImageArg.getValue();

    } 
  catch ( ArgException exception ) {
  std::cerr << "error: " << exception.error() << " for arg " << exception.argId() << std::endl;
  exit ( EXIT_FAILURE );
  }

  printf("\n\n search_resolution=%d\n iter=%d\n Deform_RATE=%f\n Affine_Degree=%f\n Statistical_factor=%f\n MatchingDegreeOfMdlOnImgEdge=%f\n AddMthdOfAvoidingContraction=%d\n", search_resolution, iter, Deform_RATE, Affine_Degree, Statistical_factor, MatchingDegreeOfMdlOnImgEdge, AddMthdOfAvoidingContraction) ;
  printf(" smoothFactor=%f\n", smoothFactor) ;
  printf(" Sampling rate: %f\n", XYZres) ;
  printf(" InputOriginalObjImg=%d\n\n", InputOriginalObjImg) ;
  if( InputOriginalObjImg==YYES ) printf(" Warping result on orignal image will be saved!\n") ;
  printf("\n\n SmoothingTimes=%d\n", SmoothingTimes) ;
  printf("ObjectForce=%d\n", ObjectForce) ;
  printf("Img_XY=%d\n", Img_XY) ;
  if(  YoungBrain==YYES )  printf("\n\n ... YoungBrain!\n\n") ; /*March 31 2003*/
  printf(" ConfidenceOnLastDeformation=%f\n", ConfidenceOnLastDeformation) ; 
  printf(" GlobalConstraint=%d\n", GlobalConstraint) ;
  printf(" WrongSegVNasGM=%d\n", WrongSegVNasGM) ;

  double scale = 7*(1./XYZres) ; if(scale<3) scale=3; printf("scale=%f\n", scale) ;

  /***** Model image, segmented *****/
  /*Img_XY = 256 ;*/	 

  printf("\nmodel image : %s\n", fixedFilename.c_str()) ;  
  printf("subject image : %s\n", movingFilename.c_str()) ;  
  printf("resampled image : %s\n", resampledFilename.c_str()) ;  

  /*** Load in fixed image and compute the attribute vectors ***/
  itk::ImageFileReader<ImageType>::Pointer ImgReader = itk::ImageFileReader<ImageType>::New();
  ImgReader->SetFileName( fixedFilename.c_str() );
  try
    {
    ImgReader->Update();
    }
  catch( itk::ExceptionObject *ex )
    {
    std::cerr << ex << std::endl;
    }

  typedef itk::ShrinkImageFilter<ImageType, ImageType> DownSampleType;
  DownSampleType::Pointer downsample = DownSampleType::New();
  downsample->SetInput( ImgReader->GetOutput() );
  for (int k = 0; k < 3; k++)
    {
    downsample->SetShrinkFactor( k, static_cast<int> (XYZres) );
    }
  downsample->Update();

  ImageType::Pointer Img = downsample->GetOutput();
  Img->DisconnectPipeline();
  std::cout << "Fixed image file read in\n";

  typedef itk::AttributeVectorImageFilter<ImageType, AttributeImageType> AttributeFilterType;
  AttributeFilterType::Pointer modleAttributeFilter = AttributeFilterType::New();
  modleAttributeFilter->SetInput( Img );
  modleAttributeFilter->SetBGValue( 0 );
  modleAttributeFilter->SetGMValue( 2 );
  modleAttributeFilter->SetWMValue( 3 );
  modleAttributeFilter->SetVNValue( 4 );
  modleAttributeFilter->SetCSFValue( 1 );

  modleAttributeFilter->SetNumberOfThreads( nThreads );
  modleAttributeFilter->SetStrength( 1 );
  modleAttributeFilter->SetScale( scale );
  modleAttributeFilter->Update();

  AttributeImageType::Pointer fixedAVec = modleAttributeFilter->GetOutput();
  fixedAVec->DisconnectPipeline();

  WriteAttributeComponent( "fAttributeV0.mha", fixedAVec, 0 );
  WriteAttributeComponent( "fAttributeV1.mha", fixedAVec, 1 );
  WriteAttributeComponent( "fAttributeV2.mha", fixedAVec, 2 );
  WriteAttributeComponent( "fAttributeV3.mha", fixedAVec, 3 );
  WriteAttributeComponent( "fAttributeV4.mha", fixedAVec, 4 );

   /*** Load in moving image and compute the attribute vectors ***/
  ImgReader->SetFileName( movingFilename.c_str() );
  try
    {
    ImgReader->Update();
    }
  catch( itk::ExceptionObject *ex )
    {
    std::cerr << ex << std::endl;
    }

  downsample->SetInput( ImgReader->GetOutput() );
  for (int k = 0; k < 3; k++)
    {
    downsample->SetShrinkFactor( k, static_cast<int> (XYZres) );
    }
  downsample->Update();

  ImageType::Pointer mImg = downsample->GetOutput();
  mImg->DisconnectPipeline();
  std::cout << "Moving image file read in\n";

  AttributeFilterType::Pointer subjectAttributeFilter = AttributeFilterType::New();
  subjectAttributeFilter->SetInput( mImg );
  subjectAttributeFilter->SetBGValue( 0 );
  subjectAttributeFilter->SetGMValue( 2 );
  subjectAttributeFilter->SetWMValue( 3 );
  subjectAttributeFilter ->SetVNValue( 4 );
  subjectAttributeFilter->SetCSFValue( 1 );

  subjectAttributeFilter->SetNumberOfThreads( nThreads );
  subjectAttributeFilter->SetStrength( 1 );
  subjectAttributeFilter->SetScale( scale );
  subjectAttributeFilter->Update();

  AttributeImageType::Pointer movingAVec = subjectAttributeFilter->GetOutput();
  movingAVec->DisconnectPipeline();
  
  WriteAttributeComponent( "mAttributeV0.mha", movingAVec, 0 );
  WriteAttributeComponent( "mAttributeV1.mha", movingAVec, 1 );
  WriteAttributeComponent( "mAttributeV2.mha", movingAVec, 2 );
  WriteAttributeComponent( "mAttributeV3.mha", movingAVec, 3 );
  WriteAttributeComponent( "mAttributeV4.mha", movingAVec, 4 );


  ///* Select edge points in the model image to be focused */
  //MdlThreshold.Geom_UP = 0.9*255 ;
  //MdlThreshold.Geom_DN = 0.4*255 ;
  //MdlThreshold.VNvlm_UP = 255/12 ;
  //MdlThreshold.VNvlm_DN = 170 ; /* ~65% added on Dec 2006 */
  //MdlThreshold.CSFBG_UP = 255/4 ;
  //Select3DEdgePointsInModelTO1D( &MdlVer_Num, MdlImg, DeformFld, image_size, z_size) ; /* get  MdlVer, FixedMdlVer, MdlVer_Fea*/

  ///***** Object image, segmented  *****/
  ///*Img_XY = 256 ;	 */
  //fp=myopen(argv[2],"r");
  //fseek(fp,0,SEEK_END);
  //Img_Z=ftell(fp)/(Img_XY*Img_XY);
  //rewind(fp);

  //Img = UCalloc3d(Img_XY,Img_XY,Img_Z);

  //for(k=0;k<Img_Z;k++)
  //  for(i=0;i<Img_XY;i++)
  //    fread(Img[k][i],1,Img_XY,fp);
  //fclose(fp);
  //printf("\n\n^^^^ Segmented object image input!\n") ;

  ///*image_size = Img_XY/XYZres ;
  //z_size = Img_Z/XYZres ; */

  //ObjImg = ImgAttributealloc3d(image_size,image_size,z_size); 

  //for(k=0; k<z_size; k++)
  //{
  //  if(k<Img_Z/XYZres) 
  //    for(i=0; i<image_size; i++)
  //      for(j=0; j<image_size; j++)
  //        ObjImg[k][i][j].Tiss=Img[(int)(k*XYZres)][(int)(i*XYZres)][(int)(j*XYZres)] ;
  //  else
  //    for(i=0; i<image_size; i++)
  //      for(j=0; j<image_size; j++)
  //        ObjImg[k][i][j].Tiss=0;
  //}
  //UCfree3d(Img, Img_Z, Img_XY) ;

  ///* get its edge map, geometric features */
  //Get_WMedge_GmVnEdge_FromSegmentedImg(ObjImg) ;
  //scale = 7*(1./XYZres) ; if(scale<3) scale=3; printf("scale=%d\n", scale) ;
  //Compute_GeometricFeatures(ObjImg, scale, 1., 1., 1.5) ;

  //WriteImgAttribute("ObjImg", ObjImg, image_size, z_size) ;

  ///* Select edge points in the object image to be used as landmarks */
  //Select3DEdgePointsInObjectTO1D(&ObjVer_Num, ObjImg, image_size, z_size) ; /* got ObjVer, ObjVer_Fea*/
  //forceByFocusedPntInObj = Fvector3dalloc1d(MdlVer_Num); 
  //multiple         = Ialloc1d(MdlVer_Num); 
  //MyHoodSize       = search_resolution/2*2+12+1;  /*20+1 ;*/
  //MyHood           = Ivector3dalloc1d(MyHoodSize*MyHoodSize*MyHoodSize) ;
  //calculate_hood_byIncreasingRadius(MyHood, MyHoodSize, &pixelNumIn_MyHood, 1., 1., 1.) ;


  ///***** Check here whether to input original Object image for warping it *****/
  //if( InputOriginalObjImg==YYES )
  //{
  //  /*Img_XY = 256 ;  */
  //  fp=myopen(ObjOriginalImgFile,"r");
  //  fseek(fp,0,SEEK_END);
  //  Img_Z=ftell(fp)/(Img_XY*Img_XY);
  //  rewind(fp);
  //  Img = UCalloc3d(Img_XY,Img_XY,Img_Z);
  //  for(k=0;k<Img_Z;k++)
  //    for(i=0;i<Img_XY;i++)
  //      fread(Img[k][i],1,Img_XY,fp);
  //  fclose(fp);
  //  printf("\n\n^^^^  Original object image input!\n") ;
  //  /*image_size = Img_XY/XYZres ; z_size = Img_Z/XYZres ; */

  //  ObjOriginalImg = UCalloc3d(image_size,image_size,z_size); 

  //  for(k=0; k<z_size; k++)
  //  {
  //    if(k<Img_Z/XYZres) 
  //      for(i=0; i<image_size; i++)
  //        for(j=0; j<image_size; j++)
  //          ObjOriginalImg[k][i][j]=Img[(int)(k*XYZres)][(int)(i*XYZres)][(int)(j*XYZres)] ;
  //    else
  //      for(i=0; i<image_size; i++)
  //        for(j=0; j<image_size; j++)
  //          ObjOriginalImg[k][i][j]=0;
  //  }
  //  UCfree3d(Img, Img_Z, Img_XY) ;
  //}

  ///* Inout model's surface model for deforming and carving it into subject's space */
  //if( InputSurfVer==YYES && XYZres==1.0 )
  //{
  //  printf("\n\n^^^^  Surface model input!\n") ;
  //  ReadModelSurfVer(SurfVerFileName, &InputSurfVer) ;
  //}



  ///* estimate the global shift and scaling */
  //if( EstimateTransformOrNot==ADD )
  //{
  //  EstimatingScalingAndShiftOf3DSurfaceFromImg(MdlVer, FixedMdlVer, MdlVer_Fea, MdlVer_Num, DeformFld, ObjImg, image_size, z_size ) ;
  //  SaveCurrentWarpingResultOnSegmentedObj( ObjImg, DeformFld, image_size, z_size, (int)XYZres, 999 ) ;

  //  if( InputOriginalObjImg==YYES )
  //    SaveCurrentWarpingResultOnOriginalObjImg( ObjOriginalImg, DeformFld, image_size, z_size, (int)XYZres, 999 ) ;

  //  if( InputSurfVer==YYES && XYZres==1.0 ) /* only on sample rate 1 */
  //    SaveDeformedModelSurfVer(DeformFld, image_size, z_size, XYZres, 999) ;
  //}

  //if( OpenDeformationFieldFromLastScale==YYES )     
  //{ 
  //  OpenDeformationField("DeformationField.float.img", DeformFld, image_size, z_size) ;    
  //  SaveCurrentWarpingResultOnSegmentedObj( ObjImg, DeformFld, image_size, z_size, (int)XYZres, 999 ) ;

  //  if( InputOriginalObjImg==YYES )
  //    SaveCurrentWarpingResultOnOriginalObjImg( ObjOriginalImg, DeformFld, image_size, z_size, (int)XYZres, 999 ) ;

  //  if( InputSurfVer==YYES && XYZres==1.0 ) /* only on sample rate 1 */
  //    SaveDeformedModelSurfVer(DeformFld, image_size, z_size, XYZres, 999) ;

  //  /* update the initial deformations in MdlVer; Added on Oct 23, 2002  */
  //  /* Theoretically, we need to update MdlVer by initial input. But it is removed, for robustness issues */
  //  if( InitialUpdate==YYES )
  //  {
  //    printf("Update VerMdl by the result from the last resolution.") ;
  //    for(s=0; s<MdlVer_Num; s++)
  //    {
  //      sx = FixedMdlVer[s].x ;
  //      sy = FixedMdlVer[s].y ; 
  //      sz = FixedMdlVer[s].z ; 

  //      MdlVer[s].x = DeformFld[sz][sx][sy].x + sx ; 
  //      MdlVer[s].y = DeformFld[sz][sx][sy].y + sy ; 
  //      MdlVer[s].z = DeformFld[sz][sx][sy].z + sz ; 
  //    }
  //  }
  //  else
  //    printf("No initial update for VerMdl!\n") ;

  //}


  ///* global transformation matrix */
  //CreateMatrix(&Transform,    4, 4);

  ///* deform */
  //ratio_iteration=0;
  //for(i=0;i<iter;i++)
  //{
  //  if(ratio_iteration>0.5) /*0.5*/ 
  //  {
  //    printf("focus change!\n") ;
  //    /* focuse on more edge points */
  //    free(MdlVer) ;
  //    free(FixedMdlVer) ;
  //    free(MdlVer_Fea) ;
  //    free(forceByFocusedPntInObj) ;
  //    free(multiple) ;

  //    MdlThreshold.Geom_UP = 0.9*(1-ratio_iteration)*255 ;
  //    MdlThreshold.Geom_DN = 0.4*(2.*ratio_iteration)*255 ;
  //    MdlThreshold.VNvlm_UP = 255/4 ;
  //    TempVNvlm_DN = 170+(255-170)*ratio_iteration*1.5 ; /* ~65% added on Dec 2006 */
  //    if(TempVNvlm_DN>255)  MdlThreshold.VNvlm_DN = 255 ;
  //    else                  MdlThreshold.VNvlm_DN = TempVNvlm_DN ;
  //    MdlThreshold.CSFBG_UP = 255/4 ;
  //    Select3DEdgePointsInModelTO1D( &MdlVer_Num, MdlImg, DeformFld, image_size, z_size) ; /* get  MdlVer, FixedMdlVer, MdlVer_Fea*/

  //    forceByFocusedPntInObj = Fvector3dalloc1d(MdlVer_Num); 
  //    multiple               = Ialloc1d(MdlVer_Num); 
  //  }

  //  ratio_iteration = (float)i/(float)iter ;
  //  resolution = search_resolution*exp(-ratio_iteration*ratio_iteration/2./0.36) ;  if(resolution<1) resolution=1 ;
  //  printf("\n\n\n****************i=%d:   resolution=%d  ratio_iteration=%f************\n", i, resolution, ratio_iteration) ;

  //  AffinDeform3D(MdlVer, FixedMdlVer, MdlVer_Num, MdlVer_Fea, DeformFld, MdlImg, 
  //    ObjVer, ObjVer_Num, ObjVer_Fea, ObjImg, 
  //    image_size, z_size, resolution) ;  

  //  /* save temporary results */
  //  SaveCurrentWarpingResultOnSegmentedObj( ObjImg, DeformFld, image_size, z_size, (int)XYZres, i ) ;
  //  if( InputOriginalObjImg==YYES )
  //    SaveCurrentWarpingResultOnOriginalObjImg( ObjOriginalImg, DeformFld, image_size, z_size, (int)XYZres, i ) ;
  //  if( InputSurfVer==YYES && XYZres==1.0 ) /* only on sample rate 1 */
  //    SaveDeformedModelSurfVer(DeformFld, image_size, z_size, XYZres, i) ;

  //  /*EvaluationOfRegistration( MdlImg, ObjImg, DeformFld, image_size, z_size, (int)XYZres, i )  ;*/
  //  /* June 28, 2001: for movie */
  //  /*sprintf(filename, "DeformationField.float.img%d.%d", (int)XYZres, i); 
  //  if( XYZres>1.0 ) WriteDeformationField(filename, DeformFld, image_size, z_size) ;*/
  //}

  ///* smooth */
  //SmoothDeformationField(DeformFld, image_size, z_size) ;

  //if( XYZres>=1.0 )
  //  WriteDeformationField("DeformationField.float.img", DeformFld, image_size, z_size) ;

  //printf("Deformation step on scale %d has been finished!\n", (int)XYZres) ;

  return 0;
}



