#define X .525731112119133606
#define Z .850650808352039932
#define ADD     1
#define NOTADD  0
#define YYES    1
#define NNO     0
#define OOK     1
#define FFAIL   0
#define NEGINT    -1000
#define BOUNDERY  -10000


/* features for vertices */
#define BG    0            /* background */
#define CSF   10
#define VN    50
#define GM    150
#define WM    250

#define MAX_SIGMA 100
#define MAX_LEVEL 500
#define LOW_LEVEL 0
#define MID_LEVEL 1
#define HIGH_LEVEL 2
#define PYRAMID_LEVEL 3
#define OverSmoothTimes 3

#define GMVN_EDGE     100    /*used before June 22 2004 */
//unsigned char GMVN_EDGE=100;
#define GMCSFBG_EDGE  120  /* added on June 4, 2001*/
#define WMVN_EDGE     180
#define WMGM_EDGE     255

#define MIN_TPS_POINT 15
#define MIN_TPS_POINT_RATIO 0.01
//#define DEBUG_TPS 
//#define DUMP_DEFORMATION_EVERY_ITER


const static char acVersion[]="\n Version 2009/04/17\n\n";
const static char *apcHelpInfo[]={
	"\n[Options]\n",
	"\t -R <int>               : deformation rate, i.e. 0.05\n",  //1
	"\t -r <int,int,int>       : search resolution\n",  //2
	"\t -i <int>               : # of initial iterations (50)\n",  //3	
	"\t -a <float>             : degree for expressing local affine transformation (0.2)\n",  //5
	"\t -m <float>             : Matching degree between model and image edge (0.6)\n",  //6
	"\t -e <bool>	           : Estimate Transformation (false)\n",  //7
	"\t -c <float>             : smooth factor (i.e. 0.01)\n",  //8
	"\t -F <bool>              : read deformation field from file in the local directory\n",  //10
	"\t -E <int>               : Edge preserving smoothing times, i.e. 1,2 \n", //11
	"\t -N <bool>              : new force from object \n", //12
	"\t -U <bool>              : update initial VerMdl by the result from the last resolution\n" //13,
	"\t -X <int>               : size of XY slice image; default:256\n",  //14
	"\t -C <float>             : Confidence on deformation field calculated in the last resolution (0~1.0); default: 0.0\n",  //15
	"\t -O <string>            : directory where the intensity object\n",  //16
	"\t -B <bool>              : Big ventricel or not (1)\n", //18
	"\t -p <float>			   : Similarity between two points (0.8)\n", //22
	"\t -Y <bool>              : Young Brain or not (0)\n",
	"\t -T <string>	           : Output the temperal data or not\n",
	"\t -h  		           : Print the Usuage\n",
	"\t -t	<float> 		   : Point Similarity (0.8)\n",
	"\t -p <float,int>		   : smoothing factor for deformation fields, range [0,1], 1->smoothest, (default: 0.5))\n",
	"\t -S <bool>              : the designation of using soft correspondence (defalut : false)\n",
	"\t -A <int>               : the additional time for smoothing in soft correspondence. (default 3)\n",
	"\t -n <int>			   : the maximun of control point in each block. (default: 100)\n",
	"\t -b <int>               : the block size. (default 36)\n",
	"\t -o <int>               : the overlap block size. (default 32)\n",
	"\t -l <float>			   : the lemda value for TPS. (default 0.1)\n", 
	"\t -TPS <bool>            : using TPS as the regularization.(default false)\n",
	"\t -tps_l <int>           : the decompostion level in tps (default: 3)\n",
	"\t -tps_e <float>		   : the residual error in each block (default: 0.05)\n",
	0
};

typedef struct 
{ 
	unsigned char Geom_UP; 
	unsigned char Geom_DN; 
	unsigned char VNvlm_UP; 
	unsigned char VNvlm_DN; 
	unsigned char CSFBG_UP; 
	unsigned char CSFBG_DN; 
} Threshold ; 


//#pragma once
typedef class Definition_of_HAMMER
{
public:
	Definition_of_HAMMER();	
	~Definition_of_HAMMER();
public:
	void SetDefaultParm();
	void ObtainParm(int argc, char *argv[], int MinParm);
	void PrintUsage(const char *pcProgramName);
public:
	char TemplateFileName[300];
	char SubjectFileName[300];
	char WarpedFileName[300];
	char *pcProgramName;
	float Deform_RATE;
	int search_resolution[PYRAMID_LEVEL];
	int iter;
	float XYZres;
	float Affine_Degree;
	float MatchingDegreeOfMdlOnImgEdge;
	float PointSimilarity;
	bool EstimateTransformOrNot;
	float smoothFactor;
	//char MdlDirtory[300];
	bool OpenDeformationFieldFromLastScale;
	int SmoothingTimes;
	bool UsingForcesFromObject;
	bool InitialUpdate;
	int Img_XY;
	float ConfidenceOnLastDeformation;
	bool InputOriginalObjImg;
	char ObjOriginalImgFile[300];
	int max_nbr;
	bool BigVN;
	bool YoungBrain;
	bool OutputTemporayResults;
	char OutputDir[300];
	float	DfmSmthCoeff;
	int DfmSmthTimes;
	int Current_Level;
	bool Soft_Correspondence;
	float   AdditionalSmth;  //for soft correspondence
	int BlockSize;
	int OverStep;
	int MaxTPSPoint;
	float TPS_Lemda;
	float Residual_Tolerance;
	int TPS_Decomposition_Level;
	bool UsingTPSRegularization;
}HAMMER_Param;



typedef struct Structure_Definition_of_SubVolumnParm
{
	int Search_Radius;
	int Search_Step;
	float Point_Similarity_Threshold;
	bool IsBigVN;
	int Step_of_NBR;
	int Image_X_Size;
	int Image_Y_Size;
	int Image_Z_Size;
	float Deform_Diffusion_Weight;
	bool IsYoungBrain;
	float Subvolumn_Similarity;
	float MinDist; 
	float Smooth_Factor;
	float Deform_Rate;
	int CurrentLevel;
	float SubVolumn_Similarity_Threshold;
	int GaussianSigma;
}SubVolumnParm;

typedef struct TPS_PARAMETERS
{
	int BlockSize;
	int OverStep;
	int MaxTPSPoint;
	float TPS_Lemda;
	float Residual_Tolerance;
}TPSParm;