
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#include "itkOrientedImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkNearestNeighborInterpolateImageFunction.h"
#include "itkLinearInterpolateImageFunction.h"

#include "itkOrientImageFilter.h"

typedef itk::OrientedImage<unsigned char, 3> ImageType;

int main( int argc, char *argv[] )
{

  itk::ImageFileReader<ImageType>::Pointer imageReader = itk::ImageFileReader<ImageType>::New();
  imageReader->SetFileName( argv[1] );
  imageReader->Update();
  ImageType::Pointer image = imageReader->GetOutput();

  ImageType::Pointer oImage = ImageType::New();

  oImage->CopyInformation( image );
  ImageType::RegionType region = oImage->GetLargestPossibleRegion();
  ImageType::SpacingType spacing = oImage->GetSpacing();

  for (int k = 0; k < 3; k++)
  {
    float extent = static_cast<float>(region.GetSize(k))*spacing[k];
    spacing[k] *= atof(argv[2]);
    int nPixel = static_cast<int>(extent/spacing[k]);
    region.SetSize(k, nPixel);
  }

  oImage->SetSpacing( spacing );
  oImage->SetRegions( region );
  oImage->Allocate();
  oImage->FillBuffer( 0 );

  itk::NearestNeighborInterpolateImageFunction< ImageType, double >::Pointer interpolator = 
    itk::NearestNeighborInterpolateImageFunction< ImageType, double >::New();

  interpolator->SetInputImage( image );
  
  itk::ImageRegionIteratorWithIndex<ImageType> itOut( oImage, region );
  for (itOut.GoToBegin(); !itOut.IsAtEnd(); ++itOut)
  {
    ImageType::IndexType idx = itOut.GetIndex();
    ImageType::PointType pt;
    
    oImage->TransformIndexToPhysicalPoint( idx, pt );
    itk::ContinuousIndex<double, 3> cIdx;
    image->TransformPhysicalPointToContinuousIndex( pt, cIdx );

    if( image->GetLargestPossibleRegion().IsInside(cIdx) )
    {
      itOut.Set( interpolator->Evaluate( pt ) );
    }
  }

  itk::ImageFileWriter<ImageType>::Pointer w = itk::ImageFileWriter<ImageType>::New();
  w->SetInput( oImage );
  w->SetFileName( argv[3] );
  w->Update();
  return 0;
}


