#ifndef afcm_io_h_
#define afcm_io_h_

#include <vcl_string.h>
#include <vcl_vector.h>
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"

#include <3d_image/3d_image_base.h>

bool load_img8 (const vcl_string& name, Image8Type::Pointer& image);

bool load_img_f16 (const vcl_string& name, ImageType::Pointer& image);

bool save_img_f16 (const vcl_string& name, const ImageType::Pointer& image);

bool save_img8 (const vcl_string& name, const ImageType::Pointer& image);

bool save_01_img8 (const vcl_string& name, const ImageType::Pointer& image);

bool save_mem_fun_u (const vcl_string& name, 
                     const vcl_vector<ImageType::Pointer>& mem_fun_u);

int save_bin_pt_off (const ImageType::Pointer& image,
                     const char* filename);

#endif
