#ifndef afcm_regression_h_
#define afcm_regression_h_

#include <vcl_vector.h>

#include "afcm_base.h"

//===================================================================
// Regression on image intensity

void img_regression_linear (const ImageType::Pointer& image,
                            const float thresh,
                            vnl_matrix<double>& B);

//Use B to compute a new fitting
void compute_linear_fit_img (const vnl_matrix<double>& B, 
                             const ImageType::Pointer& fit_image);

void img_regression_quadratic (const ImageType::Pointer& image,
                               const float thresh,
                               vnl_matrix<double>& B);

//Use B to compute a new fitting
void compute_quadratic_fit_img (const vnl_matrix<double>& B, 
                                const ImageType::Pointer& fit_image);

#endif