#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <cstdio>

#include <cstdlib>
#include "math.h"
#include "set"


#include <math.h>
#include <stdlib.h>

#include "itkOrientedImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"

#include "itkOrientImageFilter.h"
#include "vcl_vector.h"
#include "vcl_cstdio.h"

//MJ_TEMP
//float FLT_MAX = 100000.0;


class BiasCorr
{
public:

typedef itk::OrientedImage<float, 3> ImageType;

void update_gain_to_image (const ImageType::Pointer& gain_field,
                           const ImageType::Pointer& image,
                           float globalmean);


void compute_quadratic_fit_img (const vnl_matrix<double>& B,
                                const ImageType::Pointer& fit_image);


void grid_regression_quadratic (const vcl_vector<float> & centroid_v_grid,
                                const vcl_vector<ImageType::IndexType>& grid_center_index,
                                vnl_matrix<double>& B);

bool detect_bnd_box (const ImageType::Pointer& image,
                     const float bg_thresh,
                     int& xmin, int& ymin, int& zmin,
                     int& xmax, int& ymax, int& zmax);


void compute_grid_imgs (const ImageType::Pointer& image,
                        const int xmin, const int ymin, const int zmin,
                        const int xmax, const int ymax, const int zmax,
                        const int n_grid,
                        vcl_vector<ImageType::Pointer>& image_grid,
                        vcl_vector<ImageType::IndexType>& grid_center_index);


int BiasCorrection(std::string& inputVolume1, std::string& inputWhiteProbability, std::string& outputVolume1);


BiasCorr(){};
~BiasCorr(){};


private:

protected:

};

