/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkRBFSVMKernel.txx,v $
  Language:  C++
  Date:      $Date: 2006/09/07 11:48:50 $
  Version:   $Revision: 1.1 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __itkRBFSVMKernel_txx
#define __itkRBFSVMKernel_txx

#include "itkRBFSVMKernel.h"

#include <math.h>

using namespace std;

//#define debug

namespace itk
{
namespace Statistics
{

/** Constructor */
template<class TVector, class TOutput>
RBFSVMKernel<TVector,TOutput>
::RBFSVMKernel()
{
   setParametres(6000.0);
}

/** Destructor */
template<class TVector, class TOutput>
RBFSVMKernel<TVector,TOutput>
::~RBFSVMKernel()
{}


// SVMTorch's evaluation function
template<class TVector, class TOutput>
double RBFSVMKernel<TVector,TOutput>
::evalue (int i, int j)  
{
   // TODO: to be removed
   setParametres(6000.0);

#ifdef debug

//   printf ("RBFSVMKernel::evalue (int i, int j)\n");

   cout << "m_Gamma: " << m_Gamma << endl;
   cout << "dot(i,j): " << dot(i,j) << endl;
   cout << "precalc[" << i <<"]: " << precalc[i] << endl;
   cout << "precalc[" << j <<"]: " << precalc[j] << endl;

   cout << "exp(m_Gamma*( 2.*dot(i,j)-precalc[i]-precalc[j] )): " << exp(m_Gamma*( 2.*dot(i,j)-precalc[i]-precalc[j] )) << endl;
#endif // debug

    return(exp(m_Gamma*( 2.*dot(i,j)-precalc[i]-precalc[j] )));

}


template<class TVector, class TOutput>
double RBFSVMKernel<TVector,TOutput>
::evalue (MeasurementVectorType& x, int j)
{
#ifdef debug
  // printf ("RBFSVMKernel::evalue (MeasurementVectorType& x, int j)\n");
#endif // debug

   // CAUTION  -- TODO: to be removed
   setParametres(6000.0);

  double sum = 0;

  typedef itk::VariableLengthVector<double> MeasurementVectorType;

  SampleType::MeasurementVectorType  mv;
  mv.SetSize(mySample->GetMeasurementVectorSize());
  mv = mySample->GetMeasurementVector(j);

  for(unsigned int t = 0; t < mySample->GetMeasurementVectorSize(); t++)
  {
#ifdef debug
//     cout << x[t] << " " ;
//     cout << mv.GetElement(t) << " ";	
#endif // debug

    double z = x[t] - mv.GetElement(t);
    sum -= z*z;
  }

#ifdef debug
//  cout << endl;

//  printf ("%f->%f", sum, exp(m_Gamma*sum));

#endif // debug

  m_Evalvalue = (double) exp(m_Gamma*sum);

  return(exp(m_Gamma*sum));
}


template<class TVector, class TOutput>
void RBFSVMKernel<TVector,TOutput>
::SetData (SampleType* sample)
{
  printf ("RBFSVMKernel::SetData --- OK!!!\n");

  std::cout << "size: " << sample->Size() << std::endl;

   mySample = sample;

  std::cout << "size: " << mySample->Size() << std::endl;
 

}

template<class TVector, class TOutput>
double RBFSVMKernel<TVector,TOutput>
::GetEvalvalue()
{
   return m_Evalvalue;
}

//mjkim for SVMTorch
template<class TVector, class TOutput>
void RBFSVMKernel<TVector,TOutput>
::init() 
{
   printf ("RBFSVMKernel::init()\n");

   printf ("number of train_examples\n");

  precalc.SetSize(mySample->Size());

  cout << "# Precalculating...";
  cout.flush();

  cout << "mySample->Size(): " << mySample->Size() << endl;


  for(unsigned int i = 0; i <mySample->Size(); i++)
    precalc[i]= dot(i, i);
  cout << "OK\n";

  precalc_alloc = true;



}

/** Print the object */
template<class TVector, class TOutput>
void  
RBFSVMKernel<TVector, TOutput>
::PrintSelf( std::ostream& os, Indent indent ) const 
{ 
  Superclass::PrintSelf( os, indent ); 
  os << indent << "RBFSVMKernel(" << this << ")" << std::endl; 
}


template<class TVector, class TOutput>
double RBFSVMKernel<TVector,TOutput>
::dot(int i, int j)
{
   // ONLY non-sparse mode
    double sum = 0;
   // double *ptr_i = svm.data[i];
   // double *ptr_j = svm.data[j];

  typedef itk::VariableLengthVector<double> MeasurementVectorType;
  SampleType::MeasurementVectorType  mv1;
  SampleType::MeasurementVectorType  mv2;

  mv1.SetSize(mySample->GetMeasurementVectorSize());
  mv2.SetSize(mySample->GetMeasurementVectorSize());

   
    mv1 = mySample->GetMeasurementVector(i);
    mv2 = mySample->GetMeasurementVector(j);

    for(unsigned int t = 0; t < mySample->GetMeasurementVectorSize(); t++)
      //sum += ptr_i[t] * ptr_j[t];
        sum += mv1[t] * mv2[t];

    return(sum);

}

template<class TVector, class TOutput>
void RBFSVMKernel<TVector,TOutput>
::setParametres(double std)
{
  m_Gamma = 1./(std*std);
}


template<class TVector, class TOutput>
void RBFSVMKernel<TVector,TOutput>
::getParametres(double &std)
{
  std = 1./(sqrt(m_Gamma));
}

 

} // end namespace Statistics
} // end namespace itk

#endif // __itkRBFSVMKernel_txx
