/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkSVMSolver1.h,v $
  Language:  C++
  Date:      $Date: 2006/09/07 11:48:50 $
  Version:   $Revision: 1.1 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __SVMSolver1_h
#define __SVMSolver1_h

#include "itkSVMSolverBase.h"
#include <map>

namespace itk
{
namespace Statistics
{
template<class TXSample, class TYSample>
class SVMSolver1 : public SVMSolverBase<TXSample,TYSample>
{
public:

  typedef SVMSolver1 Self;
  typedef SVMSolverBase<TXSample,TYSample> Superclass;
  typedef SmartPointer<Self> Pointer;
  typedef SmartPointer<const Self> ConstPointer;
  itkTypeMacro(SVMSolver1, SVMSolverBase);
  itkNewMacro(Self) ;

  
  typedef typename Superclass::XVectorType XVectorType;
  typedef typename Superclass::YVectorType YVectorType;
  typedef typename Superclass::InternalVectorType InternalVectorType;
  typedef typename Superclass::VnlVectorType VnlVectorType;
  typedef typename Superclass::SVMType SVMType;
  typedef typename Superclass::VnlMatrixType VnlMatrixType;

  typedef itk::VariableLengthVector<double> DoubleVectorType;
  typedef itk::VariableLengthVector<int> IntVectorType;
  typedef itk::VariableLengthVector<char> CharVectorType;

  typedef typename TXSample::Pointer InputSamplePointerType;
  typedef typename TXSample::Pointer OutputSamplePointerType;

  typedef double                                      ValueType;
  typedef itk::VariableLengthVector<ValueType>       MeasurementVectorType;
  typedef itk::Statistics::NumericsListSample<MeasurementVectorType> SampleType;




  // mjkim for SVMTorch
  int n_support_vectors;
  int n_support_vectors_bound;
//  int *support_vectors;
 // double *sv_alpha;

  IntVectorType support_vectors;
  DoubleVectorType sv_alpha;

  bool regression_mode;

  virtual void analyticSolve(int xi, int xj);
//  virtual void setOption(const string& optionname, const string& value);

  void train();
  void save(std::ostringstream& svmfilename);

  void load(std::ostringstream& svmfilename);
  double use(MeasurementVectorType& x);


  itkSetMacro(C,double);
  itkGetMacro(C,double);
  
  itkSetMacro(Epsilon,double);
  itkGetMacro(Epsilon,double);

//  OutputSamplePointerType outputSamplePointer;
   SampleType::Pointer outputSamplePointer;

protected:

  SVMSolver1();
  ~SVMSolver1();
    
  /** Method to print the object. */
  virtual void PrintSelf( std::ostream& os, Indent indent ) const;

private:

  double                         m_C;             //alpha upper bound
  VnlVectorType                  m_Alphas;
  double                         m_Epsilon; // alphas lowe bound
  int                            m_WorkingSetSize;

// mjkim for SVMTorch
  double  C;
  void prepareToLauch();
  void atomiseAll();
  bool svm_is_ready;
  bool support_vectors_is_ready;
  int lm;
  double eps_regression;
  double cache_size_meg;

//  OutputSamplePointerType outputSamplePointer;


};

} // end namespace Statistics
} // end namespace itk






#ifndef ITK_MANUAL_INSTANTIATION
  #include "itkSVMSolver1.txx"
#endif

#endif
